/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="message", type={4}, optional=false, doc={@GamlAnnotations.doc(value="the message to display as a warning.")})}, omissible="message")
@GamlAnnotations.doc(value="The statement makes the agent output an arbitrary message in the error view as a warning.", usages={@GamlAnnotations.usage(value="Emmitting a warning", examples={@GamlAnnotations.example(value="warn \"This is a warning from \" + self;")})})
public class WarnStatement
extends AbstractStatement {
    final IExpression message = this.getFacet("message");

    public WarnStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = iScope.getAgent();
        String string = null;
        if (iAgent != null && !iAgent.dead()) {
            string = Cast.asString(iScope, this.message.value(iScope));
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning(string, iScope), false);
        }
        return string;
    }
}

