/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.GamaCoordinateSequenceFactory;
import gama.core.common.geometry.GamaGeometryFactory;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.DynamicLineString;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.gaml.operators.Maths;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.util.AssertionFailedException;
import org.locationtech.jts.util.GeometricShapeFactory;

@GamlAnnotations.type(name="geometry", id=13, wraps={IShape.class, GamaShape.class}, kind=104, concept={"type", "geometry"}, doc={@GamlAnnotations.doc(value="Represents geometries, i.e. the support for the shapes of agents and all the spatial operations in GAMA.")})
public class GamaGeometryType
extends GamaType<IShape> {
    public static final WKTReader SHAPE_READER = new WKTReader();
    private static double theta = Math.tan(0.423);

    @Override
    @GamlAnnotations.doc(value="Cast the argument into a geometry. If the argument is already a geometry or an agent, returns it; if it is a species, returns the union of all its agents' geometries; if it is a pair, tries to build a segment from it; if it is a file containing geometries, returns the union of these geometries; if it is a container and its contents are points, builds the resulting geometry, otherwise cast the objects present in the container as geometries and returns their union; if it is a string, interprets it as a wkt specification; otherwise, returns nil. ")
    public IShape cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaGeometryType.staticCast(iScope, object, object2, bl);
    }

    public static IShape staticCast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        if (object instanceof IShape) {
            IShape iShape = (IShape)object;
            if (bl) {
                return iShape.copy(iScope);
            }
            return iShape;
        }
        if (object instanceof ISpecies) {
            return GamaGeometryType.geometriesToGeometry(iScope, iScope.getAgent().getPopulationFor((ISpecies)object));
        }
        if (object instanceof GamaPair) {
            return GamaGeometryType.pairToGeometry(iScope, (GamaPair)object);
        }
        if (object instanceof GamaGeometryFile) {
            return ((GamaGeometryFile)object).getGeometry(iScope);
        }
        if (object instanceof IContainer) {
            if (GamaGeometryType.isPoints(iScope, (IContainer)object)) {
                return GamaGeometryType.pointsToGeometry(iScope, (IContainer)object);
            }
            return GamaGeometryType.geometriesToGeometry(iScope, (IContainer)object);
        }
        if (object instanceof String) {
            try {
                Geometry geometry = SHAPE_READER.read((String)object);
                return GamaShapeFactory.createFrom(geometry);
            }
            catch (ParseException parseException) {
                GAMA.reportError(iScope, GamaRuntimeException.warning("WKT Parsing exception: " + parseException.getMessage(), iScope), false);
            }
        }
        return null;
    }

    private static boolean isPoints(IScope iScope, IContainer iContainer) {
        for (Object ValueType : iContainer.iterable(iScope)) {
            if (ValueType instanceof GamaPoint) continue;
            return false;
        }
        return true;
    }

    @Override
    public GamaShape getDefault() {
        return null;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public IType getKeyType() {
        return Types.STRING;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    public static IShape buildPolygon(List<? extends IShape> list) {
        GamaPoint gamaPoint;
        GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory = GamaGeometryFactory.COORDINATES_FACTORY;
        int n = list.size();
        CoordinateSequence coordinateSequence = gamaCoordinateSequenceFactory.create(n, 3);
        int n2 = 0;
        while (n2 < n) {
            gamaPoint = list.get(n2).getLocation();
            coordinateSequence.setOrdinate(n2, 0, gamaPoint.x);
            coordinateSequence.setOrdinate(n2, 1, gamaPoint.y);
            coordinateSequence.setOrdinate(n2, 2, gamaPoint.z);
            ++n2;
        }
        coordinateSequence = CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)gamaCoordinateSequenceFactory, (CoordinateSequence)coordinateSequence);
        LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateSequence);
        gamaPoint = GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, null);
        return GamaShapeFactory.createFrom((Geometry)gamaPoint);
    }

    public static IShape buildMultiPolygon(List<List<IShape>> list) {
        Polygon[] polygonArray = new Polygon[list.size()];
        int n = 0;
        while (n < list.size()) {
            GamaPoint gamaPoint;
            List<IShape> list2 = list.get(n);
            GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory = GamaGeometryFactory.COORDINATES_FACTORY;
            int n2 = list2.size();
            CoordinateSequence coordinateSequence = gamaCoordinateSequenceFactory.create(n2, 3);
            int n3 = 0;
            while (n3 < n2) {
                gamaPoint = list2.get(n3).getLocation();
                coordinateSequence.setOrdinate(n3, 0, gamaPoint.x);
                coordinateSequence.setOrdinate(n3, 1, gamaPoint.y);
                coordinateSequence.setOrdinate(n3, 2, gamaPoint.z);
                ++n3;
            }
            coordinateSequence = CoordinateSequences.ensureValidRing((CoordinateSequenceFactory)gamaCoordinateSequenceFactory, (CoordinateSequence)coordinateSequence);
            LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateSequence);
            gamaPoint = (Polygon)GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, null).convexHull();
            polygonArray[n] = gamaPoint;
            ++n;
        }
        MultiPolygon multiPolygon = GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
        return GamaShapeFactory.createFrom(multiPolygon.buffer(0.0));
    }

    public static IShape buildTriangle(double d, double d2, GamaPoint gamaPoint) {
        Coordinate[] coordinateArray = new Coordinate[4];
        double d3 = gamaPoint == null ? 0.0 : gamaPoint.getZ();
        coordinateArray[0] = new GamaPoint(-d / 2.0, d2 / 2.0, d3);
        coordinateArray[1] = new GamaPoint(0.0, -d2 / 2.0, d3);
        coordinateArray[2] = new GamaPoint(d / 2.0, d2 / 2.0, d3);
        coordinateArray[3] = coordinateArray[0];
        GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory = GamaGeometryFactory.COORDINATES_FACTORY;
        CoordinateSequence coordinateSequence = gamaCoordinateSequenceFactory.create(coordinateArray);
        LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateSequence);
        Polygon polygon = GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, null);
        GamaShape gamaShape = GamaShapeFactory.createFrom((Geometry)polygon);
        if (gamaPoint != null) {
            gamaShape.setLocation(gamaPoint);
        }
        return gamaShape;
    }

    public static IShape buildTriangle(double d, GamaPoint gamaPoint) {
        double d2 = Math.sqrt(3.0) / 2.0 * d;
        Coordinate[] coordinateArray = new Coordinate[4];
        double d3 = gamaPoint == null ? 0.0 : gamaPoint.getX();
        double d4 = gamaPoint == null ? 0.0 : gamaPoint.getY();
        double d5 = gamaPoint == null ? 0.0 : gamaPoint.getZ();
        coordinateArray[0] = new GamaPoint(d3 - d / 2.0, d4 + d2 / 3.0, d5);
        coordinateArray[1] = new GamaPoint(d3, d4 - 2.0 * d2 / 3.0, d5);
        coordinateArray[2] = new GamaPoint(d3 + d / 2.0, d4 + d2 / 3.0, d5);
        coordinateArray[3] = coordinateArray[0];
        GamaCoordinateSequenceFactory gamaCoordinateSequenceFactory = GamaGeometryFactory.COORDINATES_FACTORY;
        CoordinateSequence coordinateSequence = gamaCoordinateSequenceFactory.create(coordinateArray);
        LinearRing linearRing = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateSequence);
        Polygon polygon = GeometryUtils.GEOMETRY_FACTORY.createPolygon(linearRing, null);
        return GamaShapeFactory.createFrom((Geometry)polygon);
    }

    public static IShape buildRectangle(double d, double d2, GamaPoint gamaPoint) {
        Coordinate[] coordinateArray = new Coordinate[5];
        double d3 = gamaPoint == null ? 0.0 : gamaPoint.getX();
        double d4 = gamaPoint == null ? 0.0 : gamaPoint.getY();
        double d5 = gamaPoint == null ? 0.0 : gamaPoint.getZ();
        coordinateArray[4] = new GamaPoint(d3 - d / 2.0, d4 + d2 / 2.0, d5);
        coordinateArray[3] = new GamaPoint(d3 + d / 2.0, d4 + d2 / 2.0, d5);
        coordinateArray[2] = new GamaPoint(d3 + d / 2.0, d4 - d2 / 2.0, d5);
        coordinateArray[1] = new GamaPoint(d3 - d / 2.0, d4 - d2 / 2.0, d5);
        coordinateArray[0] = new GamaPoint(d3 - d / 2.0, d4 + d2 / 2.0, d5);
        return GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createRectangle(coordinateArray));
    }

    public static IShape buildPolyhedron(List<IShape> list, Double d) {
        IShape iShape = GamaGeometryType.buildPolygon(list);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.POLYHEDRON);
        return iShape;
    }

    public static IShape buildLine(IShape iShape) {
        return GamaGeometryType.buildLine(new GamaPoint(), iShape);
    }

    public static IShape buildLine(IShape iShape, IShape iShape2) {
        Coordinate[] coordinateArray = new Coordinate[]{iShape == null ? new GamaPoint(0.0, 0.0) : iShape.getLocation(), iShape2 == null ? new GamaPoint(0.0, 0.0) : iShape2.getLocation()};
        if (coordinateArray[0].equals((Object)coordinateArray[1])) {
            return GamaGeometryType.createPoint((GamaPoint)coordinateArray[0]);
        }
        return GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray));
    }

    public static IShape buildLineCylinder(IShape iShape, IShape iShape2, double d) {
        IShape iShape3 = GamaGeometryType.buildLine(iShape, iShape2);
        iShape3.setDepth(d);
        iShape3.setGeometricalType(IShape.Type.LINECYLINDER);
        return iShape3;
    }

    public static IShape buildPlan(IShape iShape, IShape iShape2, Double d) {
        IShape iShape3 = GamaGeometryType.buildLine(iShape, iShape2);
        iShape3.setDepth(d);
        iShape3.setGeometricalType(IShape.Type.PLAN);
        return iShape3;
    }

    public static IShape buildPolyline(List<IShape> list) {
        ArrayList<GamaPoint> arrayList = new ArrayList<GamaPoint>();
        for (IShape iShape : list) {
            arrayList.add(iShape.getLocation());
        }
        return GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createLineString(arrayList.toArray(new Coordinate[arrayList.size()])));
    }

    public static IShape buildPolylineCylinder(List<IShape> list, double d) {
        IShape iShape = GamaGeometryType.buildPolyline(list);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.LINECYLINDER);
        return iShape;
    }

    public static IShape buildPolyplan(List<IShape> list, Double d) {
        IShape iShape = GamaGeometryType.buildPolyline(list);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.POLYPLAN);
        return iShape;
    }

    public static GamaShape createPoint(IShape iShape) {
        return GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(iShape == null ? new GamaPoint(0.0, 0.0) : iShape.getLocation()));
    }

    public static IShape buildSquare(double d, GamaPoint gamaPoint) {
        return GamaGeometryType.buildRectangle(d, d, gamaPoint);
    }

    public static IShape buildCube(double d, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildRectangle(d, d, gamaPoint);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.CUBE);
        return iShape;
    }

    public static IShape buildBox(double d, double d2, double d3, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildRectangle(d, d2, gamaPoint);
        iShape.setDepth(d3);
        iShape.setGeometricalType(IShape.Type.BOX);
        return iShape;
    }

    public static IShape buildHexagon(double d, double d2, double d3) {
        return GamaGeometryType.buildHexagon(d, new GamaPoint(d2, d3));
    }

    public static IShape buildHexagon(double d, GamaPoint gamaPoint) {
        return GamaGeometryType.buildHexagon(d, d, gamaPoint);
    }

    public static IShape buildHexagon(double d, double d2, GamaPoint gamaPoint) {
        Coordinate[] coordinateArray;
        double d3 = gamaPoint.getX();
        double d4 = gamaPoint.getY();
        coordinateArray = new Coordinate[]{new GamaPoint(d3 - d / 2.0, d4), new GamaPoint(d3 - d / 4.0, d4 + d2 / 2.0), new GamaPoint(d3 + d / 4.0, d4 + d2 / 2.0), new GamaPoint(d3 + d / 2.0, d4), new GamaPoint(d3 + d / 4.0, d4 - d2 / 2.0), new GamaPoint(d3 - d / 4.0, d4 - d2 / 2.0), new GamaPoint(coordinateArray[0])};
        Polygon polygon = GeometryUtils.GEOMETRY_FACTORY.createPolygon(GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coordinateArray), null);
        return GamaShapeFactory.createFrom((Geometry)polygon);
    }

    public static IShape buildCircle(double d, GamaPoint gamaPoint) {
        Object object;
        Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint == null ? new GamaPoint(0.0, 0.0) : gamaPoint);
        Geometry geometry = point.buffer(d);
        if (gamaPoint != null) {
            object = geometry.getCoordinates();
            int n = 0;
            while (n < ((Object)object).length) {
                ((Coordinate)object[n]).z = gamaPoint.z;
                ++n;
            }
        }
        object = GamaShapeFactory.createFrom(geometry);
        object.setGeometricalType(IShape.Type.CIRCLE);
        return object;
    }

    public static IShape buildEllipse(double d, double d2, GamaPoint gamaPoint) {
        if (d <= 0.0 && d2 <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory((GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
        geometricShapeFactory.setNumPoints(GamaPreferences.Displays.DISPLAY_SLICE_NUMBER.getValue().intValue());
        geometricShapeFactory.setCentre((Coordinate)gamaPoint);
        geometricShapeFactory.setWidth(d);
        geometricShapeFactory.setHeight(d2);
        Polygon polygon = geometricShapeFactory.createEllipse();
        if (gamaPoint != null) {
            Coordinate[] coordinateArray = polygon.getCoordinates();
            int n = 0;
            while (n < coordinateArray.length) {
                coordinateArray[n].z = gamaPoint.z;
                ++n;
            }
        }
        return GamaShapeFactory.createFrom((Geometry)polygon);
    }

    public static IShape buildSquircle(double d, double d2, GamaPoint gamaPoint) {
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory((GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
        geometricShapeFactory.setNumPoints(GamaPreferences.Displays.DISPLAY_SLICE_NUMBER.getValue().intValue());
        geometricShapeFactory.setCentre((Coordinate)gamaPoint);
        geometricShapeFactory.setSize(d);
        Polygon polygon = geometricShapeFactory.createSupercircle(d2);
        if (gamaPoint != null) {
            Coordinate[] coordinateArray = polygon.getCoordinates();
            int n = 0;
            while (n < coordinateArray.length) {
                coordinateArray[n].z = gamaPoint.z;
                ++n;
            }
        }
        return GamaShapeFactory.createFrom((Geometry)polygon);
    }

    public static IShape buildArc(double d, double d2, double d3, boolean bl, GamaPoint gamaPoint) {
        if (d3 <= 0.0 || d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        GeometricShapeFactory geometricShapeFactory = new GeometricShapeFactory((GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
        geometricShapeFactory.setNumPoints(GamaPreferences.Displays.DISPLAY_SLICE_NUMBER.getValue().intValue());
        geometricShapeFactory.setCentre((Coordinate)gamaPoint);
        geometricShapeFactory.setSize(d);
        double d4 = Maths.checkHeading(d3);
        double d5 = Math.PI / 180 * d4;
        double d6 = Math.PI / 180 * Maths.checkHeading(d2 - d4 / 2.0);
        Object object = bl ? geometricShapeFactory.createArcPolygon(d6, d5) : geometricShapeFactory.createArc(d6, d5);
        if (gamaPoint != null) {
            Coordinate[] coordinateArray = object.getCoordinates();
            int n = 0;
            while (n < coordinateArray.length) {
                coordinateArray[n].z = gamaPoint.z;
                ++n;
            }
        }
        return GamaShapeFactory.createFrom((Geometry)object);
    }

    public static IShape buildCylinder(double d, double d2, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildCircle(d, gamaPoint);
        iShape.setDepth(d2);
        iShape.setGeometricalType(IShape.Type.CYLINDER);
        return iShape;
    }

    public static IShape buildSphere(double d, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildCircle(d, gamaPoint);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.SPHERE);
        return iShape;
    }

    public static IShape buildCone3D(double d, double d2, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildCircle(d, gamaPoint);
        iShape.setDepth(d2);
        iShape.setGeometricalType(IShape.Type.CONE);
        return iShape;
    }

    public static IShape buildTeapot(double d, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildCircle(d, gamaPoint);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.TEAPOT);
        return iShape;
    }

    public static IShape buildPyramid(double d, GamaPoint gamaPoint) {
        IShape iShape = GamaGeometryType.buildRectangle(d, d, gamaPoint);
        iShape.setDepth(d);
        iShape.setGeometricalType(IShape.Type.PYRAMID);
        return iShape;
    }

    public static IShape buildArrow(GamaPoint gamaPoint, double d) {
        return GamaGeometryType.buildArrow(new GamaPoint(), gamaPoint, d, d, true);
    }

    public static IShape buildArrow(GamaPoint gamaPoint, GamaPoint gamaPoint2, double d, double d2, boolean bl) {
        IList<IShape> iList = GamaListFactory.createWithoutCasting((IType)Types.POINT, gamaPoint2);
        GamaPoint gamaPoint3 = gamaPoint2.minus(gamaPoint);
        GamaPoint gamaPoint4 = new GamaPoint(-gamaPoint3.y, gamaPoint3.x);
        if (gamaPoint3.y == 0.0 && gamaPoint3.x == 0.0) {
            gamaPoint4 = new GamaPoint(-gamaPoint3.z, 0.0, 0.0);
        }
        double d3 = gamaPoint3.norm();
        double d4 = d / (2.0 * d3);
        double d5 = d2 / (2.0 * theta * d3);
        GamaPoint gamaPoint5 = gamaPoint2.minus(gamaPoint3.times(d5));
        if (bl) {
            iList.add(gamaPoint5.plus(gamaPoint4.times(d4)));
        } else {
            iList.add(0, gamaPoint5.plus(gamaPoint4.times(d4)));
        }
        iList.add(gamaPoint5.minus(gamaPoint4.times(d4)));
        return bl ? GamaGeometryType.buildPolygon(iList) : GamaGeometryType.buildPolyline(iList);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static GamaShape geometriesToGeometry(IScope var0, IContainer<?, ? extends IShape> var1_1) throws GamaRuntimeException {
        block18: {
            if (var1_1 == null || var1_1.isEmpty(var0)) {
                return null;
            }
            var2_2 = new ArrayList<Geometry>(var1_1.length(var0));
            var3_3 = true;
            var4_4 = true;
            for (Object var5_6 : var1_1.iterable(var0)) {
                if (var5_6 == null) continue;
                var7_7 = var5_6.getInnerGeometry();
                var2_2.add((Geometry)var7_7);
                if (var3_3 && !(var7_7 instanceof Polygon)) {
                    var3_3 = false;
                }
                if (!var4_4 || var7_7 instanceof LineString) continue;
                var4_4 = false;
            }
            if (var2_2.size() == 1) {
                return GamaShapeFactory.createFrom((Geometry)var2_2.get(0));
            }
            try {
                if (var3_3) {
                    var5_6 = CascadedPolygonUnion.union(var2_2);
                    if (var5_6 != null && !var5_6.isEmpty()) {
                        return GamaShapeFactory.createFrom((Geometry)var5_6);
                    }
                } else if (var4_4) {
                    var5_6 = new LineMerger();
                    for (Object var6_5 : var2_2) {
                        var5_6.add((Geometry)var6_5);
                    }
                    var6_5 = var5_6.getMergedLineStrings();
                    var7_7 = GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection(var6_5.toArray(new Geometry[0]));
                    if (!(var7_7 = var7_7.union()).isEmpty()) {
                        return GamaShapeFactory.createFrom((Geometry)var7_7);
                    }
                } else {
                    var5_6 = GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection(var2_2.toArray(new Geometry[0]));
                    if (!(var5_6 = var5_6.union()).isEmpty()) {
                        return GamaShapeFactory.createFrom((Geometry)var5_6);
                    }
                }
                break block18;
            }
            catch (IllegalArgumentException | NullPointerException | TopologyException | AssertionFailedException v0) {
                var5_6 = new ArrayList<E>(var2_2.size());
                ** for (var6_5 : var2_2)
            }
lbl-1000:
            // 1 sources

            {
                var5_6.add(var6_5.buffer(0.0));
                continue;
            }
lbl44:
            // 1 sources

            try {
                var6_5 = CascadedPolygonUnion.union((Collection)var5_6);
                if (var6_5 != null && !var6_5.isEmpty()) {
                    return GamaShapeFactory.createFrom((Geometry)var6_5);
                }
            }
            catch (IllegalArgumentException | NullPointerException | TopologyException | AssertionFailedException v1) {}
        }
        return null;
    }

    public static GamaShape pointsToGeometry(IScope iScope, IContainer<?, GamaPoint> iContainer) throws GamaRuntimeException {
        if (iContainer != null && !iContainer.isEmpty(iScope)) {
            IList iList = GamaListFactory.create(Types.LIST.of(Types.POINT));
            iList.add(iContainer.listValue(iScope, Types.NO_TYPE, false));
            IList<List<List<GamaPoint>>> iList2 = GamaListFactory.create(Types.LIST);
            iList2.add(iList);
            Geometry geometry = GeometryUtils.buildGeometryJTS(iList2);
            return GamaShapeFactory.createFrom(geometry);
        }
        return null;
    }

    public static GamaShape buildLink(IScope iScope, IShape iShape, IShape iShape2) {
        return GamaShapeFactory.createFrom((Geometry)new DynamicLineString(GeometryUtils.GEOMETRY_FACTORY, iShape, iShape2));
    }

    public static IShape pairToGeometry(IScope iScope, GamaPair gamaPair) throws GamaRuntimeException {
        IShape iShape = GamaGeometryType.staticCast(iScope, gamaPair.first(), null, false);
        if (iShape == null) {
            return null;
        }
        IShape iShape2 = GamaGeometryType.staticCast(iScope, gamaPair.last(), null, false);
        if (iShape2 == null) {
            return null;
        }
        return GamaGeometryType.buildLink(iScope, iShape, iShape2);
    }

    public static IShape buildMultiGeometry(IList<IShape> iList) {
        if (iList.size() == 0) {
            return null;
        }
        if (iList.size() == 1) {
            return (IShape)iList.get(0);
        }
        Geometry geometry = GeometryUtils.buildGeometryCollection(iList);
        if (geometry == null) {
            return null;
        }
        return GamaShapeFactory.createFrom(geometry);
    }

    public static IShape buildMultiGeometry(IShape ... iShapeArray) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Collector.AsList asList = Collector.getList();){
            IShape[] iShapeArray2 = iShapeArray;
            int n = iShapeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShape iShape = iShapeArray2[n2];
                if (iShape != null) {
                    asList.add(iShape);
                }
                ++n2;
            }
            return GamaGeometryType.buildMultiGeometry((IList<IShape>)asList.items());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IShape buildCross(Double d, Double d2, GamaPoint gamaPoint) {
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        double d3 = d / Math.sqrt(2.0);
        IShape iShape = GamaGeometryType.buildLine(new GamaPoint(gamaPoint.x - d3, gamaPoint.y - d3), new GamaPoint(gamaPoint.x + d3, gamaPoint.y + d3));
        IShape iShape2 = GamaGeometryType.buildLine(new GamaPoint(gamaPoint.x - d3, gamaPoint.y + d3), new GamaPoint(gamaPoint.x + d3, gamaPoint.y - d3));
        if (d2 != null && d2 > 0.0) {
            iShape = SpatialTransformations.enlarged_by(null, iShape, d2);
            iShape2 = SpatialTransformations.enlarged_by(null, iShape2, d2);
        }
        return SpatialOperators.union(null, iShape, iShape2);
    }
}

