/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="int", id=1, wraps={Integer.class, int.class, Long.class}, kind=101, concept={"type"}, doc={@GamlAnnotations.doc(value="Type of integer numbers")})
public class GamaIntegerType
extends GamaType<Integer> {
    @Override
    @GamlAnnotations.doc(value="Returns the parameter casted to an int value. If it is an integer, returns it. A float, returns its integer value. A color, its rgb value. An agent, its index. A string, attempts to parse it (with a radix of 16 if it begins with '#'). A bool, return 1 if true. A font, return its size.  Otherwise return 0")
    public Integer cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaIntegerType.staticCast(iScope, object, object2, bl);
    }

    public static Integer staticCast(IScope iScope, Object object, Object object2, boolean bl) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            String string = object.toString();
            string = string.replaceAll("\\p{Zs}", "");
            try {
                if (string.startsWith("#")) {
                    return Integer.parseInt(string.substring(1), 16);
                }
                int n = 10;
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                }
                return Integer.parseInt(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                Double d = 0.0;
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    return 0;
                }
                return d.intValue();
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof IValue) {
            IValue iValue = (IValue)object;
            return iValue.intValue(iScope);
        }
        return 0;
    }

    @Override
    public Integer getDefault() {
        return 0;
    }

    @Override
    public boolean isTranslatableInto(IType<?> iType) {
        return iType.isNumber() || iType == Types.NO_TYPE;
    }

    @Override
    public IType<?> coerce(IType<?> iType, IDescription iDescription) {
        if (iType == this) {
            return null;
        }
        return this;
    }

    @Override
    public IType findCommonSupertypeWith(IType<?> iType) {
        return iType == this ? this : (iType.id() == 2 ? iType : Types.NO_TYPE);
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return true;
    }
}

