/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.TypeExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.GamaNoType;
import gama.gaml.types.GamaSpeciesType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ParametricType;
import gama.gaml.types.Types;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class GamaType<Support>
implements IType<Support> {
    protected int id;
    protected String name;
    protected Class<Support> support;
    Map<String, OperatorProto> getters;
    protected IType<? super Support> parent;
    protected int varKind;
    protected String plugin;
    final IExpression expression = new TypeExpression(this);
    public static final int TYPE = 0;
    public static final int CONTENT = 1;
    public static final int KEY = 2;
    public static final int DENOTED = 3;
    public static final int PAIR_OF_TYPES = 4;

    static {
        DEBUG.ON();
    }

    @Override
    public String getTitle() {
        return "Data type " + this.getName();
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public String getDefiningPlugin() {
        return this.plugin;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        GamlAnnotations.doc[] docArray;
        GamlAnnotations.type type2;
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc();
        GamlAnnotations.doc doc2 = this.getClass().getAnnotation(GamlAnnotations.doc.class);
        if (doc2 == null && (type2 = this.getClass().getAnnotation(GamlAnnotations.type.class)) != null && (docArray = type2.doc()) != null && docArray.length > 0) {
            doc2 = docArray[0];
        }
        regularDoc.append("<i>").append("Wraps Java objects of type ").append(this.getSupportName()).append("</i>");
        if (doc2 != null) {
            regularDoc.append("<p>").append(doc2.value()).append("</p>");
        }
        this.documentFields(regularDoc);
        return regularDoc;
    }

    @Override
    public void documentFields(IGamlDescription.Doc doc2) {
        if (this.getters != null) {
            if (this.getters.isEmpty()) {
                doc2.append("<p>").append("No fields accessible").append("</p>");
            }
            for (OperatorProto operatorProto : this.getters.values()) {
                this.getFieldDocumentation(doc2, operatorProto);
            }
        }
    }

    public String getSupportName() {
        return this.support.getSimpleName();
    }

    void getFieldDocumentation(IGamlDescription.Doc doc2, OperatorProto operatorProto) {
        GamlAnnotations.vars vars2 = operatorProto.getJavaBase().getAnnotation(GamlAnnotations.vars.class);
        if (vars2 != null) {
            GamlAnnotations.variable[] variableArray;
            GamlAnnotations.variable[] variableArray2 = variableArray = vars2.value();
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamlAnnotations.variable variable2 = variableArray2[n2];
                if (variable2.name().equals(operatorProto.getName())) {
                    if (variable2.doc().length <= 0) break;
                    doc2.set("Accessible fields: ", variable2.name(), new IGamlDescription.ConstantDoc(variable2.doc()[0].value()));
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.name;
    }

    @Override
    public void init(int n, int n2, String string, Class<Support> clazz) {
        this.varKind = n;
        this.id = n2;
        this.name = string;
        this.support = clazz;
    }

    @Override
    public void setSupport(Class<Support> clazz) {
        this.support = clazz;
    }

    @Override
    public int getVarKind() {
        return this.varKind;
    }

    @Override
    public void setParent(IType<? super Support> iType) {
        this.parent = iType;
    }

    @Override
    public IType<? super Support> getParent() {
        return this.parent;
    }

    @Override
    public void setFieldGetters(Map<String, OperatorProto> map) {
        map.replaceAll((string, operatorProto) -> operatorProto.copyWithSignature(this));
        this.getters = map;
    }

    @Override
    public OperatorProto getGetter(String string) {
        if (this.getters == null) {
            return null;
        }
        return this.getters.get(string);
    }

    @Override
    public Map<String, OperatorProto> getFieldGetters() {
        return this.getters == null ? Collections.EMPTY_MAP : this.getters;
    }

    @Override
    public abstract Support cast(IScope var1, Object var2, Object var3, boolean var4) throws GamaRuntimeException;

    @Override
    public Support cast(IScope iScope, Object object, Object object2, IType<?> iType, IType<?> iType2, boolean bl) throws GamaRuntimeException {
        return this.cast(iScope, object, object2, bl);
    }

    @Override
    public int id() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (object instanceof IType) {
            return ((IType)object).id() == this.id;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String asPattern() {
        boolean bl = StringUtils.startsWithAny((CharSequence)this.name, (CharSequence[])vowels);
        return "${" + (bl ? "an_" : "a_") + this.name + "}";
    }

    @Override
    public Class<? extends Support> toClass() {
        return this.support;
    }

    @Override
    public boolean isAgentType() {
        return false;
    }

    @Override
    public boolean isSkillType() {
        return false;
    }

    @Override
    public IType<?> getContentType() {
        return Types.NO_TYPE;
    }

    @Override
    public IType<?> getKeyType() {
        return Types.NO_TYPE;
    }

    @Override
    public String getSpeciesName() {
        return null;
    }

    @Override
    public SpeciesDescription getSpecies() {
        return null;
    }

    @Override
    public SpeciesDescription getDenotedSpecies() {
        return this.getSpecies();
    }

    protected boolean isSuperTypeOf(IType<?> iType) {
        if (iType == null) {
            return false;
        }
        IType<?> iType2 = iType.getParent();
        while (iType2 != null) {
            if (this == iType2) {
                return true;
            }
            iType2 = iType2.getParent();
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(IType<?> iType) {
        return this == iType || this.isSuperTypeOf(iType);
    }

    @Override
    public boolean isTranslatableInto(IType<?> iType) {
        return iType.isAssignableFrom(this);
    }

    @Override
    public boolean canBeTypeOf(IScope iScope, Object object) {
        if (object == null) {
            return this.acceptNullInstances();
        }
        return this.support.isAssignableFrom(object.getClass());
    }

    @Override
    public boolean isParametricType() {
        return false;
    }

    @Override
    public boolean isParametricFormOf(IType<?> iType) {
        return false;
    }

    protected boolean acceptNullInstances() {
        return this.getDefault() == null;
    }

    @Override
    public IType<?> coerce(IType<?> iType, IDescription iDescription) {
        return null;
    }

    @Override
    public int distanceTo(IType<?> iType) {
        if (iType == this) {
            return 0;
        }
        if (iType == null) {
            return Integer.MAX_VALUE;
        }
        if (this.isSuperTypeOf(iType)) {
            return 1 + this.distanceTo(iType.getParent());
        }
        return 1 + this.getParent().distanceTo(iType);
    }

    @Override
    public IType<? super Support> findCommonSupertypeWith(IType<?> iType) {
        if (iType == this) {
            return this;
        }
        if (iType == Types.NO_TYPE) {
            return this.getDefault() == null ? this : (GamaNoType)iType;
        }
        if (iType.isTranslatableInto(this)) {
            return this;
        }
        if (this.isTranslatableInto(iType)) {
            return iType;
        }
        return this.getParent().findCommonSupertypeWith(iType.getParent());
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    public static Object toType(IScope iScope, Object object, IType<?> iType, boolean bl) {
        if (iType == null || iType.id() == 0) {
            return object;
        }
        return iType.cast(iScope, object, null, bl);
    }

    public IType<?> keyTypeIfCasting(IExpression iExpression) {
        return this.getKeyType();
    }

    public IType<?> contentsTypeIfCasting(IExpression iExpression) {
        return this.getContentType();
    }

    public IType<Support> getGamlType() {
        return this;
    }

    @Override
    public IType<?> typeIfCasting(IExpression iExpression) {
        return GamaType.from(this, this.keyTypeIfCasting(iExpression), this.contentsTypeIfCasting(iExpression));
    }

    public static IType<?> from(TypeDescription typeDescription) {
        return GamaType.from(Types.SPECIES, Types.INT, typeDescription.getGamlType());
    }

    public static IContainerType<?> from(IContainerType<IContainer<?, ?>> iContainerType, IType<?> iType, IType<?> iType2) {
        if (!(iType != null && iType != Types.NO_TYPE || iType2 != null && iType2 != Types.NO_TYPE)) {
            return iContainerType;
        }
        IType<?> iType3 = iType == Types.NO_TYPE ? iContainerType.getGamlType().getKeyType() : iType;
        IType<?> iType4 = iType2 == Types.NO_TYPE ? iContainerType.getGamlType().getContentType() : iType2;
        return ParametricType.createParametricType(iContainerType.getGamlType(), iType3, iType4);
    }

    public static IType<?> from(IType<?> iType, IType<?> iType2, IType<?> iType3) {
        if (iType2 == null || iType3 == null) {
            return iType;
        }
        if (iType instanceof IContainerType) {
            if (!(iType instanceof GamaSpeciesType) && iType3.isAssignableFrom(iType.getContentType()) && iType2.isAssignableFrom(iType.getKeyType())) {
                return iType;
            }
            return GamaType.from((IContainerType)iType, iType2, iType3);
        }
        return iType;
    }

    public static IType<?> findCommonType(IExpression[] iExpressionArray, int n) {
        IType iType = Types.NO_TYPE;
        if (iExpressionArray.length == 0) {
            return iType;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            IType[] iTypeArray;
            IExpression[] iExpressionArray2 = iExpressionArray;
            int n2 = iExpressionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iTypeArray = iExpressionArray2[n3];
                if (iTypeArray != null) {
                    IType<?> iType2 = iTypeArray.getGamlType();
                    asOrderedSet.add(n == 0 ? iType2 : (n == 1 ? iType2.getContentType() : iType2.getKeyType()));
                }
                ++n3;
            }
            iTypeArray = asOrderedSet.items().toArray(new IType[asOrderedSet.size()]);
            return GamaType.findCommonType(iTypeArray);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IType<?> findCommonType(IExpression ... iExpressionArray) {
        return GamaType.findCommonType(iExpressionArray, 0);
    }

    public static IType<?> findCommonType(IType<?> ... iTypeArray) {
        IType<Object> iType = Types.NO_TYPE;
        if (iTypeArray.length == 0) {
            return iType;
        }
        iType = iTypeArray[0];
        if (iTypeArray.length == 1) {
            return iType;
        }
        int n = 1;
        while (n < iTypeArray.length) {
            IType<?> iType2 = iTypeArray[n];
            if (iType2 == Types.NO_TYPE) {
                if (iType.getDefault() != null) {
                    iType = Types.NO_TYPE;
                }
            } else {
                iType = iType == Types.NO_TYPE ? iType2.findCommonSupertypeWith(iType) : iType.findCommonSupertypeWith(iType2);
            }
            ++n;
        }
        return iType;
    }

    public static IType<?> of(Object object) {
        if (object instanceof IValue) {
            return ((IValue)object).getGamlType();
        }
        if (object instanceof IExpression) {
            return ((IExpression)object).getGamlType();
        }
        if (object == null) {
            return Types.NO_TYPE;
        }
        return Types.get(object.getClass());
    }

    public static IType<?> findSpecificType(IType<?> iType, IType<?> iType2) {
        return GamaType.requiresCasting(iType, iType2) ? iType : iType2;
    }

    public static boolean requiresCasting(IType<?> iType, IType<?> iType2) {
        return iType != null && iType != Types.NO_TYPE && !iType.isAssignableFrom(iType2);
    }

    @Override
    public void setDefiningPlugin(String string) {
        this.plugin = string;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        if (this.plugin != null) {
            gamlProperties.put("plugins", this.plugin);
            gamlProperties.put("types", this.name);
        }
    }

    @Override
    public boolean isDrawable() {
        return false;
    }

    @Override
    public IType<?> getWrappedType() {
        return Types.NO_TYPE;
    }

    @Override
    public boolean isCompoundType() {
        return false;
    }

    @Override
    public Support deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        throw GamaRuntimeException.error("The deserialization of " + this.getName() + " objects has not yet been implemented", iScope);
    }

    @Override
    public IExpression getExpression() {
        return this.expression;
    }
}

