/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.interfaces;

import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.ILayer;
import gama.core.common.util.RandomUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.util.matrix.IField;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.statements.draw.TextDrawingAttributes;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public interface IGraphics {
    public static final RenderingHints QUALITY_RENDERING = new RenderingHints(null);
    public static final RenderingHints SPEED_RENDERING = new RenderingHints(null);
    public static final RenderingHints MEDIUM_RENDERING = new RenderingHints(null);

    public RandomUtils getRandom();

    public void setDisplaySurface(IDisplaySurface var1);

    public int getDisplayWidth();

    public int getDisplayHeight();

    public Rectangle2D drawAsset(IAsset var1, DrawingAttributes var2);

    public Rectangle2D drawField(IField var1, MeshDrawingAttributes var2);

    public Rectangle2D drawImage(BufferedImage var1, DrawingAttributes var2);

    public Rectangle2D drawChart(ChartOutput var1);

    public Rectangle2D drawString(String var1, TextDrawingAttributes var2);

    public Rectangle2D drawShape(Geometry var1, DrawingAttributes var2);

    public void setAlpha(double var1);

    public void fillBackground(Color var1);

    public boolean beginDrawingLayers();

    public void beginDrawingLayer(ILayer var1);

    public void beginOverlay(OverlayLayer var1);

    public void endOverlay();

    public double getyRatioBetweenPixelsAndModelUnits();

    public double getxRatioBetweenPixelsAndModelUnits();

    public double getAbsoluteRatioBetweenPixelsAndModelsUnits();

    public Envelope getVisibleRegion();

    public void endDrawingLayer(ILayer var1);

    public void endDrawingLayers();

    public void beginHighlight();

    public void endHighlight();

    public double getXOffsetInPixels();

    public double getYOffsetInPixels();

    public Double getZoomLevel();

    default public boolean is2D() {
        return true;
    }

    public int getViewWidth();

    public int getViewHeight();

    public IDisplaySurface getSurface();

    default public double getMaxEnvDim() {
        return this.getSurface().getData().getMaxEnvDim();
    }

    default public double getEnvWidth() {
        return this.getSurface().getData().getEnvWidth();
    }

    default public double getEnvHeight() {
        return this.getSurface().getData().getEnvHeight();
    }

    public void dispose();

    public boolean isNotReadyToUpdate();

    default public void accumulateTemporaryEnvelope(Rectangle2D rectangle2D) {
    }

    default public Rectangle2D getAndWipeTemporaryEnvelope() {
        return null;
    }

    public static interface ThreeD
    extends IGraphics {
        @Override
        default public boolean is2D() {
            return false;
        }

        public GamaPoint getCameraPos();

        public GamaPoint getCameraTarget();

        public GamaPoint getCameraOrientation();
    }
}

