/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.core.kernel.experiment.AbstractExperimentController;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.TestAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import java.util.concurrent.ArrayBlockingQueue;

public class DefaultExperimentController
extends AbstractExperimentController {
    private IExperimentAgent agent;
    private final Thread executionThread;

    public DefaultExperimentController(IExperimentPlan iExperimentPlan) {
        this.commands = new ArrayBlockingQueue(10);
        this.experiment = iExperimentPlan;
        this.executionThread = new Thread(() -> {
            while (this.experimentAlive) {
                this.step();
            }
        }, "Front end scheduler");
        this.executionThread.setUncaughtExceptionHandler(GamaExecutorService.EXCEPTION_HANDLER);
        this.commandThread.setUncaughtExceptionHandler(GamaExecutorService.EXCEPTION_HANDLER);
        this.lock.acquire();
        this.commandThread.start();
        this.executionThread.start();
    }

    @Override
    protected boolean processUserCommand(IExperimentController.ExperimentCommand experimentCommand) {
        IScope iScope = this.getScope();
        switch (experimentCommand) {
            case _CLOSE: {
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.NONE);
                return true;
            }
            case _OPEN: {
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.NOTREADY);
                try {
                    this.experiment.open();
                    return true;
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    DEBUG.ERR((Object)("Error in previous experiment: " + gamaRuntimeException.getMessage()));
                    this.closeExperiment(gamaRuntimeException);
                    return false;
                }
                catch (Exception exception) {
                    DEBUG.ERR((Object)("Error when opening the experiment: " + exception.getMessage()));
                    this.closeExperiment(exception);
                    return false;
                }
            }
            case _START: {
                try {
                    this.paused = false;
                    this.lock.release();
                    return true;
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    this.closeExperiment(gamaRuntimeException);
                    return false;
                }
                finally {
                    GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.RUNNING);
                }
            }
            case _PAUSE: {
                this.paused = true;
                if (!this.disposing) {
                    GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.PAUSED);
                }
                return true;
            }
            case _STEP: {
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.PAUSED);
                this.paused = true;
                this.lock.release();
                return true;
            }
            case _BACK: {
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.PAUSED);
                this.paused = true;
                this.experiment.getAgent().backward(this.getScope());
                return true;
            }
            case _RELOAD: {
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.NOTREADY);
                try {
                    boolean bl = !this.isPaused() && !this.experiment.isAutorun();
                    this.paused = true;
                    iScope.getGui().getStatus().waitStatus(iScope, "Reloading...");
                    this.experiment.reload();
                    if (bl) {
                        boolean bl2 = this.processUserCommand(IExperimentController.ExperimentCommand._START);
                        return bl2;
                    }
                    iScope.getGui().getStatus().informStatus(iScope, "Experiment reloaded");
                    return true;
                }
                catch (GamaRuntimeException gamaRuntimeException) {
                    this.closeExperiment(gamaRuntimeException);
                    return false;
                }
                catch (Throwable throwable) {
                    this.closeExperiment(GamaRuntimeException.create(throwable, iScope));
                    return false;
                }
                finally {
                    GAMA.updateExperimentState(this.experiment);
                }
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        this.scope = null;
        this.agent = null;
        if (this.experiment != null) {
            try {
                this.paused = true;
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.NOTREADY);
                this.getScope().getGui().closeDialogs(this.getScope());
                GAMA.updateExperimentState(this.experiment, IExperimentStateListener.State.NONE);
            }
            finally {
                this.acceptingCommands = false;
                this.experimentAlive = false;
                this.lock.release();
                if (this.commandThread != null && this.commandThread.isAlive()) {
                    this.commands.offer(IExperimentController.ExperimentCommand._CLOSE);
                }
            }
        }
    }

    @Override
    public void close() {
        this.closeExperiment(null);
    }

    public void closeExperiment(Exception exception) {
        this.disposing = true;
        if (exception != null) {
            this.getScope().getGui().getStatus().errorStatus(this.scope, exception);
        }
        this.experiment.dispose();
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void schedule(ExperimentAgent experimentAgent) {
        block5: {
            this.agent = experimentAgent;
            this.scope = experimentAgent.getScope();
            this.serverConfiguration = GAMA.getPlatformAgent().getServer() != null ? GAMA.getPlatformAgent().getServer().obtainGuiServerConfiguration() : null;
            this.scope.setServerConfiguration(this.serverConfiguration);
            try {
                if (!this.scope.init(experimentAgent).passed()) {
                    this.scope.setDisposeStatus();
                } else if (experimentAgent instanceof TestAgent || experimentAgent.getSpecies().isAutorun()) {
                    this.asynchronousStart();
                }
            }
            catch (Throwable throwable) {
                if (this.scope != null && this.scope.interrupted() || throwable instanceof GamaRuntimeException) break block5;
                GAMA.reportError(this.scope, GamaRuntimeException.create(throwable, this.scope), true);
            }
        }
    }

    protected void step() {
        if (this.paused) {
            this.lock.acquire();
        }
        try {
            if (this.scope == null) {
                return;
            }
            if (!this.scope.step(this.agent).passed()) {
                this.scope.setDisposeStatus();
                this.paused = true;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }
}

