/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.shape;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IEnvelopeProvider;
import gama.core.common.interfaces.ILocated;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.runtime.IScope;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonGeometryObject;
import gama.core.util.file.json.JsonValue;
import gama.gaml.interfaces.IAttributed;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="area", type=2, doc={@GamlAnnotations.doc(value="Returns the total area of this geometry")}), @GamlAnnotations.variable(name="volume", type=2, doc={@GamlAnnotations.doc(value="Returns the total volume of this geometry")}), @GamlAnnotations.variable(name="centroid", type=7, doc={@GamlAnnotations.doc(value="Returns the centroid of this geometry")}), @GamlAnnotations.variable(name="width", type=2, doc={@GamlAnnotations.doc(value="Returns the width (length on the x-axis) of the rectangular envelope of this  geometry")}), @GamlAnnotations.variable(name="attributes", type=10, index=4, doc={@GamlAnnotations.doc(value="Returns the attributes kept by this geometry (the ones shared with the agent)")}), @GamlAnnotations.variable(name="depth", type=2, doc={@GamlAnnotations.doc(value="Returns the depth (length on the z-axis) of the rectangular envelope of this geometry")}), @GamlAnnotations.variable(name="height", type=2, doc={@GamlAnnotations.doc(value="Returns the height (length on the y-axis) of the rectangular envelope of this geometry")}), @GamlAnnotations.variable(name="points", type=5, of=7, doc={@GamlAnnotations.doc(value="Returns the list of points that delimit this geometry. A point will return a list with itself")}), @GamlAnnotations.variable(name="envelope", type=13, doc={@GamlAnnotations.doc(value="Returns the envelope of this geometry (the smallest rectangle that contains the geometry)")}), @GamlAnnotations.variable(name="geometries", type=5, of=13, doc={@GamlAnnotations.doc(value="Returns the list of geometries that compose this geometry, or a list containing the geometry itself if it is simple")}), @GamlAnnotations.variable(name="multiple", type=3, doc={@GamlAnnotations.doc(value="Returns whether this geometry is composed of multiple geometries or not")}), @GamlAnnotations.variable(name="perimeter", type=2, doc={@GamlAnnotations.doc(value="Returns the length of the contour of this geometry")}), @GamlAnnotations.variable(name="holes", type=5, of=13, doc={@GamlAnnotations.doc(value="Returns the list of holes inside this geometry as a list of geometries, and an emptly list if this geometry is solid")}), @GamlAnnotations.variable(name="contour", type=13, doc={@GamlAnnotations.doc(value="Returns the polyline representing the contour of this geometry")})})
public interface IShape
extends ILocated,
IValue,
IAttributed,
IEnvelopeProvider {
    public static final Map<String, Type> JTS_TYPES = GamaMapFactory.createUnordered();
    public static final Set<Type> THREED_TYPES = new HashSet<Type>();
    public static final WKTWriter SHAPE_WRITER = new WKTWriter();

    @Override
    public IShape copy(IScope var1);

    public boolean covers(IShape var1);

    public boolean partiallyOverlaps(IShape var1);

    public boolean touches(IShape var1);

    public boolean crosses(IShape var1);

    public void dispose();

    public double euclidianDistanceTo(GamaPoint var1);

    public double euclidianDistanceTo(IShape var1);

    public IAgent getAgent();

    public Envelope3D getEnvelope();

    public Type getGeometricalType();

    public IShape getGeometry();

    public Geometry getInnerGeometry();

    public boolean intersects(IShape var1);

    public boolean isLine();

    public boolean isPoint();

    public void setAgent(IAgent var1);

    public void setGeometry(IShape var1);

    public void setInnerGeometry(Geometry var1);

    public void setDepth(double var1);

    @GamlAnnotations.getter(value="attributes")
    default public IMap<String, Object> getOrCreateAttributes() {
        return (IMap)this.getAttributes(true);
    }

    @GamlAnnotations.getter(value="multiple")
    public boolean isMultiple();

    @GamlAnnotations.getter(value="area")
    public Double getArea();

    @GamlAnnotations.getter(value="volume")
    public Double getVolume();

    @GamlAnnotations.getter(value="perimeter")
    public double getPerimeter();

    @Override
    default public double floatValue(IScope iScope) {
        return this.getArea();
    }

    @Override
    default public int intValue(IScope iScope) {
        return this.getArea().intValue();
    }

    @GamlAnnotations.getter(value="holes")
    public IList<GamaShape> getHoles();

    @GamlAnnotations.getter(value="centroid")
    public GamaPoint getCentroid();

    @GamlAnnotations.getter(value="contour")
    public GamaShape getExteriorRing(IScope var1);

    @GamlAnnotations.getter(value="width")
    default public Double getWidth() {
        return this.getEnvelope().getWidth();
    }

    @GamlAnnotations.getter(value="height")
    default public Double getHeight() {
        return this.getEnvelope().getHeight();
    }

    @GamlAnnotations.getter(value="depth")
    public Double getDepth();

    default public Double getMaxDimension() {
        return Math.max(Math.max(this.getHeight(), this.getWidth()), this.getDepth() == null ? 0.0 : this.getDepth());
    }

    @GamlAnnotations.getter(value="envelope")
    default public GamaShape getGeometricEnvelope() {
        return GamaShapeFactory.createFrom(this.getEnvelope());
    }

    @GamlAnnotations.getter(value="points")
    public IList<GamaPoint> getPoints();

    @GamlAnnotations.getter(value="geometries")
    public IList<? extends IShape> getGeometries();

    default public void copyShapeAttributesFrom(IShape iShape) {
        Type type2;
        Double d = iShape.getDepth();
        if (d != null) {
            this.setDepth(d);
        }
        if (THREED_TYPES.contains((Object)(type2 = iShape.getGeometricalType()))) {
            this.setGeometricalType(type2);
        }
    }

    public void setGeometricalType(Type var1);

    @Override
    default public Envelope3D computeEnvelope(IScope iScope) {
        return this.getEnvelope();
    }

    @Override
    default public JsonValue serializeToJson(Json json) {
        try {
            JsonGeometryObject jsonGeometryObject = new JsonGeometryObject(this.getInnerGeometry(), json);
            jsonGeometryObject.add("inner_type", this.getGeometricalType().name());
            if (this.getAgent() != null) {
                jsonGeometryObject.add("agent", json.valueOf(this.getAgent()));
            }
            if (this.getDepth() != null) {
                jsonGeometryObject.add("depth", json.valueOf(this.getDepth()));
            }
            return jsonGeometryObject;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Json.NULL;
        }
    }

    public static enum Type {
        BOX("3D"),
        CIRCLE("3D"),
        CONE("3D"),
        CUBE("3D"),
        SQUARE("3D"),
        ROUNDED(""),
        CYLINDER("3D"),
        GRIDLINE(""),
        LINEARRING("LinearRing"),
        LINESTRING("LineString"),
        MULTILINESTRING("MultiLineString"),
        MULTIPOINT("MultiPoint"),
        MULTIPOLYGON("MultiPolygon"),
        NULL(""),
        PLAN("3D"),
        POINT("Point"),
        POLYGON("Polygon"),
        POLYHEDRON("3D"),
        POLYPLAN("3D"),
        PYRAMID("3D"),
        SPHERE("3D"),
        TEAPOT("3D"),
        LINECYLINDER("3D"),
        THREED_FILE("");


        private Type(String string2) {
            if (string2.isEmpty()) {
                return;
            }
            if ("3D".equals(string2)) {
                THREED_TYPES.add(this);
            } else {
                JTS_TYPES.put(string2, this);
            }
        }
    }
}

