/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.projection;

import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class SimpleScalingProjection
implements IProjection {
    public CoordinateFilter scaling;
    public CoordinateFilter inverseScaling;

    @Override
    public void createTransformation(MathTransform mathTransform) {
    }

    public SimpleScalingProjection(Double d) {
        if (d != null) {
            this.createScalingTransformations(d);
        }
    }

    @Override
    public Geometry transform(Geometry geometry) {
        if (this.scaling != null) {
            geometry.apply(this.scaling);
            geometry.geometryChanged();
        }
        return geometry;
    }

    @Override
    public Geometry inverseTransform(Geometry geometry) {
        if (this.inverseScaling != null) {
            geometry.apply(this.inverseScaling);
            geometry.geometryChanged();
        }
        return geometry;
    }

    public void createScalingTransformations(Double d) {
        this.scaling = coordinate -> {
            coordinate.x *= d.doubleValue();
            coordinate.y *= d.doubleValue();
            coordinate.z *= d.doubleValue();
        };
        this.inverseScaling = coordinate -> {
            coordinate.x /= d.doubleValue();
            coordinate.y /= d.doubleValue();
            coordinate.z /= d.doubleValue();
        };
    }

    @Override
    public CoordinateReferenceSystem getInitialCRS(IScope iScope) {
        return null;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS(IScope iScope) {
        return null;
    }

    @Override
    public Envelope3D getProjectedEnvelope() {
        return null;
    }

    @Override
    public void translate(Geometry geometry) {
    }

    @Override
    public void inverseTranslate(Geometry geometry) {
    }

    @Override
    public void convertUnit(Geometry geometry) {
    }

    @Override
    public void inverseConvertUnit(Geometry geometry) {
    }
}

