/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.outputs.AbstractOutputManager;
import gama.core.outputs.IOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.factories.DescriptionFactory;
import java.util.HashMap;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="synchronized", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether the displays that compose this output should be synchronized with the simulation cycles")}), @GamlAnnotations.facet(name="autosave", type={3, 4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to save the whole screen on disk. A value of true/false will save it with the resolution of the physical screen. Passing it a string allows to define the filename Note that setting autosave to true (or to any other value than false) will synchronize all the displays defined in the experiment")})})
@GamlAnnotations.inside(kinds={1, 13})
@GamlAnnotations.doc(value="`output` blocks define how to visualize a simulation (with one or more display blocks that define separate windows). It will include a set of displays, monitors and files statements. It will be taken into account only if the experiment type is `gui`.", usages={@GamlAnnotations.usage(value="Its basic syntax is: ", examples={@GamlAnnotations.example(value="experiment exp_name type: gui {", isExecutable=false), @GamlAnnotations.example(value="   // [inputs]", isExecutable=false), @GamlAnnotations.example(value="   output {", isExecutable=false), @GamlAnnotations.example(value="      // [display, file, inspect, layout or monitor statements]", isExecutable=false), @GamlAnnotations.example(value="   }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "monitor", "inspect", "layout"})
@validator(value=SimulationOutputValidator.class)
public class SimulationOutputManager
extends AbstractOutputManager {
    public static SimulationOutputManager createEmpty() {
        return new SimulationOutputManager(DescriptionFactory.create("output", null));
    }

    public SimulationOutputManager(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public boolean init(IScope iScope) {
        iScope.getGui().getStatus().waitStatus(iScope, " Building outputs ");
        boolean bl = super.init(iScope);
        this.updateDisplayOutputsName(iScope.getSimulation());
        iScope.getGui().getStatus().informStatus(iScope, null, "overlays/status.clock");
        return bl;
    }

    public void updateDisplayOutputsName(SimulationAgent simulationAgent) {
        for (IOutput iOutput : this) {
            GAMA.getGui().updateViewTitle(iOutput, simulationAgent);
        }
    }

    public static class SimulationOutputValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            Iterable<IDescription> iterable = iDescription.getChildrenWithKeyword("display");
            HashMap<String, IDescription> hashMap = new HashMap<String, IDescription>();
            for (IDescription iDescription2 : iterable) {
                String string = iDescription2.getName();
                if (string == null) continue;
                IDescription iDescription3 = (IDescription)hashMap.get(string);
                if (iDescription3 == null) {
                    hashMap.put(string, iDescription2);
                    continue;
                }
                iDescription2.info("'" + string + "' is defined twice in this experiment. Only this definition will be taken into account.", "gaml.duplicate.definition.issue");
                iDescription3.info("'" + string + "' is defined twice in this experiment. This definition will not be taken into account.", "gaml.duplicate.definition.issue");
            }
        }
    }
}

