/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.interfaces.IConsoleListener;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaServerMessager;
import gama.core.util.GamaColor;

public final class GamaServerConsoleListener
extends GamaServerMessager
implements IConsoleListener {
    @Override
    public boolean canSendMessage(IExperimentAgent iExperimentAgent) {
        if (!GamaPreferences.Runtime.CORE_SERVER_CONSOLE.getValue().booleanValue()) {
            return false;
        }
        IScope iScope = iExperimentAgent.getScope();
        return iScope != null && iScope.getServerConfiguration().console();
    }

    @Override
    public void informConsole(String string, ITopLevelAgent iTopLevelAgent, GamaColor gamaColor) {
        System.out.println(string);
        if (!this.canSendMessage(iTopLevelAgent.getExperiment())) {
            return;
        }
        this.sendMessage(iTopLevelAgent.getExperiment(), this.json.object("message", string, "color", gamaColor), GamaServerMessage.Type.SimulationOutput);
    }

    @Override
    public void debugConsole(int n, String string, ITopLevelAgent iTopLevelAgent, GamaColor gamaColor) {
        if (!this.canSendMessage(iTopLevelAgent.getExperiment())) {
            return;
        }
        this.sendMessage(iTopLevelAgent.getExperiment(), this.json.object("cycle", n, "message", string, "color", gamaColor), GamaServerMessage.Type.SimulationDebug);
    }
}

