/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.util.file.json.Json;
import gama.dev.DEBUG;
import org.java_websocket.WebSocket;

public abstract class GamaServerMessager {
    Json json = Json.getNew();

    public abstract boolean canSendMessage(IExperimentAgent var1);

    public void sendMessage(IExperimentAgent iExperimentAgent, Object object, GamaServerMessage.Type type2) {
        try {
            if (iExperimentAgent == null) {
                DEBUG.OUT((Object)("No experiment, unable to send message: " + String.valueOf(object)));
                return;
            }
            IScope iScope = iExperimentAgent.getScope();
            if (iScope == null) {
                DEBUG.OUT((Object)("No scope, unable to send message: " + String.valueOf(object)));
                return;
            }
            WebSocket webSocket = iScope.getServerConfiguration().socket();
            if (webSocket == null) {
                DEBUG.OUT((Object)("No socket found, maybe the client is already disconnected. Unable to send message: " + String.valueOf(object)));
                return;
            }
            webSocket.send(this.json.valueOf(new GamaServerMessage(type2, object, iScope.getServerConfiguration().expId())).toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DEBUG.OUT((Object)("Unable to send message:" + String.valueOf(object)));
            DEBUG.OUT((Object)exception.toString());
        }
    }
}

