/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.IModifiableContainer;
import gama.core.util.file.GamaFile;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.ParseException;
import gama.core.util.file.json.WriterConfig;
import gama.gaml.statements.Facets;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

@GamlAnnotations.file(name="json", extensions={"json"}, buffer_type=10, buffer_index=4, concept={"file"})
@GamlAnnotations.doc(value="Reads a JSON file into a map<string, unknown>. Either a direct map of the object denoted in the JSON file, or a map with only one key ('gama_contents') containing the list in the JSON file. All data structures (JSON object and JSON array) are properly converted into GAMA structures (map and list) recursively, or into direct GAMA objects when they sport the required tags. ")
public class GamaJsonFile
extends GamaFile<IMap<String, Object>, Object> {
    @GamlAnnotations.doc(value="This file constructor allows to read a json file", examples={@GamlAnnotations.example(value="file f <-json_file(\"file.json\");", isExecutable=false)})
    public GamaJsonFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This constructor allows to  store a map in a json file (it does not save it). The file can then be saved later using the `save` statement", examples={@GamlAnnotations.example(value="file f <-json_file(\"file.json\", map([\"var1\"::1.0, \"var2\"::3.0]));", isExecutable=false)})
    public GamaJsonFile(IScope iScope, String string, IMap<String, Object> iMap) {
        super(iScope, string, iMap);
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }

    @Override
    public IContainerType getGamlType() {
        return Types.MAP.of(Types.STRING, Types.NO_TYPE);
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader fileReader = new FileReader(this.getFile(iScope));){
                IMap iMap;
                Object object = Json.getNew().parse(fileReader).toGamlValue(iScope);
                if (object instanceof IMap) {
                    iMap = (IMap)object;
                } else {
                    iMap = GamaMapFactory.create();
                    iMap.put("gama_contents", object);
                }
                this.setBuffer(iMap);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ParseException | IOException exception) {
            throw GamaRuntimeException.create(exception, iScope);
        }
    }

    @Override
    protected String getHttpContentType() {
        return "application/json";
    }

    @Override
    protected void flushBuffer(IScope iScope, Facets facets2) throws GamaRuntimeException {
        File file2;
        IMap iMap;
        IMap iMap2 = iMap = (IMap)this.getBuffer();
        if (iMap.size() == 1 && iMap.containsKey("gama_contents")) {
            iMap2 = iMap.get("gama_contents");
        }
        if ((file2 = this.getFile(iScope)).exists()) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning(file2.getName() + " already exists", iScope), false);
        }
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(file2.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                outputStreamWriter.write(Json.getNew().valueOf(iMap2).toString(WriterConfig.PRETTY_PRINT));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create(iOException, iScope);
        }
    }

    @Override
    public IModifiableContainer ensureContentsIsCompatible(IModifiableContainer iModifiableContainer) {
        if (iModifiableContainer instanceof IMap) {
            return iModifiableContainer;
        }
        IMap iMap = GamaMapFactory.create();
        iMap.put("gama_contents", iModifiableContainer);
        return iMap;
    }
}

