/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.path;

import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.IGraph;
import gama.core.util.path.GamaPath;
import gama.gaml.operators.Cast;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import org.apache.commons.lang3.ArrayUtils;
import org.jgrapht.Graph;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class GamaSpatialPath
extends GamaPath<IShape, IShape, IGraph<IShape, IShape>> {
    IList<IShape> segments;
    IShape shape = null;
    boolean threeD = false;
    IMap<IShape, IShape> realObjects;

    public GamaSpatialPath(GamaSpatialGraph gamaSpatialGraph, IShape iShape, IShape iShape2, IList<? extends IShape> iList) {
        super(gamaSpatialGraph, iShape, iShape2, iList);
    }

    public GamaSpatialPath(GamaSpatialGraph gamaSpatialGraph, IShape iShape, IShape iShape2, IList<? extends IShape> iList, boolean bl) {
        super(gamaSpatialGraph, iShape, iShape2, iList, bl);
    }

    public GamaSpatialPath(IShape iShape, IShape iShape2, IList<? extends IShape> iList) {
        super(null, iShape, iShape2, iList, false);
    }

    public GamaSpatialPath(IShape iShape, IShape iShape2, IList<? extends IShape> iList, boolean bl) {
        super(null, iShape, iShape2, iList, bl);
    }

    public GamaSpatialPath(IList<? extends IShape> iList) {
        super(iList);
    }

    @Override
    protected IShape createEdge(IShape iShape, IShape iShape2) {
        return GamaGeometryType.buildLine(iShape.getLocation(), iShape2.getLocation());
    }

    @Override
    public void init(IGraph<IShape, IShape> iGraph, IShape iShape, IShape iShape2, IList<? extends IShape> iList, boolean bl) {
        Object object;
        super.init(iGraph, iShape, iShape2, iList, bl);
        this.source = iShape;
        this.target = iShape2;
        this.graph = iGraph;
        this.segments = GamaListFactory.create(Types.GEOMETRY);
        this.realObjects = GamaMapFactory.createUnordered();
        this.graphVersion = 0;
        Geometry geometry = iList == null || iList.isEmpty() ? null : ((IShape)iList.get(0)).getInnerGeometry();
        Object object2 = null;
        Object object3 = null;
        GamaPoint gamaPoint = null;
        if (geometry != null) {
            object = GeometryUtils.getPointsOf(geometry);
            object3 = object[0];
            gamaPoint = object[((GamaPoint[])object).length - 1];
        }
        if (geometry != null && iList != null && object3 != null && gamaPoint != null) {
            GamaPoint[] gamaPointArray;
            Object object4;
            if (iList.size() > 1) {
                double d = object3.z;
                block0: for (IShape object52 : iList) {
                    object4 = GeometryUtils.getPointsOf(object52);
                    int n = ((GamaPoint[])object4).length;
                    int geometry2 = 0;
                    while (geometry2 < n) {
                        gamaPointArray = object4[geometry2];
                        if (gamaPointArray.z != d) {
                            this.threeD = true;
                            continue block0;
                        }
                        if (this.threeD) continue block0;
                        ++geometry2;
                    }
                }
                IShape iShape3 = ((IShape)iList.get(1)).getGeometry();
                object2 = this.threeD ? (((IShape)iList.get(1)).getPoints().contains(object3) ? gamaPoint : object3) : (object3.euclidianDistanceTo(iShape3) > gamaPoint.euclidianDistanceTo(iShape3) ? object3 : gamaPoint);
            } else {
                object = (IShape)this.edges.get(this.edges.size() - 1);
                GamaPoint gamaPoint2 = SpatialPunctal._closest_point_to(((IShape)this.getEndVertex()).getLocation(), (IShape)object);
                Object object5 = object2 = iShape.euclidianDistanceTo((GamaPoint)object3) < gamaPoint2.euclidianDistanceTo((GamaPoint)object3) ? object3 : gamaPoint;
            }
            if (this.graph != null) {
                this.graphVersion = this.graph.getPathComputer().getVersion();
            }
            int n = 0;
            for (IShape iShape4 : iList) {
                if (bl) {
                    IAgent iAgent = iShape4 instanceof IAgent ? (IAgent)iShape4 : null;
                    gamaPointArray = GeometryUtils.getPointsOf(iShape4);
                    Geometry geometry2 = iShape4.getInnerGeometry();
                    object4 = gamaPointArray[0];
                    GamaPoint gamaPoint3 = gamaPointArray[gamaPointArray.length - 1];
                    IShape iShape5 = null;
                    Object[] objectArray = (GamaPoint[])GeometryUtils.getContourCoordinates(geometry2).toCoordinateArray().clone();
                    if ((iGraph == null || !iGraph.isDirected()) && object2.euclidianDistanceTo((GamaPoint)object4) > object2.euclidianDistanceTo(gamaPoint3)) {
                        ArrayUtils.reverse((Object[])objectArray);
                        object2 = object4;
                    } else {
                        object2 = gamaPoint3;
                    }
                    ICoordinates iCoordinates = GeometryUtils.GEOMETRY_FACTORY.getCoordinateSequenceFactory().create((GamaPoint[])objectArray, false);
                    LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString(iCoordinates);
                    iShape5 = GamaShapeFactory.createFrom((Geometry)lineString);
                    boolean bl2 = false;
                    if (this.threeD) {
                        double iList3 = ((GamaPoint)iShape5.getPoints().get(0)).getZ();
                        int n2 = 1;
                        while (n2 < iShape5.getPoints().size()) {
                            if (((GamaPoint)iShape5.getPoints().get(n2)).getZ() != iList3) {
                                bl2 = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!bl2) {
                        if (n == 0 && !((IShape)this.source).equals(object2)) {
                            GamaPoint gamaPoint4 = ((IShape)this.source).getLocation();
                            if (((IShape)this.source).euclidianDistanceTo(iShape5) > Math.min(0.01, iShape5.getPerimeter() / 1000.0)) {
                                gamaPoint4 = SpatialPunctal._closest_point_to((IShape)this.source, iShape5);
                                gamaPoint4.z = this.zVal(gamaPoint4, iShape5);
                            }
                            iShape5 = (IShape)GeometryUtils.split_at(iShape5, gamaPoint4).get(1);
                        }
                        if (n == iList.size() - 1 && !iShape2.equals(GeometryUtils.getLastPointOf(iShape5))) {
                            GamaPoint gamaPoint5 = iShape2.getLocation();
                            if (iShape2.euclidianDistanceTo(iShape5) > Math.min(0.01, iShape5.getPerimeter() / 1000.0)) {
                                gamaPoint5 = SpatialPunctal._closest_point_to(iShape2, iShape5);
                                gamaPoint5.z = this.zVal(gamaPoint5, iShape5);
                            }
                            iShape5 = (IShape)GeometryUtils.split_at(iShape5, gamaPoint5).get(0);
                        }
                    } else {
                        double d;
                        GamaPoint gamaPoint6;
                        int n3;
                        int n4;
                        if (n == 0 && !((IShape)this.source).equals(object2)) {
                            IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
                            iList2.add((IShape)this.source);
                            if (iShape5.getPoints().size() == 2) {
                                iList2.add((IShape)iShape5.getPoints().get(iShape5.getPoints().size() - 1));
                            } else {
                                n4 = 0;
                                double d2 = Double.MAX_VALUE;
                                n3 = 0;
                                while (n3 < iShape5.getPoints().size() - 1) {
                                    gamaPoint6 = (GamaPoint)iShape5.getPoints().get(n3);
                                    d = gamaPoint6.euclidianDistanceTo((IShape)this.source);
                                    if (d < d2) {
                                        n4 = n3;
                                        d2 = d;
                                    }
                                    ++n3;
                                }
                                n3 = n4 + 1;
                                while (n3 < iShape5.getPoints().size()) {
                                    iList2.add((IShape)iShape5.getPoints().get(n3));
                                    ++n3;
                                }
                            }
                            iShape5 = SpatialCreation.line(GAMA.getRuntimeScope(), iList2);
                        }
                        if (n == iList.size() - 1 && !iShape2.equals(GeometryUtils.getLastPointOf(iShape5))) {
                            IList<IShape> iList3 = GamaListFactory.create(Types.GEOMETRY);
                            iList3.add((IShape)iShape5.getPoints().get(0));
                            if (iShape5.getPoints().size() == 2) {
                                iList3.add((IShape)iShape5.getPoints().get(0));
                            } else {
                                n4 = 0;
                                double d3 = Double.MAX_VALUE;
                                n3 = 1;
                                while (n3 < iShape5.getPoints().size()) {
                                    gamaPoint6 = (GamaPoint)iShape5.getPoints().get(n3);
                                    d = gamaPoint6.euclidianDistanceTo(iShape2);
                                    if (d < d3) {
                                        n4 = n3;
                                        d3 = d;
                                    }
                                    ++n3;
                                }
                                n3 = 0;
                                while (n3 < n4) {
                                    iList3.add((IShape)iShape5.getPoints().get(n3));
                                    ++n3;
                                }
                            }
                            iList3.add(iShape2);
                            iShape5 = SpatialCreation.line(GAMA.getRuntimeScope(), iList3);
                        }
                    }
                    if (iAgent != null) {
                        this.realObjects.put(iShape5.getGeometry(), iAgent);
                    } else {
                        this.realObjects.put(iShape5.getGeometry(), iShape4);
                    }
                    this.segments.add(iShape5.getGeometry());
                } else {
                    this.segments.add(iShape4.getGeometry());
                }
                ++n;
            }
        }
    }

    protected double zVal(GamaPoint gamaPoint, IShape iShape) {
        double d = 0.0;
        int n = GeometryUtils.getPointsOf(iShape).length;
        Coordinate[] coordinateArray = new Coordinate[2];
        Point point = (Point)gamaPoint.getInnerGeometry();
        double d2 = Double.MAX_VALUE;
        GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(iShape);
        int n2 = 0;
        while (n2 < n - 1) {
            coordinateArray[0] = gamaPointArray[n2];
            coordinateArray[1] = gamaPointArray[n2 + 1];
            LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray);
            double d3 = lineString.distance((Geometry)point);
            if (d3 < d2) {
                d2 = d3;
                GamaPoint gamaPoint2 = new GamaPoint(coordinateArray[0]);
                GamaPoint gamaPoint3 = new GamaPoint(coordinateArray[1]);
                d = gamaPoint2.z + (gamaPoint3.z - gamaPoint2.z) * gamaPoint.distance(gamaPoint2) / lineString.getLength();
            }
            ++n2;
        }
        return d;
    }

    public GamaSpatialPath(GamaSpatialGraph gamaSpatialGraph, IList<? extends IShape> iList) {
        IAgent iAgent;
        if (iList.isEmpty()) {
            this.source = new GamaPoint(0.0, 0.0);
            this.target = (IShape)this.source;
        } else {
            this.source = (IShape)iList.get(0);
            this.target = (IShape)iList.get(iList.size() - 1);
        }
        this.segments = GamaListFactory.create(Types.GEOMETRY);
        this.realObjects = GamaMapFactory.createUnordered();
        this.graph = gamaSpatialGraph;
        int n = 0;
        int n2 = iList.size();
        while (n < n2 - 1) {
            IShape iShape = GamaGeometryType.buildLine(((IShape)iList.get(n)).getLocation(), ((IShape)iList.get(n + 1)).getLocation());
            this.segments.add(iShape);
            IAgent iAgent2 = ((IShape)iList.get(n)).getAgent();
            if (iAgent2 != null) {
                this.realObjects.put(((IShape)iList.get(n)).getGeometry(), iAgent2);
            }
            ++n;
        }
        IAgent iAgent3 = iAgent = iList.isEmpty() ? null : ((IShape)iList.get(iList.size() - 1)).getAgent();
        if (iAgent != null) {
            this.realObjects.put(((IShape)iList.get(iList.size() - 1)).getGeometry(), iAgent);
        }
    }

    @Override
    public GamaSpatialPath copy(IScope iScope) {
        return new GamaSpatialPath(this.getGraph(), (IShape)this.source, (IShape)this.target, this.edges);
    }

    @Override
    public GamaSpatialGraph getGraph() {
        return (GamaSpatialGraph)this.graph;
    }

    @Override
    public IList getEdgeGeometry() {
        return this.segments;
    }

    @Override
    public void acceptVisitor(IAgent iAgent) {
        iAgent.setAttribute("current_path", this);
    }

    @Override
    public void forgetVisitor(IAgent iAgent) {
        iAgent.setAttribute("current_path", null);
    }

    @Override
    public int indexOf(IAgent iAgent) {
        return Cast.asInt(null, iAgent.getAttribute("index_on_path"));
    }

    @Override
    public int indexSegmentOf(IAgent iAgent) {
        return Cast.asInt(null, iAgent.getAttribute("index_on_path_segment"));
    }

    @Override
    public boolean isVisitor(IAgent iAgent) {
        return iAgent.getAttribute("current_path") == this;
    }

    @Override
    public void setIndexOf(IAgent iAgent, int n) {
        iAgent.setAttribute("index_on_path", n);
    }

    @Override
    public void setIndexSegementOf(IAgent iAgent, int n) {
        iAgent.setAttribute("index_on_path_segment", n);
    }

    @Override
    public double getDistance(IScope iScope) {
        if (this.segments == null || this.segments.isEmpty()) {
            return Double.MAX_VALUE;
        }
        Coordinate[] coordinateArray = ((IShape)this.segments.get(0)).getInnerGeometry().getCoordinates();
        Coordinate[] coordinateArray2 = ((IShape)this.segments.get(this.getEdgeList().size() - 1)).getInnerGeometry().getCoordinates();
        if (coordinateArray.length == 0 || coordinateArray2.length == 0) {
            return Double.MAX_VALUE;
        }
        GamaPoint gamaPoint = new GamaPoint(coordinateArray[0]);
        GamaPoint gamaPoint2 = new GamaPoint(coordinateArray2[coordinateArray2.length - 1]);
        boolean bl = ((IShape)this.source).getLocation().equals(gamaPoint);
        boolean bl2 = ((IShape)this.target).getLocation().equals(gamaPoint2);
        if (bl && bl2) {
            double d = 0.0;
            for (IShape iShape : this.segments) {
                IShape iShape2 = this.getRealObject(iShape);
                double d2 = this.getGraph().getEdgeWeight(iShape2);
                d += iShape2.getPerimeter() == 0.0 ? 0.0 : iShape.getInnerGeometry().getLength() * d2 / iShape2.getPerimeter();
            }
            return d;
        }
        return this.getDistanceComplex(iScope, bl, bl2);
    }

    private double getDistanceComplex(IScope iScope, boolean bl, boolean bl2) {
        int n;
        IShape iShape;
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.segments.size();
        IShape iShape2 = ((IShape)this.source).getLocation();
        if (!bl) {
            double d2 = Double.MAX_VALUE;
            iShape = null;
            n = 0;
            while (n < n4) {
                iShape = (IShape)this.segments.get(n);
                double d3 = iShape.euclidianDistanceTo((IShape)this.source);
                if (d3 < d2) {
                    d2 = d3;
                    n2 = n;
                }
                ++n;
            }
            iShape = (IShape)this.segments.get(n2);
            iShape2 = SpatialPunctal._closest_point_to((IShape)this.source, iShape);
            n3 = this.getIndexSegment(iShape, (GamaPoint)iShape2, n3, d2);
        }
        IShape iShape3 = (IShape)this.segments.get(n4 - 1);
        int n5 = iShape3.getInnerGeometry().getNumPoints();
        iShape = ((IShape)this.target).getLocation();
        if (!bl2) {
            iShape = SpatialPunctal._closest_point_to((IShape)this.getEndVertex(), iShape3);
            n5 = this.getIndexSegment(iShape3, (GamaPoint)iShape, 1, Double.MAX_VALUE);
        }
        n = n2;
        while (n < n4) {
            IShape iShape4 = (IShape)this.segments.get(n);
            Coordinate[] coordinateArray = iShape4.getInnerGeometry().getCoordinates();
            IShape iShape5 = this.getRealObject(iShape4);
            double d4 = this.getGraph().getEdgeWeight(iShape5);
            double d5 = d4 / iShape5.getPerimeter();
            int n6 = n3;
            while (n6 < coordinateArray.length) {
                IShape iShape6 = null;
                iShape6 = n == n4 - 1 && n6 == n5 ? iShape : new GamaPoint(coordinateArray[n6]);
                double d6 = iShape2.euclidianDistanceTo((GamaPoint)iShape6) * d5;
                iShape2 = iShape6;
                d += d6;
                if (n == n4 - 1 && n6 == n5) break;
                ++n3;
                ++n6;
            }
            n3 = 1;
            ++n2;
            ++n;
        }
        return d;
    }

    private int getIndexSegment(IShape iShape, GamaPoint gamaPoint, int n, double d) {
        int n2 = n;
        if (iShape.getInnerGeometry().getNumPoints() >= 3) {
            Point point = (Point)gamaPoint.getInnerGeometry();
            double d2 = d;
            Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
            int n3 = coordinateArray.length;
            Coordinate[] coordinateArray2 = new Coordinate[2];
            int n4 = 0;
            while (n4 < n3 - 1) {
                coordinateArray2[0] = coordinateArray[n4];
                coordinateArray2[1] = coordinateArray[n4 + 1];
                LineString lineString = GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray2);
                double d3 = lineString.distance((Geometry)point);
                if (d3 < d2) {
                    d2 = d3;
                    n2 = n4 + 1;
                }
                ++n4;
            }
        }
        return n2;
    }

    @Override
    public ITopology getTopology(IScope iScope) {
        if (this.graph == null) {
            return null;
        }
        return ((GamaSpatialGraph)this.graph).getTopology(iScope);
    }

    @Override
    public void setRealObjects(IMap<IShape, IShape> iMap) {
        this.realObjects = iMap;
    }

    @Override
    public IShape getRealObject(Object object) {
        return (IShape)this.realObjects.get(object);
    }

    @Override
    public IShape getGeometry() {
        if (this.shape == null && this.segments.size() > 0) {
            if (this.segments.size() == 1) {
                this.shape = GamaShapeFactory.createFrom((IShape)this.segments.get(0));
            } else {
                IList<IShape> iList = GamaListFactory.create(Types.POINT);
                for (IShape iShape : this.segments) {
                    GamaPoint[] gamaPointArray = GeometryUtils.getPointsOf(iShape);
                    int n = gamaPointArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GamaPoint gamaPoint = gamaPointArray[n2];
                        if (!iList.contains(gamaPoint)) {
                            iList.add(gamaPoint);
                        }
                        ++n2;
                    }
                }
                if (iList.size() > 1) {
                    this.shape = GamaGeometryType.buildPolyline(iList);
                }
            }
        }
        return this.shape;
    }

    @Override
    public void setGraph(IGraph<IShape, IShape> iGraph) {
        this.graph = iGraph;
        this.graphVersion = iGraph.getPathComputer().getVersion();
        for (IShape iShape : this.edges) {
            IAgent iAgent = iShape.getAgent();
            if (iAgent != null) {
                this.realObjects.put(iShape.getGeometry(), iAgent);
                continue;
            }
            this.realObjects.put(iShape.getGeometry(), iShape);
        }
    }

    @Override
    public IList<IShape> getEdgeList() {
        if (this.edges == null) {
            return this.segments;
        }
        return this.edges;
    }

    @Override
    public IList<IShape> getVertexList() {
        if (this.graph == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Collector.AsList asList = Collector.getList();){
                IShape iShape = null;
                for (Object e : this.getEdgeList()) {
                    iShape = (IShape)e;
                    asList.add(GeometryUtils.getFirstPointOf(iShape));
                }
                if (iShape != null) {
                    asList.add(GeometryUtils.getLastPointOf(iShape));
                }
                return asList.items();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.getPathVertexList();
    }

    public IList<IShape> getPathVertexList() {
        GamaSpatialGraph gamaSpatialGraph = this.getGraph();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Collector.AsList asList = Collector.getList();){
            IShape iShape = (IShape)this.getStartVertex();
            asList.add(iShape);
            IShape iShape2 = null;
            for (IShape iShape3 : this.getEdgeList()) {
                iShape2 = iShape;
                if ((iShape = GamaSpatialPath.getOppositeVertex(gamaSpatialGraph, iShape3, iShape)).equals(iShape2)) continue;
                asList.add(iShape);
            }
            return asList.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IShape getOppositeVertex(Graph<IShape, IShape> graph, IShape iShape, IShape iShape2) {
        IShape iShape3 = (IShape)graph.getEdgeSource((Object)iShape);
        IShape iShape4 = (IShape)graph.getEdgeTarget((Object)iShape);
        if (iShape2.equals(iShape3)) {
            return iShape4;
        }
        if (iShape2.equals(iShape4)) {
            return iShape3;
        }
        return iShape2.euclidianDistanceTo(iShape3) > iShape2.euclidianDistanceTo(iShape4) ? iShape4 : iShape3;
    }

    public boolean isThreeD() {
        return this.threeD;
    }
}

