/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.species;

import gama.core.common.interfaces.ISkill;
import gama.core.kernel.model.GamlModelSpecies;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.AbstractGraphNodeAgent;
import gama.core.util.matrix.IMatrix;
import gama.dev.DEBUG;
import gama.gaml.architecture.IArchitecture;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.UserCommandStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class AbstractSpecies
extends Symbol
implements ISpecies {
    protected final boolean isGrid;
    protected final boolean isGraph;
    protected final Map<String, ISpecies> microSpecies = GamaMapFactory.createOrdered();
    private final Map<String, IVariable> variables = GamaMapFactory.createOrdered();
    private final Map<String, AspectStatement> aspects = GamaMapFactory.createOrdered();
    private final Map<String, ActionStatement> actions = GamaMapFactory.createOrdered();
    private final Map<String, UserCommandStatement> userCommands = GamaMapFactory.createOrdered();
    private final List<IStatement> behaviors = new ArrayList<IStatement>();
    protected ISpecies macroSpecies;
    protected ISpecies parentSpecies;
    final IArchitecture control;

    static {
        DEBUG.OFF();
    }

    public AbstractSpecies(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
        this.isGrid = "grid".equals(this.getKeyword());
        this.isGraph = AbstractGraphNodeAgent.class.isAssignableFrom(((SpeciesDescription)iDescription).getJavaBase());
        this.control = (IArchitecture)((Object)this.getDescription().getControl().createInstance());
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getName();
    }

    @Override
    public Collection<IStatement> getBehaviors() {
        return this.behaviors;
    }

    @Override
    public Iterable<? extends IAgent> iterable(IScope iScope) {
        return this.getPopulation(iScope).iterable(iScope);
    }

    @Override
    public void addTemporaryAction(ActionStatement actionStatement) {
        this.actions.put(actionStatement.getName(), actionStatement);
    }

    @Override
    public void removeTemporaryAction() {
        this.actions.remove("__synthetic__action__");
        this.getDescription().removeAction("__synthetic__action__");
    }

    public IPopulation<IAgent> getPopulation(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        IPopulation<? extends IAgent> iPopulation = null;
        if (iAgent != null) {
            iPopulation = iAgent.getPopulationFor(this);
        }
        return iPopulation;
    }

    @Override
    public IList<IAgent> listValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        if (iPopulation == null) {
            iPopulation = iScope.getSimulation().getPopulationFor(iType.getName());
        }
        return iPopulation.listValue(iScope, iType, true);
    }

    @Override
    public String stringValue(IScope iScope) {
        return this.name;
    }

    @Override
    public IMap<?, ?> mapValue(IScope iScope, IType iType, IType iType2, boolean bl) throws GamaRuntimeException {
        IList<IAgent> iList = this.listValue(iScope, iType2, false);
        IMap iMap = GamaMapFactory.create(Types.STRING, iScope.getType(this.getName()));
        for (IAgent iAgent : iList.iterable(iScope)) {
            iMap.put(iAgent.getName(), iAgent);
        }
        return iMap;
    }

    @Override
    public boolean isGrid() {
        return this.isGrid;
    }

    @Override
    public boolean isGraph() {
        return this.isGraph;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ISpecies copy(IScope iScope) {
        return this;
    }

    @Override
    public IList<ISpecies> getMicroSpecies() {
        IList<ISpecies> iList = GamaListFactory.create(Types.SPECIES);
        iList.addAll(this.microSpecies.values());
        ISpecies iSpecies = this.getParentSpecies();
        if (iSpecies != null) {
            iList.addAll(iSpecies.getMicroSpecies());
        }
        return iList;
    }

    @Override
    public IList<ISpecies> getSubSpecies(IScope iScope) {
        IList<ISpecies> iList = GamaListFactory.create(Types.SPECIES);
        GamlModelSpecies gamlModelSpecies = (GamlModelSpecies)iScope.getModel().getSpecies();
        for (ISpecies iSpecies : gamlModelSpecies.getAllSpecies().values()) {
            if (iSpecies.getParentSpecies() != this) continue;
            iList.add(iSpecies);
        }
        return iList;
    }

    @Override
    public Collection<String> getMicroSpeciesNames() {
        return this.microSpecies.keySet();
    }

    @Override
    public ISpecies getMicroSpecies(String string) {
        ISpecies iSpecies = this.microSpecies.get(string);
        if (iSpecies != null) {
            return iSpecies;
        }
        ISpecies iSpecies2 = this.getParentSpecies();
        if (iSpecies2 != null) {
            return iSpecies2.getMicroSpecies(string);
        }
        return null;
    }

    @Override
    public boolean containMicroSpecies(ISpecies iSpecies) {
        ISpecies iSpecies2 = this.getParentSpecies();
        return this.microSpecies.containsValue(iSpecies) || iSpecies2 != null && iSpecies2.containMicroSpecies(iSpecies);
    }

    @Override
    public boolean hasMicroSpecies() {
        ISpecies iSpecies = this.getParentSpecies();
        return !this.microSpecies.isEmpty() || iSpecies != null && iSpecies.hasMicroSpecies();
    }

    @Override
    public SpeciesDescription getDescription() {
        return (SpeciesDescription)this.description;
    }

    @Override
    public boolean isPeer(ISpecies iSpecies) {
        return iSpecies != null && iSpecies.getMacroSpecies().equals(this.getMacroSpecies());
    }

    @Override
    public List<ISpecies> getSelfWithParents() {
        ArrayList<ISpecies> arrayList = new ArrayList<ISpecies>();
        arrayList.add(this);
        ISpecies iSpecies = this.getParentSpecies();
        while (iSpecies != null) {
            arrayList.add(iSpecies);
            iSpecies = iSpecies.getParentSpecies();
        }
        return arrayList;
    }

    @Override
    public ISpecies getParentSpecies() {
        if (this.parentSpecies == null) {
            SpeciesDescription speciesDescription = this.getDescription().getParent();
            if (speciesDescription == null || speciesDescription == this.getDescription()) {
                return null;
            }
            ISpecies iSpecies = this.getMacroSpecies();
            while (iSpecies != null && this.parentSpecies == null) {
                this.parentSpecies = iSpecies.getMicroSpecies(speciesDescription.getName());
                iSpecies = iSpecies.getMacroSpecies();
            }
        }
        return this.parentSpecies;
    }

    @Override
    public boolean extendsSpecies(ISpecies iSpecies) {
        ISpecies iSpecies2 = this.getParentSpecies();
        if (iSpecies2 == null) {
            return false;
        }
        if (iSpecies2 == iSpecies) {
            return true;
        }
        return iSpecies2.extendsSpecies(iSpecies);
    }

    @Override
    public String getParentName() {
        return this.getDescription().getParentName();
    }

    @Override
    public IArchitecture getArchitecture() {
        return this.control;
    }

    @Override
    public IVariable getVar(String string) {
        return this.variables.get(string);
    }

    @Override
    public boolean hasVar(String string) {
        return this.variables.containsKey(string);
    }

    @Override
    public Collection<String> getVarNames() {
        return this.getDescription().getAttributeNames();
    }

    @Override
    public Collection<IVariable> getVars() {
        return this.variables.values();
    }

    @Override
    public Collection<UserCommandStatement> getUserCommands() {
        return this.userCommands.values();
    }

    @Override
    public IStatement.WithArgs getAction(String string) {
        return this.actions.get(string);
    }

    @Override
    public Collection<ActionStatement> getActions() {
        return this.actions.values();
    }

    @Override
    public boolean hasAspect(String string) {
        return this.aspects.containsKey(string);
    }

    @Override
    public IExecutable getAspect(String string) {
        return this.aspects.get(string);
    }

    @Override
    public Collection<? extends IExecutable> getAspects() {
        return this.aspects.values();
    }

    @Override
    public IList<String> getAspectNames() {
        return GamaListFactory.wrap((IType)Types.STRING, this.aspects.keySet());
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        if (this.control == null) {
            throw GamaRuntimeException.error("The control of species " + this.description.getName() + " cannot be computed", GAMA.getRuntimeScope());
        }
        for (ISymbol iSymbol : iterable) {
            if (iSymbol instanceof ISpecies) {
                ISpecies iSpecies = (ISpecies)iSymbol;
                iSpecies.setMacroSpecies(this);
                this.microSpecies.put(iSpecies.getName(), iSpecies);
                continue;
            }
            if (iSymbol instanceof IVariable) {
                DEBUG.OUT((Object)("Adding " + iSymbol.getName() + " to " + String.valueOf(this)));
                this.variables.put(iSymbol.getName(), (IVariable)iSymbol);
                continue;
            }
            if (iSymbol instanceof AspectStatement) {
                this.aspects.put(iSymbol.getName(), (AspectStatement)iSymbol);
                continue;
            }
            if (iSymbol instanceof ActionStatement) {
                iSymbol.setEnclosing(this);
                this.actions.put(iSymbol.getName(), (ActionStatement)iSymbol);
                continue;
            }
            if (iSymbol instanceof UserCommandStatement) {
                this.userCommands.put(iSymbol.getName(), (UserCommandStatement)iSymbol);
                continue;
            }
            if (!(iSymbol instanceof IStatement)) continue;
            this.behaviors.add((IStatement)iSymbol);
        }
        this.control.setChildren(this.behaviors);
        this.behaviors.forEach(iStatement -> iStatement.setEnclosing(this));
        this.variables.forEach((string, iVariable) -> iVariable.setEnclosing(this));
        this.control.verifyBehaviors(this);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (IVariable iSymbol : this.variables.values()) {
            iSymbol.dispose();
        }
        this.variables.clear();
        for (AspectStatement aspectStatement : this.aspects.values()) {
            aspectStatement.dispose();
        }
        this.aspects.clear();
        for (ActionStatement actionStatement : this.actions.values()) {
            actionStatement.dispose();
        }
        this.actions.clear();
        for (IStatement iStatement : this.behaviors) {
            iStatement.dispose();
        }
        this.behaviors.clear();
        this.macroSpecies = null;
        this.parentSpecies = null;
        this.microSpecies.clear();
    }

    @Override
    public ISpecies getMacroSpecies() {
        return this.macroSpecies;
    }

    @Override
    public void setMacroSpecies(ISpecies iSpecies) {
        this.macroSpecies = iSpecies;
    }

    @Override
    public <T extends IStatement> T getStatement(Class<T> clazz, String string) {
        for (IStatement iStatement : this.behaviors) {
            boolean bl;
            boolean bl2 = clazz.isAssignableFrom(iStatement.getClass());
            if (!bl2) continue;
            if (string == null) {
                return (T)iStatement;
            }
            String string2 = iStatement.getDescription().getName();
            if (string2 == null || !(bl = string2.equals(string))) continue;
            return (T)iStatement;
        }
        return null;
    }

    @Override
    public Boolean implementsSkill(String string) {
        return this.getDescription().implementsSkill(string);
    }

    @Override
    public IAgent get(IScope iScope, Integer n) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : (IAgent)iPopulation.get(iScope, n);
    }

    @Override
    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? false : iPopulation.contains(iScope, object);
    }

    @Override
    public IAgent firstValue(IScope iScope) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : (IAgent)iPopulation.firstValue(iScope);
    }

    @Override
    public IAgent lastValue(IScope iScope) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : (IAgent)iPopulation.lastValue(iScope);
    }

    @Override
    public int length(IScope iScope) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? 0 : iPopulation.length(iScope);
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? true : iPopulation.isEmpty(iScope);
    }

    @Override
    public IContainer<Integer, ? extends IAgent> reverse(IScope iScope) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : iPopulation.reverse(iScope);
    }

    @Override
    public IAgent anyValue(IScope iScope) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : (IAgent)iPopulation.anyValue(iScope);
    }

    @Override
    public IMatrix<? extends IAgent> matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : iPopulation.matrixValue(iScope, iType, bl);
    }

    @Override
    public IMatrix<? extends IAgent> matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : iPopulation.matrixValue(iScope, iType, gamaPoint, bl);
    }

    @Override
    public IAgent getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? null : (IAgent)iPopulation.getFromIndicesList(iScope, iList);
    }

    @Override
    public boolean isMirror() {
        return this.getDescription().isMirror();
    }

    @Override
    public Collection<? extends IPopulation<? extends IAgent>> getPopulations(IScope iScope) {
        IPopulation<IAgent> iPopulation = this.getPopulation(iScope);
        return iPopulation == null ? Collections.EMPTY_LIST : Collections.singleton(iPopulation);
    }

    public ISkill getSkillInstanceFor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.control.getClass())) {
            return this.control;
        }
        return this.getSkillInstanceFor(this.getDescription(), clazz);
    }

    private ISkill getSkillInstanceFor(SpeciesDescription speciesDescription, Class clazz) {
        for (SkillDescription skillDescription : speciesDescription.getSkills()) {
            if (!clazz.isAssignableFrom(skillDescription.getJavaBase())) continue;
            return skillDescription.getInstance();
        }
        if (speciesDescription.getParent() != null && speciesDescription.getParent() != speciesDescription) {
            return this.getSkillInstanceFor(speciesDescription.getParent(), clazz);
        }
        return null;
    }
}

