/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.runtime.IScope;
import gama.gaml.compilation.ISymbol;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AttributeHolder {
    final Map<String, Attribute<?>> attributes = new HashMap(10);
    protected final ISymbol symbol;

    public void refresh(IScope iScope) {
        this.attributes.forEach((string, attribute) -> attribute.refresh((String)string, iScope));
    }

    public AttributeHolder(ISymbol iSymbol) {
        this.symbol = iSymbol;
    }

    protected <V> Attribute<V> create(String string, V v) {
        ConstantAttribute<V> constantAttribute = new ConstantAttribute<V>(v);
        this.attributes.put(string, constantAttribute);
        return constantAttribute;
    }

    protected <T extends IType<V>, V> Attribute<V> create(String string, T t, V v) {
        IExpression iExpression = this.symbol.getFacet(string);
        return this.create(string, iExpression, t, v);
    }

    protected <T extends IType<V>, V> Attribute<V> create(String string, IExpression iExpression, T t, V v) {
        Attribute<V> attribute = iExpression == null || iExpression.isConst() && iExpression.isContextIndependant() && t != Types.BOOL ? new ConstantAttribute<V>(iExpression == null ? v : t.cast(null, iExpression.getConstValue(), null, true)) : new ExpressionAttribute<T, V>(t, iExpression, v);
        this.attributes.put(string, attribute);
        return attribute;
    }

    protected <T extends IType<V>, V> Attribute<V> create(String string, IExpressionWrapper<V> iExpressionWrapper, T t, V v) {
        IExpression iExpression = this.symbol.getFacet(string);
        Attribute<V> attribute = iExpression == null ? new ConstantAttribute<V>(v) : new ExpressionEvaluator<V>(iExpressionWrapper, iExpression);
        this.attributes.put(string, attribute);
        return attribute;
    }

    public static interface Attribute<V>
    extends IExpression {
        public void refresh(String var1, IScope var2);

        public V get();

        public boolean changed();
    }

    public static class ConstantAttribute<V>
    implements Attribute<V> {
        private final V value;

        public ConstantAttribute(V v) {
            this.value = v;
        }

        @Override
        public void refresh(String string, IScope iScope) {
        }

        public V value(IScope iScope) {
            return this.value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public boolean changed() {
            return false;
        }
    }

    static class ExpressionAttribute<T extends IType<V>, V>
    implements Attribute<V> {
        final IExpression expression;
        final T returnType;
        private volatile V value;
        private volatile boolean changed;

        public ExpressionAttribute(T t, IExpression iExpression, V v) {
            this.expression = iExpression;
            this.returnType = t;
            this.value = v;
        }

        public V value(IScope iScope) {
            return (V)this.returnType.cast(iScope, this.expression.value(iScope), null, false);
        }

        @Override
        public void refresh(String string, IScope iScope) {
            this.changed = false;
            V v = this.value;
            this.value = this.value(iScope);
            this.changed = !Objects.equals(v, this.value);
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public boolean changed() {
            return this.changed;
        }
    }

    static class ExpressionEvaluator<V>
    implements Attribute<V> {
        final IExpressionWrapper<V> evaluator;
        final IExpression facet;
        private V value;
        boolean changed;

        public ExpressionEvaluator(IExpressionWrapper<V> iExpressionWrapper, IExpression iExpression) {
            this.evaluator = iExpressionWrapper;
            this.facet = iExpression;
        }

        public V value(IScope iScope) {
            return this.evaluator.value(iScope, this.facet);
        }

        @Override
        public void refresh(String string, IScope iScope) {
            this.changed = false;
            V v = this.value;
            this.value = this.value(iScope);
            this.changed = !Objects.equals(v, this.value);
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public boolean changed() {
            return this.changed;
        }
    }

    public static interface IExpressionWrapper<V> {
        public V value(IScope var1, IExpression var2);
    }
}

