/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.test;

import com.google.common.base.Objects;
import gama.core.util.GamaMapFactory;
import gama.gaml.statements.test.AbstractSummary;
import gama.gaml.statements.test.TestState;
import gama.gaml.statements.test.WithTestSummary;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.URI;

public class CompoundSummary<T extends AbstractSummary<?>, S extends WithTestSummary<?>>
extends AbstractSummary<S> {
    public final Map<String, T> summaries = GamaMapFactory.create();
    public boolean aborted;
    public String stringSummary;

    public CompoundSummary(S s) {
        super(s);
        if (s != null) {
            s.getSubElements().forEach(withTestSummary -> this.addSummary(withTestSummary.getSummary()));
        }
    }

    public CompoundSummary(Collection<T> collection) {
        super(null);
        collection.forEach(abstractSummary -> this.addSummary(abstractSummary));
    }

    public CompoundSummary() {
        this(Collections.EMPTY_LIST);
    }

    public boolean isEmpty() {
        return this.summaries.isEmpty();
    }

    @Override
    public long getTimeStamp() {
        return StreamEx.ofValues(this.summaries).mapToLong(abstractSummary -> abstractSummary.getTimeStamp()).max().getAsLong();
    }

    @Override
    public int size() {
        return this.summaries.size();
    }

    @Override
    public void setState(TestState testState) {
        this.aborted = testState == TestState.ABORTED;
    }

    @Override
    public Map<String, ? extends AbstractSummary<?>> getSummaries() {
        return this.summaries;
    }

    public void addSummary(T t) {
        String string = ((AbstractSummary)t).getTitle();
        Object object = string;
        int n = 2;
        while (this.summaries.containsKey(object)) {
            object = string + "[" + n++ + "]";
        }
        this.summaries.put((String)object, t);
    }

    public void addSummaries(Collection<T> collection) {
        for (AbstractSummary abstractSummary : collection) {
            this.addSummary(abstractSummary);
        }
    }

    @Override
    public void reset() {
        this.summaries.values().forEach(abstractSummary -> abstractSummary.reset());
        this.aborted = false;
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        return Objects.equal((Object)((AbstractSummary)object).getTitle(), (Object)this.getTitle());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTitle()});
    }

    @Override
    public TestState getState() {
        if (this.aborted) {
            return TestState.ABORTED;
        }
        TestState testState = TestState.NOT_RUN;
        block7: for (AbstractSummary abstractSummary : this.summaries.values()) {
            TestState testState2 = abstractSummary.getState();
            switch (testState2) {
                case NOT_RUN: {
                    break;
                }
                case FAILED: {
                    testState = TestState.FAILED;
                    break;
                }
                case PASSED: {
                    if (!testState.equals(TestState.NOT_RUN)) break;
                    testState = TestState.PASSED;
                    break;
                }
                case WARNING: {
                    if (!testState.equals(TestState.PASSED) && !testState.equals(TestState.NOT_RUN)) continue block7;
                    testState = TestState.WARNING;
                    break;
                }
                case ABORTED: {
                    return TestState.ABORTED;
                }
            }
        }
        return testState;
    }

    @Override
    public int countTestsWith(TestState testState) {
        return StreamEx.ofValues(this.summaries).mapToInt(abstractSummary -> abstractSummary.countTestsWith(testState)).sum();
    }

    public void getSubSummariesBelongingTo(URI uRI, List<AbstractSummary<?>> list) {
        this.getSummaries().values().forEach(abstractSummary -> {
            if (this.matches(abstractSummary.getURI(), uRI)) {
                list.add((AbstractSummary<?>)abstractSummary);
            } else if (abstractSummary instanceof CompoundSummary) {
                ((CompoundSummary)abstractSummary).getSubSummariesBelongingTo(uRI, list);
            }
        });
    }

    private boolean matches(URI uRI, URI uRI2) {
        if (uRI == null) {
            return false;
        }
        String string = uRI.toString();
        String string2 = uRI2.toString();
        return string.startsWith(string2);
    }

    public String getStringSummary() {
        if (this.stringSummary == null) {
            this.stringSummary = this.createTestsSummary();
        }
        return this.stringSummary;
    }

    protected String createTestsSummary() {
        TreeMap<TestState, Integer> treeMap = new TreeMap<TestState, Integer>();
        treeMap.put(TestState.ABORTED, 0);
        treeMap.put(TestState.FAILED, 0);
        treeMap.put(TestState.NOT_RUN, 0);
        treeMap.put(TestState.PASSED, 0);
        treeMap.put(TestState.WARNING, 0);
        int[] nArray = new int[1];
        this.summaries.values().forEach(abstractSummary -> {
            treeMap.keySet().forEach(testState -> {
                Integer n = treeMap.put((TestState)testState, (Integer)treeMap.get(testState) + abstractSummary.countTestsWith((TestState)testState));
            });
            nArray[0] = nArray[0] + abstractSummary.size();
        });
        String string = nArray[0] + " tests";
        for (TestState testState : treeMap.keySet()) {
            if ((Integer)treeMap.get(testState) == 0) continue;
            string = string + ", " + String.valueOf(treeMap.get(testState)) + " " + String.valueOf(testState);
        }
        return string;
    }
}

