/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import com.google.common.collect.Iterators;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class UniqueCoordinateSequence
implements ICoordinates {
    final GamaPoint point;
    final int dimension;

    public UniqueCoordinateSequence(int n, Coordinate coordinate) {
        this.dimension = n;
        this.point = new GamaPoint(coordinate);
    }

    public UniqueCoordinateSequence(double ... dArray) {
        this.dimension = dArray.length;
        this.point = switch (this.dimension) {
            case 0 -> new GamaPoint();
            case 1 -> new GamaPoint(dArray[0], dArray[0]);
            case 2 -> new GamaPoint(dArray[0], dArray[1]);
            default -> new GamaPoint(dArray[0], dArray[1], dArray[2]);
        };
    }

    public UniqueCoordinateSequence(int n, boolean bl, GamaPoint gamaPoint) {
        this.dimension = n;
        this.point = gamaPoint;
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public GamaPoint getCoordinate(int n) {
        return this.point;
    }

    public Coordinate getCoordinateCopy(int n) {
        return new GamaPoint(this.point);
    }

    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.point.x;
        coordinate.y = this.point.y;
        coordinate.z = this.point.z;
    }

    public double getX(int n) {
        return this.point.x;
    }

    public double getY(int n) {
        return this.point.y;
    }

    public double getOrdinate(int n, int n2) {
        return this.point.getOrdinate(n2);
    }

    public int size() {
        return 1;
    }

    public void setOrdinate(int n, int n2, double d) {
        this.point.setOrdinate(n2, d);
    }

    @Override
    public GamaPoint[] toCoordinateArray() {
        return new GamaPoint[]{this.point};
    }

    public Envelope expandEnvelope(Envelope envelope) {
        envelope.expandToInclude((Coordinate)this.point);
        return envelope;
    }

    @Override
    public Iterator<GamaPoint> iterator() {
        return Iterators.singletonIterator((Object)this.point);
    }

    @Override
    public ICoordinates yNegated() {
        return new UniqueCoordinateSequence(this.dimension, false, this.point.yNegated());
    }

    public final UniqueCoordinateSequence copy() {
        return new UniqueCoordinateSequence(this.dimension, new GamaPoint(this.point));
    }

    @Override
    @Deprecated
    public UniqueCoordinateSequence clone() {
        return this.copy();
    }

    @Override
    public void visit(ICoordinates.IndexedVisitor indexedVisitor, int n, boolean bl) {
        if (n == 0) {
            return;
        }
        indexedVisitor.process(0, this.point.x, this.point.y, this.point.z);
    }

    @Override
    public void visit(ICoordinates.PairVisitor pairVisitor) {
    }

    @Override
    public void getNormal(boolean bl, double d, GamaPoint gamaPoint) {
        gamaPoint.setLocation(0.0, 0.0, bl ? -d : d);
    }

    @Override
    public double averageZ() {
        return this.point.z;
    }

    @Override
    public ICoordinates setTo(GamaPoint ... gamaPointArray) {
        if (gamaPointArray.length == 0) {
            return this;
        }
        GamaPoint gamaPoint = gamaPointArray[0];
        this.point.x = gamaPoint.x;
        this.point.y = gamaPoint.y;
        this.point.z = gamaPoint.z;
        return this;
    }

    @Override
    public ICoordinates setTo(int n, double ... dArray) {
        if (n > 0 || dArray.length < 3) {
            return this;
        }
        this.point.x = dArray[0];
        this.point.y = dArray[1];
        this.point.z = dArray[2];
        return this;
    }

    @Override
    public void addCenterTo(GamaPoint gamaPoint) {
        gamaPoint.add(this.point);
    }

    @Override
    public Envelope3D getEnvelopeInto(Envelope3D envelope3D) {
        envelope3D.setToNull();
        envelope3D.expandToInclude(this.point);
        return envelope3D;
    }

    @Override
    public GamaPoint directionBetweenLastPointAndOrigin() {
        return new GamaPoint();
    }

    @Override
    public void applyRotation(Rotation3D rotation3D) {
        rotation3D.applyTo(this.point);
    }

    @Override
    public void replaceWith(int n, double d, double d2, double d3) {
        if (n != 0) {
            return;
        }
        this.point.setLocation(d, d2, d3);
    }

    @Override
    public boolean isHorizontal() {
        return true;
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public void setAllZ(double d) {
        this.point.z = d;
    }

    @Override
    public boolean isCoveredBy(Envelope3D envelope3D) {
        return envelope3D.covers(this.point);
    }

    @Override
    public void visitClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        vertexVisitor.process(this.point.x, this.point.y, this.point.z);
    }

    @Override
    public void visitYNegatedCounterClockwise(ICoordinates.VertexVisitor vertexVisitor) {
        vertexVisitor.process(this.point.x, -this.point.y, this.point.z);
    }

    @Override
    public boolean isClockwise() {
        return true;
    }

    @Override
    public void completeRing() {
    }

    @Override
    public void translateBy(double d, double d2, double d3) {
        this.point.add(d, d2, d3);
    }

    @Override
    public void ensureClockwiseness() {
    }
}

