/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.util;

import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.gaml.interfaces.IGamlable;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Map;

public class StringUtils {
    public static final DecimalFormat DEFAULT_DECIMAL_FORMAT;
    public static final DecimalFormatSymbols SYMBOLS;

    static {
        SYMBOLS = new DecimalFormatSymbols();
        SYMBOLS.setDecimalSeparator('.');
        SYMBOLS.setInfinity("#infinity");
        SYMBOLS.setNaN("#nan");
        DEFAULT_DECIMAL_FORMAT = new DecimalFormat("##0.0################", SYMBOLS);
    }

    public static String toGamlString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append('\'');
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c);
            ++n2;
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String toJavaString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (!StringUtils.isGamaString(string2)) {
            return string;
        }
        return string2.substring(1, string2.length() - 1);
    }

    public static final String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            if (string.codePointAt(n2) > 65535) {
                ++n2;
            }
            if (!bl) {
                if (n3 == 92) {
                    bl = true;
                } else {
                    stringBuilder.append(Character.toChars(n3));
                }
            } else if (n3 == 92) {
                bl = false;
                stringBuilder.append('\\');
                stringBuilder.append('\\');
            } else {
                switch (n3) {
                    case 114: {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 110: {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 102: {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 98: {
                        stringBuilder.append("\\b");
                        break;
                    }
                    case 116: {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 97: {
                        stringBuilder.append('\u0007');
                        break;
                    }
                    case 101: {
                        stringBuilder.append('\u001b');
                        break;
                    }
                    case 99: {
                        if (++n2 == string.length()) {
                            StringUtils.emitError("trailing \\c");
                        }
                        if ((n3 = string.codePointAt(n2)) > 127) {
                            StringUtils.emitError("expected ASCII after \\c");
                        }
                        stringBuilder.append(Character.toChars(n3 ^ 0x40));
                        break;
                    }
                    case 56: 
                    case 57: {
                        StringUtils.emitError("illegal octal digit");
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        --n2;
                    }
                    case 48: {
                        int n4;
                        if (n2 + 1 == string.length()) {
                            stringBuilder.append(Character.toChars(0));
                            break;
                        }
                        ++n2;
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 <= 2) {
                            if (n2 + n6 == string.length() || (n4 = (int)string.charAt(n2 + n6)) < 48 || n4 > 55) break;
                            ++n5;
                            ++n6;
                        }
                        if (n5 == 0) {
                            --n2;
                            stringBuilder.append('\u0000');
                            break;
                        }
                        n4 = 0;
                        try {
                            n4 = Integer.parseInt(string.substring(n2, n2 + n5), 8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            StringUtils.emitError("invalid octal value for \\0 escape");
                        }
                        stringBuilder.append(Character.toChars(n4));
                        n2 += n5 - 1;
                        break;
                    }
                    case 120: {
                        int n4;
                        if (n2 + 2 > string.length()) {
                            StringUtils.emitError("string too short for \\x escape");
                        }
                        int n5 = 0;
                        if (string.charAt(++n2) == '{') {
                            ++n2;
                            n5 = 1;
                        }
                        int n6 = 0;
                        while (n6 < 8) {
                            if (n5 == 0 && n6 == 2) break;
                            n4 = string.charAt(n2 + n6);
                            if (n4 > 127) {
                                StringUtils.emitError("illegal non-ASCII hex digit in \\x escape");
                            }
                            if (n5 != 0 && n4 == 125) break;
                            if (!(n4 >= 48 && n4 <= 57 || n4 >= 97 && n4 <= 102 || n4 >= 65 && n4 <= 70)) {
                                StringUtils.emitError(String.format("illegal hex digit #%d '%c' in \\x", n4, n4));
                            }
                            ++n6;
                        }
                        if (n6 == 0) {
                            StringUtils.emitError("empty braces in \\x{} escape");
                        }
                        n4 = 0;
                        try {
                            n4 = Integer.parseInt(string.substring(n2, n2 + n6), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            StringUtils.emitError("invalid hex value for \\x escape");
                        }
                        stringBuilder.append(Character.toChars(n4));
                        if (n5 != 0) {
                            ++n6;
                        }
                        n2 += n6 - 1;
                        break;
                    }
                    case 117: {
                        if (n2 + 4 > string.length()) {
                            StringUtils.emitError("string too short for \\u escape");
                        }
                        ++n2;
                        int n5 = 0;
                        while (n5 < 4) {
                            if (string.charAt(n2 + n5) > '\u007f') {
                                StringUtils.emitError("illegal non-ASCII hex digit in \\u escape");
                            }
                            ++n5;
                        }
                        int n6 = 0;
                        try {
                            n6 = Integer.parseInt(string.substring(n2, n2 + n5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            StringUtils.emitError("invalid hex value for \\u escape");
                        }
                        stringBuilder.append(Character.toChars(n6));
                        n2 += n5 - 1;
                        break;
                    }
                    case 85: {
                        if (n2 + 8 > string.length()) {
                            StringUtils.emitError("string too short for \\U escape");
                        }
                        ++n2;
                        int n5 = 0;
                        while (n5 < 8) {
                            if (string.charAt(n2 + n5) > '\u007f') {
                                StringUtils.emitError("illegal non-ASCII hex digit in \\U escape");
                            }
                            ++n5;
                        }
                        int n6 = 0;
                        try {
                            n6 = Integer.parseInt(string.substring(n2, n2 + n5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            StringUtils.emitError("invalid hex value for \\U escape");
                        }
                        stringBuilder.append(Character.toChars(n6));
                        n2 += n5 - 1;
                        break;
                    }
                    default: {
                        stringBuilder.append('\\');
                        stringBuilder.append(Character.toChars(n3));
                    }
                }
                bl = false;
            }
            ++n2;
        }
        if (bl) {
            stringBuilder.append('\\');
        }
        return stringBuilder.toString();
    }

    private static final void emitError(String string) {
        GAMA.reportAndThrowIfNeeded(null, GamaRuntimeException.warning(string, null), false);
    }

    public static boolean isGamaString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        return n >= 2 && string.charAt(0) == '\'' && string.charAt(n - 1) == '\'';
    }

    public static String toGaml(Object object, boolean bl) {
        if (object == null) {
            return "nil";
        }
        if (object instanceof IGamlable) {
            IGamlable iGamlable = (IGamlable)object;
            return iGamlable.serializeToGaml(bl);
        }
        if (object instanceof String) {
            String string = (String)object;
            return StringUtils.toGamlString(string);
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return DEFAULT_DECIMAL_FORMAT.format(d);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return StringUtils.toGaml(GamaListFactory.wrap((IType)Types.STRING, collection), bl);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return StringUtils.toGaml(GamaMapFactory.wrap(Types.NO_TYPE, Types.NO_TYPE, map), bl);
        }
        return String.valueOf(object);
    }
}

