/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.stochanalysis;

import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class Stochanalysis {
    public static final String CV = "Coefficient of variation";
    public static final String SE = "Standard error";
    static final double[] STOCHThresholds = new double[]{0.05, 0.01, 0.001};
    public static final String ES = "Critical effect size";
    static final double[] FISHEREffectSize = new double[]{0.01, 0.05, 0.1, 0.2, 0.4, 0.8};
    static final String[] FISHERES = new String[]{"ultra-micro", "micro", "small", "medium", "large", "huge"};
    static final double[] TALPHA = new double[]{0.99, 0.95};
    static final double[] TBETA = new double[]{0.95, 0.8};
    public static final String PT = "Power test";
    protected static final List<String> SA = List.of("Coefficient of variation", "Standard error", "Critical effect size", "Power test");
    static final String SEP = ",";

    private static String buildResultMap(Map<String, Map<ParametersSet, Map<String, List<Double>>>> map2, int n2, int n3, IScope iScope) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("== STOCHASTICITY ANALYSIS ==");
        stringBuilder.append(Strings.LN);
        stringBuilder.append(map2.size() + " outputs | " + n2 + " samples | " + n3 + " max replications").append(" | Thresholds: ").append(Arrays.toString(STOCHThresholds)).append(" | T test alpha: 0.01").append(" | T test beta: 0.05").append(" | Critical effect size: ").append(Arrays.toString(FISHEREffectSize)).append(Strings.LN);
        stringBuilder.append("Threshold meaning: threshold represent the marginal decrease of concerned statistic to decide on the number of replicates").append(Strings.LN);
        stringBuilder.append("Exemple: increase one replicates decreases standard error, if marginal decrease is under a given threshold, then select this number of replicates").append(Strings.LN);
        stringBuilder.append("Critical effect size: look at False negative (alpha) & False positive (beta) hypothesis - according to https://www.jasss.org/18/4/4.html").append(Strings.LN);
        stringBuilder.append(Strings.LN).append(Strings.LN);
        for (String string : map2.keySet()) {
            Map<ParametersSet, Map<String, List<Double>>> map3 = map2.get(string);
            stringBuilder.append("## Output : ");
            stringBuilder.append(string);
            stringBuilder.append(Strings.LN);
            block11: for (String string2 : SA) {
                if (map3.values().stream().noneMatch(map -> map.containsKey(string2))) continue;
                switch (string2) {
                    case "Coefficient of variation": 
                    case "Standard error": {
                        Object object;
                        IMap iMap = GamaMapFactory.create();
                        double[] dArray = STOCHThresholds;
                        int n4 = STOCHThresholds.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            object = dArray[n5];
                            ArrayList<Integer> arrayList = new ArrayList<Integer>();
                            for (ParametersSet parametersSet : map3.keySet()) {
                                arrayList.add(Stochanalysis.findWithRelativeThreshold(map3.get(parametersSet).get(string2), (Double)object));
                            }
                            iMap.put(object, arrayList);
                            ++n5;
                        }
                        stringBuilder.append(string2).append(Strings.LN);
                        dArray = STOCHThresholds;
                        n4 = STOCHThresholds.length;
                        n5 = 0;
                        while (n5 < n4) {
                            object = dArray[n5];
                            stringBuilder.append(object).append(" : ");
                            stringBuilder.append("min = ").append(Collections.min((Collection)iMap.get(object))).append(" | ");
                            stringBuilder.append("max = ").append(Collections.max((Collection)iMap.get(object))).append(" | ");
                            stringBuilder.append("avr = ").append(Math.round(((List)iMap.get(object)).stream().mapToInt(n -> n).average().getAsDouble())).append(Strings.LN);
                            ++n5;
                        }
                        continue block11;
                    }
                    case "Power test": 
                    case "Critical effect size": {
                        Object object;
                        IMap iMap = GamaMapFactory.create();
                        double[] dArray = FISHEREffectSize;
                        int n4 = FISHEREffectSize.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            object = dArray[n5];
                            int n6 = DoubleStream.of(FISHEREffectSize).boxed().toList().indexOf(object) * 2;
                            ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
                            arrayList.add(map3.values().stream().mapToInt(map -> ((Double)((List)map.get(ES)).get(n6)).intValue()).boxed().toList());
                            arrayList.add(map3.values().stream().mapToInt(map -> ((Double)((List)map.get(ES)).get(n6 + 1)).intValue()).boxed().toList());
                            iMap.put(object, arrayList);
                            ++n5;
                        }
                        object = (List)map3.values().stream().filter(map -> map.containsKey(PT)).findFirst().get().get(PT);
                        if (object.isEmpty() || ((Double)object.get(0)).isNaN() || object.size() != 2) {
                            throw GamaRuntimeException.error("Trying to retriev Power Test n estimates but failed to find results: [" + object.stream().map(d -> d.toString()).collect(Collectors.joining(SEP)) + "]", iScope);
                        }
                        stringBuilder.append(string2).append(Strings.LN);
                        stringBuilder.append(PT).append(" with  alpha=0.01 (0.05), beta=0.05 (0.2) and effect sized based on (ANOVA) f=" + String.valueOf(object.get(1)) + ", theoretical number of replicate is ").append(object.get(0)).append(Strings.LN);
                        n5 = 0;
                        while (n5 < FISHEREffectSize.length) {
                            if (((List)iMap.get(FISHEREffectSize[n5])).stream().flatMap(Collection::stream).distinct().count() == 1L) {
                                stringBuilder.append(FISHERES[n5]).append(" (").append(FISHEREffectSize[n5]).append(") : " + String.valueOf(((List)((List)iMap.get(FISHEREffectSize[n5])).get(0)).get(0)) + " replicates is not enough").append(Strings.LN);
                            } else {
                                stringBuilder.append(FISHERES[n5]).append(" (").append(FISHEREffectSize[n5]).append(") : ");
                                stringBuilder.append("min = ").append(Collections.min((Collection)((List)iMap.get(FISHEREffectSize[n5])).get(0))).append(" (").append(Collections.min((Collection)((List)iMap.get(FISHEREffectSize[n5])).get(1))).append(") | ");
                                stringBuilder.append("max = ").append(Collections.max((Collection)((List)iMap.get(FISHEREffectSize[n5])).get(0))).append(" (").append(Collections.max((Collection)((List)iMap.get(FISHEREffectSize[n5])).get(1))).append(") | ");
                                stringBuilder.append("avr = ").append(Math.round(((List)((List)iMap.get(FISHEREffectSize[n5])).get(0)).stream().mapToInt(n -> n).average().getAsDouble())).append(" (").append(Math.round(((List)((List)iMap.get(FISHEREffectSize[n5])).get(1)).stream().mapToInt(n -> n).average().getAsDouble())).append(")" + Strings.LN);
                            }
                            ++n5;
                        }
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected stochastic analysis: " + string2);
                    }
                }
            }
            stringBuilder.append(Strings.LN).append(Strings.LN);
        }
        return stringBuilder.toString();
    }

    private static String buildStochMap(Map<String, Map<ParametersSet, Map<String, List<Double>>>> map, int n2, int n3, IScope iScope) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Outputs").append(SEP);
        IList iList = ((ParametersSet)map.get(map.keySet().stream().findAny().get()).keySet().stream().findAny().get()).getKeys();
        stringBuilder.append(iList.stream().collect(Collectors.joining(SEP))).append(SEP);
        stringBuilder.append("Indicator").append(SEP);
        stringBuilder.append(IntStream.range(1, n3).boxed().map(n -> String.valueOf(n)).collect(Collectors.joining(SEP)));
        stringBuilder.append(Strings.LN);
        for (String string2 : map.keySet()) {
            Map<ParametersSet, Map<String, List<Double>>> map2 = map.get(string2);
            for (ParametersSet parametersSet : map2.keySet()) {
                String string3 = iList.stream().map(string -> parametersSet.get(string).toString()).collect(Collectors.joining(SEP));
                Map<String, List<Double>> map3 = map2.get(parametersSet);
                for (String string4 : map3.keySet()) {
                    stringBuilder.append(string2).append(SEP);
                    stringBuilder.append(string3).append(SEP);
                    stringBuilder.append(string4).append(SEP);
                    stringBuilder.append(map3.get(string4).stream().skip(1L).map(d -> String.valueOf(d)).collect(Collectors.joining(SEP)));
                    stringBuilder.append(Strings.LN);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static void writeAndTellReport(File file2, Map<String, Map<ParametersSet, Map<String, List<Double>>>> map, int n, int n2, IScope iScope) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileWriter fileWriter = new FileWriter(file2, false);){
                fileWriter.write("txt".equalsIgnoreCase(FileNameUtils.getExtension((String)file2.getPath())) ? Stochanalysis.buildResultMap(map, n, n2, iScope) : Stochanalysis.buildStochMap(map, n, n2, iScope));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("File " + file2.toString() + " not found", iScope);
        }
    }

    public static String buildSimulationCsv(IMap<ParametersSet, Map<String, List<Object>>> iMap, IScope iScope) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ";";
        for (String object : ((ParametersSet)iMap.keySet().stream().findFirst().get()).keySet()) {
            stringBuilder.append(object).append(string);
        }
        for (String string2 : iMap.anyValue(iScope).keySet()) {
            stringBuilder.append(string2).append(string);
        }
        for (ParametersSet parametersSet : iMap.keySet()) {
            Map map = (Map)iMap.get(parametersSet);
            int n = ((List)map.values().stream().findAny().get()).size();
            if (!map.values().stream().allMatch(list -> list.size() == n)) {
                GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("Not all sample of stochastic analysis have the same number of replicates", iScope), false);
                continue;
            }
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append(Strings.LN);
                for (Object object : parametersSet.values()) {
                    stringBuilder.append(object).append(string);
                }
                for (Object object : map.keySet()) {
                    stringBuilder.append(((List)map.get(object)).get(n2)).append(string);
                }
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    public static void writeAndTellResult(File file2, IMap<ParametersSet, Map<String, List<Object>>> iMap, IScope iScope) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileWriter fileWriter = new FileWriter(file2, false);){
                fileWriter.write(Stochanalysis.buildSimulationCsv(iMap, iScope));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("File " + file2.toString() + " not found", iScope);
        }
    }

    private static List<Double> computeMean(List<Object> list, IScope iScope) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = 0.0;
        int n = 0;
        while (n < list.size()) {
            double d2 = Cast.asFloat(iScope, list.get(n));
            arrayList.add((d += d2) / (double)(n + 1));
            ++n;
        }
        return arrayList;
    }

    private static List<Double> computeSTD(List<Double> list, List<Object> list2, IScope iScope) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        while (n < list.size()) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < n) {
                double d2 = Cast.asFloat(iScope, list2.get(n2));
                d += Math.pow(d2 - list.get(n), 2.0);
                ++n2;
            }
            arrayList.add(Math.sqrt(d / (double)(n + 1)));
            ++n;
        }
        return arrayList;
    }

    private static List<Double> computeCV(List<Double> list, List<Double> list2) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 1;
        while (n < list2.size()) {
            arrayList.add(list.get(n) / list2.get(n));
            ++n;
        }
        return arrayList;
    }

    private static int findWithThreshold(List<Double> list, double d) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n2 < list.size() - 2) {
            int n3 = n2 + 1;
            while (n3 < list.size()) {
                double d2 = Math.abs(list.get(n2) - list.get(n3));
                if (d2 <= d && !bl) {
                    bl = true;
                    n = (1 + n2 + n3) / 2;
                }
                ++n3;
            }
            ++n2;
        }
        if (!bl) {
            return -1;
        }
        return n;
    }

    private static int findWithRelativeThreshold(List<Double> list, double d) {
        Double d2 = Collections.min(list) * d;
        int n = 2;
        while (n < list.size()) {
            double d3 = list.get(n - 1) - list.get(n);
            if (d3 >= 0.0 && d3 <= d2) {
                return n;
            }
            ++n;
        }
        return list.size();
    }

    public static IMap<ParametersSet, List<Double>> stochasticityAnalysis(IMap<ParametersSet, List<Object>> iMap, String string, IScope iScope) {
        IMap iMap2 = GamaMapFactory.create();
        switch (string) {
            case "Coefficient of variation": {
                for (Map.Entry entry : iMap.entrySet()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>((Collection)entry.getValue());
                    Collections.shuffle(arrayList);
                    iMap2.put((ParametersSet)entry.getKey(), Stochanalysis.coefficientOfVariance(arrayList, iScope));
                }
                break;
            }
            case "Standard error": {
                for (Map.Entry entry : iMap.entrySet()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>((Collection)entry.getValue());
                    Collections.shuffle(arrayList);
                    iMap2.put((ParametersSet)entry.getKey(), Stochanalysis.standardError(arrayList, iScope));
                }
                break;
            }
            case "Critical effect size": {
                for (Map.Entry entry : iMap.entrySet()) {
                    ArrayList<Object> arrayList = new ArrayList<Object>((Collection)entry.getValue());
                    Collections.shuffle(arrayList);
                    iMap2.put((ParametersSet)entry.getKey(), Stochanalysis.criticalEffectSize(arrayList, iScope));
                }
                break;
            }
            case "Power test": {
                double d = Stochanalysis.fTestEffectSize(iMap.values(), iScope);
                iMap.getKeys().forEach(parametersSet -> {
                    List<Double> list = iMap2.put(parametersSet, List.of(Double.valueOf(Stochanalysis.powerTestEffectSize(iMap.values().size(), d)), Double.valueOf(d)));
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + string);
            }
        }
        return iMap2;
    }

    private static List<Double> coefficientOfVariance(List<Object> list, IScope iScope) {
        List<Double> list2 = Stochanalysis.computeMean(list, iScope);
        List<Double> list3 = Stochanalysis.computeSTD(list2, list, iScope);
        List<Double> list4 = Stochanalysis.computeCV(list3, list2);
        return list4;
    }

    private static List<Double> standardError(List<Object> list, IScope iScope) {
        List<Double> list2 = Stochanalysis.computeMean(list, iScope);
        List<Double> list3 = Stochanalysis.computeSTD(list2, list, iScope);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 1;
        while (n < list3.size()) {
            arrayList.add(list3.get(n) / Math.sqrt(n + 1));
            ++n;
        }
        return arrayList;
    }

    private static List<Double> criticalEffectSize(List<Object> list, IScope iScope) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = FISHEREffectSize;
        int n = FISHEREffectSize.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            int n3 = 0;
            while (n3 < TALPHA.length) {
                arrayList.add(Double.valueOf(Stochanalysis.ces(list, TALPHA[n3], TBETA[n3], d, iScope)));
                ++n3;
            }
            ++n2;
        }
        return arrayList;
    }

    private static int ces(List<Object> list, double d4, double d5, double d6, IScope iScope) {
        List list2 = list.stream().mapToDouble(object -> Cast.asFloat(iScope, object)).boxed().collect(Collectors.toList());
        double d7 = list2.stream().mapToDouble(d -> d).average().getAsDouble();
        d6 *= d7;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add((Double)Collections.min(list2));
        arrayList.add((Double)Collections.max(list2));
        list2.removeAll(arrayList);
        list2.stream().sorted((d2, d3) -> d2.equals(d3) ? 0 : (Math.abs(d2 - d7) > Math.abs(d3 - d7) ? -1 : 1));
        for (Double d8 : list2) {
            arrayList.add(d8);
            TDistribution tDistribution = new TDistribution((double)(arrayList.size() - 1));
            double d9 = 2.0 * Math.pow(new StandardDeviation().evaluate(arrayList.stream().mapToDouble(d -> d).toArray()), 2.0) / d6 * Math.pow(tDistribution.inverseCumulativeProbability(d4) + tDistribution.inverseCumulativeProbability(d5), 2.0);
            if (!((double)arrayList.size() >= d9)) continue;
            return arrayList.size();
        }
        return list.size();
    }

    private static double powerTestEffectSize(int n, double d) {
        return 14.091 * Math.pow(n, -0.64) * Math.pow(d, -1.986);
    }

    private static double fTestEffectSize(Collection<List<Object>> collection, IScope iScope) {
        List<Double> list2 = collection.stream().mapToDouble(list -> list.stream().mapToDouble(object -> Cast.asFloat(iScope, object)).average().getAsDouble()).boxed().toList();
        double d3 = list2.stream().mapToDouble(d -> d).average().getAsDouble();
        double d4 = list2.stream().mapToDouble(d2 -> Math.pow(d3 - d2, 2.0)).sum() / (double)(collection.size() - 1);
        double d5 = 0.0;
        for (Double d6 : list2) {
            d5 += collection.stream().mapToDouble(list -> Math.pow(Cast.asFloat(iScope, list) - d6, 2.0)).sum();
        }
        return d4 / (d5 /= (double)collection.stream().mapToInt(list -> list.size()).sum());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Object> readSimulation(String string, int n, IScope iScope) throws GamaRuntimeException {
        ArrayList<Object> arrayList;
        Object object;
        ArrayList<Object> arrayList2;
        block23: {
            arrayList2 = new ArrayList<Object>();
            try {
                File file2 = new File(string);
                object = null;
                arrayList = null;
                try {
                    FileReader fileReader = new FileReader(file2);
                    try {
                        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                            String string2 = " ";
                            ArrayList<Object> arrayList3 = new ArrayList<Object>();
                            int n2 = 0;
                            while ((string2 = bufferedReader.readLine()) != null) {
                                block21: {
                                    Object object2;
                                    String[] stringArray;
                                    String[] stringArray2 = stringArray = string2.split(SEP);
                                    int n3 = stringArray.length;
                                    int n4 = 0;
                                    while (true) {
                                        if (n4 >= n3) {
                                            if (n2 > 0) {
                                                break;
                                            }
                                            break block21;
                                        }
                                        object2 = stringArray2[n4];
                                        if (n2 == 0) {
                                            arrayList3.add(object2);
                                        }
                                        ++n4;
                                    }
                                    object2 = new LinkedHashMap();
                                    n4 = 0;
                                    while (true) {
                                        if (n4 >= stringArray.length) {
                                            arrayList2.add(object2);
                                            break;
                                        }
                                        object2.put((String)arrayList3.get(n4), stringArray[n4]);
                                        ++n4;
                                    }
                                }
                                ++n2;
                            }
                        }
                        if (fileReader == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        if (fileReader == null) throw object;
                        fileReader.close();
                        throw object;
                    }
                    fileReader.close();
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                        throw object;
                    }
                    if (object == throwable) throw object;
                    ((Throwable)object).addSuppressed(throwable);
                    throw object;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.error("File " + string + " not found", iScope);
            }
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        object = ((Map)arrayList2.get(0)).keySet().stream().toList();
        IntStream.range(0, arrayList2.size()).forEach(arg_0 -> Stochanalysis.lambda$24(n, (List)object, linkedHashMap, arrayList2, arg_0));
        arrayList = new ArrayList<Object>();
        arrayList.add(arrayList2);
        arrayList.add(linkedHashMap);
        return arrayList;
    }

    private static String buildString(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : map.values()) {
            stringBuilder.append(object).append("_");
        }
        return stringBuilder.toString();
    }

    public static String stochasticityAnalysis_From_CSV(int n, double d, String string, int n2, IScope iScope) {
        List<Object> list = Stochanalysis.readSimulation(string, n2, iScope);
        IList iList = Cast.asList(iScope, list.get(0));
        IMap iMap = Cast.asMap(iScope, list.get(1), false);
        int n3 = 1;
        for (List list2 : iMap.values()) {
            List<Object> list3;
            HashedMap hashedMap = new HashedMap();
            for (Map map : iList) {
                String string2 = Stochanalysis.buildString(map);
                list3 = (ArrayList<List>)hashedMap.get(string2);
                if (list3 != null) {
                    list3.add(list2);
                    map.replace(string2, list3);
                    continue;
                }
                list3 = new ArrayList<List>();
                list3.add(list2);
                map.put(string2, list3);
            }
            int n4 = 0;
            for (Object object : hashedMap.keySet()) {
                list3 = Stochanalysis.computeMean((List)hashedMap.get(object), iScope);
                List<Double> list4 = Stochanalysis.computeSTD(list3, (List)hashedMap.get(object), iScope);
                List<Double> list5 = Stochanalysis.computeCV(list4, list3);
                n4 += Stochanalysis.findWithThreshold(list5, d);
            }
            n3 = n4 / hashedMap.size();
        }
        return Cast.asString(iScope, n3 /= iMap.size());
    }

    private static /* synthetic */ void lambda$24(int n, List list, Map map, List list2, int n2) {
        int n3 = n;
        while (n3 < list.size()) {
            double d;
            ArrayList<Double> arrayList;
            try {
                arrayList = new ArrayList((Collection)map.get(list.get(n3)));
                d = Double.parseDouble((String)((Map)list2.get(n2)).get(list.get(n3)));
                arrayList.add(d);
                map.replace((String)list.get(n3), arrayList);
            }
            catch (Exception exception) {
                arrayList = new ArrayList<Double>();
                d = Double.parseDouble((String)((Map)list2.get(n2)).get(list.get(n3)));
                arrayList.add(d);
                map.put((String)list.get(n3), arrayList);
            }
            ((Map)list2.get(n2)).remove(list.get(n3));
            ++n3;
        }
    }
}

