/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.types.Types;

@GamlAnnotations.inside(symbols={"display"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="position", type={7}, optional=true, doc={@GamlAnnotations.doc(value="position of the upper-left corner of the layer. Note that if coordinates are in [0,1[, the position is relative to the size of the environment (e.g. {0.5,0.5} refers to the middle of the display) whereas it is absolute when coordinates are greater than 1 for x and y. The z-ordinate can only be defined between 0 and 1. The position can only be a 3D point {0.5, 0.5, 0.5}, the last coordinate specifying the elevation of the layer. In case of negative value OpenGl will position the layer out of the environment.")}), @GamlAnnotations.facet(name="rotate", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Defines the angle of rotation of this layer, in degrees, around the z-axis.")}), @GamlAnnotations.facet(name="selectable", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether the agents present on this layer are selectable by the user. Default is true")}), @GamlAnnotations.facet(name="size", type={7}, optional=true, doc={@GamlAnnotations.doc(value="extent of the layer in the screen from its position. Coordinates in [0,1[ are treated as percentages of the total surface, while coordinates > 1 are treated as absolute sizes in model units (i.e. considering the model occupies the entire view). Like in 'position', an elevation can be provided with the z coordinate, allowing to scale the layer in the 3 directions ")}), @GamlAnnotations.facet(name="transparency", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the transparency level of the layer (between 0 -- opaque -- and 1 -- fully transparent)")}), @GamlAnnotations.facet(name="species", type={14}, optional=false, doc={@GamlAnnotations.doc(value="the species of the agents in the grid")}), @GamlAnnotations.facet(name="visible", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Defines whether this layer is visible or not")}), @GamlAnnotations.facet(name="border", type={6}, optional=true, doc={@GamlAnnotations.doc(value="the color to draw lines (borders of cells)")}), @GamlAnnotations.facet(name="elevation", type={8, 2, 1, 3}, remote_context=true, optional=true, doc={@GamlAnnotations.doc(value="Allows to specify the elevation of each cell, if any. Can be a matrix of float (provided it has the same size than the grid), an int or float variable of the grid species, or simply true (in which case, the variable called 'grid_value' is used to compute the elevation of each cell)")}), @GamlAnnotations.facet(name="texture", type={12}, optional=true, doc={@GamlAnnotations.doc(value="Either file  containing the texture image to be applied on the grid or, if not specified, the use of the image composed by the colors of the cells")}), @GamlAnnotations.facet(name="smooth", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Applies a simple convolution (box filter) to smooth out the terrain produced by this field. Does not change the values of course.")}), @GamlAnnotations.facet(name="grayscale", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true, givse a grey value to each polygon depending on its elevation (false by default)")}), @GamlAnnotations.facet(name="triangulation", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specifies whther the cells will be triangulated: if it is false, they will be displayed as horizontal squares at a given elevation, whereas if it is true, cells will be triangulated and linked to neighbors in order to have a continuous surface (false by default)")}), @GamlAnnotations.facet(name="hexagonal", type={3}, optional=true, internal=true, doc={@GamlAnnotations.doc(value="")}), @GamlAnnotations.facet(name="text", type={3}, optional=true, doc={@GamlAnnotations.doc(value="specify whether the attribute used to compute the elevation is displayed on each cells (false by default)")}), @GamlAnnotations.facet(name="wireframe", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true displays the grid in wireframe using the lines color")}), @GamlAnnotations.facet(name="refresh", type={3}, optional=true, doc={@GamlAnnotations.doc(value="(openGL only) specify whether the display of the species is refreshed. (true by default, usefull in case of agents that do not move)")})}, omissible="species")
@GamlAnnotations.doc(value="`display_grid` is used using the `grid` keyword. It allows the modeler to display in an optimized way all cell agents of a grid (i.e. all agents of a species having a grid topology).", usages={@GamlAnnotations.usage(value="The general syntax is:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="   grid ant_grid lines: #black position: { 0.5, 0 } size: {0.5,0.5};", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="To display a grid as a DEM:", examples={@GamlAnnotations.example(value="display my_display {", isExecutable=false), @GamlAnnotations.example(value="    grid cell texture: texture_file text: false triangulation: true elevation: true;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"display", "agents", "chart", "event", "graphics", "image", "overlay", "species_layer"})
@serializer(value=GridLayerSerializer.class)
@validator(value=GridLayerValidator.class)
public class GridLayerStatement
extends AbstractLayerStatement {
    final boolean isHexagonal;

    public GridLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        this.setName(this.getFacet("species").literalValue());
        this.isHexagonal = iDescription.hasFacet("hexagonal");
    }

    @Override
    public boolean _init(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    @Override
    public ILayerStatement.LayerType getType(LayeredDisplayOutput layeredDisplayOutput) {
        return this.isHexagonal ? ILayerStatement.LayerType.GRID_AGENTS : ILayerStatement.LayerType.GRID;
    }

    @Override
    public boolean _step(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    public static class GridLayerSerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append("grid ");
        }
    }

    public static class GridLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            Object object;
            String string = statementDescription.getFacet("species").serializeToGaml(true);
            SpeciesDescription speciesDescription = statementDescription.getModelDescription().getSpeciesDescription(string);
            if (speciesDescription == null || !speciesDescription.isGrid()) {
                statementDescription.error(string + " is not a grid species", "gaml.wrong.type.issue", "species", new String[0]);
                return;
            }
            IExpression iExpression = speciesDescription.getFacetExpr("neighbors");
            if (iExpression != null && iExpression.isConst() && (Integer)(object = (Integer)iExpression.getConstValue()) == 6) {
                statementDescription.setFacet("hexagonal", IExpressionFactory.TRUE_EXPR);
            }
            object = statementDescription.getFacetExpr("texture");
            IExpression iExpression2 = statementDescription.getFacetExpr("elevation");
            if ((iExpression2 == null || "false".equals(iExpression2.serializeToGaml(true))) && object != null) {
                statementDescription.setFacet("elevation", GAML.getExpressionFactory().createConst(0.0, Types.FLOAT));
            }
        }
    }
}

