/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.util.IContainer;
import gama.core.util.graph.IGraph;
import java.util.Collection;

public class GraphFromAgentContainerSynchronizer
implements IPopulation.Listener {
    private final IPopulation popVertices;
    private final IPopulation popEdges;
    private final IGraph graph;
    private Object currentEventVertex = null;
    private Object currentEventEdge = null;

    public GraphFromAgentContainerSynchronizer(IScope iScope, IContainer iContainer, IContainer iContainer2, IGraph iGraph) {
        this.popVertices = iContainer == null ? null : ((IAgent)iContainer.firstValue(iScope)).getPopulation();
        this.popEdges = iContainer2 == null ? null : ((IAgent)iContainer2.firstValue(iScope)).getPopulation();
        this.graph = iGraph;
    }

    IPopulation getVerticesPopulation() {
        return this.popVertices;
    }

    IPopulation getEdgesPopulation() {
        return this.popEdges;
    }

    public void notifyAgentRemoved(IScope iScope, IPopulation iPopulation, IAgent iAgent) {
        if (iPopulation == this.popVertices) {
            if (this.currentEventVertex != iAgent) {
                try {
                    this.currentEventVertex = iAgent;
                    this.graph.removeVertex(iAgent);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
            this.currentEventVertex = null;
        }
        if (iPopulation == this.popEdges) {
            if (this.currentEventEdge != iAgent) {
                try {
                    this.currentEventEdge = iAgent;
                    this.graph.removeEdge(iAgent);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
            this.currentEventEdge = null;
        }
    }

    public void notifyAgentAdded(IScope iScope, IPopulation iPopulation, IAgent iAgent) {
    }

    public void notifyAgentsAdded(IScope iScope, IPopulation iPopulation, Collection collection) {
    }

    public void notifyAgentsRemoved(IScope iScope, IPopulation iPopulation, Collection collection) {
        if (iPopulation == this.popVertices) {
            for (Object e : collection) {
                if (this.currentEventVertex != e) {
                    try {
                        this.currentEventVertex = e;
                        this.graph.removeVertex(e);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                }
                this.currentEventVertex = null;
            }
        }
        if (iPopulation == this.popEdges) {
            for (Object e : collection) {
                if (this.currentEventEdge != e) {
                    try {
                        this.currentEventEdge = e;
                        this.graph.removeEdge(e);
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                    }
                }
                this.currentEventEdge = null;
            }
        }
    }

    public void notifyPopulationCleared(IScope iScope, IPopulation iPopulation) {
        try {
            this.graph.removeAllVertices(this.graph.vertexSet());
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public static GraphFromAgentContainerSynchronizer synchronize(IScope iScope, IContainer iContainer, IContainer iContainer2, IGraph iGraph) {
        GraphFromAgentContainerSynchronizer graphFromAgentContainerSynchronizer = new GraphFromAgentContainerSynchronizer(iScope, iContainer, iContainer2, iGraph);
        if (graphFromAgentContainerSynchronizer.getEdgesPopulation() != null) {
            graphFromAgentContainerSynchronizer.getEdgesPopulation().addListener(graphFromAgentContainerSynchronizer);
        }
        if (graphFromAgentContainerSynchronizer.getVerticesPopulation() != null) {
            graphFromAgentContainerSynchronizer.getVerticesPopulation().addListener(graphFromAgentContainerSynchronizer);
        }
        return graphFromAgentContainerSynchronizer;
    }
}

