/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.util.GamaPair;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IModifiableContainer;
import gama.core.util.graph.IGraphEventProvider;
import gama.core.util.graph.PathComputer;
import gama.core.util.graph._Edge;
import gama.core.util.graph._Vertex;
import gama.core.util.path.IPath;
import gama.gaml.operators.Graphs;
import gama.gaml.species.ISpecies;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="spanning_tree", type=5, of=-299, doc={@GamlAnnotations.doc(value="Returns the list of edges that compose the minimal spanning tree of this graph")}), @GamlAnnotations.variable(name="circuit", type=17, doc={@GamlAnnotations.doc(value="Returns a polynomial approximation of the Hamiltonian cycle (the optimal tour passing through each vertex) of this graph")}), @GamlAnnotations.variable(name="connected", type=3, doc={@GamlAnnotations.doc(value="Returns whether this graph is connected or not")}), @GamlAnnotations.variable(name="edges", type=5, of=-299, doc={@GamlAnnotations.doc(value="Returns the list of edges of the receiver graph")}), @GamlAnnotations.variable(name="vertices", type=5, of=-399, doc={@GamlAnnotations.doc(value="Returns the list of vertices of the receiver graph")})})
public interface IGraph<Node, Edge>
extends IModifiableContainer<Node, Edge, GamaPair<Node, Node>, Graphs.GraphObjectToAdd>,
IAddressableContainer<Node, Edge, GamaPair<Node, Node>, List<Edge>>,
Graph<Node, Edge>,
IGraphEventProvider {
    public double getVertexWeight(Object var1);

    public Double getWeightOf(Object var1);

    public void setVertexWeight(Object var1, double var2);

    public void setWeights(Map<?, Double> var1);

    public Map<Edge, _Edge<Node, Edge>> _internalEdgeMap();

    public Map<Node, _Vertex<Node, Edge>> _internalVertexMap();

    @GamlAnnotations.getter(value="edges")
    public IList<Edge> getEdges();

    @GamlAnnotations.getter(value="vertices")
    public IList<Node> getVertices();

    @GamlAnnotations.getter(value="spanning_tree")
    public IList<Edge> getSpanningTree(IScope var1);

    @GamlAnnotations.getter(value="circuit")
    public IPath<Node, Edge, IGraph<Node, Edge>> getCircuit(IScope var1);

    @GamlAnnotations.getter(value="connected")
    public Boolean getConnected();

    @GamlAnnotations.getter(value="has_cycle")
    public Boolean hasCycle();

    public boolean isDirected();

    public void setDirected(boolean var1);

    public Object addEdge(Object var1);

    public double computeWeight(IPath<Node, Edge, ? extends IGraph<Node, Edge>> var1);

    public double computeTotalWeight();

    public Graphs.GraphObjectToAdd buildValue(IScope var1, Object var2);

    public IContainer buildValues(IScope var1, IContainer var2);

    public GamaPair<Node, Node> buildIndex(IScope var1, Object var2);

    public IContainer<?, GamaPair<Node, Node>> buildIndexes(IScope var1, IContainer var2);

    public ISpecies getVertexSpecies();

    public ISpecies getEdgeSpecies();

    @Override
    default public boolean contains(IScope iScope, Object object) {
        if (object instanceof GamaPair) {
            return Graphs.containsEdge(iScope, this, (GamaPair)object);
        }
        return Graphs.containsEdge(iScope, this, object);
    }

    @Override
    default public boolean containsKey(IScope iScope, Object object) {
        return Graphs.containsVertex(iScope, this, object);
    }

    public PathComputer getPathComputer();
}

