/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.interfaces.ISkill;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.MinimalAgent;
import gama.core.metamodel.topology.grid.GamlGridAgent;
import gama.core.metamodel.topology.grid.MinimalGridAgent;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.architecture.reflex.AbstractArchitecture;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.IGamaHelper;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.ListExpression;
import gama.gaml.expressions.types.DenotedActionExpression;
import gama.gaml.expressions.types.SkillConstantExpression;
import gama.gaml.expressions.types.SpeciesConstantExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.operators.Strings;
import gama.gaml.statements.Facets;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class SpeciesDescription
extends TypeDescription {
    private IMap<String, StatementDescription> behaviors;
    private IMap<String, StatementDescription> aspects;
    private IMap<String, SpeciesDescription> microSpecies;
    protected LinkedHashSet<SkillDescription> skills;
    protected SkillDescription control;
    private IAgentConstructor agentConstructor;
    private SpeciesConstantExpression speciesExpr;
    protected Class javaBase;

    static {
        DEBUG.ON();
    }

    public SpeciesDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, Iterable<? extends IDescription> iterable, EObject eObject, Facets facets2) {
        this(string, clazz, speciesDescription, speciesDescription2, iterable, eObject, facets2, Collections.EMPTY_SET);
    }

    public SpeciesDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, Iterable<? extends IDescription> iterable, EObject eObject, Facets facets2, Set<String> set) {
        super(string, clazz, speciesDescription, speciesDescription2, iterable, eObject, facets2, null);
        this.set(IDescription.Flag.CanUseMinimalAgents);
        this.setIf(IDescription.Flag.isMirror, this.hasFacet("mirrors"));
        this.setIf(IDescription.Flag.isGrid, "grid".equals(this.getKeyword()));
        this.setJavaBase(clazz);
        this.setSkills(this.getFacet("skills"), set);
    }

    public SpeciesDescription(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, Facets facets2, String string2) {
        super("species", clazz, speciesDescription, null, null, null, new Facets("name", string), string2);
        this.set(IDescription.Flag.CanUseMinimalAgents);
        this.setIf(IDescription.Flag.isMirror, this.hasFacet("mirrors"));
        this.setIf(IDescription.Flag.isGrid, "grid".equals(this.getKeyword()));
        this.setJavaBase(clazz);
        this.setParent(speciesDescription2);
        this.setSkills(facets2 == null ? null : (IExpressionDescription)facets2.get("skills"), set);
        this.setAgentConstructor(iAgentConstructor);
    }

    protected void addSkill(SkillDescription skillDescription) {
        if (skillDescription == null) {
            return;
        }
        if (this.skills == null) {
            this.skills = new LinkedHashSet();
        }
        this.skills.add(skillDescription);
    }

    public SymbolSerializer createSerializer() {
        return SPECIES_SERIALIZER;
    }

    @Override
    public void dispose() {
        if (this.isBuiltIn()) {
            return;
        }
        super.dispose();
        this.behaviors = null;
        this.aspects = null;
        this.skills = null;
        if (this.control != null) {
            this.control.dispose();
            this.control = null;
        }
        this.microSpecies = null;
    }

    protected void setSkills(IExpressionDescription iExpressionDescription, Set<String> set) {
        IExpression object2;
        SkillDescription skillDescription;
        String string = this.getLitteral("control");
        if (string != null) {
            skillDescription = GamaSkillRegistry.INSTANCE.get(string);
            if (skillDescription == null || !skillDescription.isControl()) {
                this.warning("This control  does not belong to the list of known agent controls (" + String.valueOf(GamaSkillRegistry.INSTANCE.getArchitectureNames()) + ")", "gaml.wrong.context.issue", "control", new String[0]);
            } else {
                this.control = skillDescription;
            }
        }
        skillDescription = GamaSkillRegistry.INSTANCE.get(this.getKeyword());
        this.addSkill(skillDescription);
        if (iExpressionDescription != null && (object2 = iExpressionDescription.compile(this)) instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)object2;
            IExpression[] iExpressionArray = listExpression.getElements();
            int n = iExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExpression iExpression = iExpressionArray[n2];
                if (iExpression instanceof SkillConstantExpression) {
                    SkillDescription skillDescription2 = ((ISkill)iExpression.getConstValue()).getDescription();
                    String string2 = skillDescription2.getDeprecated();
                    if (string2 != null) {
                        this.warning("Skill " + skillDescription2.getName() + " is deprecated: " + string2, "gaml.deprecated.code.issue", "skills", new String[0]);
                    }
                    this.addSkill(skillDescription2);
                }
                ++n2;
            }
        }
        for (String string3 : set) {
            this.addSkill(GamaSkillRegistry.INSTANCE.get(string3));
        }
    }

    @Override
    public boolean redefinesAttribute(String string) {
        if (super.redefinesAttribute(string)) {
            return true;
        }
        if (this.skills != null) {
            for (SkillDescription skillDescription : this.skills) {
                if (!skillDescription.hasAttribute(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean redefinesAction(String string) {
        if (super.redefinesAction(string)) {
            return true;
        }
        if (this.skills != null) {
            for (SkillDescription skillDescription : this.skills) {
                if (!skillDescription.hasAction(string, false)) continue;
                return true;
            }
        }
        return false;
    }

    public String getControlName() {
        String string = this.getLitteral("control");
        if (string == null) {
            string = this.parent != null && this.parent != this ? this.getParent().getControlName() : "reflex";
        }
        return string;
    }

    public String getParentName() {
        return this.getLitteral("parent");
    }

    @Override
    public IExpression getVarExpr(String string, boolean bl) {
        IExpression iExpression = super.getVarExpr(string, bl);
        if (iExpression == null) {
            StatementDescription statementDescription = this.getBehavior(string);
            if (statementDescription != null) {
                iExpression = new DenotedActionExpression(statementDescription);
            }
            if ((statementDescription = this.getAspect(string)) != null) {
                iExpression = new DenotedActionExpression(statementDescription);
            }
        }
        return iExpression;
    }

    public void copyJavaAdditions() {
        Class<? extends IAgent> clazz = this.getJavaBase();
        if (clazz == null) {
            this.error("This species cannot be compiled as its Java base is unknown. ", "gaml.unknown.species.issue");
            return;
        }
        Class<? extends IAgent> clazz2 = this.getJavaBase();
        Iterable iterable = Iterables.transform(this.getSkills(), (Function)TO_CLASS);
        Iterable<IDescription> iterable2 = GAML.getAllChildrenOf(clazz2, iterable);
        for (IDescription iDescription : iterable2) {
            this.addJavaChild(iDescription);
        }
    }

    private void addJavaChild(IDescription iDescription) {
        if (this.isBuiltIn()) {
            iDescription.setOriginName("built-in species " + this.getName());
        }
        if (iDescription instanceof VariableDescription) {
            VariableDescription variableDescription;
            boolean bl = false;
            if (this.isBuiltIn() && !this.hasAttribute(iDescription.getName()) || ((VariableDescription)iDescription).isContextualType()) {
                bl = true;
            } else if (this.parent != null && this.parent != this) {
                variableDescription = this.parent.getAttribute(iDescription.getName());
                if (variableDescription == null || !variableDescription.getOriginName().equals(iDescription.getOriginName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                variableDescription = (VariableDescription)iDescription.copy(this);
                this.addOwnAttribute(variableDescription);
            }
        } else {
            ActionDescription actionDescription;
            boolean bl = false;
            if (this.parent == null) {
                bl = true;
            } else if (!(this.parent == this || (actionDescription = this.parent.getAction(iDescription.getName())) != null && actionDescription.getOriginName().equals(iDescription.getOriginName()))) {
                bl = true;
            }
            if (bl) {
                this.addAction((ActionDescription)iDescription);
            }
        }
    }

    @Override
    public IDescription addChild(IDescription iDescription) {
        IDescription iDescription2 = super.addChild(iDescription);
        if (iDescription2 == null) {
            return null;
        }
        if (iDescription2 instanceof StatementDescription) {
            StatementDescription statementDescription = (StatementDescription)iDescription2;
            String string = iDescription2.getKeyword();
            if ("primitive".equals(string) || "action".equals(string)) {
                this.addAction((ActionDescription)statementDescription);
            } else if ("aspect".equals(string)) {
                this.addAspect(statementDescription);
            } else {
                this.addBehavior(statementDescription);
            }
        } else if (iDescription2 instanceof VariableDescription) {
            this.addOwnAttribute((VariableDescription)iDescription2);
        } else if (iDescription2 instanceof SpeciesDescription) {
            this.addMicroSpecies((SpeciesDescription)iDescription2);
        }
        return iDescription2;
    }

    protected void addMicroSpecies(SpeciesDescription speciesDescription) {
        if (!this.isModel() && speciesDescription.isGrid()) {
            speciesDescription.error("For the moment, grids cannot be defined as micro-species anywhere else than in the model");
        }
        this.getMicroSpecies().put(speciesDescription.getName(), speciesDescription);
        this.invalidateMinimalAgents();
    }

    protected void invalidateMinimalAgents() {
        this.unSet(IDescription.Flag.CanUseMinimalAgents);
        if (this.parent != null && this.parent != this && !this.parent.isBuiltIn()) {
            this.getParent().invalidateMinimalAgents();
        }
    }

    protected boolean useMinimalAgents() {
        if (!this.isSet(IDescription.Flag.CanUseMinimalAgents) || this.parent != null && this.parent != this && !this.getParent().useMinimalAgents()) {
            return false;
        }
        return !this.hasFacet("use_regular_agents") || "false".equals(this.getLitteral("use_regular_agents"));
    }

    protected void addBehavior(StatementDescription statementDescription) {
        StatementDescription statementDescription2;
        String string = statementDescription.getName();
        if (this.behaviors == null) {
            this.behaviors = GamaMapFactory.create();
        }
        if ((statementDescription2 = this.getBehavior(string)) != null && statementDescription2.getKeyword().equals(statementDescription.getKeyword())) {
            this.duplicateInfo(statementDescription, statementDescription2);
        }
        this.behaviors.put(string, statementDescription);
    }

    public boolean hasBehavior(String string) {
        return this.behaviors != null && this.behaviors.containsKey(string) || this.parent != null && this.parent != this && this.getParent().hasBehavior(string);
    }

    public StatementDescription getBehavior(String string) {
        StatementDescription statementDescription;
        StatementDescription statementDescription2 = statementDescription = this.behaviors == null ? null : (StatementDescription)this.behaviors.get(string);
        if (statementDescription == null && this.parent != null && this.parent != this) {
            statementDescription = this.getParent().getBehavior(string);
        }
        return statementDescription;
    }

    private void addAspect(StatementDescription statementDescription) {
        String string = statementDescription.getName();
        if (string == null) {
            string = "default";
            statementDescription.setName(string);
        }
        if (!"default".equals(string) && this.hasAspect(string)) {
            this.duplicateInfo(statementDescription, this.getAspect(string));
        }
        if (this.aspects == null) {
            this.aspects = GamaMapFactory.create();
        }
        this.aspects.put(string, statementDescription);
    }

    public StatementDescription getAspect(String string) {
        StatementDescription statementDescription;
        StatementDescription statementDescription2 = statementDescription = this.aspects == null ? null : (StatementDescription)this.aspects.get(string);
        if (statementDescription == null && this.parent != null && this.parent != this) {
            statementDescription = this.getParent().getAspect(string);
        }
        return statementDescription;
    }

    public Collection<String> getBehaviorNames() {
        LinkedHashSet<String> linkedHashSet;
        LinkedHashSet<String> linkedHashSet2 = linkedHashSet = this.behaviors == null ? new LinkedHashSet<String>() : new LinkedHashSet(this.behaviors.keySet());
        if (this.parent != null && this.parent != this) {
            linkedHashSet.addAll(this.getParent().getBehaviorNames());
        }
        return linkedHashSet;
    }

    public Collection<String> getAspectNames() {
        LinkedHashSet<String> linkedHashSet;
        LinkedHashSet<String> linkedHashSet2 = linkedHashSet = this.aspects == null ? new LinkedHashSet<String>() : new LinkedHashSet(this.aspects.keySet());
        if (this.parent != null && this.parent != this) {
            linkedHashSet.addAll(this.getParent().getAspectNames());
        }
        return linkedHashSet;
    }

    public Iterable<StatementDescription> getAspects() {
        return Iterables.transform(this.getAspectNames(), this::getAspect);
    }

    public SkillDescription getControl() {
        return this.control;
    }

    public boolean hasAspect(String string) {
        return this.aspects != null && this.aspects.containsKey(string) || this.parent != null && this.parent != this && this.getParent().hasAspect(string);
    }

    @Override
    public SpeciesDescription getSpeciesContext() {
        return this;
    }

    public SpeciesDescription getMicroSpecies(String string) {
        SpeciesDescription speciesDescription;
        if (this.hasMicroSpecies() && (speciesDescription = (SpeciesDescription)this.microSpecies.get(string)) != null) {
            return speciesDescription;
        }
        if (this.parent != null && this.parent != this) {
            return this.getParent().getMicroSpecies(string);
        }
        return null;
    }

    public String toString() {
        return "Description of " + this.getName();
    }

    public IAgentConstructor getAgentConstructor() {
        if (this.agentConstructor == null && this.parent != null && this.parent != this) {
            this.agentConstructor = this.getParent().getJavaBase() == this.getJavaBase() ? this.getParent().getAgentConstructor() : IAgentConstructor.CONSTRUCTORS.get(this.getJavaBase());
        }
        return this.agentConstructor;
    }

    protected void setAgentConstructor(IAgentConstructor iAgentConstructor) {
        this.agentConstructor = iAgentConstructor;
    }

    public SpeciesDescription getMacroSpecies() {
        IDescription iDescription = this.getEnclosingDescription();
        if (iDescription instanceof SpeciesDescription) {
            return (SpeciesDescription)iDescription;
        }
        return null;
    }

    @Override
    public SpeciesDescription getParent() {
        return (SpeciesDescription)super.getParent();
    }

    @Override
    public void inheritFromParent() {
        SpeciesDescription speciesDescription = this.getParent();
        if (speciesDescription != null && speciesDescription.getJavaBase() == null) {
            this.error("Species " + speciesDescription.getName() + " Java base class can not be found. No validation is possible.", "gaml.general.issue");
            return;
        }
        if (this.getJavaBase() == null) {
            this.error("Species " + this.getName() + " Java base class can not be found. No validation is possible.", "gaml.general.issue");
            return;
        }
        if (speciesDescription != null && speciesDescription != this && !speciesDescription.isBuiltIn() && speciesDescription.getJavaBase() != null) {
            if (!speciesDescription.getJavaBase().isAssignableFrom(this.getJavaBase())) {
                this.error("Species " + this.getName() + " Java base class (" + this.getJavaBase().getSimpleName() + ") is not a subclass of its parent species " + speciesDescription.getName() + " base class (" + speciesDescription.getJavaBase().getSimpleName() + ")", "gaml.general.issue");
            }
            if (!speciesDescription.isBuiltIn()) {
                this.inheritMicroSpecies(speciesDescription);
            }
        }
        super.inheritFromParent();
    }

    private void inheritMicroSpecies(SpeciesDescription speciesDescription2) {
        if (speciesDescription2 == null || speciesDescription2 == this) {
            return;
        }
        if (speciesDescription2.hasMicroSpecies()) {
            speciesDescription2.getMicroSpecies().forEachPair((string, speciesDescription) -> {
                this.getMicroSpecies().putIfAbsent((String)string, (SpeciesDescription)speciesDescription);
                return true;
            });
        }
    }

    public boolean isGrid() {
        return this.isSet(IDescription.Flag.isGrid);
    }

    @Override
    public String getTitle() {
        return Strings.capitalize(null, this.getKeyword()) + " " + this.getName();
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        IGamlDescription.RegularDoc regularDoc = new IGamlDescription.RegularDoc();
        this.documentThis(regularDoc);
        regularDoc.append("<hr/>").append(this.getMeta().getDocumentation().toString());
        return regularDoc;
    }

    public void documentThis(IGamlDescription.Doc doc2) {
        Iterable<String> iterable;
        String string = this.getParent() == null ? "nil" : this.getParent().getName();
        String string2 = this.getMacroSpecies() == null ? null : this.getMacroSpecies().getName();
        doc2.append("<b>Subspecies of:</b> ").append(string).append("<br>");
        if (string2 != null) {
            doc2.append("<b>Microspecies of:</b> ").append(string2).append("<br>");
        }
        if (!Iterables.isEmpty(iterable = this.getSkillsNames())) {
            doc2.append("<b>Skills:</b> ").append(iterable.toString()).append("<br>");
        }
        this.documentAttributes(doc2);
        this.documentActions(doc2);
    }

    public Iterable<String> getSkillsNames() {
        return Iterables.concat((Iterable)Iterables.transform((Iterable)(this.skills == null ? Collections.EMPTY_LIST : this.skills), (Function)TO_NAME), (Iterable)(this.parent != null && this.parent != this ? this.getParent().getSkillsNames() : Collections.EMPTY_LIST));
    }

    public SpeciesConstantExpression getSpeciesExpr() {
        if (this.speciesExpr == null) {
            IType<?> iType = GamaType.from(this);
            this.speciesExpr = GAML.getExpressionFactory().createSpeciesConstant(iType);
        }
        return this.speciesExpr;
    }

    public boolean visitMicroSpecies(IDescription.DescriptionVisitor<SpeciesDescription> descriptionVisitor) {
        if (!this.hasMicroSpecies()) {
            return true;
        }
        return this.getMicroSpecies().forEachValue(descriptionVisitor);
    }

    @Override
    public void setParent(TypeDescription typeDescription) {
        super.setParent(typeDescription);
        if (!this.isBuiltIn() && !this.verifyParent()) {
            super.setParent(null);
            return;
        }
        if (typeDescription instanceof SpeciesDescription && typeDescription != this && !this.isSet(IDescription.Flag.CanUseMinimalAgents) && !typeDescription.isBuiltIn()) {
            ((SpeciesDescription)typeDescription).invalidateMinimalAgents();
        }
    }

    protected boolean verifyParent() {
        if (this.parent == null) {
            return true;
        }
        if (this == this.parent) {
            this.error(this.getName() + " species can't be a sub-species of itself", "gaml.general.issue");
            return false;
        }
        if (this.parentIsAmongTheMicroSpecies()) {
            this.error(this.getName() + " species can't be a sub-species of one of its micro-species", "gaml.general.issue");
            return false;
        }
        if (!this.parentIsVisible()) {
            this.error(this.parent.getName() + " can't be a parent species of " + this.getName() + " species.", "gaml.wrong.parent.issue", "parent", new String[0]);
            return false;
        }
        if (this.hierarchyContainsSelf()) {
            this.error(this.getName() + " species and " + this.parent.getName() + " species can't be sub-species of each other.");
            return false;
        }
        return true;
    }

    private boolean parentIsAmongTheMicroSpecies() {
        final boolean[] blArray = new boolean[1];
        this.visitMicroSpecies(new IDescription.DescriptionVisitor<SpeciesDescription>(){

            @Override
            public boolean process(SpeciesDescription speciesDescription) {
                if (speciesDescription == SpeciesDescription.this.parent) {
                    blArray[0] = true;
                    return false;
                }
                speciesDescription.visitMicroSpecies(this);
                return true;
            }
        });
        return blArray[0];
    }

    private boolean hierarchyContainsSelf() {
        SpeciesDescription speciesDescription = this;
        while (speciesDescription != null) {
            SpeciesDescription speciesDescription2 = speciesDescription.getParent();
            if (speciesDescription2 == speciesDescription || speciesDescription2 == this) {
                return true;
            }
            speciesDescription = speciesDescription2;
        }
        return false;
    }

    protected boolean parentIsVisible() {
        if (this.getParent().isExperiment()) {
            return false;
        }
        SpeciesDescription speciesDescription = this.getMacroSpecies();
        while (speciesDescription != null) {
            if (speciesDescription == this.parent || speciesDescription.getMicroSpecies(this.parent.getName()) != null) {
                return true;
            }
            speciesDescription = speciesDescription.getMacroSpecies();
        }
        return false;
    }

    public boolean finalizeDescription() {
        if (this.isMirror()) {
            this.addChild(DescriptionFactory.create("agent", (IDescription)this, "name", "target", "type", String.valueOf(-28)));
        }
        this.finalizeControl();
        boolean bl = this.isBuiltIn();
        IDescription.DescriptionVisitor descriptionVisitor = speciesDescription -> {
            if (!speciesDescription.finalizeDescription()) {
                return false;
            }
            if (!speciesDescription.isExperiment() && !bl) {
                String string = speciesDescription.getName();
                if (this.hasAttribute(string) && !this.getAttribute(string).isSyntheticSpeciesContainer()) {
                    speciesDescription.error(speciesDescription.getName() + " is the name of an existing attribute in " + String.valueOf(this), "gaml.duplicate.name.issue", "name", new String[0]);
                    return false;
                }
                VariableDescription variableDescription = (VariableDescription)DescriptionFactory.create("list", (IDescription)this, "name", string);
                variableDescription.setSyntheticSpeciesContainer();
                variableDescription.setFacet("of", GAML.getExpressionFactory().createTypeExpression(this.getModelDescription().getTypeNamed(speciesDescription.getName())));
                IGamaHelper<Object> iGamaHelper = (iScope, iAgent, iVarAndActionSupport, object) -> ((IMacroAgent)iAgent).getMicroPopulation(speciesDescription.getName());
                IGamaHelper<Object> iGamaHelper2 = (iScope, iAgent, iVarAndActionSupport, object) -> null;
                IGamaHelper<Object> iGamaHelper3 = (iScope, iAgent, iVarAndActionSupport, object) -> {
                    ((IMacroAgent)iAgent).initializeMicroPopulation(iScope, speciesDescription.getName());
                    return ((IMacroAgent)iAgent).getMicroPopulation(speciesDescription.getName());
                };
                variableDescription.addHelpers(iGamaHelper, iGamaHelper3, iGamaHelper2);
                this.addChild(variableDescription);
            }
            return true;
        };
        return this.visitMicroSpecies(descriptionVisitor);
    }

    private void finalizeControl() {
        if (this.isSet(IDescription.Flag.ControlFinalized)) {
            return;
        }
        this.set(IDescription.Flag.ControlFinalized);
        if (this.control == null && this.parent != this && this.parent instanceof SpeciesDescription) {
            ((SpeciesDescription)this.parent).finalizeControl();
            this.control = ((SpeciesDescription)this.parent).getControl();
        }
        if (this.control == null) {
            this.control = GamaSkillRegistry.INSTANCE.get("reflex");
            return;
        }
        Class clazz = this.control.getJavaBase().getSuperclass();
        while (clazz != AbstractArchitecture.class) {
            SkillDescription skillDescription = GamaSkillRegistry.INSTANCE.get(clazz);
            if (skillDescription != null) {
                this.addSkill(skillDescription);
            }
            clazz = clazz.getSuperclass();
        }
    }

    @Override
    protected boolean validateChildren() {
        for (ActionDescription actionDescription : this.getActions()) {
            if (!actionDescription.isAbstract()) continue;
            this.info("Action '" + actionDescription.getName() + "' is defined or inherited as virtual. In consequence, " + this.getName() + " will be considered as abstract.", "gaml.missing.action.issue");
        }
        return super.validateChildren();
    }

    public boolean isExperiment() {
        return false;
    }

    public boolean isModel() {
        return false;
    }

    public boolean hasMicroSpecies() {
        return this.microSpecies != null;
    }

    public IMap<String, SpeciesDescription> getMicroSpecies() {
        if (this.microSpecies == null) {
            this.microSpecies = GamaMapFactory.create();
        }
        return this.microSpecies;
    }

    public boolean isMirror() {
        return this.isSet(IDescription.Flag.isMirror);
    }

    public Boolean implementsSkill(String string) {
        if (this.skills != null) {
            for (SkillDescription skillDescription : this.skills) {
                if (!skillDescription.getName().equals(string)) continue;
                return true;
            }
        }
        if (this.parent != null && this.parent != this) {
            return this.getParent().implementsSkill(string);
        }
        return false;
    }

    @Override
    public Class<? extends IAgent> getJavaBase() {
        if (this.javaBase == null) {
            this.javaBase = this.parent != null && this.parent != this && !"agent".equals(this.getParent().getName()) ? this.getParent().getJavaBase() : (this.useMinimalAgents() ? (this.isGrid() ? MinimalGridAgent.class : MinimalAgent.class) : (this.isGrid() ? GamlGridAgent.class : GamlAgent.class));
        }
        return this.javaBase;
    }

    protected void setJavaBase(Class clazz) {
        this.javaBase = clazz;
    }

    public boolean hasMacroSpecies(SpeciesDescription speciesDescription) {
        SpeciesDescription speciesDescription2 = this.getMacroSpecies();
        if (speciesDescription2 == null) {
            return false;
        }
        if (speciesDescription2.equals(speciesDescription)) {
            return true;
        }
        return speciesDescription2.hasMacroSpecies(speciesDescription);
    }

    public boolean hasParent(SpeciesDescription speciesDescription) {
        SpeciesDescription speciesDescription2 = this.getParent();
        if (speciesDescription2 == null || speciesDescription2 == this) {
            return false;
        }
        if (speciesDescription2.equals(speciesDescription)) {
            return true;
        }
        return speciesDescription2.hasParent(speciesDescription);
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (!super.visitOwnChildren(descriptionVisitor) || this.microSpecies != null && !this.microSpecies.forEachValue(descriptionVisitor)) {
            return false;
        }
        return (this.behaviors == null || this.behaviors.forEachValue(descriptionVisitor)) && (this.aspects == null || this.aspects.forEachValue(descriptionVisitor));
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        IDescription.DescriptionVisitor descriptionVisitor2 = iDescription -> {
            if (!descriptionVisitor.process((IDescription)iDescription)) {
                return false;
            }
            return iDescription.visitOwnChildrenRecursively(descriptionVisitor);
        };
        if (!super.visitOwnChildrenRecursively(descriptionVisitor) || this.microSpecies != null && !this.microSpecies.forEachValue(descriptionVisitor2)) {
            return false;
        }
        return (this.behaviors == null || this.behaviors.forEachValue(descriptionVisitor2)) && (this.aspects == null || this.aspects.forEachValue(descriptionVisitor2));
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        return Iterables.concat(super.getOwnChildren(), (Iterable)(this.microSpecies == null ? Collections.EMPTY_LIST : this.microSpecies.values()), (Iterable)(this.behaviors == null ? Collections.EMPTY_LIST : this.behaviors.values()), (Iterable)(this.aspects == null ? Collections.EMPTY_LIST : this.aspects.values()));
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        boolean bl = super.visitChildren(descriptionVisitor);
        if (!bl) {
            return false;
        }
        if (this.hasMicroSpecies()) {
            bl &= this.microSpecies.forEachValue(descriptionVisitor);
        }
        if (!bl) {
            return false;
        }
        for (IDescription iDescription : this.getBehaviors()) {
            if (bl &= descriptionVisitor.process(iDescription)) continue;
            return false;
        }
        for (IDescription iDescription : this.getAspects()) {
            if (bl &= descriptionVisitor.process(iDescription)) continue;
            return false;
        }
        return bl;
    }

    public Iterable<StatementDescription> getBehaviors() {
        return Iterables.transform(this.getBehaviorNames(), this::getBehavior);
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        super.collectMetaInformation(gamlProperties);
        if (this.isBuiltIn()) {
            gamlProperties.put("species", this.getName());
        }
    }

    public boolean belongsToAMicroModel() {
        return this.getModelDescription().isMicroModel();
    }

    public Iterable<SkillDescription> getSkills() {
        List<SkillDescription> list;
        List<SkillDescription> list2 = list = this.control == null ? Collections.EMPTY_LIST : Collections.singletonList(this.control);
        if (this.skills == null) {
            return list;
        }
        return Iterables.concat(this.skills, list);
    }
}

