/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.operators.Strings;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.CatchStatement;
import gama.gaml.statements.IStatement;

@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.doc(value="Allows the agent to execute a sequence of statements and to catch any runtime error that might happen in a subsequent `catch` block, either to ignore it (not a good idea, usually) or to safely stop the model", usages={@GamlAnnotations.usage(value="The generic syntax is:", examples={@GamlAnnotations.example(value="try {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="Optionally, the statements to execute when a runtime error happens in the block can be defined in a following statement 'catch'. The syntax then becomes:", examples={@GamlAnnotations.example(value="try {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="catch {", isExecutable=false), @GamlAnnotations.example(value="    [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
@serializer(value=IfSerializer.class)
public class TryStatement
extends AbstractStatementSequence {
    public IStatement catchStatement;

    public TryStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("catch");
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        for (ISymbol iSymbol2 : iterable) {
            if (!(iSymbol2 instanceof CatchStatement)) continue;
            this.catchStatement = (IStatement)iSymbol2;
        }
        super.setChildren(Iterables.filter(iterable, iSymbol -> iSymbol != this.catchStatement));
    }

    @Override
    public Object privateExecuteIn(IScope iScope) {
        Object object = null;
        try {
            try {
                iScope.enableTryMode();
                object = super.privateExecuteIn(iScope);
            }
            catch (Exception exception) {
                if (!(exception instanceof GamaRuntimeException)) {
                    iScope.setCurrentError(GamaRuntimeException.create(exception, iScope));
                }
                iScope.disableTryMode();
                if (this.catchStatement != null) {
                    Object object2 = iScope.execute(this.catchStatement).getValue();
                    iScope.disableTryMode();
                    return object2;
                }
                iScope.disableTryMode();
            }
        }
        finally {
            iScope.disableTryMode();
        }
        return object;
    }

    @Override
    public void dispose() {
        if (this.catchStatement != null) {
            this.catchStatement.dispose();
        }
        this.catchStatement = null;
        super.dispose();
    }

    public static class IfSerializer
    extends SymbolSerializer.StatementSerializer {
        @Override
        protected void serializeChildren(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(' ').append('{').append(Strings.LN);
            String[] stringArray = new String[1];
            symbolDescription.visitChildren(iDescription -> {
                if ("catch".equals(iDescription.getKeyword())) {
                    stringArray[0] = iDescription.serializeToGaml(false) + Strings.LN;
                } else {
                    this.serializeChild((IDescription)iDescription, stringBuilder, bl);
                }
                return true;
            });
            stringBuilder.append('}');
            if (stringArray[0] != null) {
                stringBuilder.append(stringArray[0]);
            } else {
                stringBuilder.append(Strings.LN);
            }
        }
    }
}

