/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.interfaces.IDrawDelegate;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.draw.DrawingData;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;

public class AspectDrawer
implements IDrawDelegate {
    @Override
    public Rectangle2D executeOn(IScope.IGraphicsScope iGraphicsScope, DrawingData drawingData, IExpression ... iExpressionArray) throws GamaRuntimeException {
        IAgent iAgent = iGraphicsScope.getAgent();
        if (iAgent == null) {
            return null;
        }
        String string = iExpressionArray[0].literalValue();
        IExecutable iExecutable = iAgent.getSpecies().getAspect(string);
        if (iExecutable == null) {
            return null;
        }
        return (Rectangle2D)iExecutable.executeOn(iGraphicsScope);
    }

    @Override
    public IType<?> typeDrawn() {
        return Types.ACTION;
    }

    @Override
    public void validate(IDescription iDescription, IExpression iExpression) {
        String string = iExpression.literalValue();
        IDescription iDescription2 = iDescription.getParentWithKeyword("aspect");
        if (iDescription2 == null) {
            return;
        }
        if (iDescription2.getName().equals(string)) {
            iDescription.error("An aspect cannot draw itself recursively");
        }
    }
}

