/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.Scaling3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.MeshLayerData;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.core.util.matrix.GamaField;
import gama.gaml.operators.Colors;
import gama.gaml.statements.draw.AssetDrawingAttributes;
import gama.gaml.statements.draw.BandsBasedMeshColorProvider;
import gama.gaml.statements.draw.ColorBasedMeshColorProvider;
import gama.gaml.statements.draw.DrawingAttributes;
import gama.gaml.statements.draw.GradientBasedMeshColorProvider;
import gama.gaml.statements.draw.GrayscaleMeshColorProvider;
import gama.gaml.statements.draw.IMeshColorProvider;
import gama.gaml.statements.draw.IMeshSmoothProvider;
import gama.gaml.statements.draw.ListBasedMeshColorProvider;
import gama.gaml.statements.draw.PaletteBasedMeshColorProvider;
import gama.gaml.statements.draw.ScaleBasedMeshColorProvider;
import java.util.List;

public class MeshDrawingAttributes
extends AssetDrawingAttributes {
    public IMeshSmoothProvider smoothProvider;
    public IMeshColorProvider colorProvider;
    public String speciesName;
    GamaPoint dimensions;
    Double scale;
    double noData = Double.MAX_VALUE;
    double above = MeshLayerData.ABOVE;
    int smooth;

    public MeshDrawingAttributes(String string, boolean bl) {
        super(null, bl);
        this.speciesName = string;
        this.smoothProvider = IMeshSmoothProvider.NULL;
    }

    public void setSpeciesName(String string) {
        this.speciesName = string;
    }

    public void setColors(Object object) {
        this.colorProvider = MeshDrawingAttributes.computeColors(object, this.isGrayscaled());
    }

    public static IMeshColorProvider computeColors(Object object, boolean bl) {
        if (object instanceof GamaColor) {
            GamaColor gamaColor = (GamaColor)object;
            return new ColorBasedMeshColorProvider(gamaColor);
        }
        if (object instanceof Colors.GamaPalette) {
            Colors.GamaPalette gamaPalette = (Colors.GamaPalette)object;
            return new PaletteBasedMeshColorProvider(gamaPalette);
        }
        if (object instanceof Colors.GamaScale) {
            Colors.GamaScale gamaScale = (Colors.GamaScale)object;
            return new ScaleBasedMeshColorProvider(gamaScale);
        }
        if (object instanceof Colors.GamaGradient) {
            Colors.GamaGradient gamaGradient = (Colors.GamaGradient)object;
            return new GradientBasedMeshColorProvider(gamaGradient);
        }
        if (object instanceof IList) {
            IList iList = (IList)object;
            Object e = iList.get(0);
            if (e instanceof GamaField) {
                GamaField gamaField = (GamaField)e;
                return new BandsBasedMeshColorProvider((List)((Object)gamaField));
            }
            return new ListBasedMeshColorProvider((IList)object);
        }
        if (bl) {
            return IMeshColorProvider.GRAYSCALE;
        }
        return IMeshColorProvider.DEFAULT;
    }

    public IMeshColorProvider getColorProvider() {
        if (this.isSet(DrawingAttributes.Flag.Selected)) {
            return new ColorBasedMeshColorProvider(SELECTED_COLOR);
        }
        if (this.highlight != null) {
            return new ColorBasedMeshColorProvider(this.highlight);
        }
        if (this.isSet(DrawingAttributes.Flag.Empty)) {
            return null;
        }
        return this.colorProvider;
    }

    @Override
    public GamaColor getColor() {
        if (this.isSet(DrawingAttributes.Flag.Selected)) {
            return SELECTED_COLOR;
        }
        if (this.highlight != null) {
            return this.highlight;
        }
        if (this.isSet(DrawingAttributes.Flag.Empty) || this.isSet(DrawingAttributes.Flag.Grayscaled)) {
            return null;
        }
        if (this.textures != null) {
            return TEXTURED_COLOR;
        }
        return this.fill == null ? GamaPreferences.Displays.CORE_COLOR.getValue() : this.fill;
    }

    @Override
    public String getSpeciesName() {
        return this.speciesName;
    }

    public GamaPoint getXYDimension() {
        return this.dimensions;
    }

    public void setXYDimension(GamaPoint gamaPoint) {
        this.dimensions = gamaPoint;
    }

    public void setScale(Double d) {
        this.scale = d;
    }

    public Double getScale() {
        if (this.scale == null) {
            Scaling3D scaling3D = this.getSize();
            return scaling3D == null ? 1.0 : scaling3D.getZ();
        }
        return this.scale;
    }

    public double getZFactor() {
        return this.getSize().getZ();
    }

    public boolean isTriangulated() {
        return this.isSet(DrawingAttributes.Flag.Triangulated);
    }

    public boolean isGrayscaled() {
        return this.isSet(DrawingAttributes.Flag.Grayscaled);
    }

    public boolean isWithText() {
        return this.isSet(DrawingAttributes.Flag.WithText);
    }

    public void setGrayscaled(Boolean bl) {
        if (this.colorProvider == null) {
            this.colorProvider = new GrayscaleMeshColorProvider();
        }
        this.setFlag(DrawingAttributes.Flag.Grayscaled, bl);
    }

    public void setTriangulated(Boolean bl) {
        this.setFlag(DrawingAttributes.Flag.Triangulated, bl);
    }

    public void setWithText(Boolean bl) {
        this.setFlag(DrawingAttributes.Flag.WithText, bl);
    }

    public void setSmooth(int n) {
        this.smooth = n;
        this.smoothProvider = IMeshSmoothProvider.FOR(n, this.noData);
    }

    public int getSmooth() {
        return this.smooth;
    }

    public void setNoData(double d) {
        this.noData = d;
        this.smoothProvider = IMeshSmoothProvider.FOR(this.smooth, d);
    }

    public double getNoDataValue() {
        return this.noData;
    }

    public void setAbove(double d) {
        this.above = d;
    }

    public double getAbove() {
        return this.above;
    }

    public IMeshSmoothProvider getSmoothProvider() {
        return this.smoothProvider;
    }
}

