/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sampling;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaDateType;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public abstract class SamplingUtils {
    private static ParametersSet scaleSamplingAmongValue(IScope iScope, ParametersSet parametersSet, IParameter.Batch batch, double d) {
        int n = batch.getAmongValue(iScope).size();
        int n3 = IntStream.range(1, n).filter(n2 -> d <= 1.0 * (double)n2 / (double)n).findFirst().orElse(n);
        parametersSet.put(batch.getName(), batch.getAmongValue(iScope).get(n3 - 1));
        return parametersSet;
    }

    private static ParametersSet scaleSampling(IScope iScope, ParametersSet parametersSet, IParameter.Batch batch, double d) {
        switch (batch.getType().id()) {
            case 1: {
                int n = Cast.asInt(iScope, batch.getMinValue(iScope));
                int n2 = Cast.asInt(iScope, batch.getMaxValue(iScope));
                int n3 = (int)Math.round((double)n + d * (double)(n2 - n));
                parametersSet.put(batch.getName(), (Object)n3);
                return parametersSet;
            }
            case 2: {
                double d2 = Cast.asFloat(iScope, batch.getMinValue(iScope));
                double d3 = Cast.asFloat(iScope, batch.getMaxValue(iScope));
                double d4 = d2 + d * (d3 - d2);
                parametersSet.put(batch.getName(), (Object)d4);
                return parametersSet;
            }
            case 23: {
                GamaDate gamaDate = GamaDateType.staticCast(iScope, batch.getMinValue(iScope), null, false);
                GamaDate gamaDate2 = GamaDateType.staticCast(iScope, batch.getMaxValue(iScope), null, false);
                GamaDate gamaDate3 = gamaDate.plus((double)gamaDate.getTemporal().until(gamaDate2, ChronoUnit.SECONDS) * d, (TemporalUnit)ChronoUnit.SECONDS);
                parametersSet.put(batch.getName(), (Object)gamaDate3);
                return parametersSet;
            }
            case 7: {
                GamaPoint gamaPoint = Cast.asPoint(iScope, batch.getMinValue(iScope));
                GamaPoint gamaPoint2 = Cast.asPoint(iScope, batch.getMaxValue(iScope));
                double d5 = gamaPoint.getX() + d * (gamaPoint2.getX() - gamaPoint.getX());
                double d6 = gamaPoint.getY() + d * (gamaPoint2.getY() - gamaPoint.getY());
                double d7 = gamaPoint.getZ() + d * (gamaPoint2.getZ() - gamaPoint.getZ());
                parametersSet.put(batch.getName(), (Object)new GamaPoint(d5, d6, d7));
                return parametersSet;
            }
            case 3: {
                parametersSet.put(batch.getName(), (Object)(d > 0.5 ? 1 : 0));
                return parametersSet;
            }
            case 4: {
                if (batch.getAmongValue(iScope).isEmpty()) {
                    throw GamaRuntimeException.error("Trying to force a string variable in sampling without among facets", iScope);
                }
                int n = batch.getAmongValue(iScope).size();
                int n4 = (int)Math.round(d * (double)n);
                parametersSet.put(batch.getName(), batch.getAmongValue(iScope).get(n4));
                return parametersSet;
            }
        }
        throw GamaRuntimeException.error("Trying to add a variable of unknown type " + batch.getType().asPattern() + " to a parameter set", iScope);
    }

    public static List<ParametersSet> buildParametersSetfromSample(IScope iScope, List<IParameter.Batch> list, List<Map<String, Double>> list2) {
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        int n = 0;
        while (n < list2.size()) {
            ParametersSet parametersSet = new ParametersSet();
            int n2 = 0;
            while (n2 < list.size()) {
                parametersSet = list.get(n2).getAmongValue(iScope) != null ? SamplingUtils.scaleSamplingAmongValue(iScope, parametersSet, list.get(n2), list2.get(n).get(list.get(n2).getName())) : SamplingUtils.scaleSampling(iScope, parametersSet, list.get(n2), list2.get(n).get(list.get(n2).getName()));
                ++n2;
            }
            arrayList.add(parametersSet);
            ++n;
        }
        return arrayList;
    }
}

