/*
 * Decompiled with CFR 0.152.
 */
package gama.core.messaging;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.messaging.GamaMailbox;
import gama.core.messaging.GamaMessage;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.gaml.skills.Skill;

@GamlAnnotations.skill(name="messaging", concept={"communication", "skill"})
@GamlAnnotations.doc(value="A simple skill that provides agents with a mailbox than can be filled with messages")
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="mailbox", type=5, of=24, doc={@GamlAnnotations.doc(value="The list of messages that can be consulted by the agent")})})
public class MessagingSkill
extends Skill {
    public static final String SKILL_NAME = "messaging";
    public static final String MAILBOX = "mailbox";
    public static final String MAILBOX_ATTRIBUTE = "messaging_skill_mailbox";

    @GamlAnnotations.getter(value="mailbox", initializer=true)
    public GamaMailbox getMailbox(IScope iScope, IAgent iAgent) {
        GamaMailbox gamaMailbox = (GamaMailbox)iAgent.getAttribute(MAILBOX_ATTRIBUTE);
        if (gamaMailbox == null) {
            gamaMailbox = this.createNewMailbox();
            iAgent.setAttribute(MAILBOX_ATTRIBUTE, gamaMailbox);
        }
        return gamaMailbox;
    }

    @GamlAnnotations.setter(value="mailbox")
    public void setMailbox(IAgent iAgent, GamaMailbox gamaMailbox) {
    }

    @GamlAnnotations.action(name="send", args={@GamlAnnotations.arg(name="to", type=0, optional=true, doc={@GamlAnnotations.doc(value="The agent, or server, to which this message will be sent to")}), @GamlAnnotations.arg(name="contents", type=0, optional=false, doc={@GamlAnnotations.doc(value="The contents of the message, an arbitrary object")})}, doc={@GamlAnnotations.doc(value="Action used to send a message (that can be of any kind of object) to an agent or a server.", examples={@GamlAnnotations.example(value="do send to:dest contents:\"This message is sent by \" + name + \" to \" + dest;")})})
    public GamaMessage primSendMessage(IScope iScope) throws GamaRuntimeException {
        Object object;
        IAgent iAgent = iScope.getAgent();
        Object object2 = iScope.getArg("to", 0);
        if (object2 == null) {
            object2 = iAgent;
        }
        if ((object = this.effectiveContents(iScope, iScope.getArg("contents", 0))) == null) {
            return null;
        }
        GamaMessage gamaMessage = this.createNewMessage(iScope, iAgent, object2, object);
        this.effectiveSend(iScope, gamaMessage, object2);
        return gamaMessage;
    }

    protected Object effectiveContents(IScope iScope, Object object) {
        return object;
    }

    protected GamaMailbox createNewMailbox() {
        return new GamaMailbox();
    }

    protected GamaMessage createNewMessage(IScope iScope, Object object, Object object2, Object object3) {
        return new GamaMessage(iScope, object, object2, object3);
    }

    protected void effectiveSend(IScope iScope, GamaMessage gamaMessage, Object object) {
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            if (iAgent.isInstanceOf(SKILL_NAME, false)) {
                GamaMailbox gamaMailbox = (GamaMailbox)iAgent.getAttribute(MAILBOX_ATTRIBUTE);
                gamaMailbox.addMessage(iScope, gamaMessage);
            }
        } else if (object instanceof IList) {
            for (Object e : ((IList)object).iterable(iScope)) {
                this.effectiveSend(iScope, gamaMessage.copy(iScope), e);
            }
        }
    }
}

