/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.GamlFileExtension;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.model.IModel;
import gama.core.metamodel.agent.AgentReference;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.CommandExecutor;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaWebSocketServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamaCompilationFailedException;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.GamlIdiomsProvider;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.Arguments;
import gama.gaml.statements.IStatement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.java_websocket.WebSocket;

public class DefaultServerCommands {
    public static GamaServerMessage LOAD(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        Object object;
        Object v = iMap.get("model");
        Object v2 = iMap.get("experiment");
        if (v == null || v2 == null) {
            return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "For 'load', mandatory parameters are: 'model' and 'experiment'", iMap, false);
        }
        String string = v.toString().trim();
        String string2 = v2.toString().trim();
        File file2 = new File(string);
        if (!file2.exists()) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "'" + file2.getAbsolutePath() + "' does not exist", iMap, false);
        }
        if (!GamlFileExtension.isGaml(file2.getAbsoluteFile().toString())) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "'" + file2.getAbsolutePath() + "' is not a gaml file", iMap, false);
        }
        IModel iModel = null;
        try {
            object = new ArrayList<GamlCompilationError>();
            iModel = GAML.getModelBuilder().compile(file2, (List<GamlCompilationError>)object, null);
        }
        catch (GamaCompilationFailedException gamaCompilationFailedException) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, gamaCompilationFailedException.toJsonString(), iMap, true);
        }
        catch (IOException iOException) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Impossible to compile '" + file2.getAbsolutePath() + "' because of " + iOException.getMessage(), iMap, false);
        }
        if (!iModel.getDescription().hasExperiment(string2)) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "'" + string2 + "' is not an experiment present in '" + file2.getAbsolutePath() + "'", iMap, false);
        }
        object = iModel;
        GAMA.getGui().run("openExp", () -> DefaultServerCommands.lambda$0(string2, (IModel)object), false);
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, string2, iMap, false);
    }

    public static GamaServerMessage PLAY(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        if (!GAMA.startFrontmostExperiment(true)) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Controller is full", iMap, false);
        }
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
    }

    public static GamaServerMessage PAUSE(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        IExperimentPlan iExperimentPlan;
        try {
            iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
        }
        catch (ISocketCommand.CommandException commandException) {
            return commandException.getResponse();
        }
        return new CommandResponse(iExperimentPlan.getController().processPause(true) ? GamaServerMessage.Type.CommandExecutedSuccessfully : GamaServerMessage.Type.UnableToExecuteRequest, "", iMap, false);
    }

    public static GamaServerMessage STEP(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        IExperimentPlan iExperimentPlan;
        try {
            iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
        }
        catch (ISocketCommand.CommandException commandException) {
            return commandException.getResponse();
        }
        int n = iMap.get("nb_step") != null && !"".equals(String.valueOf(iMap.get("nb_step")).trim()) ? Integer.parseInt(String.valueOf(iMap.get("nb_step"))) : 1;
        boolean bl = iMap.get("sync") != null ? Boolean.parseBoolean(String.valueOf(iMap.get("sync"))) : false;
        int n2 = 0;
        while (n2 < n) {
            try {
                if (!iExperimentPlan.getController().processStep(bl)) {
                    return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Controller is full", iMap, false);
                }
            }
            catch (RuntimeException runtimeException) {
                DEBUG.OUT((Object)runtimeException.getStackTrace());
                return new CommandResponse(GamaServerMessage.Type.GamaServerError, runtimeException, iMap, false);
            }
            ++n2;
        }
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
    }

    public static GamaServerMessage BACK(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        IExperimentPlan iExperimentPlan;
        try {
            iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
        }
        catch (ISocketCommand.CommandException commandException) {
            return commandException.getResponse();
        }
        int n = iMap.get("nb_step") != null && !"".equals(String.valueOf(iMap.get("nb_step")).trim()) ? Integer.parseInt(String.valueOf(iMap.get("nb_step"))) : 1;
        boolean bl = iMap.get("sync") != null ? Boolean.parseBoolean(String.valueOf(iMap.get("sync"))) : false;
        int n2 = 0;
        while (n2 < n) {
            try {
                if (!iExperimentPlan.getController().processBack(bl)) {
                    return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Controller is full", iMap, false);
                }
            }
            catch (RuntimeException runtimeException) {
                DEBUG.OUT((Object)runtimeException.getStackTrace());
                return new CommandResponse(GamaServerMessage.Type.GamaServerError, runtimeException, iMap, false);
            }
            ++n2;
        }
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
    }

    public static GamaServerMessage STOP(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        GAMA.closeAllExperiments(true, false);
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
    }

    public static GamaServerMessage RELOAD(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        IExperimentPlan iExperimentPlan;
        try {
            iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
        }
        catch (ISocketCommand.CommandException commandException) {
            return commandException.getResponse();
        }
        IList iList = (IList)iMap.get("parameters");
        CommandResponse commandResponse = CommandExecutor.checkLoadParameters(iList, iMap);
        if (commandResponse != null) {
            return commandResponse;
        }
        iExperimentPlan.setParameterValues(iList);
        iExperimentPlan.setStopCondition((String)iMap.get("until"));
        if (!iExperimentPlan.getController().processReload(true)) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Controller is full", iMap, false);
        }
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
    }

    public static GamaServerMessage EVAL(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        Object object;
        block13: {
            IExperimentPlan iExperimentPlan;
            try {
                iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
            }
            catch (ISocketCommand.CommandException commandException) {
                return commandException.getResponse();
            }
            Object v = iMap.get("expr");
            if (v == null) {
                return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "For evaluate, mandatory parameter is: expr", iMap, false);
            }
            String string = v.toString().trim();
            object = null;
            GamlAgent gamlAgent = iExperimentPlan.getAgent();
            if (gamlAgent == null) {
                gamlAgent = GAMA.getPlatformAgent();
            }
            IScope iScope = gamlAgent.getScope().copy("in web socket");
            if (string.startsWith("?")) {
                object = GamlIdiomsProvider.getDocumentationOn(string.substring(1));
            } else {
                try {
                    try {
                        IExpression iExpression = GAML.compileExpression(string, gamlAgent, false);
                        if (iExpression != null) {
                            object = String.valueOf(iScope.evaluate(iExpression, gamlAgent).getValue());
                        }
                    }
                    catch (Exception exception) {
                        object = "> Error: " + exception.getMessage();
                        gamlAgent.getSpecies().removeTemporaryAction();
                        GAMA.releaseScope(iScope);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    gamlAgent.getSpecies().removeTemporaryAction();
                    GAMA.releaseScope(iScope);
                    throw throwable;
                }
                gamlAgent.getSpecies().removeTemporaryAction();
                GAMA.releaseScope(iScope);
            }
        }
        if (object == null || ((String)object).length() == 0 || ((String)object).startsWith("> Error: ")) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, object, iMap, false);
        }
        boolean bl = iMap.get("escaped") == null ? false : Boolean.parseBoolean(String.valueOf(iMap.get("escaped")));
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, object, iMap, bl);
    }

    public static GamaServerMessage VALIDATE(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        Boolean bl;
        boolean bl2;
        Object v = iMap.get("expr");
        Object v2 = iMap.get("syntax");
        boolean bl3 = bl2 = v2 instanceof Boolean && (bl = (Boolean)v2) != false;
        if (v == null) {
            return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "For validate, mandatory parameter is: expr", iMap, false);
        }
        String string = v.toString().trim();
        List<String> list = GAML.validate(string, bl2);
        if (list != null && !list.isEmpty()) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, list, iMap, false);
        }
        boolean bl4 = iMap.get("escaped") == null ? false : Boolean.parseBoolean(String.valueOf(iMap.get("escaped")));
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, string, iMap, bl4);
    }

    public static GamaServerMessage ASK(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        ExperimentAgent experimentAgent;
        String string;
        IExperimentPlan iExperimentPlan;
        try {
            iExperimentPlan = gamaWebSocketServer.retrieveExperimentPlan(webSocket, iMap);
        }
        catch (ISocketCommand.CommandException commandException) {
            return commandException.getResponse();
        }
        String string2 = string = iMap.get("action") != null ? iMap.get("action").toString().trim() : null;
        if (string == null) {
            return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "For ask, mandatory parameter is: 'action'", iMap, false);
        }
        String string3 = iMap.get("agent") != null ? iMap.get("agent").toString().trim() : null;
        ExperimentAgent experimentAgent2 = iExperimentPlan.getAgent();
        IScope iScope = experimentAgent2.getScope();
        IAgent iAgent = experimentAgent = string3 == null ? experimentAgent2 : AgentReference.of(string3).getReferencedAgent(iScope);
        if (experimentAgent == null) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Agent does not exist: " + string3, iMap, false);
        }
        IStatement.WithArgs withArgs = experimentAgent.getSpecies().getAction(string);
        if (withArgs == null) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Action " + string + " does not exist in agent " + string3, iMap, false);
        }
        String string4 = (String)iMap.get("args");
        JsonValue jsonValue = Json.getNew().parse(string4);
        IMap iMap2 = Cast.asMap(iScope, jsonValue.toGamlValue(iScope), false);
        ExecutionResult executionResult = ExecutionResult.PASSED;
        IScope iScope2 = experimentAgent.getScope().copy("Ask command of gama-server");
        try {
            try {
                executionResult = iScope2.execute(withArgs, experimentAgent, new Arguments(iMap2));
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                CommandResponse commandResponse = new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, gamaRuntimeException.getMessage(), iMap, false);
                GAMA.releaseScope(iScope2);
                return commandResponse;
            }
        }
        finally {
            GAMA.releaseScope(iScope2);
        }
        if (!executionResult.passed()) {
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Error in the execution of " + string, iMap, false);
        }
        boolean bl = iMap.get("escaped") == null ? false : Boolean.parseBoolean(String.valueOf(iMap.get("escaped")));
        return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, bl);
    }

    /*
     * Exception decompiling
     */
    public static CommandResponse DOWNLOAD(GamaWebSocketServer var0, WebSocket var1_1, IMap<String, Object> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static GamaServerMessage UPLOAD(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        String string;
        String string2 = iMap.containsKey("file") ? iMap.get("file").toString() : null;
        String string3 = string = iMap.containsKey("content") ? iMap.get("content").toString() : null;
        if (string2 == null || string == null) {
            return new CommandResponse(GamaServerMessage.Type.MalformedRequest, "For 'upload', mandatory parameters are: 'file' and 'content'", iMap, false);
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileWriter fileWriter = new FileWriter(string2);){
                fileWriter.write(string);
                return new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, exception.getMessage(), iMap, false);
        }
    }

    public static GamaServerMessage EXIT(GamaWebSocketServer gamaWebSocketServer, WebSocket webSocket, IMap<String, Object> iMap) {
        try {
            CommandResponse commandResponse = new CommandResponse(GamaServerMessage.Type.CommandExecutedSuccessfully, "", iMap, false);
            return commandResponse;
        }
        finally {
            System.exit(0);
        }
    }

    private static /* synthetic */ void lambda$0(String string, IModel iModel) {
        GAMA.runGuiExperiment(string, iModel);
    }
}

