/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.Iterables;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionProvider;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.DenotedActionExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.jgrapht.graph.DirectedAcyclicGraph;

public abstract class TypeDescription
extends SymbolDescription {
    protected IMap<String, ActionDescription> actions;
    protected IMap<String, VariableDescription> attributes;
    protected TypeDescription parent;

    static {
        DEBUG.ON();
    }

    public TypeDescription(String string, Class clazz, IDescription iDescription, TypeDescription typeDescription, Iterable<? extends IDescription> iterable, EObject eObject, Facets facets2, String string2) {
        super(string, iDescription, eObject, facets2);
        this.setIf(IDescription.Flag.Abstract, "true".equals(this.getLitteral("virtual")));
        this.addChildren(iterable);
        for (ActionDescription actionDescription : this.getActions()) {
            if (!actionDescription.isAbstract()) continue;
            this.setIf(IDescription.Flag.Abstract, true);
            break;
        }
        if (typeDescription != null) {
            this.setParent(typeDescription);
        }
        if (string2 != null && this.isBuiltIn()) {
            this.originName = string2;
        }
    }

    public void documentAttributes(IGamlDescription.Doc doc2) {
        for (VariableDescription variableDescription : this.getAttributes()) {
            doc2.set("Attributes:", variableDescription.getName(), variableDescription.getShortDocumentation());
        }
    }

    public void documentActions(IGamlDescription.Doc doc2) {
        for (ActionDescription actionDescription : this.getActions()) {
            doc2.set("Actions:", actionDescription.getName(), actionDescription.getShortDocumentation(true));
        }
    }

    @Override
    public String getDefiningPlugin() {
        if (this.isBuiltIn()) {
            return this.originName;
        }
        return null;
    }

    public abstract Class getJavaBase();

    public Iterable<VariableDescription> getAttributes() {
        return Iterables.transform(this.getAttributeNames(), this::getAttribute);
    }

    public Iterable<VariableDescription> getOwnAttributes() {
        return this.attributes == null ? Collections.EMPTY_LIST : this.attributes.values();
    }

    public Collection<String> getAttributeNames() {
        LinkedHashSet<String> linkedHashSet;
        Collection<String> collection = linkedHashSet = this.parent != null && this.parent != this ? this.parent.getAttributeNames() : new LinkedHashSet<String>();
        if (this.attributes != null) {
            this.attributes.forEachKey(string -> {
                if (linkedHashSet.contains(string)) {
                    linkedHashSet.remove(string);
                }
                linkedHashSet.add((String)string);
                return true;
            });
        }
        return linkedHashSet;
    }

    public VariableDescription getAttribute(String string) {
        VariableDescription variableDescription;
        VariableDescription variableDescription2 = variableDescription = this.attributes == null ? null : (VariableDescription)this.attributes.get(string);
        if (variableDescription == null && this.parent != null && this.parent != this) {
            return this.getParent().getAttribute(string);
        }
        return variableDescription;
    }

    public boolean redefinesAttribute(String string) {
        if (!this.attributes.containsKey(this.name) || this.parent == null || this.parent == this) {
            return false;
        }
        return this.parent.hasAttribute(this.name);
    }

    @Override
    public boolean hasAttribute(String string) {
        return this.attributes != null && this.attributes.containsKey(string) || this.parent != null && this.parent != this && this.getParent().hasAttribute(string);
    }

    @Override
    public IVarDescriptionProvider getDescriptionDeclaringVar(String string) {
        IDescription iDescription = this.getEnclosingDescription();
        return this.hasAttribute(string) ? this : (iDescription == null ? null : iDescription.getDescriptionDeclaringVar(string));
    }

    @Override
    public IExpression getVarExpr(String string, boolean bl) {
        VariableDescription variableDescription = this.getAttribute(string);
        if (variableDescription == null) {
            ActionDescription actionDescription = this.getAction(string);
            if (actionDescription != null) {
                return new DenotedActionExpression(actionDescription);
            }
            return null;
        }
        return variableDescription.getVarExpr(bl);
    }

    public boolean assertAttributesAreCompatible(VariableDescription variableDescription, VariableDescription variableDescription2) {
        if (variableDescription2.isBuiltIn() && variableDescription.isBuiltIn()) {
            return true;
        }
        IType<?> iType = variableDescription.getGamlType();
        IType<?> iType2 = variableDescription2.getGamlType();
        if (!iType2.isTranslatableInto(iType)) {
            this.markTypeDifference(variableDescription, variableDescription2, iType, iType2, true);
        } else if (!iType2.equals(iType) && !iType2.isParametricFormOf(iType)) {
            this.markTypeDifference(variableDescription, variableDescription2, iType, iType2, false);
        }
        return true;
    }

    private void markTypeDifference(VariableDescription variableDescription, VariableDescription variableDescription2, IType iType, IType iType2, boolean bl) {
        String string = "Type (" + String.valueOf(iType2) + ") differs from that (" + String.valueOf(iType) + ") of the implementation of  " + variableDescription2.getName() + " in " + variableDescription.getOriginName();
        if (variableDescription.isBuiltIn()) {
            if (bl) {
                variableDescription2.error(string, "gaml.wrong.redefinition.issue", "name", new String[0]);
            } else {
                variableDescription2.warning(string, "gaml.wrong.redefinition.issue", "name", new String[0]);
            }
        } else {
            boolean bl2;
            Resource resource;
            EObject eObject = variableDescription2.getUnderlyingElement();
            Resource resource2 = eObject == null ? null : eObject.eResource();
            EObject eObject2 = variableDescription.getUnderlyingElement();
            Resource resource3 = resource = eObject2 == null ? null : eObject2.eResource();
            boolean bl3 = resource2 == null ? resource == null : (bl2 = resource2.equals(resource));
            if (bl2) {
                if (bl) {
                    variableDescription2.error(string, "gaml.wrong.redefinition.issue", "name", new String[0]);
                } else {
                    variableDescription2.info(string, "gaml.wrong.redefinition.issue", "name", new String[0]);
                }
            } else if (resource != null) {
                if (bl) {
                    variableDescription2.error(string + " in  imported file " + resource.getURI().lastSegment(), "gaml.wrong.redefinition.issue", "name", new String[0]);
                } else {
                    variableDescription2.info(string + " in  imported file " + resource.getURI().lastSegment(), "gaml.wrong.redefinition.issue", "name", new String[0]);
                }
            }
        }
    }

    public void markAttributeRedefinition(VariableDescription variableDescription, VariableDescription variableDescription2) {
        if (variableDescription2.isBuiltIn() && variableDescription.isBuiltIn()) {
            return;
        }
        if (variableDescription2.getOriginName().equals(variableDescription.getOriginName())) {
            if (!"".equals(variableDescription2.getModelDescription().getAlias())) {
                return;
            }
            variableDescription.error("Attribute " + variableDescription2.getName() + " is defined twice", "gaml.duplicate.definition.issue", "name", new String[0]);
            variableDescription2.error("Attribute " + variableDescription2.getName() + " is defined twice", "gaml.duplicate.definition.issue", "name", new String[0]);
            return;
        }
        if (variableDescription.isBuiltIn()) {
            variableDescription2.info("This definition of " + variableDescription2.getName() + " supersedes the one in " + variableDescription.getOriginName(), "gaml.redefinition.info", "name", new String[0]);
        } else {
            Resource resource;
            Resource resource2 = variableDescription2.getUnderlyingElement() == null ? null : variableDescription2.getUnderlyingElement().eResource();
            if (Objects.equals(resource2, resource = variableDescription.getUnderlyingElement().eResource())) {
                variableDescription2.info("This definition of " + variableDescription2.getName() + " supersedes the one in " + variableDescription.getOriginName(), "gaml.redefinition.info", "name", new String[0]);
            } else {
                variableDescription2.info("This definition of " + variableDescription2.getName() + " supersedes the one in imported file " + resource.getURI().lastSegment(), "gaml.redefinition.info", "name", new String[0]);
            }
        }
    }

    protected void inheritAttributesFrom(TypeDescription typeDescription) {
        for (VariableDescription variableDescription : typeDescription.getAttributes()) {
            this.addInheritedAttribute(variableDescription);
        }
    }

    public void addOwnAttribute(VariableDescription variableDescription) {
        String string = variableDescription.getName();
        VariableDescription variableDescription2 = this.getAttribute(string);
        if (variableDescription2 != null) {
            if (!this.assertAttributesAreCompatible(variableDescription2, variableDescription)) {
                return;
            }
            this.markAttributeRedefinition(variableDescription2, variableDescription);
            variableDescription.copyFrom(variableDescription2);
        }
        if (this.attributes == null) {
            this.attributes = GamaMapFactory.create();
        }
        this.attributes.put(variableDescription.getName(), variableDescription);
    }

    public void addInheritedAttribute(VariableDescription variableDescription) {
        VariableDescription variableDescription2;
        String string = variableDescription.getName();
        if (this.attributes != null && (variableDescription2 = (VariableDescription)this.attributes.get(string)) != null && this.assertAttributesAreCompatible(variableDescription, variableDescription2)) {
            if (!variableDescription2.isBuiltIn()) {
                this.markAttributeRedefinition(variableDescription, variableDescription2);
            }
            variableDescription2.copyFrom(variableDescription);
        }
    }

    private boolean add(DirectedAcyclicGraph<VariableDescription, Object> directedAcyclicGraph, VariableDescription variableDescription, VariableDescription variableDescription2, String string) {
        directedAcyclicGraph.addVertex((Object)variableDescription);
        directedAcyclicGraph.addVertex((Object)variableDescription2);
        try {
            directedAcyclicGraph.addEdge((Object)variableDescription, (Object)variableDescription2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            VariableDescription variableDescription3;
            if (variableDescription.isBuiltIn() || variableDescription.isSyntheticSpeciesContainer()) {
                if (variableDescription2.isBuiltIn() || variableDescription2.isSyntheticSpeciesContainer()) {
                    return false;
                }
                variableDescription3 = variableDescription2;
            } else {
                variableDescription3 = variableDescription;
            }
            String string2 = variableDescription3.getName();
            String string3 = (variableDescription3 == variableDescription ? variableDescription2 : variableDescription).getName();
            variableDescription3.error("Cycle detected in the " + string + " of " + string2 + " (through the " + string + " of " + string3 + ")");
            return false;
        }
        return true;
    }

    protected boolean verifyAttributeCycles() {
        if (this.attributes == null || this.attributes.size() <= 1) {
            return true;
        }
        VariableDescription variableDescription = (VariableDescription)this.attributes.get("shape");
        DirectedAcyclicGraph directedAcyclicGraph = new DirectedAcyclicGraph(Object.class);
        Set set = variableDescription == null ? Collections.EMPTY_SET : variableDescription.getDependencies(VariableDescription.INIT_DEPENDENCIES_FACETS, false, true);
        Collection collection = this.attributes.values();
        for (VariableDescription variableDescription2 : collection) {
            if (variableDescription != null && variableDescription2.isSyntheticSpeciesContainer() && !this.add((DirectedAcyclicGraph<VariableDescription, Object>)directedAcyclicGraph, variableDescription, variableDescription2, "init")) {
                return false;
            }
            Set set2 = variableDescription2 == variableDescription ? set : variableDescription2.getDependencies(VariableDescription.INIT_DEPENDENCIES_FACETS, false, true);
            for (VariableDescription variableDescription3 : set2) {
                if (!collection.contains(variableDescription3) || this.add((DirectedAcyclicGraph<VariableDescription, Object>)directedAcyclicGraph, variableDescription3, variableDescription2, "init")) continue;
                return false;
            }
            if (!variableDescription2.hasFacet("function")) continue;
            directedAcyclicGraph.removeAllVertices(collection);
            for (VariableDescription variableDescription3 : variableDescription2.getDependencies(VariableDescription.FUNCTION_DEPENDENCIES_FACETS, true, false)) {
                if (!collection.contains(variableDescription3) || this.add((DirectedAcyclicGraph<VariableDescription, Object>)directedAcyclicGraph, variableDescription3, variableDescription2, "function")) continue;
                return false;
            }
        }
        return true;
    }

    public void setParent(TypeDescription typeDescription) {
        this.parent = typeDescription;
    }

    protected void duplicateInfo(IDescription iDescription, IDescription iDescription2) {
        String string = iDescription.getName();
        String string2 = iDescription.getKeyword();
        if (!iDescription.getOriginName().equals(iDescription2.getOriginName())) {
            if ("reflex".equals(string2)) {
                iDescription.info("The order in which reflex " + string + " will be executed in " + iDescription.getOriginName() + " can differ from the order defined in " + iDescription2.getOriginName(), "gaml.general.issue", "name", string);
            }
            iDescription.info("This definition of " + string2 + " " + string + " supersedes the one existing in " + iDescription2.getOriginName(), "gaml.duplicate.definition.issue", "name", string);
        } else {
            iDescription.info("This definition of " + string2 + " " + string + " supersedes the previous one(s) in the same species", "gaml.duplicate.definition.issue", "name", string);
        }
    }

    protected void addAction(ActionDescription actionDescription) {
        String string = actionDescription.getName();
        if (this.actions != null) {
            ActionDescription actionDescription2 = (ActionDescription)this.actions.get(string);
            if (actionDescription2 != null) {
                TypeDescription.assertActionsAreCompatible(actionDescription, actionDescription2, actionDescription2.getOriginName());
                this.duplicateInfo(actionDescription, actionDescription2);
            }
        } else {
            this.actions = GamaMapFactory.create();
        }
        this.actions.put(string, actionDescription);
    }

    public boolean redefinesAction(String string) {
        if (!this.actions.containsKey(string) || this.parent == null || this.parent == this) {
            return false;
        }
        return this.parent.hasAction(string, false);
    }

    @Override
    public ActionDescription getAction(String string) {
        ActionDescription actionDescription = null;
        if (this.actions != null) {
            actionDescription = (ActionDescription)this.actions.get(string);
        }
        if (actionDescription == null && this.parent != null && this.parent != this) {
            actionDescription = this.getParent().getAction(string);
        }
        return actionDescription;
    }

    public Iterable<ActionDescription> getOwnActions() {
        return this.actions == null ? Collections.EMPTY_LIST : this.actions.values();
    }

    public void removeAction(String string) {
        if (this.actions == null) {
            return;
        }
        this.actions.remove(string);
    }

    public Collection<String> getActionNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.actions == null ? Collections.EMPTY_LIST : this.actions.keySet());
        if (this.parent != null && this.parent != this) {
            linkedHashSet.addAll(this.getParent().getActionNames());
        }
        return linkedHashSet;
    }

    public Iterable<ActionDescription> getActions() {
        return Iterables.transform(this.getActionNames(), this::getAction);
    }

    @Override
    public boolean hasAction(String string, boolean bl) {
        if (bl) {
            if (this.parent == null || this.parent == this) {
                return false;
            }
            return this.parent.hasAction(string, false);
        }
        return this.actions != null && this.actions.containsKey(string) || this.parent != null && this.parent != this && this.getParent().hasAction(string, bl);
    }

    @Override
    public IDescription getDescriptionDeclaringAction(String string, boolean bl) {
        if (bl) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getDescriptionDeclaringAction(string, false);
        }
        return this.hasAction(string, false) ? this : null;
    }

    public final boolean isAbstract() {
        return this.isSet(IDescription.Flag.Abstract);
    }

    protected IType computeType() {
        return this.getTypeNamed(this.getName());
    }

    public boolean isArgOf(String string, String string2) {
        ActionDescription actionDescription = this.getAction(string);
        if (actionDescription != null) {
            return actionDescription.containsArg(string2);
        }
        return false;
    }

    public TypeDescription getParent() {
        return this.parent;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isBuiltIn()) {
            return;
        }
        this.actions = null;
        this.attributes = null;
        this.parent = null;
    }

    protected void inheritFromParent() {
        if (this.parent != null && this.parent != this) {
            this.inheritActionsFrom(this.parent);
            this.inheritAttributesFrom(this.parent);
        }
    }

    protected void inheritActionsFrom(TypeDescription typeDescription) {
        if (typeDescription == null || typeDescription == this) {
            return;
        }
        for (ActionDescription actionDescription : typeDescription.getActions()) {
            ActionDescription actionDescription2;
            String string = actionDescription.getName();
            ActionDescription actionDescription3 = actionDescription2 = this.actions == null ? null : (ActionDescription)this.actions.get(string);
            if (actionDescription2 != null) {
                if (actionDescription.isBuiltIn() && actionDescription2.isBuiltIn()) continue;
                TypeDescription.assertActionsAreCompatible(actionDescription2, actionDescription, actionDescription.getOriginName());
                if (actionDescription.isBuiltIn()) {
                    if ("die".equals(string)) {
                        actionDescription2.warning("Redefining the built-in primitive 'die' is not advised as it can lead to potential troubles in the disposal of simulations. If it was not your intention, consider renaming this action.", "gaml.general.issue");
                        continue;
                    }
                    actionDescription2.info("Action '" + string + "' replaces a primitive of the same name defined in " + actionDescription2.getOriginName() + ". If it was not your intention, consider renaming it.", "gaml.general.issue");
                    continue;
                }
                actionDescription2.info("Action '" + string + "' supersedes the one defined in  " + actionDescription.getOriginName(), "gaml.redefinition.info", "name", new String[0]);
                continue;
            }
            if (!actionDescription.isAbstract()) continue;
            this.error("Abstract action '" + string + "', inherited from " + actionDescription.getEnclosingDescription().getName() + ", should be redefined.", "gaml.missing.action.issue", "name", new String[0]);
            return;
        }
    }

    public static void assertActionsAreCompatible(ActionDescription actionDescription, ActionDescription actionDescription2, String string) {
        if (actionDescription.isBuiltIn() && actionDescription2.isBuiltIn()) {
            return;
        }
        String string2 = actionDescription2.getName();
        IType<?> iType = actionDescription.getGamlType();
        IType<?> iType2 = actionDescription2.getGamlType();
        if (!iType2.isAssignableFrom(iType)) {
            actionDescription.error("Return type (" + String.valueOf(iType) + ") differs from that (" + String.valueOf(iType2) + ") of the implementation of  " + string2 + " in " + string);
            return;
        }
        Iterable<IDescription> iterable = actionDescription.getFormalArgs();
        Iterable<IDescription> iterable2 = actionDescription2.getFormalArgs();
        Iterator<IDescription> iterator = iterable.iterator();
        Iterator<IDescription> iterator2 = iterable2.iterator();
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        for (IDescription object2 : iterable) {
            String string5;
            if (!iterator2.hasNext()) {
                string3 = object2.getName();
                break;
            }
            IDescription iDescription = iterator2.next();
            String string6 = object2.getName();
            if (!string6.equals(string5 = iDescription.getName())) {
                bl = true;
                break;
            }
            if (iDescription.getGamlType().isAssignableFrom(object2.getGamlType())) continue;
            string4 = string6;
            break;
        }
        if (!iterator.hasNext() && iterator2.hasNext()) {
            String string7 = "Missing argument: " + iterator2.next().getName();
            actionDescription.error(string7, "gaml.different.arguments.issue", actionDescription.getUnderlyingElement(), new String[0]);
            return;
        }
        if (string3 != null) {
            String string8 = "Argument " + string3 + " does not belong to the definition of " + string2 + " in " + string;
            actionDescription.error(string8, "gaml.different.arguments.issue", actionDescription.getUnderlyingElement(), new String[0]);
            return;
        }
        if (bl) {
            String string9 = "The  names of arguments should be identical to those of the definition of " + string2 + " in " + string;
            actionDescription.error(string9, "gaml.different.arguments.issue", actionDescription.getUnderlyingElement(), new String[0]);
            return;
        }
        if (string4 != null) {
            String string10 = "The  type of argument  " + string4 + " is not compatible with that in the definition of " + string2 + " in " + string;
            actionDescription.error(string10, "gaml.different.arguments.issue", actionDescription.getUnderlyingElement(), new String[0]);
        }
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        for (IDescription iDescription : this.getAttributes()) {
            if (descriptionVisitor.process(iDescription)) continue;
            return false;
        }
        for (IDescription iDescription : this.getActions()) {
            if (descriptionVisitor.process(iDescription)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (!this.visitOwnAttributes(descriptionVisitor)) {
            return false;
        }
        return this.visitOwnActions(descriptionVisitor);
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (!this.visitOwnAttributes(descriptionVisitor)) {
            return false;
        }
        return this.visitOwnActionsRecursively(descriptionVisitor);
    }

    public boolean visitAllAttributes(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.parent != null && this.parent != this && !this.parent.visitAllAttributes(descriptionVisitor)) {
            return false;
        }
        return this.visitOwnAttributes(descriptionVisitor);
    }

    public boolean visitOwnAttributes(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.attributes == null) {
            return true;
        }
        return this.attributes.forEachValue(descriptionVisitor);
    }

    public boolean visitOwnActions(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.actions == null) {
            return true;
        }
        return this.actions.forEachValue(descriptionVisitor);
    }

    public boolean visitOwnActionsRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (this.actions == null) {
            return true;
        }
        return this.actions.forEachValue(actionDescription -> {
            if (!descriptionVisitor.process((IDescription)actionDescription)) {
                return false;
            }
            return actionDescription.visitOwnChildrenRecursively(descriptionVisitor);
        });
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        return Iterables.concat((Iterable)(this.actions == null ? Collections.EMPTY_LIST : this.actions.values()), (Iterable)(this.attributes == null ? Collections.EMPTY_LIST : this.attributes.values()));
    }

    @Override
    public IDescription validate() {
        if (this.isSet(IDescription.Flag.Validated)) {
            return this;
        }
        IDescription iDescription = super.validate();
        if (iDescription != null && !this.verifyAttributeCycles()) {
            return null;
        }
        return iDescription;
    }

    public VariableDescription getOwnAttribute(String string) {
        return this.attributes == null ? null : (VariableDescription)this.attributes.get(string);
    }

    public ActionDescription getOwnAction(String string) {
        return this.actions == null ? null : (ActionDescription)this.actions.get(string);
    }
}

