/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IDocManager;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.util.Collector;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.interfaces.IGamlDescription;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class ValidationContext
extends Collector.AsList<GamlCompilationError> {
    static final int MAX_SIZE = 1000;
    boolean shouldDocument;
    public static final ValidationContext NULL;
    final URI resourceURI;
    Set<GamlCompilationError> importedErrors;
    private boolean noWarning;
    private boolean noInfo;
    private boolean hasSyntaxErrors;
    private boolean noExperiment;
    private final IDocManager docDelegate;
    private final Map<EObject, IGamlDescription> expressionsToDocument = new ConcurrentHashMap<EObject, IGamlDescription>();
    public static final Predicate<GamlCompilationError> IS_INFO;
    public static final Predicate<GamlCompilationError> IS_WARNING;
    public static final Predicate<GamlCompilationError> IS_ERROR;
    public static final String IMPORTED_FROM = "imported from";

    static {
        DEBUG.OFF();
        NULL = new ValidationContext(null, false, IDocManager.NULL);
        IS_INFO = GamlCompilationError::isInfo;
        IS_WARNING = GamlCompilationError::isWarning;
        IS_ERROR = GamlCompilationError::isError;
    }

    public ValidationContext(URI uRI, boolean bl, IDocManager iDocManager) {
        this.resourceURI = uRI;
        this.hasSyntaxErrors = bl;
        this.docDelegate = iDocManager == null ? IDocManager.NULL : iDocManager;
    }

    @Override
    public boolean add(GamlCompilationError gamlCompilationError) {
        boolean bl;
        if (gamlCompilationError.isWarning() ? GamaPreferences.Modeling.WARNINGS_ENABLED.getValue() == false || this.noWarning : gamlCompilationError.isInfo() && (GamaPreferences.Modeling.INFO_ENABLED.getValue() == false || this.noInfo)) {
            return false;
        }
        URI uRI = gamlCompilationError.getURI();
        boolean bl2 = bl = uRI == null || uRI.equals(this.resourceURI);
        if (bl) {
            return super.add(gamlCompilationError);
        }
        if (gamlCompilationError.isError()) {
            if (this.importedErrors == null) {
                this.importedErrors = new LinkedHashSet<GamlCompilationError>();
            }
            this.importedErrors.add(gamlCompilationError);
            return true;
        }
        return false;
    }

    public boolean hasInternalSyntaxErrors() {
        return this.hasSyntaxErrors;
    }

    public boolean hasErrors() {
        return this.hasSyntaxErrors || this.hasInternalErrors() || this.hasImportedErrors();
    }

    public boolean hasInternalErrors() {
        return Iterables.any((Iterable)this.items(), IS_ERROR);
    }

    public boolean hasImportedErrors() {
        return this.importedErrors != null && !this.importedErrors.isEmpty();
    }

    public Iterable<GamlCompilationError> getInternalErrors() {
        return Iterables.filter((Iterable)this.items(), IS_ERROR);
    }

    public Collection<GamlCompilationError> getImportedErrors() {
        return this.importedErrors == null ? Collections.EMPTY_LIST : this.importedErrors;
    }

    public Iterable<GamlCompilationError> getWarnings() {
        return Iterables.filter((Iterable)this.items(), IS_WARNING);
    }

    public Iterable<GamlCompilationError> getInfos() {
        return Iterables.filter((Iterable)this.items(), IS_INFO);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.importedErrors != null) {
            this.importedErrors.clear();
        }
        this.hasSyntaxErrors = false;
    }

    @Override
    public Iterator<GamlCompilationError> iterator() {
        return Iterables.limit((Iterable)Iterables.concat((Iterable)this.items(), this.getImportedErrors()), (int)1000).iterator();
    }

    public Map<String, URI> getImportedErrorsAsStrings() {
        if (this.importedErrors == null) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, URI> linkedHashMap = new LinkedHashMap<String, URI>();
        this.importedErrors.forEach(gamlCompilationError -> {
            URI uRI = linkedHashMap.put(gamlCompilationError.toString() + " (imported from " + URI.decode((String)gamlCompilationError.getURI().lastSegment()) + ")", gamlCompilationError.getURI());
        });
        return linkedHashMap;
    }

    public void setNoWarning() {
        this.noWarning = true;
    }

    public void setNoInfo() {
        this.noInfo = true;
    }

    public void resetInfoAndWarning() {
        this.noInfo = false;
        this.noWarning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDocument(ModelDescription modelDescription) {
        if (this.shouldDocument) {
            this.docDelegate.doDocument(this.resourceURI, modelDescription, this.expressionsToDocument);
            Map<EObject, IGamlDescription> map = this.expressionsToDocument;
            synchronized (map) {
                this.expressionsToDocument.forEach((? super K eObject, ? super V iGamlDescription) -> this.docDelegate.setGamlDocumentation(this.resourceURI, (EObject)eObject, (IGamlDescription)iGamlDescription));
            }
        }
        this.expressionsToDocument.clear();
    }

    public void setGamlDocumentation(EObject eObject, IGamlDescription iGamlDescription) {
        if (this.shouldDocument && eObject != null && iGamlDescription != null) {
            this.expressionsToDocument.put(eObject, iGamlDescription);
        }
    }

    public boolean hasErrorOn(EObject ... eObjectArray) {
        List<EObject> list = Arrays.asList(eObjectArray);
        return ((StreamEx)StreamEx.of((Collection)this.items()).filter(IS_ERROR)).findAny(gamlCompilationError -> list.contains(gamlCompilationError.getStatement())).isPresent();
    }

    public void setNoExperiment() {
        this.noExperiment = true;
    }

    public boolean getNoExperiment() {
        return this.noExperiment;
    }

    public boolean verifyPlugins(List<String> list) {
        for (String string : list) {
            if (GamaBundleLoader.gamlPluginExists(string)) continue;
            if (!GAMA.isInHeadLessMode() || !GamaBundleLoader.isDisplayPlugin(string)) {
                this.add(new GamlCompilationError("Missing plugin: " + string, "gaml.missing.plugin", this.resourceURI, GamaBundleLoader.isDisplayPlugin(string) ? GamlCompilationError.GamlCompilationErrorType.Error : GamlCompilationError.GamlCompilationErrorType.Warning, new String[0]));
            }
            return false;
        }
        return true;
    }

    public boolean shouldDocument() {
        return this.shouldDocument;
    }

    public void shouldDocument(boolean bl) {
        this.shouldDocument = bl;
    }

    public URI getURI() {
        return this.resourceURI;
    }
}

