/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.multi_criteria;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.multi_criteria.Candidate;
import gama.gaml.multi_criteria.CritereFctCroyancesBasique;
import gama.gaml.multi_criteria.CritereFonctionsCroyances;
import gama.gaml.multi_criteria.Electre;
import gama.gaml.multi_criteria.EvidenceTheory;
import gama.gaml.multi_criteria.FonctionPreference;
import gama.gaml.multi_criteria.PreferenceType5;
import gama.gaml.multi_criteria.PreferenceType6;
import gama.gaml.multi_criteria.Promethee;
import gama.gaml.operators.Cast;
import gama.gaml.types.Types;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MulticriteriaAnalyzeOperator {
    static final String MULTICRITERIA = "multicriteria operators";

    /*
     * WARNING - void declaration
     */
    @GamlAnnotations.operator(value={"weighted_means_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(value="The index of the candidate that maximizes the weighted mean of its criterion values. The first operand is the list of candidates (a candidate is a list of criterion values); the second operand the list of criterion (list of map)", special_cases={"returns -1 is the list of candidates is nil or empty"}, examples={@GamlAnnotations.example(value="weighted_means_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [[\"name\"::\"utility\", \"weight\" :: 2.0],[\"name\"::\"price\", \"weight\" :: 1.0]])", equals="1")}, see={"promethee_DM", "electre_DM", "evidence_theory_DM"})
    public static Integer weightedMeansDecisionMaking(IScope iScope, IList<List> iList, IList<Map<String, Object>> iList2) throws GamaRuntimeException {
        Object object;
        if (iList == null || iList.isEmpty()) {
            return -1;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map map : iList2) {
            String string = (String)map.get("name");
            linkedList.add(string);
            object = Cast.asFloat(iScope, map.get("weight"));
            if (object != null) {
                hashMap.put(string, object);
                continue;
            }
            hashMap.put(string, 1.0);
        }
        boolean n = false;
        double d = -1.7976931348623157E308;
        object = GamaListFactory.create(Types.INT);
        for (List list : iList) {
            void var5_9;
            int n2 = 0;
            double d2 = 0.0;
            for (String string : linkedList) {
                d2 += (Double)hashMap.get(string) * Cast.asFloat(iScope, list.get(n2));
                ++n2;
            }
            if (d == d2) {
                object.add((int)var5_9);
            } else if (d < d2) {
                object.clear();
                object.add((int)var5_9);
                d = d2;
            }
            ++var5_9;
        }
        return (Integer)object.anyValue(iScope);
    }

    public static void buildCombination(List<String> list, Set<String> set, List<Set<String>> list2, int n, int n2, int n3) {
        if (n3 == list.size()) {
            list2.add(new LinkedHashSet<String>(list));
            return;
        }
        int n4 = n;
        while (n4 <= n2) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(set);
            linkedHashSet.add(list.get(n4));
            list2.add(linkedHashSet);
            MulticriteriaAnalyzeOperator.buildCombination(list, linkedHashSet, list2, n4 + 1, n2, n3 + 1);
            ++n4;
        }
    }

    @GamlAnnotations.operator(value={"fuzzy_choquet_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(value="The index of the candidate that maximizes the Fuzzy Choquet Integral value. The first operand is the list of candidates (a candidate is a list of criterion values); the second operand the list of criterion (list of string); the third operand the weights of each sub-set of criteria (map with list for key and float for value)", special_cases={"returns -1 is the list of candidates is nil or empty"}, examples={@GamlAnnotations.example(value="fuzzy_choquet_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [\"utility\", \"price\", \"size\"],[[\"utility\"]::0.5,[\"size\"]::0.1,[\"price\"]::0.4,[\"utility\", \"price\"]::0.55])", equals="0")}, see={"promethee_DM", "electre_DM", "evidence_theory_DM"})
    public static Integer fuzzyChoquetDecisionMaking(IScope iScope, IList<List> iList, IList<String> iList2, IMap iMap) throws GamaRuntimeException {
        Double d;
        if (iList == null || iList.isEmpty()) {
            return -1;
        }
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<Object, Double> hashMap2 = new HashMap<Object, Double>();
        for (Object object22 : iMap.keySet()) {
            LinkedHashSet linkedHashSet = new LinkedHashSet((List)object22);
            d = Cast.asFloat(iScope, iMap.get(object22));
            if (linkedHashSet.size() == 1) {
                hashMap.put((String)new ArrayList(linkedHashSet).get(0), d);
            }
            hashMap2.put(linkedHashSet, d);
        }
        for (String string : iList2) {
            if (hashMap.containsKey(string)) continue;
            hashMap.put(string, 1.0);
        }
        ArrayList<Set<String>> arrayList = new ArrayList<Set<String>>();
        MulticriteriaAnalyzeOperator.buildCombination(iList2, new LinkedHashSet<String>(), arrayList, 0, iList2.size() - 1, 0);
        for (Object set : arrayList) {
            if (hashMap2.containsKey(set)) continue;
            d = 0.0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                d = d + Cast.asFloat(iScope, hashMap.get(string));
            }
            hashMap2.put(set, d);
        }
        int n = 0;
        double d2 = -1.7976931348623157E308;
        int n2 = -1;
        boolean bl = true;
        for (List list : iList) {
            double d3;
            ArrayList arrayList2 = new ArrayList(list);
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            Collections.sort(arrayList2);
            for (Object e : list) {
                int n3 = arrayList2.indexOf(e);
                while (arrayList3.contains(n3)) {
                    ++n3;
                }
                arrayList3.add(n3);
            }
            double d4 = d3 = Cast.asFloat(iScope, arrayList2.get(0)).doubleValue();
            int n4 = 1;
            while (n4 < arrayList2.size()) {
                double d5 = Cast.asFloat(iScope, arrayList2.get(n4));
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                int n5 = n4;
                while (n5 < arrayList3.size()) {
                    linkedHashSet.add((String)iList2.get(arrayList3.indexOf(n5)));
                    ++n5;
                }
                d4 += (d5 - d3) * (Double)hashMap2.get(linkedHashSet);
                d3 = d5;
                ++n4;
            }
            if (bl || d2 < d4) {
                d2 = d4;
                n2 = n;
                bl = false;
            }
            ++n;
        }
        return n2;
    }

    @GamlAnnotations.operator(value={"promethee_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(value="The index of the best candidate according to the Promethee II method. This method is based on a comparison per pair of possible candidates along each criterion: all candidates are compared to each other by pair and ranked. More information about this method can be found in [Behzadian, M., Kazemzadeh, R., Albadvi, A., M., A.: PROMETHEE: A comprehensive literature review on methodologies and applications. European Journal of Operational Research(2010)](https://www.sciencedirect.com/science/article/abs/pii/S0377221709000071). The first operand is the list of candidates (a candidate is a list of criterion values); the second operand the list of criterion: A criterion is a map that contains fours elements: a name, a weight, a preference value (p) and an indifference value (q). The preference value represents the threshold from which the difference between two criterion values allows to prefer one vector of values over another. The indifference value represents the threshold from which the difference between two criterion values is considered significant.", special_cases={"returns -1 if the list of candidates is nil or empty"}, examples={@GamlAnnotations.example(value="promethee_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [[\"name\"::\"utility\", \"weight\" :: 2.0,\"p\"::0.5, \"q\"::0.0, \"s\"::1.0, \"maximize\" :: true],[\"name\"::\"price\", \"weight\" :: 1.0,\"p\"::0.5, \"q\"::0.0, \"s\"::1.0, \"maximize\" :: false]])", equals="1")}, see={"weighted_means_DM", "electre_DM", "evidence_theory_DM"})
    public static Integer prometheeDecisionMaking(IScope iScope, IList<List> iList, IList<Map<String, Object>> iList2) throws GamaRuntimeException {
        Serializable serializable;
        Object object;
        if (iList == null || iList.isEmpty()) {
            return -1;
        }
        int n = 0;
        LinkedList<Candidate> linkedList2 = new LinkedList<Candidate>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        HashMap<String, FonctionPreference> hashMap = new HashMap<String, FonctionPreference>();
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        for (Map map : iList2) {
            object = (String)map.get("name");
            linkedList3.add((String)object);
            serializable = Cast.asFloat(iScope, map.get("weight"));
            if (serializable != null) {
                hashtable.put((String)object, (Double)serializable);
            } else {
                hashtable.put((String)object, 1.0);
            }
            String string = "type_5";
            Object v = map.get("type");
            if (v != null) {
                string = v.toString();
            }
            Iterator<Object> iterator = map.get("q");
            Object v2 = map.get("p");
            Object v3 = map.get("s");
            Double d = 1.0;
            Double d2 = 0.0;
            Double d3 = 1.0;
            if (iterator != null) {
                d2 = Cast.asFloat(iScope, iterator);
            }
            if (v2 != null) {
                d = Cast.asFloat(iScope, v2);
            }
            if (v3 != null) {
                d3 = Cast.asFloat(iScope, v3);
            }
            if ("type_5".equals(string)) {
                hashMap.put((String)object, new PreferenceType5(d2, d));
                continue;
            }
            if (!"type_6".equals(string)) continue;
            hashMap.put((String)object, new PreferenceType6(d3));
        }
        Promethee promethee = new Promethee(linkedList3);
        promethee.setFctPrefCrit(hashMap);
        promethee.setPoidsCrit(hashtable);
        for (List list : iList) {
            serializable = new HashMap();
            int n2 = 0;
            for (String string : linkedList3) {
                serializable.put(string, Cast.asFloat(iScope, list.get(n2)));
                ++n2;
            }
            Candidate candidate = new Candidate(n, (Map<String, Double>)((Object)serializable));
            linkedList2.add(candidate);
            ++n;
        }
        LinkedList<Candidate> linkedList = MulticriteriaAnalyzeOperator.filtering(linkedList2, new HashMap<String, Boolean>());
        if (linkedList.isEmpty()) {
            return iScope.getRandom().between(0, linkedList2.size() - 1);
        }
        if (linkedList.size() == 1) {
            return GamaListFactory.create(iScope, Types.NO_TYPE, linkedList).firstValue(iScope).getIndex();
        }
        object = promethee.decision(linkedList);
        return ((Candidate)object).getIndex();
    }

    @GamlAnnotations.operator(value={"electre_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(value="The index of the best candidate according to a method based on the ELECTRE methods. The principle of the ELECTRE methods is to compare the possible candidates by pair. These methods analyses the possible outranking relation existing between two candidates. A candidate outranks another if this one is at least as good as the other one. The ELECTRE methods are based on two concepts: the concordance and the discordance. The concordance characterizes the fact that, for an outranking relation to be validated, a sufficient majority of criteria should be in favor of this assertion. The discordance characterizes the fact that, for an outranking relation to be validated, none of the criteria in the minority should oppose too strongly this assertion. These two conditions must be true for validating the outranking assertion. More information about the ELECTRE methods can be found in [Figueira,  J., Mousseau, V., Roy, B.: ELECTRE Methods. In: Figueira, J., Greco, S., and Ehrgott, M., (Eds.), Multiple Criteria Decision Analysis: State of the Art Surveys, Springer, New York, 133--162 (2005)](https://link.springer.com/book/10.1007/b100605). The first operand is the list of candidates (a candidate is a list of criterion values); the second operand the list of criterion: A criterion is a map that contains fives elements: a name, a weight, a preference value (p), an indifference value (q) and a veto value (v). The preference value represents the threshold from which the difference between two criterion values allows to prefer one vector of values over another. The indifference value represents the threshold from which the difference between two criterion values is considered significant. The veto value represents the threshold from which the difference between two criterion values disqualifies the candidate that obtained the smaller value; the last operand is the fuzzy cut.", special_cases={"returns -1 is the list of candidates is nil or empty"}, examples={@GamlAnnotations.example(value="electre_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [[\"name\"::\"utility\", \"weight\" :: 2.0,\"p\"::0.5, \"q\"::0.0, \"s\"::1.0, \"maximize\" :: true],[\"name\"::\"price\", \"weight\" :: 1.0,\"p\"::0.5, \"q\"::0.0, \"s\"::1.0, \"maximize\" :: false]],0.7)", equals="0")}, see={"weighted_means_DM", "promethee_DM", "evidence_theory_DM"})
    public static Integer electreDecisionMaking(IScope iScope, IList<List> iList, IList<Map<String, Object>> iList2, Double d) throws GamaRuntimeException {
        Serializable serializable;
        Object object;
        Double d2 = d;
        if (d2 == null) {
            d2 = 0.7;
        }
        if (iList == null || iList.isEmpty()) {
            return -1;
        }
        int n = 0;
        ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
        IList<String> iList3 = GamaListFactory.create(Types.STRING);
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap3 = new HashMap<String, Double>();
        HashMap<String, Double> hashMap4 = new HashMap<String, Double>();
        for (Map map : iList2) {
            object = (String)map.get("name");
            iList3.add((String)object);
            serializable = Cast.asFloat(iScope, map.get("weight"));
            if (serializable != null) {
                hashMap.put((String)object, (Double)serializable);
            } else {
                hashMap.put((String)object, 1.0);
            }
            Object v = map.get("p");
            Object v2 = map.get("q");
            Object v3 = map.get("v");
            Double d3 = 0.5;
            Double d4 = 0.0;
            Double d5 = 1.0;
            if (v2 != null) {
                d4 = Cast.asFloat(iScope, v2);
            }
            hashMap3.put((String)object, d4);
            if (v != null) {
                d3 = Cast.asFloat(iScope, v);
            }
            hashMap2.put((String)object, d3);
            if (v3 != null) {
                d5 = Cast.asFloat(iScope, v3);
            }
            hashMap4.put((String)object, d5);
        }
        Electre electre = new Electre(iList3);
        electre.setPoids(hashMap);
        electre.setIndifference(hashMap3);
        electre.setPreference(hashMap2);
        electre.setVeto(hashMap4);
        electre.setSeuilCoupe(d2);
        for (List list : iList) {
            serializable = new HashMap();
            int n2 = 0;
            for (String string : iList3) {
                serializable.put(string, Cast.asFloat(iScope, list.get(n2)));
                ++n2;
            }
            Candidate candidate = new Candidate(n, (Map<String, Double>)((Object)serializable));
            arrayList.add(candidate);
            ++n;
        }
        LinkedList<Candidate> linkedList = MulticriteriaAnalyzeOperator.filtering(arrayList, new HashMap<String, Boolean>());
        if (linkedList.isEmpty()) {
            return iScope.getRandom().between(0, arrayList.size() - 1);
        }
        object = electre.decision(linkedList);
        return ((Candidate)object).getIndex();
    }

    @GamlAnnotations.operator(value={"evidence_theory_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="evidence_theory_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [[\"name\"::\"utility\", \"s1\" :: 0.0,\"s2\"::1.0, \"v1p\"::0.0, \"v2p\"::1.0, \"v1c\"::0.0, \"v2c\"::0.0, \"maximize\" :: true],[\"name\"::\"price\",  \"s1\" :: 0.0,\"s2\"::1.0, \"v1p\"::0.0, \"v2p\"::1.0, \"v1c\"::0.0, \"v2c\"::0.0, \"maximize\" :: true]])", equals="0")}, usages={@GamlAnnotations.usage(value="if the operator is used with only 2 operands (the candidates and the criteria), the last parameter (use simple method) is set to true")})
    public static Integer evidenceTheoryDecisionMaking(IScope iScope, IList<List> iList, IList<Map<String, Object>> iList2) throws GamaRuntimeException {
        return MulticriteriaAnalyzeOperator.evidenceTheoryDecisionMaking(iScope, iList, iList2, true);
    }

    @GamlAnnotations.operator(value={"evidence_theory_DM"}, category={"multicriteria operators"}, concept={"multi_criteria"})
    @GamlAnnotations.doc(value="The index of the best candidate according to a method based on the Evidence theory. This theory, which was proposed by Shafer ([Shafer G (1976) A mathematical theory of evidence, Princeton University Press](http://www.glennshafer.com/books/amte.html)), is based on the work of Dempster ([Dempster A (1967) Upper and lower probabilities induced by multivalued mapping. Annals of Mathematical Statistics, vol.  38, pp. 325--339](https://projecteuclid.org/journals/annals-of-mathematical-statistics/volume-38/issue-2/Upper-and-Lower-Probabilities-Induced-by-a-Multivalued-Mapping/10.1214/aoms/1177698950.full)) on lower and upper probability distributions. The first operand is the list of candidates (a candidate is a list of criterion values); the second operand the list of criterion: A criterion is a map that contains seven elements: a name, a first threshold s1, a second threshold s2, a value for the assertion \"this candidate is the best\" at threshold s1 (v1p), a value for the assertion \"this candidate is the best\" at threshold s2 (v2p), a value for the assertion \"this candidate is not the best\" at threshold s1 (v1c), a value for the assertion \"this candidate is not the best\" at threshold s2 (v2c). v1p, v2p, v1c and v2c have to been defined in order that: v1p + v1c <= 1.0; v2p + v2c <= 1.0.; the last operand allows to use a simple version of this multi-criteria decision making method (simple if true)", masterDoc=true, special_cases={"returns -1 is the list of candidates is nil or empty"}, examples={@GamlAnnotations.example(value="evidence_theory_DM([[1.0, 7.0],[4.0,2.0],[3.0, 3.0]], [[\"name\"::\"utility\", \"s1\" :: 0.0,\"s2\"::1.0, \"v1p\"::0.0, \"v2p\"::1.0, \"v1c\"::0.0, \"v2c\"::0.0, \"maximize\" :: true],[\"name\"::\"price\",  \"s1\" :: 0.0,\"s2\"::1.0, \"v1p\"::0.0, \"v2p\"::1.0, \"v1c\"::0.0, \"v2c\"::0.0, \"maximize\" :: true]], false)", equals="0")}, see={"weighted_means_DM", "electre_DM", "electre_DM"})
    public static Integer evidenceTheoryDecisionMaking(IScope iScope, IList<List> iList, IList<Map<String, Object>> iList2, Boolean bl) throws GamaRuntimeException {
        Double d;
        Object object5;
        Object object2;
        Object object3;
        if (iList == null || iList.isEmpty()) {
            return -1;
        }
        int n = 0;
        boolean bl2 = bl == null ? false : bl;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        LinkedList<Candidate> linkedList2 = new LinkedList<Candidate>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        LinkedList<CritereFonctionsCroyances> linkedList4 = new LinkedList<CritereFonctionsCroyances>();
        for (Map map : iList2) {
            Object v;
            Object v2;
            Object v3;
            Object v4;
            Object v5;
            Object v6;
            object3 = (String)map.get("name");
            linkedList3.add(object3);
            object2 = map.get("s1");
            Double d2 = 0.0;
            object5 = 1.0;
            Object object4 = 0.0;
            d = 1.0;
            Double d3 = 0.0;
            Double d4 = 0.0;
            if (object2 != null) {
                d2 = Cast.asFloat(iScope, object2);
            }
            if ((v6 = map.get("s2")) != null) {
                object5 = Cast.asFloat(iScope, v6);
            }
            if ((v5 = map.get("v1p")) != null) {
                object4 = Cast.asFloat(iScope, v5);
            }
            if ((v4 = map.get("v2p")) != null) {
                d = Cast.asFloat(iScope, v4);
            }
            if ((v3 = map.get("v1c")) != null) {
                d3 = Cast.asFloat(iScope, v3);
            }
            if ((v2 = map.get("v2c")) != null) {
                d4 = Cast.asFloat(iScope, v2);
            }
            if ((v = map.get("maximize")) instanceof Boolean) {
                hashMap.put((String)object3, (Boolean)v);
            }
            CritereFctCroyancesBasique critereFctCroyancesBasique = new CritereFctCroyancesBasique((String)object3, d2, d, (Double)object4, d3, d4, (Double)object5);
            linkedList4.add(critereFctCroyancesBasique);
        }
        EvidenceTheory evidenceTheory = new EvidenceTheory();
        for (List list : iList) {
            object2 = new HashMap();
            int n2 = 0;
            for (Object object5 : linkedList3) {
                d = Cast.asFloat(iScope, list.get(n2));
                object2.put((Object)object5, (Double)d);
                ++n2;
            }
            object5 = new Candidate(n, (Map<String, Double>)object2);
            linkedList2.add((Candidate)object5);
            ++n;
        }
        LinkedList<Candidate> linkedList = MulticriteriaAnalyzeOperator.filtering(linkedList2, hashMap);
        if (linkedList.isEmpty()) {
            return iScope.getRandom().between(0, linkedList2.size() - 1);
        }
        object3 = evidenceTheory.decision(linkedList4, linkedList, bl2);
        return ((Candidate)object3).getIndex();
    }

    private static LinkedList<Candidate> filtering(Collection<Candidate> collection, Map<String, Boolean> map) {
        LinkedList<Candidate> linkedList = new LinkedList<Candidate>();
        LinkedList<Map<String, Double>> linkedList2 = new LinkedList<Map<String, Double>>();
        for (Candidate candidate : collection) {
            boolean bl = true;
            for (Candidate candidate2 : collection) {
                if (candidate == candidate2 || !MulticriteriaAnalyzeOperator.paretoInf(candidate, candidate2, map)) continue;
                bl = false;
                break;
            }
            if (!bl || linkedList2.contains(candidate.getValCriteria())) continue;
            linkedList.add(candidate);
            linkedList2.add(candidate.getValCriteria());
        }
        return linkedList;
    }

    private static boolean paretoInf(Candidate candidate, Candidate candidate2, Map<String, Boolean> map) {
        int n = 0;
        for (String string : candidate.getValCriteria().keySet()) {
            boolean bl = !map.containsKey(string) ? true : map.get(string);
            double d = candidate.getValCriteria().get(string);
            double d2 = candidate2.getValCriteria().get(string);
            if (bl ? d > d2 : d < d2) {
                return false;
            }
            if (d != d2) continue;
            ++n;
        }
        return n < candidate.getValCriteria().size();
    }
}

