/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.population.MetaPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.IMatrix;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IOperatorValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.BinaryOperator;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Colors;
import gama.gaml.operators.Points;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.eclipse.emf.ecore.EObject;

public class Containers {
    private static Function<Object, IList<?>> toLists = object -> object instanceof IList ? (IList<Object>)object : GamaListFactory.wrap(Types.NO_TYPE, object);

    public static <T> Function<Object, T> with(IScope iScope, IExpression iExpression) {
        return object -> {
            iScope.setEach(object);
            return iExpression.value(iScope);
        };
    }

    public static <T> Predicate<T> by(IScope iScope, IExpression iExpression) {
        return object -> {
            iScope.setEach(object);
            return (Boolean)iExpression.value(iScope);
        };
    }

    public static <T> Predicate<T> inContainer(IScope iScope, IContainer iContainer) {
        IContainer iContainer2 = GAML.notNull(iScope, iContainer);
        return object -> iContainer2.contains(iScope, object);
    }

    public static StreamEx stream(IScope iScope, IContainer iContainer) {
        return GAML.notNull(iScope, iContainer).stream(iScope);
    }

    public static GamaListFactory.GamaListSupplier listOf(IType iType) {
        return new GamaListFactory.GamaListSupplier(iType);
    }

    public static Supplier<IList> listLike(IContainer iContainer) {
        return new GamaListFactory.GamaListSupplier(iContainer == null ? Types.NO_TYPE : iContainer.getGamlType().getContentType());
    }

    public static Supplier<IList> listLike(IContainer iContainer, IContainer iContainer2) {
        return Containers.listOf(iContainer.getGamlType().getContentType().findCommonSupertypeWith(iContainer2.getGamlType().getContentType()));
    }

    public static GamaMapFactory.GamaMapSupplier asMapOf(IType iType, IType iType2) {
        return new GamaMapFactory.GamaMapSupplier(iType, iType2);
    }

    @GamlAnnotations.operator(internal=true, value={"internal_list"}, content_type=1, category={"Containers-related operators"}, concept={"container", "matrix"})
    @GamlAnnotations.doc(value="For internal use only.Corresponds to the 2 elements list created when accessed matrices with int cols and rows", masterDoc=true)
    public static IList internal_list(IScope iScope, Integer n, Integer n2) {
        return GamaListFactory.create(iScope, (IType)Types.INT, n, n2);
    }

    @GamlAnnotations.operator(internal=true, value={"internal_at"}, content_type=0, category={"Containers-related operators"}, concept={"container", "geometry"})
    @GamlAnnotations.doc(value="For internal use only. Corresponds to the implementation, for geometries, of the access to containers with [index]", masterDoc=true)
    public static Object internal_at(IScope iScope, IShape iShape, IList iList) throws GamaRuntimeException {
        if (iShape == null) {
            return null;
        }
        String string = Cast.asString(iScope, iList.get(0));
        return iShape.getAttribute(string);
    }

    @GamlAnnotations.operator(internal=true, value={"internal_at"}, content_type=0, category={"Containers-related operators"}, concept={"species"})
    @GamlAnnotations.doc(value="For internal use only. Corresponds to the implementation of the access to agents with [index]")
    public static Object internal_at(IScope iScope, IAgent iAgent, IList iList) throws GamaRuntimeException {
        if (iAgent == null) {
            return null;
        }
        return iAgent.getFromIndicesList(iScope, iList);
    }

    @GamlAnnotations.operator(internal=true, value={"internal_at"}, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="For internal use only. Corresponds to the implementation of the access to containers with [index]", see={"at"})
    @validator(value=InternalAtValidator.class)
    public static Object internal_at(IScope iScope, IContainer iContainer, IList iList) throws GamaRuntimeException {
        if (iContainer instanceof IContainer.Addressable) {
            return ((IContainer.Addressable)((Object)iContainer)).getFromIndicesList(iScope, iList);
        }
        throw GamaRuntimeException.error(String.valueOf(iContainer) + " cannot be accessed using " + String.valueOf(iList), iScope);
    }

    @GamlAnnotations.operator(value={"at", "@"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the element at the right operand index of the container", masterDoc=true, comment="The first element of the container is located at the index 0. In addition, if the user tries to get the element at an index higher or equals than the length of the container, he will get an IndexOutOfBoundException.The at operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list or a matrix, at returns the element at the index specified by the right operand", examples={@GamlAnnotations.example(value="[1, 2, 3] at 2", returnType="int", equals="3"), @GamlAnnotations.example(value="[{1,2}, {3,4}, {5,6}] at 0", returnType="point", equals="{1.0,2.0}")}), @GamlAnnotations.usage(value="if it is a file, at returns the element of the file content at the index specified by the right operand"), @GamlAnnotations.usage(value="if it is a population, at returns the agent at the index specified by the right operand"), @GamlAnnotations.usage(value="if it is a graph and if the right operand is a node, at returns the in and out edges corresponding to that node"), @GamlAnnotations.usage(value="if it is a graph and if the right operand is an edge, at returns the pair node_out::node_in of the edge"), @GamlAnnotations.usage(value="if it is a graph and if the right operand is a pair node1::node2, at returns the edge from node1 to node2 in the graph")}, see={"contains_all", "contains_any"})
    @validator(value=AtValidator.class)
    public static Object at(IScope iScope, IContainer iContainer, Object object) {
        if (iContainer instanceof IContainer.Addressable) {
            return ((IContainer.Addressable)((Object)iContainer)).get(iScope, object);
        }
        throw GamaRuntimeException.error(String.valueOf(iContainer) + " cannot be accessed using " + String.valueOf(object), iScope);
    }

    @GamlAnnotations.operator(value={"at", "@"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the element at the right operand index of the container")
    public static Object at(IScope iScope, IList iList, Integer n) {
        return iList.get(iScope, n);
    }

    @GamlAnnotations.operator(value={"at", "@"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the element at the right (point) operand index of the matrix")
    public static Object at(IScope iScope, IMatrix iMatrix, GamaPoint gamaPoint) {
        return iMatrix.get(iScope, gamaPoint);
    }

    @GamlAnnotations.operator(value={"at", "@"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the agent at the right operand index of the given species")
    public static IAgent at(IScope iScope, ISpecies iSpecies, Integer n) {
        return (IAgent)iSpecies.get(iScope, n);
    }

    @GamlAnnotations.operator(value={"grid_at"}, type=-299, category={"Points-related operators", "Grid-related operators"}, concept={"grid", "point"})
    @GamlAnnotations.doc(value="returns the cell of the grid (right-hand operand) at the position given by the right-hand operand", comment="If the left-hand operand is a point of floats, it is used as a point of ints.", usages={@GamlAnnotations.usage(value="if the left-hand operand is not a grid cell species, returns nil")}, examples={@GamlAnnotations.example(value="grid_cell grid_at {1,2}", equals="the agent grid_cell with grid_x=1 and grid_y = 2", isExecutable=false)})
    public static IAgent grid_at(IScope iScope, ISpecies iSpecies, GamaPoint gamaPoint) throws GamaRuntimeException {
        IShape iShape;
        ITopology iTopology = iScope.getAgent().getPopulationFor(iSpecies).getTopology();
        IContainer<?, IShape> iContainer = iTopology.getPlaces();
        if (iContainer instanceof IGrid && (iShape = (IShape)((IGrid)iContainer).get(iScope, gamaPoint)) != null) {
            return iShape.getAgent();
        }
        return null;
    }

    @GamlAnnotations.operator(value={"remove_duplicates", "distinct"}, can_be_const=true, content_type=-299, index_type=-399, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="produces a set from the elements of the operand (i.e. a list without duplicated elements)", usages={@GamlAnnotations.usage(value="if the operand is empty, remove_duplicates returns an empty list", examples={@GamlAnnotations.example(value="remove_duplicates([])", equals="[]")}), @GamlAnnotations.usage(value="if the operand is a graph, remove_duplicates returns the set of nodes"), @GamlAnnotations.usage(value="if the operand is a map, remove_duplicates returns the set of values without duplicate", examples={@GamlAnnotations.example(value="remove_duplicates([1::3,2::4,3::3,5::7])", equals="[3,4,7]")}), @GamlAnnotations.usage(value="if the operand is a matrix, remove_duplicates returns a list containing all the elments with duplicated.", examples={@GamlAnnotations.example(value="remove_duplicates([[\"c11\",\"c12\",\"c13\",\"c13\"],[\"c21\",\"c22\",\"c23\",\"c23\"]])", equals="[[\"c11\",\"c12\",\"c13\",\"c21\",\"c22\",\"c23\"]]", test=false)})}, examples={@GamlAnnotations.example(value="remove_duplicates([3,2,5,1,2,3,5,5,5])", equals="[3,2,5,1]")})
    @GamlAnnotations.test(value="remove_duplicates([3,2,5,1,2,3,5,5,5]) = [3,2,5,1]")
    public static IList remove_duplicates(IScope iScope, IContainer iContainer) {
        return (IList)Containers.stream(iScope, iContainer).distinct().toCollection(Containers.listLike(iContainer));
    }

    @GamlAnnotations.operator(value={"contains_all"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="true if the left operand contains all the elements of the right operand, false otherwise", comment="the definition of contains depends on the container", usages={@GamlAnnotations.usage(value="if the right operand is nil or empty, contains_all returns true")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] contains_all [2,4]", equals="true "), @GamlAnnotations.example(value="[1,2,3,4,5,6] contains_all [2,8]", equals="false"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] contains_all [1,3]", equals="false "), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] contains_all [2,4]", equals="true")}, see={"contains", "contains_any"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="[1,2,3,4,5,6] contains_all [2,8] = false"), @GamlAnnotations.test(value="[1::2, 3::4, 5::6] contains_all [1,3] = false"), @GamlAnnotations.test(value="[1::2, 3::4, 5::6] contains_all [2,4] = true")})
    public static Boolean contains_all(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return Containers.stream(iScope, iContainer2).allMatch(Containers.inContainer(iScope, iContainer));
    }

    @GamlAnnotations.operator(value={"contains_any"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="true if the left operand contains one of the elements of the right operand, false otherwise", comment="the definition of contains depends on the container", special_cases={"if the right operand is nil or empty, contains_any returns false"}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] contains_any [2,4]", equals="true "), @GamlAnnotations.example(value="[1,2,3,4,5,6] contains_any [2,8]", equals="true"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] contains_any [1,3]", equals="false"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] contains_any [2,4]", equals="true")}, see={"contains", "contains_all"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="[1,2,3,4,5,6] contains_any [2,4] = true"), @GamlAnnotations.test(value="[1,2,3,4,5,6] contains_any [2,8] = true"), @GamlAnnotations.test(value="[1::2, 3::4, 5::6] contains_any [2,4] = true")})
    public static Boolean contains_any(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return Containers.stream(iScope, iContainer2).anyMatch(Containers.inContainer(iScope, iContainer));
    }

    @GamlAnnotations.operator(value={"first", "first_of"}, can_be_const=true, content_type=-298, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns the nth first elements of the container. If n is greater than the list size, a translation of the container to a list is returned. If it is equal or less than zero, returns an empty list")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="first(3, [1,2,3,4,5,6]) = [1,2,3]"), @GamlAnnotations.test(value="first(0,[1,2,3,4,5,6]) = []"), @GamlAnnotations.test(value="first_of(3, [1,2,3,4,5,6]) = [1,2,3]"), @GamlAnnotations.test(value="first_of(0,[1,2,3,4,5,6]) = []")})
    public static IList first(IScope iScope, Integer n, IContainer iContainer) {
        return (IList)Containers.stream(iScope, iContainer).limit((long)(n < 0 ? 0 : n)).toCollection(Containers.listLike(iContainer));
    }

    @GamlAnnotations.operator(value={"last", "last_of"}, can_be_const=true, content_type=-298, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns the nth last elements of the container. If n is greater than the list size,  returns the container cast as a list. If it is equal or less than zero, returns an empty list")
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="last(3, [1,2,3,4,5,6]) = [4,5,6]"), @GamlAnnotations.test(value="last(0,[1,2,3,4,5,6]) = []"), @GamlAnnotations.test(value="last(10,[1::2, 3::4]) is list")})
    public static IList last(IScope iScope, Integer n, IContainer iContainer) {
        IList iList = GamaListFactory.create(iScope, iContainer.getGamlType().getContentType(), Iterables.limit((Iterable)Lists.reverse(GAML.notNull(iScope, iContainer).listValue(iScope, Types.NO_TYPE, false)), (int)(n < 0 ? 0 : n)));
        Collections.reverse(iList);
        return iList;
    }

    @GamlAnnotations.operator(value={"in"}, can_be_const=true, category={"Containers-related operators"})
    @GamlAnnotations.doc(value="true if the right operand contains the left operand, false otherwise", comment="the definition of in depends on the container", usages={@GamlAnnotations.usage(value="if the right operand is nil or empty, in returns false")}, examples={@GamlAnnotations.example(value="2 in [1,2,3,4,5,6]", equals="true"), @GamlAnnotations.example(value="7 in [1,2,3,4,5,6]", equals="false"), @GamlAnnotations.example(value="3 in [1::2, 3::4, 5::6]", equals="false"), @GamlAnnotations.example(value="6 in [1::2, 3::4, 5::6]", equals="true")}, see={"contains"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="2 in [1,2,3,4,5,6] = true"), @GamlAnnotations.test(value="3 in [1::2, 3::4, 5::6] = false")})
    public static Boolean in(IScope iScope, Object object, IContainer iContainer) throws GamaRuntimeException {
        return GAML.notNull(iScope, iContainer).contains(iScope, object);
    }

    @GamlAnnotations.operator(value={"index_of"}, can_be_const=true, category={"Species-related operators"}, concept={"container", "species"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left operator is a species, returns the index of an agent in a species. If the argument is not an agent of this species, returns -1. Use int(agent) instead")}, masterDoc=true)
    public static Integer index_of(IScope iScope, ISpecies iSpecies, Object object) {
        if (!(object instanceof IAgent) || !((IAgent)object).isInstanceOf(GAML.notNull(iScope, iSpecies), true)) {
            return -1;
        }
        return ((IAgent)object).getIndex();
    }

    @GamlAnnotations.operator(value={"index_of"}, can_be_const=true, category={"List-related operators"}, concept={"list"})
    @GamlAnnotations.doc(value="the index of the first occurence of the right operand in the left operand container", masterDoc=true, comment="The definition of index_of and the type of the index depend on the container", usages={@GamlAnnotations.usage(value="if the left operand is a list, index_of returns the index as an integer", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] index_of 4", equals="3"), @GamlAnnotations.example(value="[4,2,3,4,5,4] index_of 4", equals="0")})}, see={"at", "last_index_of"})
    @GamlAnnotations.test(value="[1,2,3,1,2,1,4,5] index_of 4 = 6")
    public static Integer index_of(IScope iScope, IList iList, Object object) {
        return GAML.notNull(iScope, iList).indexOf(object);
    }

    @GamlAnnotations.operator(value={"index_of"}, can_be_const=true, category={"Map-related operators"}, concept={"map"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left operand is a map, index_of returns the index of a value or nil if the value is not mapped")}, examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] index_of 4", equals="3")})
    @GamlAnnotations.test(value="[1::2, 3::4, 5::6] index_of 4 = 3")
    public static Object index_of(IScope iScope, IMap<?, ?> iMap, Object object) {
        for (Map.Entry entry : GAML.notNull(iScope, iMap).entrySet()) {
            if (!entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        return null;
    }

    @GamlAnnotations.operator(value={"index_of"}, can_be_const=true, category={"Matrix-related operators"}, concept={"container", "matrix"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left operand is a matrix, index_of returns the index as a point", examples={@GamlAnnotations.example(value="matrix([[1,2,3],[4,5,6]]) index_of 4", equals="{1.0,0.0}")})})
    @GamlAnnotations.test(value="matrix([[1,2,3],[4,5,6]]) index_of 4 = {1.0,0.0}")
    public static GamaPoint index_of(IScope iScope, IMatrix iMatrix, Object object) {
        int n = 0;
        while (n < GAML.notNull(iScope, iMatrix).getCols(iScope)) {
            int n2 = 0;
            while (n2 < iMatrix.getRows(iScope)) {
                if (iMatrix.get(iScope, n, n2).equals(object)) {
                    return new GamaPoint(n, n2);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    @GamlAnnotations.operator(value={"all_indexes_of"}, can_be_const=true, content_type=-399, category={"List-related operators"}, concept={"list"})
    @GamlAnnotations.doc(value="all the index of all the occurences of the right operand in the left operand container", masterDoc=true, comment="The definition of all_indexes_of and the type of the index depend on the container", usages={@GamlAnnotations.usage(value="if the left operand is a list, all_indexes_of returns a list of all the indexes as integers", examples={@GamlAnnotations.example(value="[1,2,3,1,2,3] all_indexes_of 1", equals="[0,3]"), @GamlAnnotations.example(value="[1,2,3,1,2,3] all_indexes_of 4", equals="[]")})}, see={"index_of", "last_index_of"})
    public static IList all_indexes_of2(IScope iScope, IList iList, Object object) {
        IList iList2 = GamaListFactory.create(Types.INT);
        int n = 0;
        while (n < GAML.notNull(iScope, iList).size()) {
            if (object.equals(iList.get(iScope, n))) {
                iList2.add(n);
            }
            ++n;
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"last_index_of"}, can_be_const=true, category={"Species-related operators"}, concept={"container", "species"})
    @GamlAnnotations.doc(value="the index of the last occurence of the right operand in the left operand container", usages={@GamlAnnotations.usage(value="if the left operand is a species, the last index of an agent is the same as its index")}, see={"at", "index_of"})
    @GamlAnnotations.test(value="last_index_of([1,2,2,2,5], 2) = 3")
    public static Integer last_index_of(IScope iScope, ISpecies iSpecies, Object object) {
        return Containers.index_of(iScope, GAML.notNull(iScope, iSpecies), object);
    }

    @GamlAnnotations.operator(value={"last_index_of"}, can_be_const=true, category={"List-related operators"}, concept={"list"})
    @GamlAnnotations.doc(value="the index of the last occurence of the right operand in the left operand container", masterDoc=true, comment="The definition of last_index_of and the type of the index depend on the container", usages={@GamlAnnotations.usage(value="if the left operand is a list, last_index_of returns the index as an integer", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] last_index_of 4", equals="3"), @GamlAnnotations.example(value="[4,2,3,4,5,4] last_index_of 4", equals="5")})}, see={"at", "last_index_of"})
    @GamlAnnotations.test(value="[4,2,3,4,5,4] last_index_of 4 = 5")
    public static Integer last_index_of(IScope iScope, IList iList, Object object) {
        return GAML.notNull(iScope, iList).lastIndexOf(object);
    }

    @GamlAnnotations.operator(value={"last_index_of"}, can_be_const=true, category={"Matrix-related operators"}, concept={"container", "matrix"})
    @GamlAnnotations.doc(value="the index of the last occurence of the right operand in the left operand container", usages={@GamlAnnotations.usage(value="if the left operand is a matrix, last_index_of returns the index as a point", examples={@GamlAnnotations.example(value="matrix([[1,2,3],[4,5,4]]) last_index_of 4", equals="{1.0,2.0}")})})
    @GamlAnnotations.test(value="matrix([[1,2,3],[4,5,4]]) last_index_of 4 = {1.0,2.0}")
    public static GamaPoint last_index_of(IScope iScope, IMatrix iMatrix, Object object) {
        int n = GAML.notNull(iScope, iMatrix).getCols(iScope) - 1;
        while (n > -1) {
            int n2 = iMatrix.getRows(iScope) - 1;
            while (n2 > -1) {
                if (iMatrix.get(iScope, n, n2).equals(object)) {
                    return new GamaPoint(n, n2);
                }
                --n2;
            }
            --n;
        }
        return null;
    }

    @GamlAnnotations.operator(value={"last_index_of"}, can_be_const=true, type=-399, category={"Map-related operators"}, concept={"map"})
    @GamlAnnotations.doc(value="the index of the last occurence of the right operand in the left operand container", usages={@GamlAnnotations.usage(value="if the left operand is a map, last_index_of returns the index as an int (the key of the pair)", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::4] last_index_of 4", equals="5")})})
    @GamlAnnotations.test(value="[1::2, 3::4, 5::4] last_index_of 4 = 5")
    public static Object last_index_of(IScope iScope, IMap<?, ?> iMap, Object object) {
        for (Map.Entry entry : Lists.reverse(new ArrayList(GAML.notNull(iScope, iMap).entrySet()))) {
            if (!entry.getValue().equals(object)) continue;
            return entry.getKey();
        }
        return null;
    }

    @GamlAnnotations.operator(value={"inter"}, can_be_const=true, content_type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the intersection of the two operands", comment="both containers are transformed into sets (so without duplicated element, cf. remove_deplicates operator) before the set intersection is computed.", usages={@GamlAnnotations.usage(value="if an operand is a graph, it will be transformed into the set of its nodes"), @GamlAnnotations.usage(value="if an operand is a map, it will be transformed into the set of its values", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] inter [2,4]", equals="[2,4]"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] inter [1,3]", equals="[]")}), @GamlAnnotations.usage(value="if an operand is a matrix, it will be transformed into the set of the lines", examples={@GamlAnnotations.example(value="matrix([[3,2,1],[4,5,4]]) inter [3,4]", equals="[3,4]")})}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] inter [2,4]", equals="[2,4]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] inter [0,8]", equals="[]")}, see={"remove_duplicates"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] inter [0,8] = []")
    public static IList inter(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return (IList)Containers.stream(iScope, iContainer).filter(Containers.inContainer(iScope, iContainer2)).distinct().toCollection(Containers.listLike(iContainer, iContainer2));
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new list in which all the elements of the right operand have been removed from the left one", comment="The behavior of the operator depends on the type of the operands.", usages={@GamlAnnotations.usage(value="if both operands are containers and the right operand is empty, - returns the left operand"), @GamlAnnotations.usage(value="if both operands are containers, returns a new list in which all the elements of the right operand have been removed from the left one", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] - [2,4,9]", returnType="list<int>", equals="[1,3,5,6]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] - [0,8]", returnType="list<int>", equals="[1,2,3,4,5,6]")})}, see={"+"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] - [0,8] = [1,2,3,4,5,6]")
    public static IList minus(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        IValue iValue = GAML.notNull(iScope, iContainer).listValue(iScope, iContainer.getGamlType().getContentType(), false).copy(iScope);
        iValue.removeAll(GAML.notNull(iScope, iContainer2).listValue(iScope, Types.NO_TYPE, false));
        return iValue;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left operand is a list and the right operand is an object of any type (except list), - returns a list containing the elements of the left operand minus the first occurence of this object", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,2] - 2", returnType="list<int>", equals="[1,3,4,5,6,2]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] - 0", returnType="list<int>", equals="[1,2,3,4,5,6]")})})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] - 0 = [1,2,3,4,5,6]")
    public static IList minus(IScope iScope, IList iList, Object object) {
        IValue iValue = GAML.notNull(iScope, iList).copy(iScope);
        iValue.remove(object);
        return iValue;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=-299, category={"Containers-related operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left operand is a species and the right operand is an agent of the species, - returns a list containing all the agents of the species minus this agent")})
    @GamlAnnotations.test(value="([1,2,2,3,5] - 3) = [1,2,2,5] ")
    public static IList minus(IScope iScope, ISpecies iSpecies, IAgent iAgent) {
        return Containers.minus(iScope, iSpecies.listValue(iScope, iScope.getType(iSpecies.getName()), false), (Object)iAgent);
    }

    @GamlAnnotations.operator(value={"of_generic_species"}, content_type=-298, category={"Species-related operators"}, concept={"species"})
    @GamlAnnotations.doc(value="a list, containing the agents of the left-hand operand whose species is that denoted by the right-hand operand and whose species extends the right-hand operand species ", examples={@GamlAnnotations.example(value="// species speciesA {}"), @GamlAnnotations.example(value="// species sub_speciesA parent: speciesA {}"), @GamlAnnotations.example(value="[sub_speciesA(0),sub_speciesA(1),speciesA(2),speciesA(3)] of_generic_species speciesA", equals="[sub_speciesA0,sub_speciesA1,speciesA0,speciesA1]", isExecutable=false), @GamlAnnotations.example(value="[sub_speciesA(0),sub_speciesA(1),speciesA(2),speciesA(3)] of_generic_species sous_test", equals="[sub_speciesA0,sub_speciesA1]", isExecutable=false), @GamlAnnotations.example(value="[sub_speciesA(0),sub_speciesA(1),speciesA(2),speciesA(3)] of_species speciesA", equals="[speciesA0,speciesA1]", isExecutable=false), @GamlAnnotations.example(value="[sub_speciesA(0),sub_speciesA(1),speciesA(2),speciesA(3)] of_species sous_test", equals="[sub_speciesA0,sub_speciesA1]", isExecutable=false)}, see={"of_species"})
    public static IList of_generic_species(IScope iScope, IContainer iContainer, ISpecies iSpecies) {
        return Containers.of_species(iScope, GAML.notNull(iScope, iContainer), GAML.notNull(iScope, iSpecies), true);
    }

    @GamlAnnotations.operator(value={"of_species"}, content_type=-298, category={"Species-related operators"}, concept={"species"})
    @GamlAnnotations.doc(value="a list, containing the agents of the left-hand operand whose species is the one denoted by the right-hand operand.The expression agents of_species (species self) is equivalent to agents where (species each = species self); however, the advantage of using the first syntax is that the resulting list is correctly typed with the right species, whereas, in the second syntax, the parser cannot determine the species of the agents within the list (resulting in the need to cast it explicitly if it is to be used in an ask statement, for instance).", usages={@GamlAnnotations.usage(value="if the right operand is nil, of_species returns the right operand")}, examples={@GamlAnnotations.example(value="(self neighbors_at 10) of_species (species (self))", equals="all the neighboring agents of the same species.", isExecutable=false), @GamlAnnotations.example(value="[test(0),test(1),node(1),node(2)] of_species test", equals="[test0,test1]", isExecutable=false)}, see={"of_generic_species"})
    public static IList of_species(IScope iScope, IContainer iContainer, ISpecies iSpecies) {
        return Containers.of_species(iScope, GAML.notNull(iScope, iContainer), GAML.notNull(iScope, iSpecies), false);
    }

    private static IList of_species(IScope iScope, IContainer iContainer, ISpecies iSpecies, boolean bl) {
        return (IList)iContainer.stream(iScope).filter(object -> {
            IAgent iAgent;
            return object instanceof IAgent && (iAgent = (IAgent)object).isInstanceOf(iSpecies, !bl);
        }).toCollection((Supplier)Containers.listOf(iScope.getType(iSpecies.getName())));
    }

    @GamlAnnotations.operator(value={"::", "pair"}, can_be_const=true, type=9, index_type=-199, content_type=-198, concept={"container"})
    @GamlAnnotations.doc(value="produces a new pair combining the left and the right operands", special_cases={"nil is not acceptable as a key (although it is as a value). If such a case happens, :: will throw an appropriate error"})
    @GamlAnnotations.test(value="string(1::2) = '1::2'")
    public static GamaPair pair(IScope iScope, IExpression iExpression, IExpression iExpression2) {
        Object object = iExpression.value(iScope);
        Object object2 = iExpression2.value(iScope);
        return new GamaPair<Object, Object>(GAML.notNull(iScope, object), object2, iExpression.getGamlType(), iExpression2.getGamlType());
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, type=-21, content_type=-21, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new list containing all the elements of both operands", usages={@GamlAnnotations.usage(value="if one of the operands is nil, + throws an error"), @GamlAnnotations.usage(value="if both operands are species, returns a special type of list called meta-population"), @GamlAnnotations.usage(value="if both operands are list, +returns the concatenation of both lists.", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] + [2,4,9]", returnType="list<int>", equals="[1,2,3,4,5,6,2,4,9]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] + [0,8]", returnType="list<int>", equals="[1,2,3,4,5,6,0,8]")})}, see={"-"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] + [2,4,9] = [1,2,3,4,5,6,2,4,9]")
    public static IContainer plus(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        if (iContainer instanceof IPopulationSet && iContainer2 instanceof IPopulationSet) {
            MetaPopulation metaPopulation = new MetaPopulation();
            metaPopulation.addPopulationSet((IPopulationSet)iContainer);
            metaPopulation.addPopulationSet((IPopulationSet)iContainer2);
            return metaPopulation;
        }
        return (IContainer)((Object)Containers.stream(iScope, iContainer).append((Stream)Containers.stream(iScope, iContainer2)).toCollection(Containers.listLike(iContainer, iContainer2)));
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=-299, category={"Containers-related operators"}, concept={})
    @validator(value=PlusListValidator.class)
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the right operand is an object of any type (except a container), + returns a list of the elements of the left operand, to which this object has been added", examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] + 2", returnType="list<int>", equals="[1,2,3,4,5,6,2]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] + 0", returnType="list<int>", equals="[1,2,3,4,5,6,0]")})})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] + 2 = [1,2,3,4,5,6,2]")
    public static IList plus(IScope iScope, IContainer iContainer, Object object) {
        IValue iValue = GAML.notNull(iScope, iContainer).listValue(iScope, Types.NO_TYPE, false).copy(iScope);
        iValue.addValue(iScope, object);
        return iValue;
    }

    @GamlAnnotations.operator(value={"union"}, can_be_const=true, content_type=-21, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new list containing all the elements of both containers without duplicated elements.", comment="", usages={@GamlAnnotations.usage(value="if the left or right operand is nil, union throws an error")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6] union [2,4,9]", equals="[1,2,3,4,5,6,9]"), @GamlAnnotations.example(value="[1,2,3,4,5,6] union [0,8]", equals="[1,2,3,4,5,6,0,8]"), @GamlAnnotations.example(value="[1,3,2,4,5,6,8,5,6] union [0,8]", equals="[1,3,2,4,5,6,8,0]")}, see={"inter", "+"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6] union [2,4,9] = [1,2,3,4,5,6,9]")
    public static IList union(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        return (IList)Containers.stream(iScope, iContainer).append((Stream)Containers.stream(iScope, iContainer2)).distinct().toCollection(Containers.listLike(iContainer, iContainer2));
    }

    @GamlAnnotations.operator(value={"group_by"}, iterator=true, index_type=-198, content_type=5, content_type_content_type=-299, concept={"container", "map"})
    @GamlAnnotations.doc(value="Returns a map, where the keys take the possible values of the right-hand operand and the map values are the list of elements of the left-hand operand associated to the key value", masterDoc=true, comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, group_by throws an error")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] group_by (each > 3)", equals="[false::[1, 2, 3], true::[4, 5, 6, 7, 8]]"), @GamlAnnotations.example(value="g2 group_by (length(g2 out_edges_of each) )", equals="[ 0::[node9, node7, node10, node8, node11], 1::[node6], 2::[node5], 3::[node4]]", isExecutable=false), @GamlAnnotations.example(value="(list(node) group_by (round(node(each).location.x))", equals="[32::[node5], 21::[node1], 4::[node0], 66::[node2], 96::[node3]]", isExecutable=false), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] group_by (each > 4)", equals="[false::[2, 4], true::[6]]", returnType="map<bool,list>")}, see={"first_with", "last_with", "where"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] group_by (each > 3) = [false::[1, 2, 3], true::[4, 5, 6, 7, 8]]"), @GamlAnnotations.test(value="[1::2, 3::4, 5::6] group_by (each > 4) = [false::[2, 4], true::[6]]")})
    public static IMap group_by(IScope iScope, IContainer iContainer, IExpression iExpression) {
        IType<?> iType = GAML.notNull(iScope, iContainer).getGamlType().getContentType();
        return (IMap)Containers.stream(iScope, iContainer).groupingTo(Containers.with(iScope, iExpression), (Supplier)Containers.asMapOf(iExpression.getGamlType(), Types.LIST.of(iType)), (Supplier)Containers.listOf(iType));
    }

    @GamlAnnotations.operator(value={"last_with"}, type=-299, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the last element of the left-hand operand that makes the right-hand operand evaluate to true.", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, last_with throws an error."), @GamlAnnotations.usage(value="If there is no element that satisfies the condition, it returns nil"), @GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] last_with (each >= 4)", equals="6"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6].pairs last_with (each.value >= 4)", equals="(5::6)")})}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] last_with (each > 3)", equals="8", returnType="int"), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 last_with (length(g2 out_edges_of each) = 0 )", equals="a node", isExecutable=false), @GamlAnnotations.example(value="(list(node) last_with (round(node(each).location.x) > 32)", equals="node3", isExecutable=false)}, see={"group_by", "first_with", "where"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] last_with (each > 3) = 8")
    public static Object last_with(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream(iScope, iContainer).filter(Containers.by(iScope, iExpression)).reduce((object, object2) -> object2).orElse(null);
    }

    @GamlAnnotations.operator(value={"first_with"}, type=-299, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the first element of the left-hand operand that makes the right-hand operand evaluate to true.", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, first_with throws an error. If there is no element that satisfies the condition, it returns nil"), @GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] first_with (each >= 4)", equals="4", returnType="int"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6].pairs first_with (each.value >= 4)", equals="(3::4)", returnType="pair")})}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] first_with (each > 3)", equals="4"), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 first_with (length(g2 out_edges_of each) = 0)", equals="node9", test=false), @GamlAnnotations.example(value="(list(node) first_with (round(node(each).location.x) > 32)", equals="node2", isExecutable=false)}, see={"group_by", "last_with", "where"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] first_with (each > 3) = 4")
    public static Object first_with(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream(iScope, iContainer).findFirst(Containers.by(iScope, iExpression)).orElse(null);
    }

    @GamlAnnotations.operator(value={"sum"}, can_be_const=true, type=-299, expected_content_type={1, 2, 7, 6, 4}, category={"Statistical operators", "Containers-related operators", "Color-related operators"}, concept={"statistic", "color"})
    @GamlAnnotations.doc(value="the sum of all the elements of the operand", masterDoc=true, comment="the behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list of int or float: sum returns the sum of all the elements", examples={@GamlAnnotations.example(value="sum ([12,10,3])", returnType="int", equals="25")}), @GamlAnnotations.usage(value="if it is a list of points: sum returns the sum of all points as a point (each coordinate is the sum of the corresponding coordinate of each element)", examples={@GamlAnnotations.example(value="sum([{1.0,3.0},{3.0,5.0},{9.0,1.0},{7.0,8.0}])", equals="{20.0,17.0}")}), @GamlAnnotations.usage(value="if it is a population or a list of other types: sum transforms all elements into float and sums them"), @GamlAnnotations.usage(value="if it is a map, sum returns the sum of the value of all elements"), @GamlAnnotations.usage(value="if it is a file, sum returns the sum of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a graph, sum returns the total weight of the graph"), @GamlAnnotations.usage(value="if it is a matrix of int, float or object, sum returns the sum of all the numerical elements (i.e. all elements for integer and float matrices)"), @GamlAnnotations.usage(value="if it is a matrix of other types: sum transforms all elements into float and sums them"), @GamlAnnotations.usage(value="if it is a list of colors: sum will sum them and return the blended resulting color")}, see={"mul"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="sum([{1.0,3.0},{3.0,5.0},{9.0,1.0},{7.0,8.0}]) = {20.0,17.0}"), @GamlAnnotations.test(value="sum ([12,10,3]) = 25")})
    public static Object sum(IScope iScope, IContainer iContainer) {
        return Containers.sum_of(iScope, iContainer, null);
    }

    @GamlAnnotations.operator(value={"sum"}, can_be_const=true, doc={@GamlAnnotations.doc(value="Returns the sum of the weights of the graph nodes")}, category={"Graphs-related operators"}, concept={"graph"})
    @GamlAnnotations.test(value="sum(as_edge_graph(line([{10,10},{30,10}]))) = 20.0")
    public static double sum(IScope iScope, IGraph iGraph) {
        if (iGraph == null) {
            return 0.0;
        }
        return iGraph.computeTotalWeight();
    }

    @GamlAnnotations.operator(value={"cartesian_product"}, doc={@GamlAnnotations.doc(value="Returns the cartesian product of elements in all given sub-lists")}, expected_content_type={5}, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.test(value="cartesian_product([['A','B'],['C','D']]) = [['A','C'],['A','D'],['B','C'],['B','D']]")
    public static Object cart_prod(IScope iScope, IList iList) {
        IType<?> iType = iList.getGamlType().getContentType();
        if (!iType.isContainer()) {
            throw GamaRuntimeException.error("Must be a list of list", iScope);
        }
        IList iList2 = GAML.notNull(iScope, iList).listValue(iScope, (IType)iList.getGamlType().getContentType(), false);
        List list = (List)iList2.stream(iScope).map(LinkedHashSet::new).collect(Collectors.toList());
        IList iList3 = GamaListFactory.create(iType);
        Set set = Sets.cartesianProduct((List)list);
        for (List list2 : set) {
            iList3.add(GamaListFactory.create(iScope, iType.getContentType(), list2));
        }
        return iList3;
    }

    @GamlAnnotations.operator(value={"sum_of"}, type=-198, expected_content_type={2, 7, 6, 1, 4}, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="the sum of the right-hand expression evaluated on each of the elements of the left-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] sum_of (each + 3)", equals="21")})}, examples={@GamlAnnotations.example(value="[1,2] sum_of (each * 100 )", equals="300")}, see={"min_of", "max_of", "product_of", "mean_of"})
    @GamlAnnotations.test(value="[1,2] sum_of (each * 100 ) = 300")
    public static Object sum_of(IScope iScope, IContainer iContainer, IExpression iExpression) {
        IType<?> iType;
        Object object2 = Containers.stream(iScope, iContainer);
        if (iExpression != null) {
            object2 = object2.map(Containers.with(iScope, iExpression));
            iType = iExpression.getGamlType();
        } else {
            iType = iContainer.getGamlType().getContentType();
        }
        object2 = object2.map(object -> iType.cast(iScope, object, null, false));
        return switch (iType.id()) {
            case 1 -> object2.reduce(0, Integer::sum);
            case 2 -> object2.reduce(0.0, Double::sum);
            case 7 -> object2.reduce(new GamaPoint(), GamaPoint::plus);
            case 6 -> object2.reduce(GamaColor.get(0, 0, 0, 0), GamaColor::merge);
            case 4 -> object2.reduce("", String::concat);
            default -> throw GamaRuntimeException.error("No sum can be computed for " + iContainer.serializeToGaml(true), iScope);
        };
    }

    @GamlAnnotations.operator(value={"among"}, content_type=-298, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="Returns a list of length the value of the left-hand operand, containing random elements from the right-hand operand. As of GAMA 1.6, the order in which the elements are returned can be different than the order in which they appear in the right-hand container", special_cases={"if the right-hand operand is empty, among returns a new empty list. If it is nil, it throws an error.", "if the left-hand operand is greater than the length of the right-hand operand, among returns the right-hand operand (converted as a list). If it is smaller or equal to zero, it returns an empty list"}, examples={@GamlAnnotations.example(value="3 among [1,2,4,3,5,7,6,8]", returnType="list<int>", equals="[1,2,8] (for example)", test=false), @GamlAnnotations.example(value="3 among g2", equals="[node6,node11,node7]", isExecutable=false), @GamlAnnotations.example(value="3 among list(node)", equals="[node1,node11,node4]", isExecutable=false), @GamlAnnotations.example(value="1 among [1::2,3::4]", returnType="list<int>", equals="2 or 4", test=false)})
    public static IList among(IScope iScope, Integer n, IContainer iContainer) throws GamaRuntimeException {
        if (n <= 0) {
            if (n < 0) {
                GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("'among' expects a positive number (not " + String.valueOf(n) + ")", iScope), false);
            }
            return Containers.listLike(iContainer).get();
        }
        IList iList = GAML.notNull(iScope, iContainer).listValue(iScope, iContainer.getGamlType().getContentType(), false);
        int n2 = iList.size();
        if (n >= n2) {
            return iList;
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = n3;
            ++n3;
        }
        iScope.getRandom().shuffleInPlace(nArray);
        IList iList2 = Containers.listLike(iContainer).get();
        int n4 = 0;
        while (n4 < n) {
            iList2.add(iList.get(nArray[n4]));
            ++n4;
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"sort_by", "sort"}, content_type=-299, iterator=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns a list, containing the elements of the left-hand operand sorted in ascending order by the value of the right-hand operand when it is evaluated on them. ", comment="the left-hand operand is casted to a list before applying the operator. In the right-hand operand, the keyword each can be used to represent, in turn, each of the elements.", special_cases={"if the left-hand operand is nil, sort_by throws an error. If the sorting function returns values that cannot be compared, an error will be thrown as well"}, examples={@GamlAnnotations.example(value="[1,2,4,3,5,7,6,8] sort_by (each)", equals="[1,2,3,4,5,6,7,8]"), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 sort_by (length(g2 out_edges_of each) )", equals="[node9, node7, node10, node8, node11, node6, node5, node4]", test=false), @GamlAnnotations.example(value="(list(node) sort_by (round(node(each).location.x))", equals="[node5, node1, node0, node2, node3]", isExecutable=false), @GamlAnnotations.example(value="[1::2, 5::6, 3::4] sort_by (each)", equals="[2, 4, 6]")}, see={"group_by"})
    @GamlAnnotations.test(value="[1,2,4,3,5,7,6,8] sort_by (each) = [1,2,3,4,5,6,7,8]")
    @validator(value=ComparableValidator.class)
    public static IList sort(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return (IList)Containers.stream(iScope, iContainer).sortedBy(Containers.with(iScope, iExpression)).toCollection(Containers.listLike(iContainer));
    }

    @GamlAnnotations.operator(value={"where", "select"}, content_type=-299, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(masterDoc=true, value="a list containing all the elements of the left-hand operand that make the right-hand operand evaluate to true. ", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, where throws an error"), @GamlAnnotations.usage(value="if the left-operand is a map, the keyword each will contain each value", examples={@GamlAnnotations.example(value="[1::2, 3::4, 5::6] where (each >= 4)", equals="[4, 6]")})}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] where (each > 3)", equals="[4, 5, 6, 7, 8] "), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 where (length(g2 out_edges_of each) = 0 )", equals="[node9, node7, node10, node8, node11]", test=false), @GamlAnnotations.example(value="(list(node) where (round(node(each).location.x) > 32)", equals="[node2, node3]", isExecutable=false)}, see={"first_with", "last_with"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] where (each > 3) = [4, 5, 6, 7, 8] ")
    public static IList where(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return (IList)Containers.stream(iScope, iContainer).filter(Containers.by(iScope, iExpression)).toCollection(Containers.listLike(iContainer));
    }

    @GamlAnnotations.operator(value={"where", "select"}, content_type=-299, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="Returns a list contaning only the elements that make the predicate return true")
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] where (each != 2) = [1, 3, 4, 5, 6, 7, 8] ")
    public static IList where(IScope iScope, IList iList, IExpression iExpression) {
        return Containers.where(iScope, iList.iterable(iScope), iList.getGamlType().getContentType(), iExpression);
    }

    private static IList where(IScope iScope, Iterable iterable, IType iType, IExpression iExpression) {
        IList iList = GamaListFactory.create(iType);
        for (Object t : iterable) {
            iScope.setEach(t);
            if (!((Boolean)iExpression.value(iScope)).booleanValue()) continue;
            iList.add(t);
        }
        iScope.setEach(null);
        return iList;
    }

    @GamlAnnotations.operator(value={"where", "select"}, content_type=-299, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="Returns a list containing only the agents of this species that make the predicate return true")
    public static IList where(IScope iScope, ISpecies iSpecies, IExpression iExpression) {
        return Containers.where(iScope, iSpecies.iterable(iScope), iSpecies.getGamlType().getContentType(), iExpression);
    }

    @GamlAnnotations.operator(value={"with_max_of"}, type=-299, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="one of elements of the left-hand operand that maximizes the value of the right-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, with_max_of returns the default value of the right-hand operand")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] with_max_of (each )", equals="8"), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 with_max_of (length(g2 out_edges_of each)  ) ", equals="node4", test=false), @GamlAnnotations.example(value="(list(node) with_max_of (round(node(each).location.x))", equals="node3", isExecutable=false), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] with_max_of (each)", equals="6")}, see={"where", "with_min_of"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] with_max_of (each ) = 8")
    @validator(value=ComparableValidator.class)
    public static Object with_max_of(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream(iScope, iContainer).maxBy(Containers.with(iScope, iExpression)).orElse(null);
    }

    @GamlAnnotations.operator(value={"with_min_of"}, type=-299, iterator=true, category={"Containers-related operators"}, concept={"container", "filter"})
    @GamlAnnotations.doc(value="one of elements of the left-hand operand that minimizes the value of the right-hand operand", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the right-hand operand elements. ", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, with_max_of returns the default value of the right-hand operand")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] with_min_of (each )", equals="1"), @GamlAnnotations.example(value="graph g2 <- graph([]);", isTestOnly=true), @GamlAnnotations.example(value="g2 with_min_of (length(g2 out_edges_of each)  )", equals="node11", test=false), @GamlAnnotations.example(value="(list(node) with_min_of (round(node(each).location.x))", equals="node0", isExecutable=false), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] with_min_of (each)", equals="2")}, see={"where", "with_max_of"})
    @GamlAnnotations.test(value="[1,2,3,4,5,6,7,8] with_min_of (each )  = 1")
    @validator(value=ComparableValidator.class)
    public static Object with_min_of(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return Containers.stream(iScope, iContainer).minBy(Containers.with(iScope, iExpression)).orElse(null);
    }

    @GamlAnnotations.operator(value={"accumulate"}, content_type=-25, iterator=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new flat list, in which each element is the evaluation of the right-hand operand. If this evaluation returns a list, the elements of this result are added directly to the list returned", comment="accumulate is dedicated to the application of a same computation on each element of a container (and returns a list). In the right-hand operand, the keyword each can be used to represent, in turn, each of the left-hand operand elements. ", examples={@GamlAnnotations.example(value="[a1,a2,a3] accumulate (each neighbors_at 10)", equals="a flat list of all the neighbors of these three agents", isExecutable=false), @GamlAnnotations.example(value="[1,2,4] accumulate ([2,4])", returnType="list<int>", equals="[2,4,2,4,2,4]"), @GamlAnnotations.example(value="[1,2,4] accumulate (each * 2)", returnType="list<int>", equals="[2,4,8]")}, see={"collect"})
    @GamlAnnotations.test(value="[1,2,4] accumulate ([2,4]) = [2,4,2,4,2,4]")
    public static IList accumulate(IScope iScope, IContainer iContainer, IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        IType<?> iType2 = iType;
        if (iType2.isContainer()) {
            iType2 = iType2.getContentType();
        }
        return (IList)Containers.stream(iScope, iContainer).flatCollection(Containers.with(iScope, iExpression).andThen(toLists)).toCollection((Supplier)Containers.listOf(iType2));
    }

    @GamlAnnotations.operator(value={"collect"}, content_type=-198, iterator=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new list, in which each element is the evaluation of the right-hand operand.", comment="collect is similar to accumulate except that accumulate always produces flat lists if the right-hand operand returns a list.In addition, collect can be applied to any container.", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, collect throws an error")}, examples={@GamlAnnotations.example(value="[1,2,4] collect (each *2)", equals="[2,4,8]"), @GamlAnnotations.example(value="[1,2,4] collect ([2,4])", equals="[[2,4],[2,4],[2,4]]"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] collect (each + 2)", equals="[4,6,8]"), @GamlAnnotations.example(value="(list(node) collect (node(each).location.x * 2)", equals="the list of nodes with their x multiplied by 2", isExecutable=false)}, see={"accumulate"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="[1,2,4] collect (each *2) = [2,4,8]"), @GamlAnnotations.test(value="[1,2,4] collect ([2,4]) = [[2,4],[2,4],[2,4]]")})
    public static IList collect(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return (IList)Containers.stream(iScope, iContainer).map(Containers.with(iScope, iExpression)).toCollection((Supplier)Containers.listOf(iExpression.getGamlType()));
    }

    @GamlAnnotations.operator(value={"interleave"}, content_type=-22, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns a new list containing the interleaved elements of the containers contained in the operand", comment="the operand should be a list of lists of elements. The result is a list of elements. ", examples={@GamlAnnotations.example(value="interleave([1,2,4,3,5,7,6,8])", equals="[1,2,4,3,5,7,6,8]"), @GamlAnnotations.example(value="interleave([['e11','e12','e13'],['e21','e22','e23'],['e31','e32','e33']])", equals="['e11','e21','e31','e12','e22','e32','e13','e23','e33']")})
    public static IList interleave(IScope iScope, IContainer iContainer) {
        Iterable iterable = GAML.notNull(iScope, iContainer).iterable(iScope);
        IType<?> iType = iContainer.getGamlType().getContentType();
        if (iType.isContainer()) {
            iType = iType.getContentType();
        }
        InterleavingIterator interleavingIterator = new InterleavingIterator(iScope, Iterables.toArray(iterable, Object.class));
        return GamaListFactory.create(iScope, iType, interleavingIterator);
    }

    @GamlAnnotations.operator(value={"count"}, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns an int, equal to the number of elements of the left-hand operand that make the right-hand operand evaluate to true.", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the elements.", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, count throws an error")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] count (each > 3)", equals="5"), @GamlAnnotations.example(value="// Number of nodes of graph g2 without any out edge"), @GamlAnnotations.example(value="graph g2 <- graph([]);"), @GamlAnnotations.example(value="g2 count (length(g2 out_edges_of each) = 0  ) ", equals="the total number of out edges", test=false), @GamlAnnotations.example(value="// Number of agents node with x > 32"), @GamlAnnotations.example(value="int n <- (list(node) count (round(node(each).location.x) > 32);", isExecutable=false), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] count (each > 4)", equals="1")}, see={"group_by"})
    public static Integer count(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return (int)GAML.notNull(iScope, iContainer).stream(iScope).filter(Containers.by(iScope, iExpression)).count();
    }

    @GamlAnnotations.operator(value={"one_matches", "one_verifies"}, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns true if at least one of the elements of the left-hand operand make the right-hand operand evaluate to true.  Returns false if the left-hand operand is empty. 'c one_matches each.property' is strictly equivalent to '(c count each.property) > 0' but faster in most cases (as it is a shortcircuited operator) ", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the elements.", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, one_matches throws an error")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] one_matches (each > 3)", equals="true"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] one_matches (each > 4)", equals="true")}, see={"none_matches", "all_match", "count"})
    public static Boolean one_matches(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return GAML.notNull(iScope, iContainer).stream(iScope).anyMatch(Containers.by(iScope, iExpression));
    }

    @GamlAnnotations.operator(value={"none_matches", "none_verifies"}, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns true if none of the elements of the left-hand operand make the right-hand operand evaluate to true. 'c none_matches each.property' is strictly equivalent to '(c count each.property) = 0'", comment="In the right-hand operand, the keyword each can be used to represent, in turn, each of the elements.", usages={@GamlAnnotations.usage(value="If the left-hand operand is nil, none_matches throws an error."), @GamlAnnotations.usage(value="If the left-hand operand is empty, none_matches returns true.")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] none_matches (each > 3)", equals="false"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] none_matches (each > 4)", equals="false")}, see={"one_matches", "all_match", "count"})
    public static Boolean none_matches(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return GAML.notNull(iScope, iContainer).stream(iScope).noneMatch(Containers.by(iScope, iExpression));
    }

    @GamlAnnotations.operator(value={"all_match", "all_verify"}, iterator=true, expected_content_type={3}, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="Returns true if all the elements of the left-hand operand make the right-hand operand evaluate to true. Returns true if the left-hand operand is empty. 'c all_match each.property' is strictly equivalent to '(c count each.property)  = length(c)' but faster in most cases (as it is a shortcircuited operator)", comment="in the right-hand operand, the keyword each can be used to represent, in turn, each of the elements.", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, all_match throws an error"), @GamlAnnotations.usage(value="if the left-hand operand is empty, all_match returns true")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] all_match (each > 3)", equals="false"), @GamlAnnotations.example(value="[1::2, 3::4, 5::6] all_match (each > 4)", equals="false")}, see={"none_matches", "one_matches", "count"})
    public static Boolean all_match(IScope iScope, IContainer iContainer, IExpression iExpression) {
        return GAML.notNull(iScope, iContainer).stream(iScope).allMatch(Containers.by(iScope, iExpression));
    }

    @GamlAnnotations.operator(value={"index_by"}, iterator=true, content_type=-299, index_type=-198, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="produces a new map from the evaluation of the right-hand operand for each element of the left-hand operand", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, index_by throws an error. If the operation results in duplicate keys, only the first value corresponding to the key is kept")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] index_by (each - 1)", equals="[0::1, 1::2, 2::3, 3::4, 4::5, 5::6, 6::7, 7::8]")}, see={})
    public static IMap index_by(IScope iScope, IContainer iContainer, IExpression iExpression) {
        StreamEx streamEx = iContainer.stream(iScope);
        IType<?> iType = iContainer.getGamlType().getContentType();
        return (IMap)streamEx.collect(Collectors.toMap(Containers.with(iScope, iExpression), object -> object, (object, object2) -> object, Containers.asMapOf(iExpression.getGamlType(), iType)));
    }

    @GamlAnnotations.operator(value={"as_map"}, iterator=true, content_type=-298, index_type=-398, expected_content_type={9}, category={"Map-related operators"}, concept={"container", "map"})
    @GamlAnnotations.doc(value="produces a new map from the evaluation of the right-hand operand for each element of the left-hand operand", comment="the right-hand operand should be a pair", usages={@GamlAnnotations.usage(value="if the left-hand operand is nil, as_map throws an error.")}, examples={@GamlAnnotations.example(value="[1,2,3,4,5,6,7,8] as_map (each::(each * 2))", returnType="map<int,int>", equals="[1::2, 2::4, 3::6, 4::8, 5::10, 6::12, 7::14, 8::16]"), @GamlAnnotations.example(value="[1::2,3::4,5::6] as_map (each::(each * 2))", returnType="map<int,int>", equals="[2::4, 4::8, 6::12] ")}, see={})
    public static IMap as_map(IScope iScope, IContainer iContainer, IExpression iExpression) {
        BinaryOperator binaryOperator;
        if (!(iExpression instanceof BinaryOperator) || !"::".equals((binaryOperator = (BinaryOperator)iExpression).getName())) {
            throw GamaRuntimeException.error("'as_map' expects a pair as second argument", iScope);
        }
        IExpression iExpression2 = binaryOperator.arg(0);
        IExpression iExpression3 = binaryOperator.arg(1);
        return (IMap)Containers.stream(iScope, iContainer).collect(Collectors.toMap(Containers.with(iScope, iExpression2), Containers.with(iScope, iExpression3), (object, object2) -> object, Containers.asMapOf(iExpression2.getGamlType(), iExpression3.getGamlType())));
    }

    @GamlAnnotations.operator(value={"create_map"}, iterator=true, content_type=-298, index_type=-299, category={"Map-related operators"}, expected_content_type={-21}, concept={"container", "map"})
    @GamlAnnotations.doc(value="returns a new map using the left operand as keys for the right operand", usages={@GamlAnnotations.usage(value="if the left operand contains duplicates, create_map throws an error."), @GamlAnnotations.usage(value="if both operands have different lengths, choose the minimum length between the two operandsfor the size of the map")}, examples={@GamlAnnotations.example(value="create_map([0,1,2],['a','b','c'])", returnType="map<int,string>", equals="[0::'a',1::'b',2::'c']"), @GamlAnnotations.example(value="create_map([0,1],[0.1,0.2,0.3])", returnType="map<int,float>", equals="[0::0.1,1::0.2]"), @GamlAnnotations.example(value="create_map(['a','b','c','d'],[1.0,2.0,3.0])", returnType="map<string,float>", equals="['a'::1.0,'b'::2.0,'c'::3.0]")}, see={})
    public static IMap create_map(IScope iScope, IList iList, IList iList2) {
        if (iList.length(iScope) != iList2.length(iScope)) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("'create_map' expects two lists of the same length", iScope), false);
        }
        return GamaMapFactory.create(iScope, iList.getGamlType(), iList2.getGamlType(), iList, iList2);
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, type=-21, content_type=-21, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new map containing all the elements of both operands", examples={@GamlAnnotations.example(value="['a'::1,'b'::2] + ['c'::3]", equals="['a'::1,'b'::2,'c'::3]"), @GamlAnnotations.example(value="['a'::1,'b'::2] + [5::3.0]", equals="['a'::1,'b'::2,5::3.0]")}, see={"-"})
    public static IMap plus(IScope iScope, IMap iMap, IMap iMap2) {
        IType<?> iType = GamaType.findCommonType(GAML.notNull(iScope, iMap).getGamlType(), GAML.notNull(iScope, iMap2).getGamlType());
        IMap<?, ?> iMap3 = GamaMapFactory.createWithoutCasting(iType.getKeyType(), iType.getContentType(), iMap);
        iMap3.putAll(iMap2);
        return iMap3;
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, type=-199, content_type=-21, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="returns a new map containing all the elements of both operands", examples={@GamlAnnotations.example(value="['a'::1,'b'::2] + ('c'::3)", equals="['a'::1,'b'::2,'c'::3]"), @GamlAnnotations.example(value="['a'::1,'b'::2] + ('c'::3)", equals="['a'::1,'b'::2,'c'::3]")}, see={"-"})
    public static IMap plus(IScope iScope, IMap iMap, GamaPair gamaPair) {
        IType<?> iType = GamaType.findCommonType(GAML.notNull(iScope, iMap).getGamlType(), GAML.notNull(iScope, gamaPair).getGamlType());
        IMap<?, ?> iMap2 = GamaMapFactory.createWithoutCasting(iType.getKeyType(), iType.getContentType(), iMap);
        iMap2.put(gamaPair.key, gamaPair.value);
        return iMap2;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, type=-21, content_type=-21, category={"Containers-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns a new map containing all the elements of the first operand not present in the second operand", examples={@GamlAnnotations.example(value="['a'::1,'b'::2] - ['b'::2]", equals="['a'::1]"), @GamlAnnotations.example(value="['a'::1,'b'::2] - ['b'::2,'c'::3]", equals="['a'::1]")}, see={"-"})
    public static IMap minus(IScope iScope, IMap iMap, IMap iMap2) {
        IValue iValue = GAML.notNull(iScope, iMap).copy(iScope);
        iValue.removeValues(iScope, iMap2);
        return iValue;
    }

    @GamlAnnotations.operator(value={"-"}, can_be_const=true, type=-199, content_type=-21, category={"Containers-related operators"}, concept={})
    @GamlAnnotations.doc(value="returns a new map containing all the elements of the first operand without the one of the second operand", examples={@GamlAnnotations.example(value="['a'::1,'b'::2] - ('b'::2)", equals="['a'::1]"), @GamlAnnotations.example(value="['a'::1,'b'::2] - ('c'::3)", equals="['a'::1,'b'::2]")}, see={"-"})
    public static IMap minus(IScope iScope, IMap iMap, GamaPair gamaPair) {
        IValue iValue = GAML.notNull(iScope, iMap).copy(iScope);
        iValue.remove(gamaPair.getKey());
        return iValue;
    }

    @GamlAnnotations.operator(value={"mean"}, can_be_const=true, type=-1299, expected_content_type={1, 2, 7, 6}, category={"Statistical operators", "Containers-related operators", "Color-related operators"}, concept={"statistic", "color"})
    @GamlAnnotations.doc(value="the mean of all the elements of the operand", comment="the elements of the operand are summed (see sum for more details about the sum of container elements ) and then the sum value is divided by the number of elements.", special_cases={"if the container contains points, the result will be a point. If the container contains rgb values, the result will be a rgb color"}, examples={@GamlAnnotations.example(value="mean ([4.5, 3.5, 5.5, 7.0])", equals="5.125 ")}, see={"sum"})
    @GamlAnnotations.test(value="mean ([4.5, 3.5, 5.5, 7.0]) with_precision 3 = 5.125")
    public static Object opMean(IScope iScope, IContainer iContainer) throws GamaRuntimeException {
        Object object = Containers.sum(iScope, iContainer);
        int n = iContainer.length(iScope);
        if (n == 0) {
            n = 1;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() / (double)n;
        }
        if (object instanceof GamaPoint) {
            return Points.divide(iScope, (GamaPoint)object, n);
        }
        if (object instanceof GamaColor) {
            return Colors.divide((GamaColor)object, n);
        }
        return Cast.asFloat(iScope, object) / (double)n;
    }

    public static class AtValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            IType<?> iType;
            boolean bl;
            IType<?> iType2 = iExpressionArray[0].getGamlType();
            IType<?> iType3 = iExpressionArray[1].getGamlType();
            if (Types.FILE.isAssignableFrom(iType2)) {
                iType2 = iType2.getWrappedType();
            }
            boolean bl2 = bl = (iType = iType2.getKeyType()) != Types.NO_TYPE && !iType3.isTranslatableInto(iType);
            if (bl) {
                iDescription.error("The contents of this " + iType2.getGamlType().getName() + " can only be accessed with " + String.valueOf(iType2.getKeyType()) + " keys", "gaml.wrong.type.issue", eObject, new String[0]);
                return false;
            }
            return true;
        }
    }

    public static class ComparableValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            IExpression iExpression = iExpressionArray[1];
            if (!iExpression.getGamlType().isComparable()) {
                iDescription.error("The comparison function should return values that are comparable with each other (e.g. int, float, string, point, color, etc.)", "gaml.unmatched.types.issue", eObject, new String[0]);
                return false;
            }
            return true;
        }
    }

    private static class InterleavingIterator
    extends AbstractIterator {
        private final Queue<Iterator> queue = new ArrayDeque<Iterator>();

        public InterleavingIterator(IScope iScope, Object ... objectArray) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (object instanceof IContainer) {
                    this.queue.add(((IContainer)object).iterable(iScope).iterator());
                } else if (object instanceof Iterator) {
                    this.queue.add((Iterator)object);
                } else if (object instanceof Iterable) {
                    this.queue.add(((Iterable)object).iterator());
                } else {
                    this.queue.add((Iterator)Iterators.singletonIterator((Object)object));
                }
                ++n2;
            }
        }

        protected Object computeNext() {
            while (!this.queue.isEmpty()) {
                Iterator iterator = this.queue.poll();
                if (!iterator.hasNext()) continue;
                Object e = iterator.next();
                this.queue.offer(iterator);
                return e;
            }
            return this.endOfData();
        }
    }

    public static class InternalAtValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            IType<?> iType;
            boolean bl;
            if (Types.isEmpty(iExpressionArray[1])) {
                return true;
            }
            IType<?> iType2 = iExpressionArray[0].getGamlType();
            IType<?> iType3 = iExpressionArray[1].getGamlType().getContentType();
            if (Types.FILE.isAssignableFrom(iType2)) {
                iType2 = iType2.getWrappedType();
            }
            boolean bl2 = bl = (iType = iType2.getKeyType()) != Types.NO_TYPE && !iType3.isTranslatableInto(iType) && (!Types.MATRIX.isAssignableFrom(iType2) || iType3 != Types.INT);
            if (bl) {
                iDescription.error("The contents of this " + iType2.getGamlType().getName() + " can only be accessed with " + String.valueOf(iType2.getKeyType()) + " keys", "gaml.wrong.type.issue", eObject, new String[0]);
                return false;
            }
            return true;
        }
    }

    public static class PlusListValidator
    implements IOperatorValidator {
        @Override
        public boolean validate(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
            IExpression iExpression = iExpressionArray[1];
            IExpression iExpression2 = iExpressionArray[0];
            IType<?> iType = iExpressionArray[1].getGamlType();
            IType<?> iType2 = iExpressionArray[0].getGamlType().getContentType();
            if (iType2 != Types.NO_TYPE && !iType.isTranslatableInto(iType2) && !Types.isEmptyContainerCase(iType2, iExpression)) {
                StringBuilder stringBuilder = new StringBuilder("The type of the elements of ").append(iExpression2.serializeToGaml(false)).append(" (").append(iType2).append(") does not match with the type of the ");
                stringBuilder.append("argument");
                stringBuilder.append(" (").append(iType).append("). ");
                stringBuilder.append("The argument will be casted to ").append(iType2).append(". ");
                iDescription.warning(stringBuilder.toString(), "gaml.wrong.type.issue", eObject, new String[0]);
            }
            return true;
        }
    }

    public static abstract class Range {
        @GamlAnnotations.operator(value={"range"}, content_type=1, category={"Containers-related operators"}, can_be_const=true)
        @GamlAnnotations.doc(value="builds a list of int representing all contiguous values from zero to the argument. The range can be increasing or decreasing.", masterDoc=true, special_cases={"Passing 0 will return a singleton list with 0."})
        @GamlAnnotations.test(value="range(2) = [0,1,2]")
        public static IList range(IScope iScope, Integer n) {
            if (n == 0) {
                return GamaListFactory.wrap((IType)Types.INT, 0);
            }
            return Range.range(iScope, 0, n);
        }

        @GamlAnnotations.operator(value={"range", "to"}, content_type=1, category={"Containers-related operators"}, can_be_const=true)
        @GamlAnnotations.doc(value="the list of int representing all contiguous values from the first to the second argument.", usages={@GamlAnnotations.usage(value="When used with 2 operands, it returns the list of int representing all contiguous values from the first to the second argument. Passing the same value for both will return a singleton list with this value", examples={@GamlAnnotations.example(value="range(0,2)", equals="[0,1,2]")})})
        @GamlAnnotations.test(value="range(0,2) = [0,1,2]")
        public static IList range(IScope iScope, Integer n, Integer n2) {
            Integer n3 = n > n2 ? -1 : 1;
            return Range.range(iScope, n, n2, n3);
        }

        @GamlAnnotations.operator(value={"range"}, content_type=1, category={"Containers-related operators"}, can_be_const=true)
        @GamlAnnotations.doc(value="a list of int representing all contiguous values from the first to the second argument, using the step represented by the third argument.", usages={@GamlAnnotations.usage(value="When used with 3 operands, it returns a list of int representing all contiguous values from the first to the second argument, using the step represented by the third argument. The range can be increasing or decreasing. Passing the same value for both will return a singleton list with this value. Passing a step of 0 will result in an exception. Attempting to build infinite ranges (e.g. end > start with a negative step) will similarly not be accepted and yield an exception", examples={@GamlAnnotations.example(value="range(0,6,2)", equals="[0,2,4,6]")})})
        public static IList range(IScope iScope, Integer n, Integer n2, Integer n3) {
            if (n3 == 0) {
                throw GamaRuntimeException.error("The step of a range should not be equal to 0", iScope);
            }
            if (n.equals(n2)) {
                return GamaListFactory.wrap((IType)Types.INT, n);
            }
            if (n2 > n) {
                if (n3 < 0) {
                    throw GamaRuntimeException.error("Negative step would result in an infinite range", iScope);
                }
            } else if (n3 > 0) {
                throw GamaRuntimeException.error("Positive step would result in an infinite range", iScope);
            }
            return (IList)IntStreamEx.rangeClosed((int)n, (int)n2, (int)n3).boxed().toCollection((Supplier)Containers.listOf(Types.INT));
        }

        @GamlAnnotations.operator(value={"every"}, content_type=-299, category={"Containers-related operators"}, can_be_const=true)
        @GamlAnnotations.doc(value="Retrieves elements from the first argument every `step` (second argument) elements. Raises an error if the step is negative or equal to zero")
        @GamlAnnotations.test(value="[1,2,3,4,5] every 2 = [1,3,5]")
        public static IList every(IScope iScope, IList iList, Integer n) {
            if (n <= 0) {
                throw GamaRuntimeException.error("The step value in `every` should be strictly positive", iScope);
            }
            return (IList)IntStreamEx.range((int)0, (int)GAML.notNull(iScope, iList).size(), (int)n).mapToObj(iList::get).toCollection(Containers.listLike(iList));
        }

        @GamlAnnotations.operator(value={"copy_between", "between"}, can_be_const=true, content_type=-299, category={"List-related operators"}, concept={"container", "list"})
        @GamlAnnotations.doc(value="Returns a copy of the first operand between the indexes determined by the second (inclusive) and third operands (exclusive)", examples={@GamlAnnotations.example(value=" copy_between ([4, 1, 6, 9 ,7], 1, 3)", equals="[1, 6]")}, usages={@GamlAnnotations.usage(value="If the first operand is empty, returns an empty object of the same type"), @GamlAnnotations.usage(value="If the second operand is greater than or equal to the third operand, return an empty object of the same type"), @GamlAnnotations.usage(value="If the first operand is nil, raises an error")})
        @GamlAnnotations.test(value="copy_between ([4, 1, 6, 9 ,7], 1, 3) = [1,6]")
        public static IList copy_between(IScope iScope, IList iList, Integer n, Integer n2) {
            int n3 = n < 0 ? 0 : n;
            int n4 = GAML.notNull(iScope, iList).size();
            int n5 = n2 > n4 ? n4 : n2;
            IList iList2 = Containers.listLike(iList).get();
            if (n3 < n5) {
                iList2.addAll(iList.subList(n3, n5));
            }
            return iList2;
        }

        @GamlAnnotations.operator(internal=true, value={"internal_between"}, can_be_const=true, content_type=-299, category={"List-related operators"}, concept={"container", "list"})
        @GamlAnnotations.doc(value="For internal use only. Corresponds to the implementation, for containers, of the access with [begin::end]", masterDoc=true)
        public static IList copy_between(IScope iScope, IList iList, GamaPair gamaPair) {
            return Range.copy_between(iScope, iList, Cast.asInt(iScope, gamaPair.key), Cast.asInt(iScope, gamaPair.value));
        }
    }
}

