/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.grid.GridTopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.IPath;
import gama.core.util.path.PathFactory;
import gama.gaml.types.Types;

public class SpatialRelations {
    @GamlAnnotations.operator(value={"towards", "direction_to"}, category={"Spatial operators", "Spatial relations operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="The direction (in degree) between the two geometries (geometries, agents, points) considering the topology of the agent applying the operator.", examples={@GamlAnnotations.example(value="ag1 towards ag2", equals="the direction between ag1 and ag2 and ag3 considering the topology of the agent applying the operator", isExecutable=false)}, see={"distance_between", "distance_to", "direction_between", "path_between", "path_to"})
    public static Double towards(IScope iScope, IShape iShape, IShape iShape2) {
        return iScope.getTopology().directionInDegreesTo(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"distance_between"}, category={"Spatial operators", "Spatial relations operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="A distance between a list of geometries (geometries, agents, points) considering a topology.", examples={@GamlAnnotations.example(value="my_topology distance_between [ag1, ag2, ag3]", equals="the distance between ag1, ag2 and ag3 considering the topology my_topology", isExecutable=false)}, see={"towards", "direction_to", "distance_to", "direction_between", "path_between", "path_to"})
    public static Double distance_between(IScope iScope, ITopology iTopology, IContainer<?, IShape> iContainer) {
        int n = iContainer.length(iScope);
        if (n == 0 || n == 1) {
            return 0.0;
        }
        IShape iShape = null;
        double d = 0.0;
        for (IShape iShape2 : iContainer.iterable(iScope)) {
            if (iShape != null) {
                Double d2 = iTopology.distanceBetween(iScope, iShape, iShape2);
                if (d2 == null) {
                    return null;
                }
                d += d2.doubleValue();
            }
            iShape = iShape2;
        }
        return d;
    }

    @GamlAnnotations.operator(value={"direction_between"}, category={"Spatial operators", "Spatial relations operators"}, concept={})
    @GamlAnnotations.doc(value="A direction (in degree) between a list of two geometries (geometries, agents, points) considering a topology.", examples={@GamlAnnotations.example(value="my_topology direction_between [ag1, ag2]", equals="the direction between ag1 and ag2 considering the topology my_topology", isExecutable=false)}, see={"towards", "direction_to", "distance_to", "distance_between", "path_between", "path_to"})
    @GamlAnnotations.test(value="topology(world) direction_between([{0,0},{50,50}]) = 45.0")
    public static Double direction_between(IScope iScope, ITopology iTopology, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        int n = iContainer.length(iScope);
        if (n == 0 || n == 1) {
            return 0.0;
        }
        IShape iShape = iContainer.firstValue(iScope);
        IShape iShape2 = iContainer.lastValue(iScope);
        return iTopology.directionInDegreesTo(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"path_between"}, type=17, content_type=-299, category={"Spatial operators", "Spatial relations operators", "Path-related operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="A path between two geometries (geometries, agents or points) considering a topology.", examples={@GamlAnnotations.example(value="my_topology path_between (ag1, ag2)", equals="A path between ag1 and ag2", isExecutable=false)}, see={"towards", "direction_to", "distance_between", "direction_between", "path_to", "distance_to"})
    public static IPath path_between(IScope iScope, ITopology iTopology, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        return iTopology.pathBetween(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"path_between"}, type=17, content_type=-299, category={"Spatial operators", "Spatial relations operators", "Path-related operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="A path between a list of several geometries (geometries, agents or points) considering a topology.", examples={@GamlAnnotations.example(value="my_topology path_between [ag1, ag2]", equals="A path between ag1 and ag2", isExecutable=false)}, see={"towards", "direction_to", "distance_between", "direction_between", "path_to", "distance_to"})
    public static IPath path_between(IScope iScope, ITopology iTopology, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        if (iContainer.isEmpty(iScope)) {
            return null;
        }
        int n = iContainer.length(iScope);
        IShape iShape = iContainer.firstValue(iScope);
        if (n == 1) {
            return PathFactory.newInstance(iScope, iScope.getTopology(), iShape, iShape, GamaListFactory.create(Types.GEOMETRY));
        }
        IShape iShape2 = iContainer.lastValue(iScope);
        if (n == 2) {
            return iTopology.pathBetween(iScope, iShape, iShape2);
        }
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        IShape iValue2 = null;
        for (IShape iValue3 : iContainer.iterable(iScope)) {
            GamaSpatialPath gamaSpatialPath;
            if (iValue2 != null && (gamaSpatialPath = iTopology.pathBetween(iScope, iValue2, iValue3)) != null && gamaSpatialPath.getEdgeList() != null) {
                iList.addAll(gamaSpatialPath.getEdgeList());
            }
            iValue2 = iValue3;
        }
        GamaSpatialPath gamaSpatialPath = PathFactory.newInstance(iScope, iTopology, iShape, iShape2, iList);
        gamaSpatialPath.setWeight(gamaSpatialPath.getVertexList().size());
        return gamaSpatialPath;
    }

    @GamlAnnotations.operator(value={"path_between"}, category={"Grid-related operators", "Path-related operators"}, concept={"grid"})
    @GamlAnnotations.doc(value="The shortest path between several objects according to set of cells", masterDoc=true, examples={@GamlAnnotations.example(value="path_between (cell_grid where each.is_free, [ag1, ag2, ag3])", equals="A path between ag1 and ag2 and ag3 passing through the given cell_grid agents", isExecutable=false)})
    public static IPath path_between(IScope iScope, IList<IAgent> iList, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty() || iContainer.isEmpty(iScope)) {
            return null;
        }
        ITopology iTopology = ((IAgent)iList.get(0)).getTopology();
        int n = iContainer.length(iScope);
        IShape iShape = iContainer.firstValue(iScope);
        if (n == 1) {
            if (iTopology instanceof GridTopology) {
                GridTopology gridTopology = (GridTopology)iTopology;
                return gridTopology.pathBetween(iScope, iShape, iShape, iList);
            }
            return iScope.getTopology().pathBetween(iScope, iShape, iShape);
        }
        IShape iShape2 = iContainer.lastValue(iScope);
        if (n == 2) {
            if (iTopology instanceof GridTopology) {
                GridTopology gridTopology = (GridTopology)iTopology;
                return gridTopology.pathBetween(iScope, iShape, iShape2, iList);
            }
            return iScope.getTopology().pathBetween(iScope, iShape, iShape2);
        }
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        IShape iShape3 = null;
        double d = 0.0;
        for (IShape iValue2 : iContainer.iterable(iScope)) {
            if (iShape3 != null) {
                if (iTopology instanceof GridTopology) {
                    GridTopology gridTopology = (GridTopology)iTopology;
                    GamaSpatialPath gamaSpatialPath = gridTopology.pathBetween(iScope, iShape3, iValue2, iList);
                    iList2.addAll(gamaSpatialPath.getEdgeList());
                    d += gamaSpatialPath.getWeight();
                } else {
                    iList2.addAll(iScope.getTopology().pathBetween(iScope, iShape3, iValue2).getEdgeList());
                }
            }
            iShape3 = iValue2;
        }
        GamaSpatialPath gamaSpatialPath = PathFactory.newInstance(iScope, iTopology instanceof GridTopology ? iTopology : iScope.getTopology(), iShape, iShape2, iList2);
        gamaSpatialPath.setWeight(iTopology instanceof GridTopology ? d : (double)gamaSpatialPath.getVertexList().size());
        return gamaSpatialPath;
    }

    @GamlAnnotations.operator(value={"path_between"}, category={"Grid-related operators", "Path-related operators"}, concept={"grid"})
    @GamlAnnotations.doc(value="The shortest path between several objects according to set of cells with corresponding weights", masterDoc=true, examples={@GamlAnnotations.example(value="path_between (cell_grid as_map (each::each.is_obstacle ? 9999.0 : 1.0), [ag1, ag2, ag3])", equals="A path between ag1 and ag2 and ag3 passing through the given cell_grid agents with minimal cost", isExecutable=false)})
    public static IPath path_between(IScope iScope, IMap<IAgent, Object> iMap, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        if (iMap == null || iMap.isEmpty() || iContainer.isEmpty(iScope)) {
            return null;
        }
        return SpatialRelations.path_between(iScope, iMap.getKeys(), iContainer);
    }

    @GamlAnnotations.operator(value={"path_between"}, category={"Grid-related operators", "Path-related operators"}, concept={"grid"})
    @GamlAnnotations.doc(value="The shortest path between two objects according to set of cells", masterDoc=true, examples={@GamlAnnotations.example(value="path_between (cell_grid where each.is_free, ag1, ag2)", equals="A path between ag1 and ag2 passing through the given cell_grid agents", isExecutable=false)})
    public static IPath path_between(IScope iScope, IList<IAgent> iList, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty() || iShape == null || iShape2 == null) {
            return null;
        }
        ITopology iTopology = ((IAgent)iList.get(0)).getTopology();
        if (iTopology instanceof GridTopology) {
            GridTopology gridTopology = (GridTopology)iTopology;
            return gridTopology.pathBetween(iScope, iShape, iShape2, iList);
        }
        return iScope.getTopology().pathBetween(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"path_between"}, category={"Grid-related operators", "Path-related operators"}, concept={"grid"})
    @GamlAnnotations.doc(value="The shortest path between two objects according to set of cells with corresponding weights", masterDoc=true, examples={@GamlAnnotations.example(value="path_between (cell_grid as_map (each::each.is_obstacle ? 9999.0 : 1.0), ag1, ag2)", equals="A path between ag1 and ag2 passing through the given cell_grid agents with a minimal cost", isExecutable=false)})
    public static IPath path_between(IScope iScope, IMap<IAgent, Object> iMap, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        if (iMap == null || iMap.isEmpty()) {
            return null;
        }
        return SpatialRelations.path_between(iScope, iMap.getKeys(), iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"distance_to"}, category={"Spatial operators", "Spatial relations operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="A distance between two geometries (geometries, agents or points) considering the topology of the agent applying the operator.", masterDoc=true, examples={@GamlAnnotations.example(value="ag1 distance_to ag2", equals="the distance between ag1 and ag2 considering the topology of the agent applying the operator", isExecutable=false)}, see={"towards", "direction_to", "distance_between", "direction_between", "path_between", "path_to"})
    public static Double distance_to(IScope iScope, IShape iShape, IShape iShape2) {
        return iScope.getTopology().distanceBetween(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"distance_to"}, category={"Spatial operators", "Spatial relations operators"})
    @GamlAnnotations.doc(value="An Euclidean distance between two points.")
    @GamlAnnotations.test(value=" {20,20} distance_to {30,30} = 14.142135623730951")
    public static Double distance_to(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        return iScope.getTopology().distanceBetween(iScope, gamaPoint, gamaPoint2);
    }

    @GamlAnnotations.operator(value={"path_to"}, type=17, category={"Spatial operators", "Spatial relations operators", "Path-related operators"}, concept={"spatial_computation", "spatial_relation", "agent_location", "topology"})
    @GamlAnnotations.doc(value="A path between two geometries (geometries, agents or points) considering the topology of the agent applying the operator.", masterDoc=true, examples={@GamlAnnotations.example(value="ag1 path_to ag2", equals="the path between ag1 and ag2 considering the topology of the agent applying the operator", isExecutable=false)}, see={"towards", "direction_to", "distance_between", "direction_between", "path_between", "distance_to"})
    public static IPath path_to(IScope iScope, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        if (iShape == null) {
            return null;
        }
        return iScope.getTopology().pathBetween(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"path_to"}, type=17, category={"Spatial operators", "Spatial relations operators", "Path-related operators"}, concept={"shortest_path"})
    @GamlAnnotations.doc(value="A shortest path between two points considering the topology of the agent applying the operator.")
    public static IPath path_to(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) throws GamaRuntimeException {
        if (gamaPoint == null) {
            return null;
        }
        return iScope.getTopology().pathBetween(iScope, gamaPoint, gamaPoint2);
    }
}

