/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.Rotation3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.graph.IGraph;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Containers;
import gama.gaml.operators.Graphs;
import gama.gaml.operators.Points;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class SpatialTransformations {
    @GamlAnnotations.operator(value={"convex_hull"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry corresponding to the convex hull of the operand.", examples={@GamlAnnotations.example(value="convex_hull(self)", equals="the convex hull of the geometry of the agent applying the operator", test=false)})
    public static IShape convex_hull(IScope iScope, IShape iShape) {
        return GamaShapeFactory.createFrom(iShape.getInnerGeometry().convexHull()).withAttributesOf(iShape);
    }

    @GamlAnnotations.operator(value={"*", "scaled_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operand a float, returns a geometry corresponding to the left-hand operand (geometry, agent, point) scaled by the right-hand operand coefficient", examples={@GamlAnnotations.example(value="circle(10) * 2", equals="circle(20)", test=false), @GamlAnnotations.example(value="(circle(10) * 2).location with_precision 9", equals="(circle(20)).location with_precision 9"), @GamlAnnotations.example(value="(circle(10) * 2).height with_precision 9", equals="(circle(20)).height with_precision 9", returnType="float")})})
    public static IShape scaled_by(IScope iScope, IShape iShape, Double d) {
        return GamaShapeFactory.createFrom(iShape).withScaling(d);
    }

    @GamlAnnotations.operator(value={"*", "scaled_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operand a point, returns a geometry corresponding to the left-hand operand (geometry, agent, point) scaled by the right-hand operand coefficients in the 3 dimensions", examples={@GamlAnnotations.example(value="shape * {0.5,0.5,2}", equals="a geometry corresponding to the geometry of the agent applying the operator scaled by a coefficient of 0.5 in x, 0.5 in y and 2 in z", test=false)})})
    @GamlAnnotations.test(value="geometry g <- cube (2);float v1 <- g.area * g.height; g <- g * {5, 5, 5};float v2 <- g.area * g.height;  v1 < v2")
    public static IShape scaled_by(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        return GamaShapeFactory.createFrom(iShape).withScaling(Scaling3D.of(gamaPoint), false);
    }

    @GamlAnnotations.operator(value={"scaled_to"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="allows to restrict the size of a geometry so that it fits in the envelope {width, height, depth} defined by the second operand", examples={@GamlAnnotations.example(value="shape scaled_to {10,10}", equals="a geometry corresponding to the geometry of the agent applying the operator scaled so that it fits a square of 10x10", test=false)})
    @GamlAnnotations.test(value="geometry g <- cube (2);float v1 <- g.area * g.height; g <- g scaled_to {20,20};float v2 <- g.area * g.height;  v1 < v2")
    public static IShape scaled_to(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        return GamaShapeFactory.createFrom(iShape).withScaling(Scaling3D.of(gamaPoint), true);
    }

    @GamlAnnotations.operator(value={"+", "buffer", "enlarged_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operands a float and an integer, returns a geometry corresponding to the left-hand operand (geometry, agent, point) enlarged by the first right-hand operand (distance), using a number of segments equal to the second right-hand operand", examples={@GamlAnnotations.example(value="circle(5) + (5,32)", equals="circle(10)", test=false)})})
    @GamlAnnotations.test(value="(circle(5) + (5,32)).height with_precision 5 = 20.0")
    public static IShape enlarged_by(IScope iScope, IShape iShape, Double d, Integer n) {
        if (iShape == null) {
            return null;
        }
        Geometry geometry = iShape.getInnerGeometry().buffer(d.doubleValue(), n.intValue());
        if (geometry != null && !geometry.isEmpty()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"+", "buffer", "enlarged_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operands a float, an integer and one of #round, #square or #flat, returns a geometry corresponding to the left-hand operand (geometry, agent, point) enlarged by the first right-hand operand (distance), using a number of segments equal to the second right-hand operand and a flat, square or round end cap style", examples={@GamlAnnotations.example(value="circle(5) + (5,32,#round)", equals="circle(10)", test=false)})})
    @GamlAnnotations.test(value="(circle(5) + (5,32,#round)).height with_precision 5 = 20.0")
    public static IShape enlarged_by(IScope iScope, IShape iShape, Double d, Integer n, Integer n2) {
        if (iShape == null) {
            return null;
        }
        Geometry geometry = iShape.getInnerGeometry().buffer(d.doubleValue(), n.intValue(), n2.intValue());
        if (geometry != null && !geometry.isEmpty()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"+", "buffer", "enlarged_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operands a float, an integer, one of #round, #square or #flat and a boolean, returns a geometry corresponding to the left-hand operand (geometry, agent, point) enlarged by the first right-hand operand (distance), using a number of segments equal to the second right-hand operand and a flat, square or round end cap style and single sided is the boolean is true", examples={@GamlAnnotations.example(value="line([{10,10}, {50,50}]) + (5,32,#round, true)", equals="A ploygon corresponding to the buffer generated", test=false)})})
    @GamlAnnotations.test(value="(line([{10,10}, {50,50}]) + (5,32,#round, true)).area with_precision 1 = 282.8")
    public static IShape enlarged_by(IScope iScope, IShape iShape, Double d, Integer n, Integer n2, Boolean bl) {
        if (iShape == null) {
            return null;
        }
        BufferParameters bufferParameters = new BufferParameters(n.intValue(), n2.intValue());
        bufferParameters.setSingleSided(bl.booleanValue());
        Geometry geometry = BufferOp.bufferOp((Geometry)iShape.getInnerGeometry(), (double)d, (BufferParameters)bufferParameters);
        if (geometry != null && !geometry.isEmpty()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"+", "buffer", "enlarged_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operands a float and a boolean, returns a geometry corresponding to the left-hand operand (geometry, agent, point) enlarged by the first right-hand operand (distance), single sided is the boolean is true", examples={@GamlAnnotations.example(value="line([{10,10}, {50,50}]) + (5, true)", equals="A ploygon corresponding to the buffer generated", test=false)})})
    @GamlAnnotations.test(value="(line([{10,10}, {50,50}]) + (5, true)).area with_precision 1 = 282.8")
    public static IShape enlarged_by(IScope iScope, IShape iShape, Double d, Boolean bl) {
        if (iShape == null) {
            return null;
        }
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setSingleSided(bl.booleanValue());
        Geometry geometry = BufferOp.bufferOp((Geometry)iShape.getInnerGeometry(), (double)d, (BufferParameters)bufferParameters);
        if (geometry != null && !geometry.isEmpty()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"+", "buffer", "enlarged_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operand a float, returns a geometry corresponding to the left-hand operand (geometry, agent, point) enlarged by the right-hand operand distance. The number of segments used by default is 8 and the end cap style is #round", examples={@GamlAnnotations.example(value="circle(5) + 5", equals="circle(10)", test=false)})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="(circle(5) + 5).height with_precision 1 = 20.0"), @GamlAnnotations.test(value="(circle(5) + 5).location with_precision 9 = (circle(10)).location with_precision 9")})
    public static IShape enlarged_by(IScope iScope, IShape iShape, Double d) {
        if (iShape == null) {
            return null;
        }
        Geometry geometry = iShape.getInnerGeometry().buffer(d.doubleValue());
        if (geometry != null && !geometry.isEmpty()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"-", "reduced_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a geometry and the right-hand operand a float, returns a geometry corresponding to the left-hand operand (geometry, agent, point) reduced by the right-hand operand distance", examples={@GamlAnnotations.example(value="shape - 5", equals="a geometry corresponding to the geometry of the agent applying the operator reduced by a distance of 5", test=false)})})
    @GamlAnnotations.test(value="(square(20) - 5).area = 100.0")
    public static IShape reduced_by(IScope iScope, IShape iShape, Double d) {
        if (iShape == null) {
            return null;
        }
        return SpatialTransformations.enlarged_by(iScope, iShape, -d.doubleValue());
    }

    @GamlAnnotations.operator(value={"rotated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry resulting from the application of a rotation by the right-hand operand angle (degree) to the left-hand operand (geometry, agent, point)", masterDoc=true, examples={@GamlAnnotations.example(value="self rotated_by 45", equals="the geometry resulting from a 45 degrees rotation to the geometry of the agent applying the operator.", test=false)}, see={"transformed_by", "translated_by"})
    @GamlAnnotations.test(value="(( square(5) rotated_by 45).width with_precision 2 = 7.07)")
    public static IShape rotated_by(IScope iScope, IShape iShape, Double d) {
        if (iShape == null) {
            return null;
        }
        return GamaShapeFactory.createFrom(iShape).withRotation(new AxisAngle(d));
    }

    @GamlAnnotations.operator(value={"inverse_rotation"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="The inverse rotation. It is a rotation around the same axis with the opposite angle.", masterDoc=true, examples={@GamlAnnotations.example(value="inverse_rotation(38.0::{1,1,1})", equals="-38.0::{1,1,1}", test=false)}, see={"rotation_composition, normalized_rotation"})
    @GamlAnnotations.test(value="inverse_rotation(38.0::{1,1,1}) = (-38.0::{1,1,1})")
    public static GamaPair<Double, GamaPoint> inverse_rotation(IScope iScope, GamaPair<Double, GamaPoint> gamaPair) {
        return new GamaPair<Double, GamaPoint>(-((Double)gamaPair.key).doubleValue(), (GamaPoint)gamaPair.value, Types.FLOAT, Types.POINT);
    }

    @GamlAnnotations.operator(value={"normalized_rotation"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="The rotation normalized according to Euler formalism with a positive angle, such that each rotation has a unique set of parameters (positive angle, normalize axis rotation).", masterDoc=true, examples={@GamlAnnotations.example(value="normalized_rotation(-38.0::{1,1,1})", equals="38.0::{-0.5773502691896258,-0.5773502691896258,-0.5773502691896258}", test=false)}, see={"rotation_composition, inverse_rotation"})
    @GamlAnnotations.test(value="normalized_rotation(-38::{1,1,1})=(38.0::{-0.5773502691896258,-0.5773502691896258,-0.5773502691896258})")
    public static GamaPair<Double, GamaPoint> normalized_rotation(IScope iScope, GamaPair gamaPair) {
        GamaPair gamaPair2 = (GamaPair)GamaType.from(Types.PAIR, Types.FLOAT, Types.POINT).cast(iScope, gamaPair, null, false);
        GamaPoint gamaPoint = (GamaPoint)gamaPair2.getValue();
        double d = Math.sqrt(gamaPoint.x * gamaPoint.x + gamaPoint.y * gamaPoint.y + gamaPoint.z * gamaPoint.z);
        gamaPoint.x = Math.signum((Double)gamaPair2.getKey()) * gamaPoint.x / d;
        gamaPoint.y = Math.signum((Double)gamaPair2.getKey()) * gamaPoint.y / d;
        gamaPoint.z = Math.signum((Double)gamaPair2.getKey()) * gamaPoint.z / d;
        return new GamaPair<Double, GamaPoint>(Math.signum((Double)gamaPair2.getKey()) * (Double)gamaPair2.getKey(), gamaPoint, Types.FLOAT, Types.POINT);
    }

    @GamlAnnotations.operator(value={"rotation_composition"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="The rotation resulting from the composition of the rotations in the list, from left to right. Angles are in degrees.", masterDoc=true, examples={@GamlAnnotations.example(value="rotation_composition([38.0::{1,1,1},90.0::{1,0,0}])", equals="115.22128507898108::{0.9491582126366207,0.31479943993669307,-0.0}", test=false)}, see={"inverse_rotation"})
    @GamlAnnotations.test(value="normalized_rotation(rotation_composition(38.0::{1,1,1},90.0::{1,0,0}))=normalized_rotation(115.22128507898108::{0.9491582126366207,0.31479943993669307,-0.0})")
    public static GamaPair<Double, GamaPoint> rotation_composition(IScope iScope, IList<GamaPair> iList) {
        Rotation3D rotation3D = new Rotation3D(new GamaPoint(1.0, 0.0, 0.0), 0.0);
        for (GamaPair gamaPair : iList) {
            GamaPair gamaPair2 = (GamaPair)GamaType.from(Types.PAIR, Types.FLOAT, Types.POINT).cast(iScope, gamaPair, null, false);
            rotation3D = rotation3D.applyTo(new Rotation3D((GamaPoint)gamaPair2.value, Math.PI / 180 * (Double)gamaPair2.key));
        }
        return new GamaPair<Double, GamaPoint>(57.29577951308232 * rotation3D.getAngle(), rotation3D.getAxis(), Types.FLOAT, Types.POINT);
    }

    @GamlAnnotations.operator(value={"rotated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry resulting from the application of a rotation by the operand angles (degree) along the operand axis (last operand) to the left-hand operand (geometry, agent, point)", masterDoc=true, examples={@GamlAnnotations.example(value="rotated_by(pyramid(10),45.0, {1,0,0})", equals="the geometry resulting from a 45 degrees rotation along the {1,0,0} vector to the geometry of the agent applying the operator.", test=false)}, see={"transformed_by", "translated_by"})
    public static IShape rotated_by(IScope iScope, IShape iShape, Double d, GamaPoint gamaPoint) {
        if (iShape == null) {
            return null;
        }
        if (gamaPoint.x == 0.0 && gamaPoint.y == 0.0 && gamaPoint.z == 0.0) {
            return iShape;
        }
        return GamaShapeFactory.createFrom(iShape).withRotation(new AxisAngle(gamaPoint, d)).withLocation(iShape.getLocation());
    }

    @GamlAnnotations.operator(value={"rotated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="When used  with a  point and  a pair angle::point, it returns a point resulting from the application of the right-hand rotation operand (angles in degree) to the left-hand operand point")})
    public static GamaPoint rotated_by(IScope iScope, GamaPoint gamaPoint, GamaPair gamaPair) {
        if (gamaPoint == null) {
            return null;
        }
        GamaPair gamaPair2 = (GamaPair)GamaType.from(Types.PAIR, Types.FLOAT, Types.POINT).cast(iScope, gamaPair, null, false);
        GamaPoint gamaPoint2 = new GamaPoint(gamaPoint);
        new Rotation3D((GamaPoint)gamaPair2.getValue(), Math.PI / 180 * (Double)gamaPair2.getKey()).applyTo(gamaPoint2);
        return gamaPoint2;
    }

    @GamlAnnotations.operator(value={"rotated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="rotated_by(pyramid(10),45.0::{1,0,0})", equals="the geometry resulting from a 45 degrees rotation along the {1,0,0} vector to the geometry of the agent applying the operator.", test=false)}, see={"transformed_by", "translated_by"})
    public static IShape rotated_by(IScope iScope, IShape iShape, GamaPair gamaPair) {
        GamaPair gamaPair2 = (GamaPair)GamaType.from(Types.PAIR, Types.FLOAT, Types.POINT).cast(iScope, gamaPair, null, false);
        if (iShape == null || gamaPair2 == null) {
            return null;
        }
        return GamaShapeFactory.createFrom(iShape).withRotation(new AxisAngle((GamaPoint)gamaPair2.getValue(), (Double)gamaPair2.getKey())).withLocation(iShape.getLocation());
    }

    @GamlAnnotations.operator(value={"rotated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="the right-hand operand representing  the angle can be a float or an integer")})
    public static IShape rotated_by(IScope iScope, IShape iShape, Integer n) {
        if (iShape == null) {
            return null;
        }
        if (n == null) {
            return iShape.copy(iScope);
        }
        return GamaShapeFactory.createFrom(iShape).withRotation(new AxisAngle(n.doubleValue()));
    }

    @GamlAnnotations.operator(value={"transformed_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry resulting from the application of a rotation and a scaling (right-operand : point {angle(degree), scale factor} of the left-hand operand (geometry, agent, point)", examples={@GamlAnnotations.example(value="self transformed_by {45, 0.5}", equals="the geometry resulting from 45 degrees rotation and 50% scaling of the geometry of the agent applying the operator.", test=false)}, see={"rotated_by", "translated_by"})
    public static IShape transformed_by(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        if (iShape == null) {
            return null;
        }
        return SpatialTransformations.scaled_by(iScope, SpatialTransformations.rotated_by(iScope, iShape, gamaPoint.x), gamaPoint.y);
    }

    @GamlAnnotations.operator(value={"translated_by"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry resulting from the application of a translation by the right-hand operand distance to the left-hand operand (geometry, agent, point)", examples={@GamlAnnotations.example(value="self translated_by {10,10,10}", equals="the geometry resulting from applying the translation to the left-hand geometry (or agent).", test=false)}, see={"rotated_by", "transformed_by"})
    public static IShape translated_by(IScope iScope, IShape iShape, GamaPoint gamaPoint) throws GamaRuntimeException {
        if (iShape == null) {
            return null;
        }
        return SpatialTransformations.at_location(iScope, iShape, Points.add(iShape.getLocation(), gamaPoint));
    }

    @GamlAnnotations.operator(value={"at_location", "translated_to"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "agent_location"})
    @GamlAnnotations.doc(value="A geometry resulting from the tran of a translation to the right-hand operand point of the left-hand operand (geometry, agent, point)", examples={@GamlAnnotations.example(value="self at_location {10, 20}", equals="the geometry resulting from a translation to the location {10, 20} of the left-hand geometry (or agent).", test=false), @GamlAnnotations.example(value=" (box({10, 10 , 5}) at_location point(50,50,0)).location.x", equals="50.0", returnType="float")})
    public static IShape at_location(IScope iScope, IShape iShape, GamaPoint gamaPoint) throws GamaRuntimeException {
        if (iShape == null) {
            return null;
        }
        return GamaShapeFactory.createFrom(iShape).withLocation(gamaPoint);
    }

    @GamlAnnotations.operator(value={"without_holes", "solid"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "agent_location"})
    @GamlAnnotations.doc(value="A geometry corresponding to the operand geometry (geometry, agent, point) without its holes", examples={@GamlAnnotations.example(value="solid(self)", equals="the geometry corresponding to the geometry of the agent applying the operator without its holes.", test=false), @GamlAnnotations.example(value="without_holes(polygon([{0,50}, {0,0}, {50,0}, {50,50}, {0,50}]) - square(10) at_location {10,10}).area", equals="2500.0", returnType="float")})
    public static IShape without_holes(IScope iScope, IShape iShape) {
        Geometry geometry;
        if (iShape == null) {
            return null;
        }
        Geometry geometry2 = geometry = iShape.getInnerGeometry();
        if (geometry instanceof Polygon) {
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createPolygon(GeometryUtils.GEOMETRY_FACTORY.createLinearRing(((Polygon)geometry).getExteriorRing().getCoordinates()), null);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            Polygon[] polygonArray = new Polygon[multiPolygon.getNumGeometries()];
            int n = 0;
            while (n < multiPolygon.getNumGeometries()) {
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
                polygonArray[n] = GeometryUtils.GEOMETRY_FACTORY.createPolygon(GeometryUtils.GEOMETRY_FACTORY.createLinearRing(polygon.getExteriorRing().getCoordinates()), null);
                ++n;
            }
            geometry2 = GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray);
        }
        return GamaShapeFactory.createFrom(geometry2).withAttributesOf(iShape);
    }

    @GamlAnnotations.operator(value={"skeletonize"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="It can be used with 2 additional float operands: the tolerances for the clipping and for the triangulation")})
    public static IList<IShape> skeletonize(IScope iScope, IShape iShape, Double d, Double d2) {
        List<LineString> list = GeometryUtils.squeletisation(iScope, iShape.getInnerGeometry(), d2, d, false);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        for (LineString lineString : list) {
            iList.add(GamaShapeFactory.createFrom((Geometry)lineString));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"skeletonize"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="It can be used with 3 additional float operands: the tolerance for the clipping, the  tolerance for the triangulation, and the approximation for the clipping.")})
    public static IList<IShape> skeletonize(IScope iScope, IShape iShape, Double d, Double d2, boolean bl) {
        List<LineString> list = GeometryUtils.squeletisation(iScope, iShape.getInnerGeometry(), d2, d, bl);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        for (LineString lineString : list) {
            iList.add(GamaShapeFactory.createFrom((Geometry)lineString));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"skeletonize"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="It can be used with 1 additional float operand: the tolerance for the clipping.")})
    public static IList<IShape> skeletonize(IScope iScope, IShape iShape, Double d) {
        List<LineString> list = GeometryUtils.squeletisation(iScope, iShape.getInnerGeometry(), 0.0, d, false);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        for (LineString lineString : list) {
            iList.add(GamaShapeFactory.createFrom((Geometry)lineString));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"skeletonize"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (polylines) corresponding to the skeleton of the operand geometry (geometry, agent)", masterDoc=true, examples={@GamlAnnotations.example(value="skeletonize(self)", equals="the list of geometries corresponding to the skeleton of the geometry of the agent applying the operator.", test=false)})
    @GamlAnnotations.test(value=" // applies only to a square \n length(skeletonize(square(5))) = 1")
    public static IList<IShape> skeletonize(IScope iScope, IShape iShape) {
        List<LineString> list = GeometryUtils.squeletisation(iScope, iShape.getInnerGeometry(), 0.0, 0.0, false);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        for (LineString lineString : list) {
            iList.add(GamaShapeFactory.createFrom((Geometry)lineString));
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation of the operand geometry (geometry, agent, point)", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate(self)", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IShape iShape) {
        if (iShape == null) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iShape.getInnerGeometry(), 0.0, 0.0, false);
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation of the operand geometry (geometry, agent, point) with the given tolerance for the clipping", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate(self, 0.1)", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IShape iShape, Double d) {
        if (iShape == null) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iShape.getInnerGeometry(), 0.0, d, false);
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation computed from the list of polylines", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate([line([{0,50},{100,50}]), line([{50,0},{50,100}]))", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IList<IShape> iList) {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iList, 0.0);
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation computed from the list of polylines with the given tolerance for the triangulation", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate([line([{0,50},{100,50}]), line([{50,0},{50,100}], 0.01))", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator with the a tolerance of 0.01 for the triangulation.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IList<IShape> iList, double d) {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iList, d);
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation of the operand geometry (geometry, agent, point) with the given tolerance for the clipping and for the triangulation", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate(self,0.1, 1.0)", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IShape iShape, Double d, Double d2) {
        if (iShape == null) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iShape.getInnerGeometry(), d2, d, false);
    }

    @GamlAnnotations.operator(value={"triangulate", "to_triangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries (triangles) corresponding to the Delaunay triangulation of the operand geometry (geometry, agent, point, use_approx_clipping) with the given tolerance for the clipping and for the triangulation with using an approximate clipping is the last operand is true", masterDoc=true, examples={@GamlAnnotations.example(value="triangulate(self,0.1, 1.0, true)", equals="the list of geometries (triangles) corresponding to the Delaunay triangulation of the geometry of the agent applying the operator.", test=false)})
    public static IList<IShape> triangulate(IScope iScope, IShape iShape, Double d, Double d2, boolean bl) {
        if (iShape == null) {
            return null;
        }
        return GeometryUtils.triangulation(iScope, iShape.getInnerGeometry(), d2, d, bl);
    }

    @GamlAnnotations.operator(value={"voronoi"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries corresponding to the Voronoi diagram built from the list of points (with eventually a given  clip).", masterDoc=true, examples={@GamlAnnotations.example(value="voronoi([{10,10},{50,50},{90,90},{10,90},{90,10}])", equals="the list of geometries corresponding to the Voronoi Diagram built from the list of points.", test=false)})
    public static IList<IShape> vornoi(IScope iScope, IList<GamaPoint> iList) {
        if (iList == null) {
            return null;
        }
        return GeometryUtils.voronoi(iScope, iList);
    }

    @GamlAnnotations.operator(value={"voronoi"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of geometries corresponding to the Voronoi diagram built from the list of points according to the given clip", examples={@GamlAnnotations.example(value="voronoi([{10,10},{50,50},{90,90},{10,90},{90,10}], square(300))", equals="the list of geometries corresponding to the Voronoi Diagram built from the list of points with a square of 300m side size as clip.", test=false)})
    public static IList<IShape> vornoi(IScope iScope, IList<GamaPoint> iList, IShape iShape) {
        if (iList == null) {
            return null;
        }
        return GeometryUtils.voronoi(iScope, iList, iShape);
    }

    @GamlAnnotations.operator(value={"smooth"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="Returns a 'smoothed' geometry, where straight lines are replaces by polynomial (bicubic) curves. The first parameter is the original geometry, the second is the 'fit' parameter which can be in the range 0 (loose fit) to 1 (tightest fit).", masterDoc=true, examples={@GamlAnnotations.example(value="smooth(square(10), 0.0)", equals="a 'rounded' square", test=false)})
    public static IShape smooth(IScope iScope, IShape iShape, Double d) {
        if (iShape == null) {
            return null;
        }
        double d2 = d == null ? 0.0 : (d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d));
        return GeometryUtils.smooth(iShape.getInnerGeometry(), d2);
    }

    @GamlAnnotations.operator(value={"to_squares"}, type=5, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of squares of the size corresponding to the given size that result from the decomposition of the geometry into squares (geometry, size, overlaps), if overlaps = true, add the squares that overlap the border of the geometry", examples={@GamlAnnotations.example(value="to_squares(self, 10.0, true)", equals="the list of squares of side size 10.0 corresponding to the discretization into squares of the geometry of the agent applying the operator. The squares overlapping the border of the geometry are kept", test=false)})
    public static IList<IShape> toSquares(IScope iScope, IShape iShape, Double d, boolean bl) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.discretization(iShape.getInnerGeometry(), d, d, bl);
    }

    @GamlAnnotations.operator(value={"to_squares"}, type=5, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of a given number of squares from the decomposition of the geometry into squares (geometry, nb_square, overlaps), if overlaps = true, add the squares that overlap the border of the geometry", examples={@GamlAnnotations.example(value="to_squares(self, 10, true)", equals="the list of 10 squares corresponding to the discretization into squares of the geometry of the agent applying the operator. The squares overlapping the border of the geometry are kept", test=false)})
    public static IList<IShape> toSquares(IScope iScope, IShape iShape, Integer n, boolean bl) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.squareDiscretization(iShape.getInnerGeometry(), n, bl, 0.99);
    }

    @GamlAnnotations.operator(value={"to_squares"}, type=5, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of a given number of squares from the decomposition of the geometry into squares (geometry, nb_square, overlaps, precision_coefficient), if overlaps = true, add the squares that overlap the border of the geometry, coefficient_precision should be close to 1.0", examples={@GamlAnnotations.example(value="to_squares(self, 10, true, 0.99)", equals="the list of 10 squares corresponding to the discretization into squares of the geometry of the agent applying the operator. The squares overlapping the border of the geometry are kept", test=false)})
    public static IList<IShape> squareDiscretization(IScope iScope, IShape iShape, Integer n, boolean bl, double d) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.squareDiscretization(iShape.getInnerGeometry(), n, bl, d);
    }

    @GamlAnnotations.operator(value={"to_rectangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of rectangles of the size corresponding to the given dimension that result from the decomposition of the geometry into rectangles (geometry, dimension, overlaps), if overlaps = true, add the rectangles that overlap the border of the geometry", masterDoc=true, examples={@GamlAnnotations.example(value="to_rectangles(self, {10.0, 15.0}, true)", equals="the list of rectangles of size {10.0, 15.0} corresponding to the discretization into rectangles of the geometry of the agent applying the operator. The rectangles overlapping the border of the geometry are kept", test=false)})
    public static IList<IShape> to_rectangle(IScope iScope, IShape iShape, GamaPoint gamaPoint, boolean bl) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.discretization(iShape.getInnerGeometry(), gamaPoint.x, gamaPoint.y, bl);
    }

    @GamlAnnotations.operator(value={"to_rectangles"}, type=5, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of rectangles corresponding to the given dimension that result from the decomposition of the geometry into rectangles (geometry, nb_cols, nb_rows, overlaps) by a grid composed of the given number of columns and rows, if overlaps = true, add the rectangles that overlap the border of the geometry", examples={@GamlAnnotations.example(value="to_rectangles(self, 5, 20, true)", equals="the list of rectangles corresponding to the discretization by a grid of 5 columns and 20 rows into rectangles of the geometry of the agent applying the operator. The rectangles overlapping the border of the geometry are kept", test=false)})
    public static IList<IShape> to_rectangle(IScope iScope, IShape iShape, int n, int n2, boolean bl) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        Envelope3D envelope3D = iShape.getEnvelope();
        double d = envelope3D.getWidth() / (double)n;
        double d2 = envelope3D.getHeight() / (double)n2;
        return GeometryUtils.discretization(iShape.getInnerGeometry(), d, d2, bl);
    }

    @GamlAnnotations.operator(value={"split_geometry", "to_squares"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries that result from the decomposition of the geometry by square cells of the given side size (geometry, size). It can be used to split in rectangles by giving a point or 2 integer values as operand.", masterDoc=true, examples={@GamlAnnotations.example(value="to_squares(self, 10.0)", equals="the list of the geometries corresponding to the decomposition of the geometry by squares of side size 10.0", test=false)})
    @GamlAnnotations.test(value="length(square(10.0) split_geometry(3)) = 16")
    public static IList<IShape> toSquares(IScope iScope, IShape iShape, Double d) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.geometryDecomposition(iShape, d, d);
    }

    @GamlAnnotations.operator(value={"split_geometry", "to_rectangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries that result from the decomposition of the geometry by rectangle cells of the given dimension (geometry, {size_x, size_y})", examples={@GamlAnnotations.example(value="to_rectangles(self, {10.0, 15.0})", equals="the list of the geometries corresponding to the decomposition of the geometry by rectangles of size 10.0, 15.0", test=false)})
    @GamlAnnotations.test(value="length(square(10.0) split_geometry({2,3})) = 20")
    public static IList<IShape> toRectangle(IScope iScope, IShape iShape, GamaPoint gamaPoint) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        return GeometryUtils.geometryDecomposition(iShape, gamaPoint.x, gamaPoint.y);
    }

    @GamlAnnotations.operator(value={"split_geometry", "to_rectangles"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of geometries that result from the decomposition of the geometry according to a grid with the given number of rows and columns (geometry, nb_cols, nb_rows)", examples={@GamlAnnotations.example(value="to_rectangles(self, 10,20)", equals="the list of the geometries corresponding to the decomposition of the geometry of the agent applying the operator", test=false)})
    @GamlAnnotations.test(value="length(square(10.0) split_geometry(2,2)) = 4")
    public static IList<IShape> to_rectangle(IScope iScope, IShape iShape, int n, int n2) {
        if (iShape == null || iShape.getInnerGeometry().getArea() <= 0.0) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        Envelope3D envelope3D = iShape.getEnvelope();
        double d = envelope3D.getWidth() / (double)n;
        double d2 = envelope3D.getHeight() / (double)n2;
        return GeometryUtils.geometryDecomposition(iShape, d, d2);
    }

    /*
     * WARNING - void declaration
     */
    @GamlAnnotations.operator(value={"to_segments"}, type=5, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={})
    @GamlAnnotations.doc(value="A list of a segments resulting from the decomposition of the geometry (or its contours for polygons) into sgements", examples={@GamlAnnotations.example(value="to_segments(line([{10,10},{80,10},{80,80}]))", equals="[line([{10,10},{80,10}]), line([{80,10},{80,80}])]", test=false)})
    public static IList<IShape> toSegments(IScope iScope, IShape iShape) {
        if (iShape == null) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (iShape.isMultiple()) {
            for (IShape iShape2 : iShape.getGeometries()) {
                iList.addAll(SpatialTransformations.toSegments(iScope, iShape2));
            }
        } else if (iShape.isPoint()) {
            iList.add(GamaShapeFactory.createFrom(iShape));
        } else {
            void var3_7;
            boolean n = true;
            while (var3_7 < iShape.getPoints().size()) {
                IList<IShape> iList2 = GamaListFactory.create(Types.POINT);
                iList2.add((IShape)iShape.getPoints().get((int)(var3_7 - true)));
                iList2.add((IShape)iShape.getPoints().get((int)var3_7));
                iList.add(SpatialCreation.line(iScope, iList2));
                ++var3_7;
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"as_hexagonal_grid"}, content_type=13, category={"Spatial operators", "Spatial transformations operators", "Grid-related operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "grid"})
    @GamlAnnotations.doc(value="A list of geometries (hexagonal) corresponding to the hexagonal tesselation of the first operand geometry", examples={@GamlAnnotations.example(value="self as_hexagonal_grid {10, 5}", equals="list of geometries (hexagonal) corresponding to the hexagonal tesselation of the first operand geometry", test=false)}, see={"as_4_grid", "as_grid"})
    public static IList<IShape> as_hexagonal_grid(IShape iShape, GamaPoint gamaPoint) {
        return GeometryUtils.hexagonalGridFromGeom(iShape, (int)gamaPoint.x, (int)gamaPoint.y);
    }

    @GamlAnnotations.operator(value={"as_grid"}, content_type=13, category={"Spatial operators", "Spatial transformations operators", "Grid-related operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "grid"})
    @GamlAnnotations.doc(value="A matrix of square geometries (grid with 8-neighborhood) with dimension given by the right-hand operand ({nb_cols, nb_lines}) corresponding to the square tessellation of the left-hand operand geometry (geometry, agent)", examples={@GamlAnnotations.example(value="self as_grid {10, 5}", equals="a matrix of square geometries (grid with 8-neighborhood) with 10 columns and 5 lines corresponding to the square tessellation of the geometry of the agent applying the operator.", test=false)}, see={"as_4_grid", "as_hexagonal_grid"})
    public static IMatrix as_grid(IScope iScope, IShape iShape, GamaPoint gamaPoint) throws GamaRuntimeException {
        return new GamaSpatialMatrix(iScope, iShape, (int)gamaPoint.x, (int)gamaPoint.y, false, false, false, false, "");
    }

    @GamlAnnotations.operator(value={"as_4_grid"}, content_type=13, category={"Spatial operators", "Spatial transformations operators", "Grid-related operators"}, concept={"geometry", "spatial_computation", "spatial_transformation", "grid"})
    @GamlAnnotations.doc(value="A matrix of square geometries (grid with 4-neighborhood) with dimension given by the right-hand operand ({nb_cols, nb_lines}) corresponding to the square tessellation of the left-hand operand geometry (geometry, agent)", examples={@GamlAnnotations.example(value="self as_4_grid {10, 5}", equals="the matrix of square geometries (grid with 4-neighborhood) with 10 columns and 5 lines corresponding to the square tessellation of the geometry of the agent applying the operator.", test=false)}, see={"as_grid", "as_hexagonal_grid"})
    public static IMatrix as_4_grid(IScope iScope, IShape iShape, GamaPoint gamaPoint) throws GamaRuntimeException {
        return new GamaSpatialMatrix(iScope, iShape, (int)gamaPoint.x, (int)gamaPoint.y, false, true, false, false, "");
    }

    @GamlAnnotations.operator(value={"to_sub_geometries"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries resulting after spliting the geometry into sub-geometries.", masterDoc=true, examples={@GamlAnnotations.example(value="to_sub_geometries(rectangle(10, 50), [0.1, 0.5, 0.4])", equals="a list of three geometries corresponding to 3 sub-geometries", test=false)})
    @GamlAnnotations.test(value="length(to_sub_geometries(rectangle(10, 50), [0.1, 0.5, 0.4])) = 3")
    public static IList<IShape> splitGeometries(IScope iScope, IShape iShape, IList<Double> iList) {
        if (iShape == null) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        double d = iShape.getArea() / 2000.0;
        return SpatialTransformations.splitGeometries(iScope, iShape, iList, d);
    }

    @GamlAnnotations.operator(value={"to_sub_geometries"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries resulting after spliting the geometry into sub-geometries.", examples={@GamlAnnotations.example(value="to_sub_geometries(rectangle(10, 50), [0.1, 0.5, 0.4], 1.0)", equals="a list of three geometries corresponding to 3 sub-geometries using cubes of 1m size", test=false)})
    public static IList<IShape> splitGeometries(IScope iScope, IShape iShape3, IList<Double> iList, Double d) throws GamaRuntimeException {
        if (iShape3 == null || iList == null || iList.isEmpty()) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        if (iShape3.isPoint()) {
            iList2.add(iShape3.copy(iScope));
        } else if (iShape3.isLine()) {
            IList<Double> iList3 = GamaListFactory.create(Types.FLOAT);
            Double d2 = (Double)Containers.sum(iScope, iList);
            double d3 = 0.0;
            int n = 0;
            while (n < iList.size() - 1) {
                iList3.add((d3 += ((Double)iList.get(n)).doubleValue()) / d2);
                ++n;
            }
            IList iList4 = SpatialPunctal.points_along(iShape3, iList3);
            IShape iShape4 = iShape3.copy(iScope);
            for (GamaPoint gamaPoint : iList4) {
                IList<IShape> iList5 = SpatialOperators.split_at(iShape4, gamaPoint);
                iList2.add((IShape)iList5.get(0));
                iShape4 = (IShape)iList5.get(1);
            }
            iList2.add(iShape4);
        } else if (iShape3.getArea() > 0.0) {
            Comparator comparator = iShape3.getWidth() > iShape3.getHeight() ? (iShape, iShape2) -> Double.compare(iShape.getLocation().getX(), iShape2.getLocation().getX()) : (iShape, iShape2) -> Double.compare(iShape.getLocation().getY(), iShape2.getLocation().getY());
            ArrayList arrayList = new ArrayList(SpatialTransformations.toSquares(iScope, iShape3, d).stream().sorted(comparator).toList());
            Double d4 = (Double)Containers.sum(iScope, iList);
            int n = arrayList.size();
            for (Double d5 : iList) {
                int n2 = Math.min((int)(d5 / d4 * (double)n + 0.5), n);
                IList<IShape> iList6 = GamaListFactory.create(Types.GEOMETRY);
                int n3 = 0;
                while (n3 < n2) {
                    iList6.add((IShape)arrayList.remove(0));
                    ++n3;
                }
                if (iList6.isEmpty()) continue;
                IShape iShape5 = SpatialTransformations.clean(iScope, SpatialOperators.union(iScope, iList6));
                iList2.add(iShape5);
            }
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"split_lines"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries resulting after cutting the lines at their intersections.", examples={@GamlAnnotations.example(value="split_lines([line([{0,10}, {20,10}]), line([{0,10}, {20,10}])])", equals="a list of four polylines: line([{0,10}, {10,10}]), line([{10,10}, {20,10}]), line([{10,0}, {10,10}]) and line([{10,10}, {10,20}])", test=false)})
    @GamlAnnotations.test(value="split_lines([line([{0,10}, {20,10}]), line([{10,0}, {10,20}])]) = [line([{0,10}, {10,10}]), line([{10,10}, {20,10}]), line([{10,0}, {10,10}]) , line([{10,10}, {10,20}])]")
    public static IList<IShape> split_lines(IScope iScope, IContainer<?, IShape> iContainer) throws GamaRuntimeException {
        if (iContainer.isEmpty(iScope)) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        IShape iShape = SpatialOperators.union(iScope, iContainer);
        Geometry geometry = iShape.getInnerGeometry();
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        int n = 0;
        int n2 = geometry.getNumGeometries();
        while (n < n2) {
            Geometry geometry2 = geometry.getGeometryN(n);
            if (geometry2 instanceof LineString) {
                iList.add(GamaShapeFactory.createFrom(geometry2));
            }
            ++n;
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"split_lines"}, content_type=13, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of geometries resulting after cutting the lines at their intersections. if the last boolean operand is set to true, the split lines will import the attributes of the initial lines", examples={@GamlAnnotations.example(value="split_lines([line([{0,10}, {20,10}]), line([{0,10}, {20,10}])])", equals="a list of four polylines: line([{0,10}, {10,10}]), line([{10,10}, {20,10}]), line([{10,0}, {10,10}]) and line([{10,10}, {10,20}])", test=false)})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="split_lines([line({10,10}, {20,20}), line({10.0,20.0,0.0},{15.0,15.0,0.0})]) = [line ({10.0,10.0,0.0},{15.0,15.0,0.0}), line({15.0,15.0,0.0},{20.0,20.0,0.0}), line({10.0,20.0,0.0},{15.0,15.0,0.0})]"), @GamlAnnotations.test(value="length(split_lines([line({10,10}, {20,20}), line({10.0,20.0,0.0},{15.0,15.0,0.0})])) = 3")})
    public static IList<IShape> split_lines(IScope iScope, IContainer<?, IShape> iContainer, boolean bl) throws GamaRuntimeException {
        if (iContainer.isEmpty(iScope)) {
            return GamaListFactory.create(Types.GEOMETRY);
        }
        if (!bl) {
            return SpatialTransformations.split_lines(iScope, iContainer);
        }
        boolean bl2 = true;
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        iList.addAll((Collection)((Object)iContainer));
        IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
        block0: while (bl2) {
            bl2 = false;
            IList<IShape> iList3 = GamaListFactory.createWithoutCasting((IType)Types.GEOMETRY, iList);
            for (IShape iShape2 : iList) {
                Object object;
                Object object2;
                IValue iValue;
                Object object3;
                IValue iValue2;
                iList3.remove(iShape2);
                if (!iShape2.getInnerGeometry().isSimple()) {
                    iValue2 = GamaListFactory.create(Types.GEOMETRY);
                    int n = 0;
                    while (n < iShape2.getPoints().size() - 1) {
                        object3 = GamaListFactory.create(Types.POINT);
                        object3.add((IShape)iShape2.getPoints().get(n));
                        object3.add((IShape)iShape2.getPoints().get(n + 1));
                        iValue2.add((IShape)SpatialCreation.line(iScope, object3));
                        ++n;
                    }
                    iValue = SpatialOperators.union(iScope, iValue2);
                    object3 = iValue.getInnerGeometry();
                    int n2 = 0;
                    int n3 = object3.getNumGeometries();
                    while (n2 < n3) {
                        object2 = object3.getGeometryN(n2);
                        if (object2 instanceof LineString) {
                            object = GamaShapeFactory.createFrom((Geometry)object2);
                            object.copyAttributesOf(iShape2);
                            iList3.add(GamaShapeFactory.createFrom((Geometry)object2));
                        }
                        ++n2;
                    }
                    bl2 = true;
                    iList = iList3;
                    continue block0;
                }
                iValue2 = SpatialTransformations.enlarged_by(iScope, iShape2, (Double)Math.min(0.001, iShape2.getPerimeter() / 1000.0), 10);
                IValue iValue3 = iValue = iValue2 == null ? GamaListFactory.create() : SpatialQueries.overlapping(iScope, iList3, iValue2);
                if (!iValue.isEmpty()) {
                    object3 = iShape2.getPoints().firstValue(iScope);
                    GamaPoint gamaPoint = iShape2.getPoints().lastValue(iScope);
                    PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)iValue2.getInnerGeometry());
                    object = iValue.iterator();
                    while (object.hasNext()) {
                        IShape iShape3;
                        object2 = (IShape)object.next();
                        if (preparedGeometry.covers(object2.getInnerGeometry()) || preparedGeometry.coveredBy(object2.getInnerGeometry()) || (iShape3 = SpatialOperators.inter(iScope, iShape2, (IShape)object2)) == null || iShape3.getPerimeter() > 0.0 || iShape3.getLocation().equals(object3) && iShape3.getLocation().equals(gamaPoint)) continue;
                        GamaPoint gamaPoint2 = iShape3.getPoints().firstValue(iScope);
                        IList<IShape> iList4 = SpatialOperators.split_at((IShape)object2, gamaPoint2);
                        iList4.removeIf(iShape -> iShape.getPerimeter() == 0.0);
                        IList<IShape> iList5 = SpatialOperators.split_at(iShape2, gamaPoint2);
                        iList5.removeIf(iShape -> iShape.getPerimeter() == 0.0);
                        if (iList4.size() <= 1 && iList5.size() <= 1) continue;
                        bl2 = true;
                        iList3.addAll(iList4);
                        iList3.addAll(iList5);
                        iList3.remove(object2);
                        break;
                    }
                    if (bl2) {
                        iList = iList3;
                        continue block0;
                    }
                }
                iList2.add(iShape2);
            }
        }
        return iList2;
    }

    @GamlAnnotations.operator(value={"clean"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry corresponding to the cleaning of the operand (geometry, agent, point)", comment="The cleaning corresponds to a buffer with a distance of 0.0", examples={@GamlAnnotations.example(value="clean(self)", equals="returns the geometry resulting from the cleaning of the geometry of the agent applying the operator.", test=false)})
    public static IShape clean(IScope iScope, IShape iShape) {
        if (iShape == null || iShape.getInnerGeometry() == null) {
            return iShape;
        }
        if (iShape.getInnerGeometry() instanceof Polygon) {
            return GamaShapeFactory.createFrom(GeometryUtils.cleanGeometry(iShape.getInnerGeometry())).withAttributesOf(iShape);
        }
        if (iShape.getInnerGeometry() instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)iShape.getInnerGeometry();
            int n = multiPolygon.getNumGeometries();
            Polygon[] polygonArray = new Polygon[n];
            int n2 = 0;
            while (n2 < n) {
                polygonArray[n2] = (Polygon)GeometryUtils.cleanGeometry(multiPolygon.getGeometryN(n2));
                ++n2;
            }
            return GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(polygonArray)).withAttributesOf(iShape);
        }
        return iShape.copy(iScope);
    }

    @GamlAnnotations.operator(value={"clean_network"}, content_type=-299, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A list of polylines corresponding to the cleaning of the first operand (list of polyline geometry or agents), considering the tolerance distance given by the second operand; the third operator is used to define if the operator should as well split the lines at their intersections(true to split the lines); the last operandis used to specify if the operator should as well keep only the main connected component of the network. Usage: clean_network(lines:list of geometries or agents, tolerance: float, split_lines: bool, keepMainConnectedComponent: bool)", comment="The cleaned set of polylines", examples={@GamlAnnotations.example(value="clean_network(my_road_shapefile.contents, 1.0, true, false)", equals="returns the list of polulines resulting from the cleaning of the geometry of the agent applying the operator with a tolerance of 1m, and splitting the lines at their intersections.", isExecutable=false), @GamlAnnotations.example(value="clean_network([line({10,10}, {20,20}), line({10,20},{20,10})],3.0,true,false)", equals="[line({10.0,20.0,0.0},{15.0,15.0,0.0}),line({15.0,15.0,0.0},{20.0,10.0,0.0}), line({10.0,10.0,0.0},{15.0,15.0,0.0}), line({15.0,15.0,0.0},{20.0,20.0,0.0})]")})
    @GamlAnnotations.test(value="length(clean_network([line({10,10}, {20,20}), line({10,20},{20,10})],3.0,true,false)) = 4")
    public static IList<IShape> clean(IScope iScope, IList<IShape> iList, double d, boolean bl, boolean bl2) {
        if (iList == null || iList.isEmpty()) {
            return iList;
        }
        IValue iValue = iList.copy(iScope);
        iValue.removeIf(iShape -> !iShape.getGeometry().isLine());
        if (iValue.isEmpty()) {
            return GamaListFactory.EMPTY_LIST;
        }
        IValue iValue2 = GamaListFactory.create();
        IList<IValue> iList2 = iValue.copy(iScope);
        boolean bl3 = true;
        if (d > 0.0) {
            block0: while (bl3) {
                for (IValue iValue3 : iList2) {
                    GamaPoint gamaPoint = iValue3.getPoints().firstValue(iScope);
                    bl3 = SpatialTransformations.connectLine(iScope, gamaPoint, (IShape)iValue3, true, (IList<IShape>)iValue, (IList<IShape>)iValue2, d);
                    if (bl3) {
                        iList2 = GamaListFactory.create();
                        iList2.addAll((Collection<IValue>)((Object)iValue));
                        continue block0;
                    }
                    GamaPoint gamaPoint2 = iValue3.getPoints().lastValue(iScope);
                    bl3 = SpatialTransformations.connectLine(iScope, gamaPoint2, (IShape)iValue3, false, (IList<IShape>)iValue, (IList<IShape>)iValue2, d);
                    if (bl3) {
                        iList2 = GamaListFactory.create();
                        iList2.addAll((Collection<IValue>)((Object)iValue));
                        continue block0;
                    }
                    iValue2.add(iValue3);
                    iValue.remove(iValue3);
                }
            }
        } else {
            iValue2 = iList2;
        }
        iValue2.removeIf(iShape -> iShape.getPerimeter() == 0.0 || !iShape.getInnerGeometry().isValid() || iShape.getInnerGeometry().isEmpty());
        if (bl) {
            iValue2 = SpatialTransformations.split_lines(iScope, iValue2, true);
            iValue2.removeIf(iShape -> !iShape.getInnerGeometry().isValid() || iShape.getInnerGeometry().isEmpty() || iShape.getPerimeter() == 0.0);
        }
        if (bl2) {
            IValue iValue3;
            iValue3 = Graphs.spatialFromEdges(iScope, (IContainer)iValue2);
            iValue3 = Graphs.reduceToMainconnectedComponentOf(iScope, (IGraph)iValue3);
            return iValue3.getEdges();
        }
        return iValue2;
    }

    private static boolean connectLine(IScope iScope, GamaPoint gamaPoint, IShape iShape, boolean bl, IList<IShape> iList, IList<IShape> iList2, double d) {
        IValue iValue = iList.copy(iScope);
        iValue.addAll(iList2);
        iValue.remove(iShape);
        IShape iShape2 = SpatialQueries.closest_to(iScope, iValue, gamaPoint);
        if (iShape2 == null || iShape2.intersects(iShape)) {
            return false;
        }
        if (iShape2.euclidianDistanceTo(gamaPoint) <= d) {
            GamaPoint gamaPoint2 = iShape2.getPoints().firstValue(iScope);
            if (gamaPoint.equals3D(gamaPoint2)) {
                return false;
            }
            GamaPoint gamaPoint3 = iShape2.getPoints().lastValue(iScope);
            if (gamaPoint.equals3D(gamaPoint3)) {
                return false;
            }
            if (gamaPoint.euclidianDistanceTo(gamaPoint2) <= d) {
                SpatialTransformations.modifyPoint(iScope, iShape, gamaPoint2, bl);
                return false;
            }
            if (gamaPoint.euclidianDistanceTo(gamaPoint3) > d) {
                GamaPoint gamaPoint4 = (GamaPoint)SpatialPunctal.closest_points_with(gamaPoint, iShape2).get(1);
                SpatialTransformations.modifyPoint(iScope, iShape, gamaPoint4, bl);
                IList<IShape> iList3 = SpatialOperators.split_at(iShape2, gamaPoint4);
                if (iList2.contains(iShape2)) {
                    iList2.remove(iShape2);
                    iList2.addAll(iList3);
                } else {
                    iList.remove(iShape2);
                    iList.addAll(iList3);
                }
                return true;
            }
            SpatialTransformations.modifyPoint(iScope, iShape, gamaPoint3, bl);
        }
        return false;
    }

    private static void modifyPoint(IScope iScope, IShape iShape, GamaPoint gamaPoint, boolean bl) {
        if (bl) {
            iShape.getInnerGeometry().getCoordinates()[0] = gamaPoint;
        } else {
            iShape.getInnerGeometry().getCoordinates()[iShape.getInnerGeometry().getCoordinates().length - 1] = gamaPoint;
        }
        iShape.getInnerGeometry().geometryChanged();
    }

    @GamlAnnotations.operator(value={"simplification"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry corresponding to the simplification of the operand (geometry, agent, point) considering a tolerance distance.", comment="The algorithm used for the simplification is Douglas-Peucker", examples={@GamlAnnotations.example(value="self simplification 0.1", equals="the geometry resulting from the application of the Douglas-Peuker algorithm on the geometry of the agent applying the operator with a tolerance distance of 0.1.", test=false)})
    public static IShape simplification(IScope iScope, IShape iShape, Double d) {
        if (iShape == null || iShape.getInnerGeometry() == null) {
            return iShape;
        }
        if (iShape.isPoint()) {
            return iShape.copy(iScope);
        }
        Geometry geometry = DouglasPeuckerSimplifier.simplify((Geometry)iShape.getInnerGeometry(), (double)d);
        if (geometry != null && !geometry.isEmpty() && geometry.isSimple()) {
            return GamaShapeFactory.createFrom(geometry).withAttributesOf(iShape);
        }
        return iShape.copy(iScope);
    }

    @GamlAnnotations.operator(value={"with_precision"}, category={"Spatial operators", "Spatial transformations operators"}, concept={"geometry", "spatial_computation", "spatial_transformation"})
    @GamlAnnotations.doc(value="A geometry corresponding to the rounding of points of the operand considering a given precison.", examples={@GamlAnnotations.example(value="self with_precision 2", equals="the geometry resulting from the rounding of points of the geometry with a precision of 0.1.", test=false)})
    public static IShape withPrecision(IScope iScope, IShape iShape, Integer n) {
        if (iShape == null || iShape.getInnerGeometry() == null) {
            return iShape;
        }
        double d = Math.pow(10.0, n.intValue());
        PrecisionModel precisionModel = new PrecisionModel(d);
        return GamaShapeFactory.createFrom(GeometryPrecisionReducer.reduce((Geometry)iShape.getInnerGeometry(), (PrecisionModel)precisionModel));
    }
}

