/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IStatement;
import gama.gaml.types.Types;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="from", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the lower bound of the loop")}), @GamlAnnotations.facet(name="to", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the higher bound of the loop")}), @GamlAnnotations.facet(name="step", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the incrementation of the loop")}), @GamlAnnotations.facet(name="name", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="a temporary variable name")}), @GamlAnnotations.facet(name="over", type={16, 7}, optional=true, doc={@GamlAnnotations.doc(value="a list, point, matrix or map expression")}), @GamlAnnotations.facet(name="while", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean expression")}), @GamlAnnotations.facet(name="times", type={1}, optional=true, doc={@GamlAnnotations.doc(value="an int expression")})}, omissible="name")
@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.doc(value="Allows the agent to perform the same set of statements either a fixed number of times, or while a condition is true, or by progressing in a collection of elements or along an interval of numbers. Be aware that there are no prevention of infinite loops. As a consequence, open loops should be used with caution, as one agent may block the execution of the whole model.", usages={@GamlAnnotations.usage(value="The basic syntax for repeating a fixed number of times a set of statements is:", examples={@GamlAnnotations.example(value="loop times: an_int_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumTimes <- 1;", isTestOnly=true), @GamlAnnotations.example(value="loop times: 3 {sumTimes <- sumTimes + sumTimes;}", isTestOnly=true), @GamlAnnotations.example(var="sumTimes", equals="8", isTestOnly=true)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements while a condition holds is:", examples={@GamlAnnotations.example(value="loop while: a_bool_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumWhile <- 1;", isTestOnly=true), @GamlAnnotations.example(value="loop while: (sumWhile < 5) {sumWhile <- sumWhile + sumWhile;}", isTestOnly=true), @GamlAnnotations.example(var="sumWhile", equals="8", isTestOnly=true)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements by progressing over a container of a point is:", examples={@GamlAnnotations.example(value="loop a_temp_var over: a_collection_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements while an index iterates over a range of values with a fixed step of 1 is:", examples={@GamlAnnotations.example(value="loop a_temp_var from: int_expression_1 to: int_expression_2 {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="The incrementation step of the index can also be chosen:", examples={@GamlAnnotations.example(value="loop a_temp_var from: int_expression_1 to: int_expression_2 step: int_expression3 {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumFor <- 0;", isTestOnly=true), @GamlAnnotations.example(value="loop i from: 10 to: 30 step: 10 {sumFor <- sumFor + i;}", isTestOnly=true), @GamlAnnotations.example(var="sumFor", equals="60", isTestOnly=true)}), @GamlAnnotations.usage(value="In these latter three cases, the name facet designates the name of a temporary variable, whose scope is the loop, and that takes, in turn, the value of each of the element of the list (or each value in the interval). For example, in the first instance of the \"loop over\" syntax :", examples={@GamlAnnotations.example(value="int a <- 0;"), @GamlAnnotations.example(value="loop i over: [10, 20, 30] {"), @GamlAnnotations.example(value="     a <- a + i;"), @GamlAnnotations.example(value="} // a now equals 60"), @GamlAnnotations.example(var="a", equals="60", isTestOnly=true)}), @GamlAnnotations.usage(value="The second (quite common) case of the loop syntax allows one to use an interval of integers or floats. The from and to facets take an int or float expression as arguments, with the first (resp. the last) specifying the beginning (resp. end) of the inclusive interval (i.e. [to, from]). If the step is not defined, it is assumed to be equal to 1 or -1, depending on the direction of the range. If it is defined, its sign will be respected, so that a positive step will never allow the loop to enter a loop from i to j where i is greater than j", examples={@GamlAnnotations.example(value="list the_list <-list (species_of (self));"), @GamlAnnotations.example(value="loop i from: 0 to: length (the_list) - 1 {"), @GamlAnnotations.example(value="     ask the_list at i {"), @GamlAnnotations.example(value="        // ..."), @GamlAnnotations.example(value="     }"), @GamlAnnotations.example(value="} // every  agent of the list is asked to do something")})})
@serializer(value=LoopSerializer.class)
@validator(value=LoopValidator.class)
public class LoopStatement
extends AbstractStatementSequence
implements IStatement.Breakable {
    private final LoopExecuter executer;
    private final String varName;

    public LoopStatement(IDescription iDescription) {
        super(iDescription);
        boolean bl = this.getFacet("while") != null;
        boolean bl2 = this.getFacet("over") != null;
        boolean bl3 = this.getFacet("from") != null && this.getFacet("to") != null;
        this.varName = iDescription.getName();
        this.executer = bl ? new While() : (bl2 ? new Over() : (bl3 ? new Bounded() : new Times()));
    }

    @Override
    public void enterScope(IScope iScope) {
    }

    @Override
    public void leaveScope(IScope iScope) {
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        try {
            Object object = this.executer.runIn(iScope);
            return object;
        }
        finally {
            iScope.getAndClearBreakStatus();
        }
    }

    protected FlowStatus loopBody(IScope iScope, Object object, Object[] objectArray) {
        iScope.push(this);
        if (this.varName != null) {
            iScope.setVarValue(this.varName, object, true);
        }
        objectArray[0] = super.privateExecuteIn(iScope);
        iScope.pop(this);
        return iScope.getAndClearContinueStatus();
    }

    class Bounded
    implements LoopExecuter {
        private final IExpression from;
        private final IExpression to;
        private final IExpression step;
        private Number constantFrom;
        private Number constantTo;
        private Number constantStep;
        private final boolean stepDefined;
        private final boolean isInt;

        Bounded() throws GamaRuntimeException {
            this.from = LoopStatement.this.getFacet("from");
            this.to = LoopStatement.this.getFacet("to");
            this.step = LoopStatement.this.getFacet("step");
            IScope iScope = null;
            boolean bl = this.isInt = this.from.getGamlType() == Types.INT && this.to.getGamlType() == Types.INT && (this.step == null || this.step.getGamlType() == Types.INT);
            if (this.from.isConst()) {
                this.constantFrom = this.getFromExp(iScope, this.from);
            }
            if (this.to.isConst()) {
                this.constantTo = this.getFromExp(iScope, this.to);
            }
            if (this.step == null) {
                this.stepDefined = false;
                this.constantStep = 1;
            } else if (this.step.isConst()) {
                this.stepDefined = true;
                this.constantStep = this.getFromExp(iScope, this.step);
            } else {
                this.stepDefined = true;
            }
        }

        Number getFromExp(IScope iScope, IExpression iExpression) {
            return this.isInt ? (double)Cast.asInt(iScope, iExpression.value(iScope)).intValue() : Cast.asFloat(iScope, iExpression.value(iScope));
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Object[] objectArray = new Object[1];
            Number number = this.constantFrom == null ? (Number)this.getFromExp(iScope, this.from) : (Number)this.constantFrom;
            Number number2 = this.constantTo == null ? (Number)this.getFromExp(iScope, this.to) : (Number)this.constantTo;
            Number number3 = this.constantStep == null ? (Number)this.getFromExp(iScope, this.step) : (Number)this.constantStep;
            boolean bl = false;
            if (number.equals(number2)) {
                LoopStatement.this.loopBody(iScope, number, objectArray);
            } else if (number.doubleValue() - number2.doubleValue() > 0.0) {
                if (number3.doubleValue() > 0.0) {
                    if (this.stepDefined) {
                        return null;
                    }
                    number3 = number3 instanceof Integer ? (Number)(-number3.intValue()) : (Number)(-number3.doubleValue());
                }
                if (this.isInt) {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    while (n >= n2 && !bl) {
                        FlowStatus flowStatus = LoopStatement.this.loopBody(iScope, n, objectArray);
                        switch (flowStatus) {
                            case CONTINUE: {
                                break;
                            }
                            case BREAK: 
                            case RETURN: 
                            case DIE: 
                            case DISPOSE: {
                                bl = true;
                            }
                        }
                        n += number3.intValue();
                    }
                } else {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    while (d >= d2 && !bl) {
                        FlowStatus flowStatus = LoopStatement.this.loopBody(iScope, d, objectArray);
                        switch (flowStatus) {
                            case CONTINUE: {
                                break;
                            }
                            case BREAK: 
                            case RETURN: 
                            case DIE: 
                            case DISPOSE: {
                                bl = true;
                            }
                        }
                        d += number3.doubleValue();
                    }
                }
            } else if (this.isInt) {
                int n = number.intValue();
                int n3 = number2.intValue();
                while (n <= n3 && !bl) {
                    FlowStatus flowStatus = LoopStatement.this.loopBody(iScope, n, objectArray);
                    switch (flowStatus) {
                        case CONTINUE: {
                            break;
                        }
                        case BREAK: 
                        case RETURN: 
                        case DIE: 
                        case DISPOSE: {
                            bl = true;
                        }
                    }
                    n += number3.intValue();
                }
            } else {
                double d = number.doubleValue();
                double d3 = number2.doubleValue();
                while (d <= d3 && !bl) {
                    FlowStatus flowStatus = LoopStatement.this.loopBody(iScope, d, objectArray);
                    switch (flowStatus) {
                        case CONTINUE: {
                            break;
                        }
                        case BREAK: 
                        case RETURN: 
                        case DIE: 
                        case DISPOSE: {
                            bl = true;
                        }
                    }
                    d += number3.doubleValue();
                }
            }
            return objectArray[0];
        }
    }

    static interface LoopExecuter {
        public Object runIn(IScope var1);
    }

    public static class LoopSerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("name".equals(string) && (symbolDescription.hasFacet("times") || symbolDescription.hasFacet("while"))) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }
    }

    public static class LoopValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            IExpressionDescription iExpressionDescription = iDescription.getFacet("times");
            IExpressionDescription iExpressionDescription2 = iDescription.getFacet("over");
            IExpressionDescription iExpressionDescription3 = iDescription.getFacet("from");
            IExpressionDescription iExpressionDescription4 = iDescription.getFacet("to");
            IExpressionDescription iExpressionDescription5 = iDescription.getFacet("while");
            IExpressionDescription iExpressionDescription6 = iDescription.getFacet("name");
            if (iExpressionDescription6 != null && iExpressionDescription6.isConst() && iExpressionDescription6.toString().startsWith("_internal_")) {
                iExpressionDescription6 = null;
            }
            if (iExpressionDescription6 != null) {
                IDescriptionValidator.Assert.nameIsValid(iDescription);
            }
            if (iExpressionDescription != null) {
                this.processTimes(iDescription, iExpressionDescription2, iExpressionDescription3, iExpressionDescription4, iExpressionDescription5, iExpressionDescription6);
            } else if (iExpressionDescription2 != null) {
                this.processOver(iDescription, iExpressionDescription3, iExpressionDescription4, iExpressionDescription5, iExpressionDescription6);
            } else if (iExpressionDescription5 != null) {
                this.processCond(iDescription, iExpressionDescription3, iExpressionDescription4, iExpressionDescription6);
            } else if (iExpressionDescription3 != null) {
                this.processFromTo(iDescription, iExpressionDescription4, iExpressionDescription6);
            } else if (iExpressionDescription4 != null) {
                iDescription.error("'loop' is missing the 'from:' facet", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "from", "0");
            } else {
                iDescription.error("Missing the definition of the kind of loop to perform (times, over, while, from/to)", "gaml.missing.facet.issue");
            }
        }

        private void processFromTo(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2) {
            if (iExpressionDescription2 == null) {
                iDescription.error("No variable has been declared", "gaml.missing.name.issue", "name", new String[0]);
                return;
            }
            if (iExpressionDescription == null) {
                iDescription.error("'loop' is missing the 'to:' facet", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "to", "0");
            }
        }

        private void processCond(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3) {
            if (iExpressionDescription != null) {
                iDescription.error("'while' and 'from' are not compatible", "gaml.conflicting.facets", "while", "from");
            }
            if (iExpressionDescription2 != null) {
                iDescription.error("'while' and 'to' are not compatible", "gaml.conflicting.facets", "while", "to");
            }
            if (iExpressionDescription3 != null) {
                iDescription.error("No variable should be declared", "gaml.unused.code.issue", "while", "name");
            }
        }

        private void processOver(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3, IExpressionDescription iExpressionDescription4) {
            if (iExpressionDescription3 != null) {
                iDescription.error("'over' and 'while' are not compatible", "gaml.conflicting.facets", "over", "while");
            } else if (iExpressionDescription != null) {
                iDescription.error("'over' and 'from' are not compatible", "gaml.conflicting.facets", "over", "from");
            } else if (iExpressionDescription2 != null) {
                iDescription.error("'over' and 'to' are not compatible", "gaml.conflicting.facets", "over", "to");
            }
            if (iExpressionDescription4 == null) {
                iDescription.error("No variable has been declared", "gaml.missing.name.issue", "over", new String[0]);
            }
        }

        private void processTimes(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3, IExpressionDescription iExpressionDescription4, IExpressionDescription iExpressionDescription5) {
            if (iExpressionDescription != null) {
                iDescription.error("'times' and 'over' are not compatible", "gaml.conflicting.facets", "times", "over");
            } else if (iExpressionDescription4 != null) {
                iDescription.error("'times' and 'while' are not compatible", "gaml.conflicting.facets", "times", "while");
            } else if (iExpressionDescription2 != null) {
                iDescription.error("'times' and 'from' are not compatible", "gaml.conflicting.facets", "times", "from");
            } else if (iExpressionDescription3 != null) {
                iDescription.error("'times' and 'to' are not compatible", "gaml.conflicting.facets", "times", "to");
            }
            if (iExpressionDescription5 != null) {
                iDescription.error("No variable should be declared", "gaml.unused.code.issue", "name", new String[0]);
            }
        }
    }

    class Over
    implements LoopExecuter {
        private final IExpression overExpression;

        Over() {
            this.overExpression = LoopStatement.this.getFacet("over");
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Iterable<Object> iterable;
            Object[] objectArray = new Object[1];
            Object object = this.overExpression.value(iScope);
            if (!(object instanceof IContainer)) {
                iterable = Cast.asList(iScope, object);
            } else {
                IContainer iContainer = (IContainer)object;
                iterable = iContainer.iterable(iScope);
            }
            IList iList = iterable;
            boolean bl = false;
            block4: for (Object t : iList) {
                switch (LoopStatement.this.loopBody(iScope, t, objectArray)) {
                    case CONTINUE: {
                        break;
                    }
                    case BREAK: 
                    case RETURN: 
                    case DIE: 
                    case DISPOSE: {
                        bl = true;
                    }
                    default: {
                        if (bl) break block4;
                    }
                }
            }
            return objectArray[0];
        }
    }

    class Times
    implements LoopExecuter {
        private final IExpression timesExpression;
        private Integer constantTimes;

        Times() throws GamaRuntimeException {
            this.timesExpression = LoopStatement.this.getFacet("times");
            if (this.timesExpression.isConst()) {
                this.constantTimes = Types.INT.cast(null, this.timesExpression.getConstValue(), null, false);
            }
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Object[] objectArray = new Object[1];
            int n = this.constantTimes == null ? Cast.asInt(iScope, this.timesExpression.value(iScope)) : this.constantTimes;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n && !bl) {
                switch (LoopStatement.this.loopBody(iScope, null, objectArray)) {
                    case CONTINUE: {
                        break;
                    }
                    case BREAK: 
                    case RETURN: 
                    case DIE: 
                    case DISPOSE: {
                        bl = true;
                    }
                }
                ++n2;
            }
            return objectArray[0];
        }
    }

    class While
    implements LoopExecuter {
        private final IExpression cond;

        While() {
            this.cond = LoopStatement.this.getFacet("while");
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Object[] objectArray = new Object[1];
            boolean bl = false;
            while (Boolean.TRUE.equals(Cast.asBool(iScope, this.cond.value(iScope))) && !bl) {
                switch (LoopStatement.this.loopBody(iScope, null, objectArray)) {
                    case CONTINUE: {
                        break;
                    }
                    case BREAK: 
                    case RETURN: 
                    case DIE: 
                    case DISPOSE: {
                        bl = true;
                    }
                }
            }
            return objectArray[0];
        }
    }
}

