/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IDrawDelegate;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.DrawingData;
import gama.gaml.statements.draw.TextDrawingAttributes;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;

public class TextDrawer
implements IDrawDelegate {
    @Override
    public Rectangle2D executeOn(IScope.IGraphicsScope iGraphicsScope, DrawingData drawingData, IExpression ... iExpressionArray) throws GamaRuntimeException {
        String string = Cast.asString(iGraphicsScope, iExpressionArray[0].value(iGraphicsScope));
        if (string == null || string.length() == 0) {
            return null;
        }
        TextDrawingAttributes textDrawingAttributes = this.computeAttributes(iGraphicsScope, drawingData);
        return iGraphicsScope.getGraphics().drawString(string, textDrawingAttributes);
    }

    TextDrawingAttributes computeAttributes(IScope iScope, DrawingData drawingData) {
        TextDrawingAttributes textDrawingAttributes = new TextDrawingAttributes(Scaling3D.of(drawingData.size.get()), drawingData.rotation.get(), drawingData.getLocation(), drawingData.color.get());
        if (textDrawingAttributes.getLocation() == null) {
            textDrawingAttributes.setLocation(iScope.getAgent().getLocation().clone());
        }
        textDrawingAttributes.setFont(drawingData.font.get());
        textDrawingAttributes.setAnchor(drawingData.getAnchor());
        textDrawingAttributes.setBorder(drawingData.border.get());
        textDrawingAttributes.setEmpty(drawingData.empty.get());
        textDrawingAttributes.setHeight(drawingData.depth.get());
        textDrawingAttributes.setPerspective(drawingData.perspective.get());
        textDrawingAttributes.setTextures(drawingData.texture.get());
        textDrawingAttributes.setLineWidth(drawingData.lineWidth.get());
        textDrawingAttributes.setPrecision(drawingData.precision.get());
        return textDrawingAttributes;
    }

    @Override
    public IType<?> typeDrawn() {
        return Types.STRING;
    }
}

