/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class GamaAgentType
extends GamaType<IAgent> {
    SpeciesDescription species;

    public GamaAgentType(SpeciesDescription speciesDescription, String string, int n, Class<IAgent> clazz) {
        this.species = speciesDescription;
        this.name = string;
        this.id = n;
        this.support = clazz;
        if (speciesDescription != null) {
            this.setDefiningPlugin(speciesDescription.getDefiningPlugin());
        }
    }

    @Override
    public boolean isAssignableFrom(IType<?> iType) {
        boolean bl = super.isAssignableFrom(iType);
        if (!bl && iType.isAgentType() && iType.getSpecies() == this.getSpecies()) {
            return true;
        }
        return bl;
    }

    @Override
    public String getDefiningPlugin() {
        return this.species.getDefiningPlugin();
    }

    @Override
    public IAgent cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        if (object == null || iScope == null || iScope.getModel() == null) {
            return null;
        }
        ISpecies iSpecies = (ISpecies)object2;
        if (iSpecies == null) {
            iSpecies = iScope.getModel().getSpecies(this.species.getName());
        }
        if (iSpecies == null) {
            return (IAgent)Types.AGENT.cast(iScope, object, object2, bl);
        }
        if (object instanceof IAgent) {
            return ((IAgent)object).isInstanceOf(iSpecies, false) ? (IAgent)object : null;
        }
        if (object instanceof Integer) {
            return iScope.getAgent().getPopulationFor(iSpecies).getAgent((Integer)object);
        }
        if (object instanceof GamaPoint) {
            return iScope.getAgent().getPopulationFor(iSpecies).getAgent(iScope, (GamaPoint)object);
        }
        return null;
    }

    @Override
    public IAgent getDefault() {
        return null;
    }

    @Override
    public boolean isAgentType() {
        return true;
    }

    @Override
    public String getSpeciesName() {
        return this.name;
    }

    @Override
    public SpeciesDescription getSpecies() {
        return this.species;
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    public boolean canBeTypeOf(IScope iScope, Object object) {
        boolean bl = super.canBeTypeOf(iScope, object);
        if (bl) {
            return true;
        }
        if (object instanceof IAgent) {
            ISpecies iSpecies = iScope.getModel().getSpecies(this.getSpeciesName());
            return ((IAgent)object).isInstanceOf(iSpecies, false);
        }
        return false;
    }

    @Override
    public String getSupportName() {
        return ", type of agents instances of species " + this.species.getName();
    }

    @Override
    public IType<String> getKeyType() {
        return Types.STRING;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }
}

