/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="float", id=2, wraps={Double.class, double.class}, kind=101, doc={@GamlAnnotations.doc(value="Represents floating point numbers (equivalent to Double in Java)")}, concept={"type"})
public class GamaFloatType
extends GamaType<Double> {
    @Override
    @GamlAnnotations.doc(value="Cast the argument into a float number. If the argument is a float, returns it; if it is an int, returns it as a float; if it is a string, tries to extract a double from it; if it is a bool, return 1.0 if true and 0.0 if false; if it is a shape (or an agent) returns its area; if it is a font, returns its size; if it is a date, returns the number of milliseconds since the starting date and time of the simulation ")
    public Double cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaFloatType.staticCast(iScope, object, object2, bl);
    }

    public static Double staticCast(IScope iScope, Object object, Object object2, boolean bl) {
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof IValue) {
            IValue iValue = (IValue)object;
            return iValue.floatValue(iScope);
        }
        return 0.0;
    }

    @Override
    public Double getDefault() {
        return 0.0;
    }

    @Override
    public boolean isTranslatableInto(IType<?> iType) {
        return iType.isNumber() || iType == Types.NO_TYPE;
    }

    @Override
    public IType<?> coerce(IType<?> iType, IDescription iDescription) {
        if (iType == this) {
            return null;
        }
        return this;
    }

    @Override
    public IType<? super Double> findCommonSupertypeWith(IType<?> iType) {
        return iType.isNumber() ? this : Types.NO_TYPE;
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }

    @Override
    public boolean isNumber() {
        return true;
    }
}

