/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.core.metamodel.agent.IAgent;
import gama.dev.DEBUG;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.types.GamaAgentType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TypesManager
implements ITypesManager {
    public static int CURRENT_INDEX;
    private TypesManager parent;
    private final ConcurrentHashMap<String, IType<?>> types = new ConcurrentHashMap(5, 0.75f);

    static {
        DEBUG.ON();
        CURRENT_INDEX = 100;
    }

    public TypesManager(ITypesManager iTypesManager) {
        this.setParent(iTypesManager);
    }

    @Override
    public Set<IType<?>> getAllTypes() {
        return new HashSet(this.types.values());
    }

    @Override
    public void setParent(ITypesManager iTypesManager) {
        this.parent = (TypesManager)iTypesManager;
    }

    @Override
    public void alias(String string, String string2) {
        IType<?> iType = this.types.get(string);
        if (iType != null) {
            this.types.put(string2, iType);
        }
    }

    @Override
    public IType<? extends IAgent> addSpeciesType(SpeciesDescription speciesDescription) {
        String string = speciesDescription.getName();
        if (!"agent".equals(string)) {
            if (this.containsType(string)) {
                speciesDescription.error("Species " + string + " already declared. Species name must be unique", "gaml.duplicate.name.issue", speciesDescription.getUnderlyingElement(), string);
            }
            return this.addSpeciesType(new GamaAgentType(speciesDescription, speciesDescription.getName(), ++CURRENT_INDEX, speciesDescription.getJavaBase()), speciesDescription.getJavaBase());
        }
        return this.get("agent");
    }

    @Override
    public <Support> IType<Support> initType(String string, IType<Support> iType, int n, int n2, Class<Support> clazz, String string2) {
        IType iType2 = iType;
        if ("unknown".equals(string)) {
            iType2 = Types.NO_TYPE;
        }
        iType2.init(n2, n, string, clazz);
        iType2.setDefiningPlugin(string2);
        return this.addType(iType2, clazz);
    }

    private IType<? extends IAgent> addSpeciesType(IType<? extends IAgent> iType, Class<? extends IAgent> clazz) {
        int n = iType.id();
        String string = iType.toString();
        this.types.put(string, iType);
        this.types.put(String.valueOf(n), iType);
        Types.CLASSES_TYPES_CORRESPONDANCE.put(clazz, string);
        return iType;
    }

    private IType addType(IType iType, Class clazz) {
        int n = iType.id();
        String string = iType.toString();
        this.types.put(string, iType);
        this.types.put(String.valueOf(n), iType);
        return iType;
    }

    @Override
    public void init(ModelDescription modelDescription) {
        modelDescription.visitAllSpecies(speciesDescription -> {
            this.addSpeciesType((SpeciesDescription)speciesDescription);
            return true;
        });
        modelDescription.visitAllSpecies(speciesDescription -> {
            IType<?> iType = this.get(speciesDescription.getName());
            if (!"agent".equals(iType.getName())) {
                SpeciesDescription speciesDescription2 = speciesDescription.getParent();
                iType.setParent(speciesDescription2 == null || speciesDescription2 == speciesDescription ? this.get("agent") : this.get(speciesDescription2.getName()));
            }
            return true;
        });
    }

    @Override
    public boolean containsType(String string) {
        IType<?> iType = this.types.get(string);
        if (iType != null) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.containsType(string);
    }

    public IType get(String string, IType iType) {
        if (string == null) {
            return iType;
        }
        IType<?> iType2 = this.types.get(string);
        if (iType2 != null) {
            return iType2;
        }
        if (this.parent == null) {
            return iType;
        }
        return this.parent.get(string, iType);
    }

    @Override
    public void dispose() {
        this.types.clear();
    }

    @Override
    public IType decodeType(String string) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        try {
            streamTokenizer.nextToken();
            return this.decode(streamTokenizer);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    IType decode(StreamTokenizer streamTokenizer) throws IOException {
        String string = streamTokenizer.sval;
        IType<?> iType = this.get(string);
        streamTokenizer.nextToken();
        if (!(iType instanceof IContainerType)) {
            return iType;
        }
        IContainerType iContainerType = (IContainerType)iType;
        IType iType2 = Types.NO_TYPE;
        IType iType3 = Types.NO_TYPE;
        boolean bl = true;
        if (streamTokenizer.ttype == 60) {
            do {
                streamTokenizer.nextToken();
                if (bl) {
                    iType2 = this.decode(streamTokenizer);
                    bl = false;
                    continue;
                }
                iType3 = this.decode(streamTokenizer);
                bl = true;
            } while (streamTokenizer.ttype == 44);
            streamTokenizer.nextToken();
        }
        if (bl) {
            return iContainerType.of(iType2, iType3);
        }
        return iContainerType.of(iType2);
    }
}

