/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sampling;

import gama.core.kernel.batch.exploration.sampling.SamplingUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LatinhypercubeSampling
extends SamplingUtils {
    private static double nextDouble(double d, double d2, Random random) {
        return d + random.nextDouble() * (d2 - d);
    }

    private static int nextInt(int n, Random random) {
        return random.nextInt(n);
    }

    private static List<Double> shuffle(List<Double> list, Random random) {
        int n = list.size() - 1;
        while (n >= 1) {
            int n2 = LatinhypercubeSampling.nextInt(n + 1, random);
            if (n != n2) {
                double d = list.get(n);
                list.set(n, list.get(n2));
                list.set(n2, d);
            }
            --n;
        }
        return list;
    }

    private static Map<String, List<Double>> generate(int n, List<String> list, Random random) {
        LinkedHashMap<String, List<Double>> linkedHashMap = new LinkedHashMap<String, List<Double>>();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = 1.0 / (double)n;
        int n2 = 0;
        while (n2 < list.size()) {
            int n3 = 0;
            while (n3 < n) {
                arrayList.add(LatinhypercubeSampling.nextDouble((double)n3 * d, (double)(n3 + 1) * d, random));
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < list.size()) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>(LatinhypercubeSampling.shuffle(arrayList, random));
            linkedHashMap.put(list.get(n2), arrayList2);
            ++n2;
        }
        return linkedHashMap;
    }

    private static List<Map<String, Double>> transformMapListToListMap(Map<String, List<Double>> map, List<String> list) {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n = 0;
        while (n < map.get(list.get(0)).size()) {
            LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
            int n2 = 0;
            while (n2 < list.size()) {
                linkedHashMap.put(list.get(n2), map.get(list.get(n2)).get(n));
                ++n2;
            }
            arrayList.add(linkedHashMap);
            ++n;
        }
        return arrayList;
    }

    public static List<ParametersSet> latinHypercubeSamples(int n, List<IParameter.Batch> list, Random random, IScope iScope) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < list.size()) {
            arrayList.add(list.get(n2).getName());
            ++n2;
        }
        Map<String, List<Double>> map = LatinhypercubeSampling.generate(n, arrayList, random);
        List<Map<String, Double>> list2 = LatinhypercubeSampling.transformMapListToListMap(map, arrayList);
        return LatinhypercubeSampling.buildParametersSetfromSample(iScope, list, list2);
    }
}

