/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.AbstractAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.util.graph.GamaGraph;
import gama.gaml.species.GamlSpecies;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGeometryType;
import java.util.Iterator;
import java.util.Objects;

@GamlAnnotations.species(name="agent", doc={@GamlAnnotations.doc(value="The species parent of all agent species")})
public class MinimalAgent
extends AbstractAgent {
    protected final IPopulation<? extends IAgent> population;
    protected String name;
    protected final IShape geometry;
    public final int hashCode;

    public MinimalAgent(IPopulation<? extends IAgent> iPopulation, int n) {
        this(iPopulation, n, GamaShapeFactory.create());
    }

    protected MinimalAgent(IPopulation<? extends IAgent> iPopulation, int n, IShape iShape) {
        super(n);
        this.population = iPopulation;
        this.hashCode = Objects.hash(this.getPopulation(), n);
        this.geometry = iShape;
        iShape.setAgent(this);
    }

    public MinimalAgent(IPopulation<? extends IAgent> iPopulation, int n, int n2, IShape iShape) {
        super(n);
        this.population = iPopulation;
        this.hashCode = n2;
        this.geometry = iShape;
        iShape.setAgent(this);
    }

    @Override
    public IPopulation<? extends IAgent> getPopulation() {
        return this.population;
    }

    @Override
    public IShape getGeometry(IScope iScope) {
        return this.geometry;
    }

    @Override
    public void setGeometry(IScope iScope, IShape iShape) {
        IShape iShape2;
        if (iShape == this.geometry || iShape == null || iShape.getInnerGeometry() == null || this.dead() || this.getSpecies().isGrid() && ((GamlSpecies)this.getSpecies()).belongsToAMicroModel()) {
            return;
        }
        ITopology iTopology = this.getTopology();
        GamaPoint gamaPoint = iShape.getLocation().copy(iScope);
        IAgent iAgent = iShape.getAgent();
        if (iAgent == null) {
            iShape2 = iShape;
        } else {
            iShape2 = GamaShapeFactory.createFrom(iShape.getInnerGeometry().copy());
            iShape2.copyShapeAttributesFrom(iShape);
        }
        if (!gamaPoint.equals(iShape2.getLocation())) {
            iShape2.setLocation(gamaPoint);
        }
        iShape2.setAgent(this);
        Envelope3D envelope3D = Envelope3D.of(this.geometry);
        this.geometry.setGeometry(iShape2);
        iTopology.updateAgent(envelope3D, this);
        this.notifyVarValueChange("shape", iShape2);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = super.getName();
        }
        if (this.dead()) {
            return this.name + " (dead)";
        }
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
        this.notifyVarValueChange("name", string);
    }

    @Override
    public GamaPoint setLocation(IScope iScope, GamaPoint gamaPoint) {
        Object object;
        IValue iValue;
        if (gamaPoint == null || this.dead() || this.getSpecies().isGrid()) {
            return this.getLocation();
        }
        GamaPoint gamaPoint2 = gamaPoint.copy(iScope);
        ITopology iTopology = this.getTopology();
        if (iTopology == null) {
            return this.getLocation();
        }
        gamaPoint2 = iTopology.normalizeLocation(iScope, gamaPoint2, false);
        if (this.geometry == null || this.geometry.getInnerGeometry() == null) {
            this.setGeometry(GamaGeometryType.createPoint(gamaPoint2));
        } else {
            iValue = this.geometry.getLocation();
            if (gamaPoint2.equals(iValue)) {
                return gamaPoint2;
            }
            object = this.geometry.getEnvelope();
            this.geometry.setLocation(gamaPoint2);
            iTopology.updateAgent((Envelope3D)object, this);
        }
        iValue = (GamaGraph)this.getAttribute("attached_graph");
        if (iValue != null) {
            object = ((GamaGraph)iValue).edgesOf(this);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof IAgent)) continue;
                IShape iShape = (IShape)((GamaGraph)iValue).getEdgeSource(e);
                IShape iShape2 = (IShape)((GamaGraph)iValue).getEdgeTarget(e);
                ((IAgent)e).setGeometry(GamaGeometryType.buildLine(iShape.getLocation(), iShape2.getLocation()));
            }
        }
        this.notifyVarValueChange("location", gamaPoint2);
        return gamaPoint2;
    }

    @Override
    public GamaPoint getLocation(IScope iScope) {
        if (this.geometry == null || this.geometry.getInnerGeometry() == null) {
            GamaPoint gamaPoint;
            ITopology iTopology = this.getTopology();
            GamaPoint gamaPoint2 = gamaPoint = iTopology == null ? null : iTopology.getRandomLocation(iScope);
            if (gamaPoint == null) {
                return null;
            }
            this.setGeometry(GamaGeometryType.createPoint(gamaPoint));
            return gamaPoint;
        }
        return this.geometry.getLocation();
    }

    @Override
    public boolean isInstanceOf(ISpecies iSpecies, boolean bl) {
        if ("agent".equals(iSpecies.getName())) {
            return true;
        }
        return super.isInstanceOf(iSpecies, bl);
    }

    @Override
    public boolean init(IScope iScope) {
        if (!this.getPopulation().isInitOverriden()) {
            this._init_(iScope);
        } else {
            iScope.execute(this.getSpecies().getAction("_init_"), this, null);
        }
        return !iScope.interrupted();
    }

    @Override
    public boolean doStep(IScope iScope) {
        if (!this.getPopulation().isStepOverriden()) {
            super.doStep(iScope);
            return !iScope.interrupted();
        }
        return iScope.execute(this.getSpecies().getAction("_step_"), this, null).passed();
    }

    @GamlAnnotations.action(name="_init_")
    public Object _init_(IScope iScope) {
        return super.init(iScope);
    }

    @GamlAnnotations.action(name="_step_")
    public Object _step_(IScope iScope) {
        return super.step(iScope);
    }

    public final int hashCode() {
        return this.hashCode;
    }
}

