/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.shape;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.IIntersectable;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.operators.Maths;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.NumberUtil;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="x", type=2, doc={@GamlAnnotations.doc(value="Returns the x ordinate of this point")}), @GamlAnnotations.variable(name="y", type=2, doc={@GamlAnnotations.doc(value="Returns the y ordinate of this point")}), @GamlAnnotations.variable(name="z", type=2, doc={@GamlAnnotations.doc(value="Returns the z ordinate of this point")})})
public class GamaPoint
extends Coordinate
implements IShape,
IIntersectable,
Cloneable {
    public GamaPoint() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public GamaPoint(double d, double d2) {
        this.setLocation(d, d2, 0.0);
    }

    public GamaPoint(double d, double d2, double d3) {
        this.setLocation(d, d2, d3);
    }

    public GamaPoint(Coordinate coordinate) {
        if (coordinate == null) {
            this.setLocation(0.0, 0.0, 0.0);
        } else {
            this.setLocation(coordinate.x, coordinate.y, coordinate.z);
        }
    }

    public boolean smallerThan(GamaPoint gamaPoint) {
        return this.x < gamaPoint.x || this.y < gamaPoint.y || this.z < gamaPoint.z;
    }

    public boolean smallerThanOrEqualTo(GamaPoint gamaPoint) {
        return this.x <= gamaPoint.x || this.y <= gamaPoint.y || this.z <= gamaPoint.z;
    }

    public boolean biggerThan(GamaPoint gamaPoint) {
        return this.x > gamaPoint.x || this.y > gamaPoint.y || this.z > gamaPoint.z;
    }

    public boolean biggerThanOrEqualTo(GamaPoint gamaPoint) {
        return this.x >= gamaPoint.x || this.y >= gamaPoint.y || this.z >= gamaPoint.z;
    }

    @Override
    public GamaPoint setLocation(GamaPoint gamaPoint) {
        if (gamaPoint == this) {
            return this;
        }
        return this.setLocation(gamaPoint.x, gamaPoint.y, gamaPoint.z);
    }

    public GamaPoint setLocation(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.setZ(d3);
        return this;
    }

    public void setCoordinate(Coordinate coordinate) {
        this.setLocation(coordinate.x, coordinate.y, coordinate.z);
    }

    public void setOrdinate(int n, double d) {
        switch (n) {
            case 0: {
                this.setX(d);
                break;
            }
            case 1: {
                this.setY(d);
                break;
            }
            case 2: {
                this.setZ(d);
            }
        }
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setZ(double d) {
        this.z = Double.isNaN(d) ? 0.0 : d;
    }

    @GamlAnnotations.getter(value="x")
    public double getX() {
        return this.x;
    }

    @GamlAnnotations.getter(value="y")
    public double getY() {
        return this.y;
    }

    @GamlAnnotations.getter(value="z")
    public double getZ() {
        return this.z;
    }

    @Override
    public boolean isPoint() {
        return true;
    }

    @Override
    public boolean isLine() {
        return false;
    }

    public String toString() {
        return "{" + this.x + "," + this.y + "," + this.z + "}";
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "{" + this.x + "," + this.y + "," + this.z + "}";
    }

    @Override
    public GamaPoint getLocation() {
        return this;
    }

    @Override
    public String stringValue(IScope iScope) {
        return "{" + this.x + "," + this.y + "," + this.z + "}";
    }

    public GamaPoint add(GamaPoint gamaPoint) {
        this.x += gamaPoint.x;
        this.y += gamaPoint.y;
        this.setZ(this.z + gamaPoint.z);
        return this;
    }

    public GamaPoint add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.setZ(this.z + d3);
        return this;
    }

    public GamaPoint subtract(GamaPoint gamaPoint) {
        this.x -= gamaPoint.x;
        this.y -= gamaPoint.y;
        this.setZ(this.z - gamaPoint.z);
        return this;
    }

    public GamaPoint multiplyBy(double d) {
        this.x *= d;
        this.y *= d;
        this.setZ(this.z * d);
        return this;
    }

    public GamaPoint divideBy(double d) {
        this.x /= d;
        this.y /= d;
        this.setZ(this.z / d);
        return this;
    }

    @Override
    public GamaPoint copy(IScope iScope) {
        return new GamaPoint(this.x, this.y, this.z);
    }

    @Override
    public GamaShape getGeometry() {
        return GamaGeometryType.createPoint(this);
    }

    @Override
    public void setGeometry(IShape iShape) {
        this.setLocation(iShape.getLocation());
    }

    @Override
    public Geometry getInnerGeometry() {
        return GeometryUtils.GEOMETRY_FACTORY.createPoint(this);
    }

    @Override
    public Envelope3D getEnvelope() {
        return Envelope3D.of((Coordinate)this);
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return Envelope3D.of(0.0, this.x, 0.0, this.y, 0.0, this.z);
    }

    public boolean equals(Object object) {
        if (object instanceof GamaPoint) {
            double d = GamaPreferences.External.TOLERANCE_POINTS.getValue();
            if (d > 0.0) {
                return this.equalsWithTolerance((GamaPoint)object, d);
            }
            return this.equals3D((GamaPoint)object);
        }
        return super.equals(object);
    }

    public boolean equalsWithTolerance(Coordinate coordinate, double d) {
        if (d == 0.0) {
            return this.equals3D(coordinate);
        }
        if (!NumberUtil.equalsWithTolerance((double)this.x, (double)coordinate.x, (double)d) || !NumberUtil.equalsWithTolerance((double)this.y, (double)coordinate.y, (double)d)) {
            return false;
        }
        return Double.isNaN(this.z) || Double.isNaN(coordinate.z) || NumberUtil.equalsWithTolerance((double)this.z, (double)coordinate.z, (double)d);
    }

    @Override
    public boolean covers(IShape iShape) {
        if (iShape.isPoint()) {
            return this.equals(iShape.getLocation());
        }
        return false;
    }

    @Override
    public double euclidianDistanceTo(IShape iShape) {
        if (iShape.isPoint()) {
            return this.euclidianDistanceTo(iShape.getLocation());
        }
        return iShape.euclidianDistanceTo(this);
    }

    @Override
    public double euclidianDistanceTo(GamaPoint gamaPoint) {
        return this.distance3D(gamaPoint);
    }

    @Override
    public boolean intersects(IShape iShape) {
        if (iShape.isPoint()) {
            return this.equals(iShape.getLocation());
        }
        return iShape.intersects(this);
    }

    @Override
    public boolean touches(IShape iShape) {
        if (iShape.isPoint()) {
            return false;
        }
        return iShape.touches(this);
    }

    @Override
    public boolean partiallyOverlaps(IShape iShape) {
        if (iShape.isPoint()) {
            return false;
        }
        return iShape.partiallyOverlaps(this);
    }

    @Override
    public boolean crosses(IShape iShape) {
        if (iShape.isPoint()) {
            return false;
        }
        return iShape.crosses(this);
    }

    @Override
    public IAgent getAgent() {
        return null;
    }

    @Override
    public void setAgent(IAgent iAgent) {
    }

    @Override
    public void setInnerGeometry(Geometry geometry) {
        Coordinate coordinate = geometry.getCoordinate();
        this.setLocation(coordinate.x, coordinate.y, coordinate.z);
    }

    @Override
    public void dispose() {
    }

    public GamaMap getAttributes(boolean bl) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public IShape.Type getGeometricalType() {
        return IShape.Type.POINT;
    }

    public GamaPoint times(double d) {
        return new GamaPoint(this.x * d, this.y * d, this.z * d);
    }

    public GamaPoint dividedBy(double d) {
        return new GamaPoint(this.x / d, this.y / d, this.z / d);
    }

    public GamaPoint minus(GamaPoint gamaPoint) {
        return new GamaPoint(this.x - gamaPoint.x, this.y - gamaPoint.y, this.z - gamaPoint.z);
    }

    public GamaPoint minus(double d, double d2, double d3) {
        return new GamaPoint(this.x - d, this.y - d2, this.z - d3);
    }

    public GamaPoint plus(GamaPoint gamaPoint) {
        return new GamaPoint(this.x + gamaPoint.x, this.y + gamaPoint.y, this.z + gamaPoint.z);
    }

    public GamaPoint plus(double d, double d2, double d3) {
        return new GamaPoint(this.x + d, this.y + d2, this.z + d3);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + GamaPoint.hashCode((double)this.x);
        n = 370 * n + GamaPoint.hashCode((double)this.y);
        return 3700 * n + GamaPoint.hashCode((double)this.z);
    }

    public GamaPoint normalized() {
        double d = this.norm();
        if (d == 0.0) {
            return new GamaPoint(0.0, 0.0, 0.0);
        }
        return new GamaPoint(this.x / d, this.y / d, this.z / d);
    }

    public GamaPoint normalize() {
        double d = this.norm();
        if (d == 0.0) {
            return this;
        }
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public GamaPoint negated() {
        return new GamaPoint(-this.x, -this.y, -this.z);
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public static final double dotProduct(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        return gamaPoint.x * gamaPoint2.x + gamaPoint.y * gamaPoint2.y + gamaPoint.z * gamaPoint2.z;
    }

    public static final GamaPoint cross(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        return new GamaPoint(gamaPoint.y * gamaPoint2.z - gamaPoint.z * gamaPoint2.y, gamaPoint2.x * gamaPoint.z - gamaPoint2.z * gamaPoint.x, gamaPoint.x * gamaPoint2.y - gamaPoint.y * gamaPoint2.x);
    }

    @Override
    public IList<GamaPoint> getPoints() {
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        iList.add(this.clone());
        return iList;
    }

    public GamaPoint yNegated() {
        return new GamaPoint(this.x, -this.y, this.z);
    }

    @Override
    public void setDepth(double d) {
    }

    public IType getGamlType() {
        return Types.POINT;
    }

    @Override
    public Double getArea() {
        return 0.0;
    }

    @Override
    public Double getVolume() {
        return 0.0;
    }

    @Override
    public double getPerimeter() {
        return 0.0;
    }

    @Override
    public IList<GamaShape> getHoles() {
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    public GamaPoint getCentroid() {
        return this;
    }

    @Override
    public GamaShape getExteriorRing(IScope iScope) {
        return GamaShapeFactory.createFrom(this);
    }

    @Override
    public Double getWidth() {
        return 0.0;
    }

    @Override
    public Double getHeight() {
        return 0.0;
    }

    @Override
    public Double getDepth() {
        return null;
    }

    @Override
    public GamaShape getGeometricEnvelope() {
        return GamaShapeFactory.createFrom(this);
    }

    @Override
    public IList<? extends IShape> getGeometries() {
        return GamaListFactory.wrap((IType)Types.GEOMETRY, GamaShapeFactory.createFrom(this));
    }

    @Override
    public boolean isMultiple() {
        return false;
    }

    public double getOrdinate(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0;
    }

    @Override
    public void copyShapeAttributesFrom(IShape iShape) {
    }

    public GamaPoint orthogonal() {
        double d = 0.6 * this.norm();
        if (d == 0.0) {
            return this;
        }
        if (Math.abs(this.x) <= d) {
            double d2 = 1.0 / Math.sqrt(this.y * this.y + this.z * this.z);
            return new GamaPoint(0.0, d2 * this.z, -d2 * this.y);
        }
        if (Math.abs(this.y) <= d) {
            double d3 = 1.0 / Math.sqrt(this.x * this.x + this.z * this.z);
            return new GamaPoint(-d3 * this.z, 0.0, d3 * this.x);
        }
        double d4 = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        return new GamaPoint(d4 * this.y, -d4 * this.x, 0.0);
    }

    public GamaPoint withPrecision(int n) {
        return new GamaPoint(Maths.round(this.x, n), Maths.round(this.y, n), Maths.round(this.z, n));
    }

    @Override
    public void setGeometricalType(IShape.Type type2) {
    }

    public GamaPoint clone() {
        return new GamaPoint(this.x, this.y, this.z);
    }

    @Override
    public boolean intersects(Envelope envelope) {
        return envelope.intersects((Coordinate)this);
    }

    @Override
    public boolean intersects(Coordinate coordinate) {
        return this.equals3D(coordinate);
    }

    public GamaPoint rounded() {
        return new GamaPoint(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "x", this.x, "y", this.y, "z", this.z);
    }

    public static class Immutable
    extends GamaPoint {
        public Immutable() {
        }

        public Immutable(Coordinate coordinate) {
            this.x = coordinate.x;
            this.y = coordinate.y;
            this.z = coordinate.z;
        }

        public Immutable(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        public Immutable(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        @Override
        public GamaPoint setLocation(GamaPoint gamaPoint) {
            return this;
        }

        @Override
        public GamaPoint setLocation(double d, double d2, double d3) {
            return this;
        }

        @Override
        public void setCoordinate(Coordinate coordinate) {
        }

        @Override
        public void setOrdinate(int n, double d) {
        }

        @Override
        public void setX(double d) {
        }

        @Override
        public void setY(double d) {
        }

        @Override
        public void setZ(double d) {
        }

        @Override
        public GamaPoint add(GamaPoint gamaPoint) {
            return this;
        }

        @Override
        public GamaPoint add(double d, double d2, double d3) {
            return this;
        }

        @Override
        public GamaPoint subtract(GamaPoint gamaPoint) {
            return this;
        }

        @Override
        public GamaPoint multiplyBy(double d) {
            return this;
        }

        @Override
        public GamaPoint divideBy(double d) {
            return this;
        }

        @Override
        public void setGeometry(IShape iShape) {
        }

        @Override
        public void setInnerGeometry(Geometry geometry) {
        }

        @Override
        public GamaPoint normalize() {
            return this;
        }

        @Override
        public void negate() {
        }

        @Override
        public void setDepth(double d) {
        }
    }
}

