/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.GamaQuadTree;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import gama.gaml.species.ISpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.locationtech.jts.geom.Envelope;

public class CompoundSpatialIndex
implements ISpatialIndex.Compound {
    boolean disposed = false;
    private final WeakHashMap<ISpecies, ISpatialIndex> spatialIndexes = new WeakHashMap();
    private Envelope bounds;
    private boolean parallel;
    protected final double[] steps;
    private final WeakHashMap<ISpecies, Iterable<ISpatialIndex>> cachedSpeciesIndices = new WeakHashMap();

    public CompoundSpatialIndex(Envelope envelope, boolean bl) {
        this.bounds = envelope;
        this.parallel = bl;
        double d = Math.max(envelope.getWidth(), envelope.getHeight());
        this.steps = new double[]{d / 100.0, d / 50.0, d / 20.0, d / 10.0, d / 2.0, d, d * Math.sqrt(2.0)};
    }

    @Override
    public void insert(IAgent iAgent) {
        if (this.disposed || iAgent == null) {
            return;
        }
        IPopulation<? extends IAgent> iPopulation = iAgent.getPopulation();
        ISpatialIndex iSpatialIndex = this.spatialIndexes.getOrDefault(iPopulation.getSpecies(), null);
        if (iSpatialIndex == null && !GamaPreferences.Experimental.QUADTREE_OPTIMIZATION.getValue().booleanValue()) {
            iSpatialIndex = this.add(iPopulation, false);
        }
        if (iSpatialIndex != null) {
            iSpatialIndex.insert(iAgent);
        }
    }

    @Override
    public void remove(Envelope3D envelope3D, IAgent iAgent) {
        if (this.disposed || iAgent == null) {
            return;
        }
        ISpatialIndex iSpatialIndex = this.spatialIndexes.getOrDefault(iAgent.getSpecies(), null);
        if (iSpatialIndex != null) {
            iSpatialIndex.remove(envelope3D, iAgent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IAgent firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        if (this.disposed) {
            return null;
        }
        Iterable<ISpatialIndex> iterable = this.add(iScope, iAgentFilter);
        Throwable throwable = null;
        Object var8_8 = null;
        try (Collector.AsList asList = Collector.getList();){
            Object object = this.steps;
            int n2 = this.steps.length;
            int n3 = 0;
            block7: while (n3 < n2) {
                double d2 = object[n3];
                Iterator<ISpatialIndex> d4 = iterable.iterator();
                while (true) {
                    IAgent iAgent;
                    if (!d4.hasNext()) {
                        if (asList.isEmpty()) break;
                        break block7;
                    }
                    ISpatialIndex object2 = d4.next();
                    if (object2 == null || (iAgent = object2.firstAtDistance(iScope, iShape, d2, iAgentFilter)) == null) continue;
                    asList.add(iAgent);
                }
                ++n3;
            }
            int n = asList.items().size();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return (IAgent)asList.items().get(0);
            }
            asList.shuffleInPlaceWith(iScope.getRandom());
            double d2 = Double.MAX_VALUE;
            Object object3 = null;
            Iterator iterator = asList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return object3;
                }
                object = (IAgent)iterator.next();
                double d3 = iShape.euclidianDistanceTo((IShape)object);
                if (!(d3 < d2)) continue;
                d2 = d3;
                object3 = object;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private Collection<IAgent> nFirstAtDistanceInSpatialIndexes(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection, Iterable<ISpatialIndex> iterable) {
        if (this.disposed) {
            return null;
        }
        ArrayList<IAgent> arrayList = new ArrayList<IAgent>(collection);
        double[] dArray = this.steps;
        int n2 = this.steps.length;
        int n3 = 0;
        while (n3 < n2) {
            double d = dArray[n3];
            for (ISpatialIndex iSpatialIndex : iterable) {
                Collection<IAgent> collection2 = iSpatialIndex.firstAtDistance(iScope, iShape, d, iAgentFilter, n, arrayList);
                arrayList.addAll(collection2);
            }
            if (arrayList.size() >= n) break;
            ++n3;
        }
        if (arrayList.size() <= n) {
            return arrayList;
        }
        iScope.getRandom().shuffleInPlace(arrayList);
        Ordering ordering = Ordering.natural().onResultOf(iShape2 -> Double.valueOf(iShape.euclidianDistanceTo((IShape)iShape2)));
        return ordering.leastOf(arrayList, n);
    }

    @Override
    public Collection<IAgent> firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection) {
        if (this.disposed) {
            return null;
        }
        Iterable<ISpatialIndex> iterable = this.add(iScope, iAgentFilter);
        return this.nFirstAtDistanceInSpatialIndexes(iScope, iShape, iAgentFilter, n, collection, iterable);
    }

    @Override
    public Collection<IAgent> allInEnvelope(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter, boolean bl) {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        Iterable<ISpatialIndex> iterable = this.add(iScope, iAgentFilter);
        Throwable throwable = null;
        Object var8_9 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            for (ISpatialIndex iSpatialIndex : iterable) {
                asOrderedSet.addAll(iSpatialIndex.allInEnvelope(iScope, iShape, envelope, iAgentFilter, bl));
            }
            asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Collection<IAgent> allAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        Iterable<ISpatialIndex> iterable = this.add(iScope, iAgentFilter);
        Throwable throwable = null;
        Object var8_8 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            for (ISpatialIndex iSpatialIndex : iterable) {
                if (iSpatialIndex == null) continue;
                asOrderedSet.addAll(iSpatialIndex.allAtDistance(iScope, iShape, d, iAgentFilter));
            }
            asOrderedSet.shuffleInPlaceWith(iScope.getRandom());
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.spatialIndexes.clear();
    }

    private ISpatialIndex add(IScope iScope, ISpecies iSpecies, boolean bl) {
        if (this.disposed || iSpecies == null) {
            return null;
        }
        return this.add(iSpecies.getPopulation(iScope), bl);
    }

    private ISpatialIndex add(IPopulation<? extends IAgent> iPopulation, boolean bl) {
        if (this.disposed || iPopulation == null) {
            return null;
        }
        ISpecies iSpecies = iPopulation.getSpecies();
        ISpatialIndex iSpatialIndex = this.spatialIndexes.getOrDefault(iSpecies, null);
        if (iSpatialIndex == null) {
            iSpatialIndex = iPopulation.isGrid() ? ((GridPopulation)iPopulation).getTopology().getPlaces() : GamaQuadTree.create(this.bounds, this.parallel);
            this.spatialIndexes.put(iSpecies, iSpatialIndex);
            if (bl) {
                for (IAgent iAgent : iPopulation) {
                    iSpatialIndex.insert(iAgent);
                }
            }
        }
        return iSpatialIndex;
    }

    private Iterable<ISpatialIndex> add(IScope iScope, IAgentFilter iAgentFilter) {
        if (iAgentFilter instanceof IPopulationSet) {
            return Iterables.transform(((IPopulationSet)iAgentFilter).getPopulations(iScope), iPopulation -> this.add((IPopulation<? extends IAgent>)iPopulation, true));
        }
        ISpecies iSpecies2 = iAgentFilter.getSpecies();
        if (iSpecies2 == null || "agent".equals(iSpecies2.getName())) {
            return this.spatialIndexes.values();
        }
        if (!this.cachedSpeciesIndices.containsKey(iSpecies2)) {
            this.cachedSpeciesIndices.put(iSpecies2, Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.concat(Collections.singleton(iSpecies2), iSpecies2.getSubSpecies(iScope)), iSpecies -> this.add(iScope, (ISpecies)iSpecies, true))));
        }
        return this.cachedSpeciesIndices.get(iSpecies2);
    }

    @Override
    public void remove(ISpecies iSpecies) {
        this.spatialIndexes.remove(iSpecies);
    }

    @Override
    public void update(IScope iScope, Envelope envelope, boolean bl) {
        this.bounds = envelope;
        this.parallel = bl;
        WeakHashMap<ISpecies, ISpatialIndex> weakHashMap = new WeakHashMap<ISpecies, ISpatialIndex>();
        weakHashMap.putAll(this.spatialIndexes);
        for (ISpecies iSpecies : weakHashMap.keySet()) {
            this.remove(iSpecies);
            this.add(iScope, iSpecies, true);
        }
    }

    @Override
    public void mergeWith(ISpatialIndex.Compound compound) {
        CompoundSpatialIndex compoundSpatialIndex = (CompoundSpatialIndex)compound;
        if (compoundSpatialIndex == null) {
            return;
        }
        compoundSpatialIndex.spatialIndexes.forEach((iSpecies, iSpatialIndex) -> this.spatialIndexes.put((ISpecies)iSpecies, (ISpatialIndex)iSpatialIndex));
        compound.dispose();
    }
}

