/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.continuous;

import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ISpatialIndex;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.continuous.RootTopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.PathFactory;
import gama.gaml.operators.Maths;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class AmorphousTopology
implements ITopology {
    IShape expandableEnvironment = GamaGeometryType.createPoint(new GamaPoint(0.0, 0.0));

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "Expandable topology";
    }

    @Override
    public IType<?> getGamlType() {
        return Types.TOPOLOGY;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "topology({0,0})";
    }

    @Override
    public ITopology copy(IScope iScope) throws GamaRuntimeException {
        return new AmorphousTopology();
    }

    @Override
    public void initialize(IScope iScope, IPopulation<? extends IAgent> iPopulation) throws GamaRuntimeException {
    }

    @Override
    public void updateAgent(Envelope3D envelope3D, IAgent iAgent) {
        IShape iShape = SpatialOperators.union(iAgent.getScope(), this.expandableEnvironment.getGeometry(), iAgent.getGeometry());
        this.expandableEnvironment.setGeometry(GamaShapeFactory.createFrom(iShape.getInnerGeometry().getEnvelope()));
    }

    @Override
    public void removeAgent(IAgent iAgent) {
    }

    public IList<IAgent> getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, int n) {
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    public IAgent getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        return null;
    }

    @Override
    public IAgent getAgentFarthestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        return null;
    }

    public Set<IAgent> getNeighborsOf(IScope iScope, IShape iShape, Double d, IAgentFilter iAgentFilter) throws GamaRuntimeException {
        return Collections.EMPTY_SET;
    }

    public Set<IAgent> getAgentsIn(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, ITopology.SpatialRelation spatialRelation) {
        return Collections.EMPTY_SET;
    }

    @Override
    public Double distanceBetween(IScope iScope, IShape iShape, IShape iShape2) {
        return iShape.euclidianDistanceTo(iShape2);
    }

    @Override
    public Double distanceBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        return gamaPoint.euclidianDistanceTo(gamaPoint2);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        return PathFactory.newInstance(iScope, this, GamaListFactory.wrap((IType)Types.GEOMETRY, iShape, iShape2), 0.0);
    }

    @Override
    public GamaPoint getDestination(IScope iScope, GamaPoint gamaPoint, double d, double d2, boolean bl) {
        double d3 = d2 * Maths.cos(d);
        double d4 = d2 * Maths.sin(d);
        return new GamaPoint(gamaPoint.getX() + d3, gamaPoint.getY() + d4);
    }

    @Override
    public GamaPoint getDestination3D(IScope iScope, GamaPoint gamaPoint, double d, double d2, double d3, boolean bl) {
        double d4 = d3 * Maths.cos(d2) * Maths.cos(d);
        double d5 = d3 * Maths.cos(d2) * Maths.sin(d);
        double d6 = d3 * Maths.sin(d2);
        return new GamaPoint(gamaPoint.getX() + d4, gamaPoint.getY() + d5, gamaPoint.getZ() + d6);
    }

    @Override
    public GamaPoint getRandomLocation(IScope iScope) {
        return new GamaPoint(iScope.getRandom().next(), iScope.getRandom().next());
    }

    @Override
    public IContainer<?, IShape> getPlaces() {
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        iList.add(this.expandableEnvironment);
        return iList;
    }

    @Override
    public IShape getEnvironment() {
        return this.expandableEnvironment;
    }

    @Override
    public GamaPoint normalizeLocation(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        return gamaPoint;
    }

    @Override
    public double getWidth() {
        return this.expandableEnvironment.getEnvelope().getWidth();
    }

    @Override
    public double getHeight() {
        return this.expandableEnvironment.getEnvelope().getHeight();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isValidLocation(IScope iScope, GamaPoint gamaPoint) {
        return true;
    }

    @Override
    public boolean isValidGeometry(IScope iScope, IShape iShape) {
        return true;
    }

    @Override
    public Double directionInDegreesTo(IScope iScope, IShape iShape, IShape iShape2) {
        GamaPoint gamaPoint = iShape.getLocation();
        GamaPoint gamaPoint2 = iShape2.getLocation();
        double d = gamaPoint2.getX();
        double d2 = gamaPoint2.getY();
        double d3 = d - gamaPoint.getX();
        double d4 = d2 - gamaPoint.getY();
        double d5 = Maths.atan2(d4, d3);
        return Maths.checkHeading(d5);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) throws GamaRuntimeException {
        return PathFactory.newInstance(iScope, this, GamaListFactory.create(iScope, (IType)Types.POINT, gamaPoint, gamaPoint2), 0.0);
    }

    @Override
    public List<Geometry> listToroidalGeometries(Geometry geometry) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isTorus() {
        return false;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public ISpatialIndex getSpatialIndex() {
        return new ISpatialIndex(){

            @Override
            public void insert(IAgent iAgent) {
            }

            @Override
            public void remove(Envelope3D envelope3D, IAgent iAgent) {
            }

            @Override
            public IAgent firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
                return null;
            }

            @Override
            public Collection<IAgent> firstAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter, int n, Collection<IAgent> collection) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Collection<IAgent> allInEnvelope(IScope iScope, IShape iShape, Envelope envelope, IAgentFilter iAgentFilter, boolean bl) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Collection<IAgent> allAtDistance(IScope iScope, IShape iShape, double d, IAgentFilter iAgentFilter) {
                return Collections.EMPTY_LIST;
            }

            @Override
            public void dispose() {
            }
        };
    }

    @Override
    public IList<GamaSpatialPath> kPathsBetween(IScope iScope, IShape iShape, IShape iShape2, int n) {
        IList<GamaSpatialPath> iList = GamaListFactory.create(Types.PATH);
        iList.add(this.pathBetween(iScope, iShape, iShape2));
        return iList;
    }

    @Override
    public IList<GamaSpatialPath> kPathsBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, int n) {
        IList<GamaSpatialPath> iList = GamaListFactory.create(Types.PATH);
        iList.add(this.pathBetween(iScope, gamaPoint, gamaPoint2));
        return iList;
    }

    @Override
    public void setRoot(IScope iScope, RootTopology rootTopology) {
    }
}

