/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.file.GamaShapeFile;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.ShapeDrawingAttributes;
import java.awt.Color;
import java.util.List;

public class GisLayer
extends AbstractLayer {
    IExpression gisExpression;
    IExpression colorExpression;

    public GisLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
        this.gisExpression = iLayerStatement.getFacet("gis");
        this.colorExpression = iLayerStatement.getFacet("color");
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) {
        GamaColor gamaColor = this.colorExpression == null ? GamaColor.get(GamaPreferences.Displays.CORE_COLOR.getValue().getRGB()) : Cast.asColor(iGraphicsScope, this.colorExpression.value(iGraphicsScope));
        List<IShape> list = this.buildGisLayer(iGraphicsScope);
        if (list != null) {
            for (IShape iShape : list) {
                if (iShape == null) continue;
                ShapeDrawingAttributes shapeDrawingAttributes = new ShapeDrawingAttributes(iShape, null, gamaColor, GamaColor.get(Color.black));
                iGraphics.drawShape(iShape.getInnerGeometry(), shapeDrawingAttributes);
            }
        }
    }

    public List<IShape> buildGisLayer(IScope iScope) throws GamaRuntimeException {
        GamaShapeFile gamaShapeFile = this.getShapeFile(iScope);
        if (gamaShapeFile == null) {
            return null;
        }
        return (List)gamaShapeFile.getContents(iScope);
    }

    private GamaShapeFile getShapeFile(IScope iScope) {
        if (this.gisExpression == null) {
            return null;
        }
        if (this.gisExpression.getGamlType().id() == 4) {
            String string = Cast.asString(iScope, this.gisExpression.value(iScope));
            return new GamaShapeFile(iScope, string);
        }
        Object object = this.gisExpression.value(iScope);
        if (object instanceof GamaShapeFile) {
            return (GamaShapeFile)object;
        }
        return null;
    }

    @Override
    public String getType() {
        return "Gis layer";
    }
}

