/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.IExperimentStateListener;
import gama.core.runtime.server.CommandResponse;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaWebSocketServer;
import gama.core.runtime.server.ISocketCommand;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;

public class GamaGuiWebSocketServer
extends GamaWebSocketServer
implements IExperimentStateListener {
    private GamaServerExperimentConfiguration currentServerConfig = GamaServerExperimentConfiguration.GUI;
    private volatile IExperimentStateListener.State currentState = IExperimentStateListener.State.NONE;

    public static GamaGuiWebSocketServer startForGUI(int n) {
        return GamaGuiWebSocketServer.startForGUI(n, 10000);
    }

    public static GamaGuiWebSocketServer startForGUI(int n, int n2) {
        GamaGuiWebSocketServer gamaGuiWebSocketServer = new GamaGuiWebSocketServer(n, n2);
        gamaGuiWebSocketServer.currentServerConfig = GamaServerExperimentConfiguration.GUI;
        gamaGuiWebSocketServer.start();
        return gamaGuiWebSocketServer;
    }

    private GamaGuiWebSocketServer(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        this.currentServerConfig = this.currentServerConfig.withSocket(webSocket);
        GAMA.getGui().getConsole().addConsoleListener(this.console);
        super.onOpen(webSocket, clientHandshake);
    }

    @Override
    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        super.onClose(webSocket, n, string, bl);
        GAMA.getGui().getConsole().removeConsoleListener(this.console);
    }

    @Override
    public void onError(WebSocket webSocket, Exception exception) {
        exception.printStackTrace();
    }

    @Override
    public void onStart() {
        super.onStart();
        GAMA.addExperimentStateListener(this);
    }

    public void stop() throws InterruptedException {
        super.stop();
        GAMA.removeExperimentStateListener(this);
    }

    @Override
    public IExperimentPlan getExperiment(String string, String string2) {
        return GAMA.getExperiment();
    }

    @Override
    public void execute(Runnable runnable) {
        runnable.run();
    }

    @Override
    public void updateStateTo(IExperimentPlan iExperimentPlan, IExperimentStateListener.State state) {
        if (state != this.currentState) {
            this.currentState = state;
            WebSocket webSocket = this.currentServerConfig.socket();
            if (webSocket == null || webSocket.isClosed()) {
                return;
            }
            webSocket.send(Json.getNew().valueOf(new GamaServerMessage(GamaServerMessage.Type.SimulationStatus, state.name(), "0")).toString());
        }
    }

    @Override
    public GamaServerExperimentConfiguration obtainGuiServerConfiguration() {
        return this.currentServerConfig;
    }

    @Override
    public void addExperiment(String string, String string2, IExperimentPlan iExperimentPlan) {
    }

    @Override
    public IExperimentPlan retrieveExperimentPlan(WebSocket webSocket, IMap<String, Object> iMap) throws ISocketCommand.CommandException {
        IExperimentPlan iExperimentPlan = GAMA.getExperiment();
        if (iExperimentPlan == null || iExperimentPlan.getAgent() == null || iExperimentPlan.getAgent().dead() || iExperimentPlan.getCurrentSimulation() == null) {
            throw new ISocketCommand.CommandException(new CommandResponse(GamaServerMessage.Type.UnableToExecuteRequest, "Unable to find the experiment or simulation", iMap, false));
        }
        return iExperimentPlan;
    }
}

