/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph.loader;

import gama.core.runtime.GAMA;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.nio.dimacs.DIMACSImporter;
import org.jgrapht.nio.dot.DOTImporter;
import org.jgrapht.nio.gexf.SimpleGEXFImporter;
import org.jgrapht.nio.gml.GmlImporter;
import org.jgrapht.nio.graph6.Graph6Sparse6Importer;
import org.jgrapht.nio.graphml.GraphMLImporter;
import org.jgrapht.nio.tsplib.TSPLIBImporter;

public class GraphImporters {
    private static final Map<String, Class<? extends GraphImporter>> name2parser = new HashMap<String, Class<? extends GraphImporter>>(){
        {
            this.put("dimacs", DIMACSImporter.class);
            this.put("dot", DOTImporter.class);
            this.put("gexf", SimpleGEXFImporter.class);
            this.put("graphml", GraphMLImporter.class);
            this.put("graph6", Graph6Sparse6Importer.class);
            this.put("gml", GmlImporter.class);
            this.put("tsplib", TSPLIBImporter.class);
        }
    };
    private static final List<String> parsersForAutomaticDetection = new LinkedList<String>(){
        {
            this.add("graphml");
            this.add("gexf");
            this.add("dimacs");
            this.add("graph6");
            this.add("gml");
            this.add("tsplib");
            this.add("json");
            this.add("csv");
        }
    };
    private static Map<String, GraphImporter> name2singleton = new HashMap<String, GraphImporter>();

    public static Set<String> getAvailableLoaders() {
        return name2parser.keySet();
    }

    public static List<String> getLoadersForAutoDetection() {
        return parsersForAutomaticDetection;
    }

    public static GraphImporter getGraphImporter(String string) {
        GraphImporter graphImporter = name2singleton.get(string);
        if (graphImporter == null) {
            Class<? extends GraphImporter> clazz = name2parser.get(string);
            if (clazz == null) {
                throw GamaRuntimeException.error("unknown parser name: " + string + "; please choose one of " + GraphImporters.getAvailableLoaders().toString(), GAMA.getRuntimeScope());
            }
            try {
                Constructor<? extends GraphImporter> constructor = clazz.getConstructor(new Class[0]);
                graphImporter = constructor.newInstance(new Object[0]);
                name2singleton.put(string, graphImporter);
                return graphImporter;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw GamaRuntimeException.create(noSuchMethodException, GAMA.getRuntimeScope());
            }
            catch (SecurityException securityException) {
                throw GamaRuntimeException.create(securityException, GAMA.getRuntimeScope());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw GamaRuntimeException.create(illegalArgumentException, GAMA.getRuntimeScope());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw GamaRuntimeException.create(invocationTargetException, GAMA.getRuntimeScope());
            }
            catch (InstantiationException instantiationException) {
                throw GamaRuntimeException.create(instantiationException, GAMA.getRuntimeScope());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw GamaRuntimeException.create(illegalAccessException, GAMA.getRuntimeScope());
            }
        }
        return graphImporter;
    }
}

