/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.user;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractPlaceHolderStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;

@GamlAnnotations.inside(symbols={"user_command"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-200}, optional=true, doc={@GamlAnnotations.doc(value="the displayed name")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the variable type")}), @GamlAnnotations.facet(name="init", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the init value")}), @GamlAnnotations.facet(name="min", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the minimum value")}), @GamlAnnotations.facet(name="slider", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Whether to display a slider or not when applicable")}), @GamlAnnotations.facet(name="max", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the maximum value")}), @GamlAnnotations.facet(name="returns", type={-204}, optional=false, doc={@GamlAnnotations.doc(value="a new local variable containing the value given by the user")}), @GamlAnnotations.facet(name="among", type={5}, of=4, optional=true, doc={@GamlAnnotations.doc(value="the set of acceptable values, only for string inputs")})}, omissible="name")
@GamlAnnotations.doc(value="It allows to let the user define the value of a variable.", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="user_panel \"Advanced Control\" {", isExecutable=false), @GamlAnnotations.example(value="\tuser_input \"Location\" returns: loc type: point <- {0,0};", isExecutable=false), @GamlAnnotations.example(value="\tcreate cells number: 10 with: [location::loc];", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"user_command", "user_init", "user_panel"})
public class UserInputStatement
extends AbstractPlaceHolderStatement
implements IParameter {
    boolean isValued;
    Object initialValue;
    Object currentValue;
    IExpression min;
    IExpression max;
    IExpression among;
    IExpression init = this.getFacet("init");
    IExpression slider;
    String tempVar;

    public UserInputStatement(IDescription iDescription) {
        super(iDescription);
        this.min = this.getFacet("min");
        this.max = this.getFacet("max");
        this.among = this.getFacet("among");
        this.slider = this.getFacet("slider");
        this.tempVar = this.getLiteral("returns");
    }

    @Override
    public String getTitle() {
        return this.description.getName();
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return null;
    }

    @Override
    public void setValue(IScope iScope, Object object) {
        this.currentValue = object;
    }

    @Override
    public Object value(IScope iScope) throws GamaRuntimeException {
        if (!this.isValued) {
            if (this.init != null) {
                this.currentValue = this.initialValue = this.init.value(iScope);
            }
            this.isValued = true;
        }
        return this.currentValue;
    }

    @Override
    public IType getType() {
        IType<?> iType = this.description.getGamlType();
        if (iType != Types.NO_TYPE) {
            return iType;
        }
        if (this.init == null) {
            return Types.NO_TYPE;
        }
        return this.init.getGamlType();
    }

    @Override
    public Object getInitialValue(IScope iScope) {
        return this.initialValue;
    }

    @Override
    public Comparable getMinValue(IScope iScope) {
        return this.min == null ? null : (Comparable)this.min.value(iScope);
    }

    @Override
    public Comparable getMaxValue(IScope iScope) {
        return this.max == null ? null : (Comparable)this.max.value(iScope);
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) {
        iScope.addVarWithValue(this.tempVar, this.currentValue);
        return this.currentValue;
    }

    public String getTempVarName() {
        return this.tempVar;
    }

    @Override
    public List getAmongValue(IScope iScope) {
        return this.among == null ? null : (List)this.among.value(iScope);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Comparable getStepValue(IScope iScope) {
        return null;
    }

    @Override
    public void setUnitLabel(String string) {
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public void setDefined(boolean bl) {
    }

    @Override
    public boolean acceptsSlider(IScope iScope) {
        if (this.slider == null) {
            return true;
        }
        return Cast.asBool(iScope, this.slider.value(iScope));
    }

    @Override
    public List<GamaColor> getColors(IScope iScope) {
        return null;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        return null;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return false;
    }

    @Override
    public void setValueNoCheckNoNotification(Object object) {
        this.currentValue = object;
    }
}

