/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation.kernel;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;

public class GamaClassLoader
extends ClassLoader {
    private static volatile GamaClassLoader loader;
    private final List<ClassLoader> loaders = new ArrayList<ClassLoader>();
    private static final ListBasedLoader customLoader;

    static {
        customLoader = new ListBasedLoader();
    }

    public static GamaClassLoader getInstance() {
        if (loader == null) {
            loader = new GamaClassLoader();
        }
        return loader;
    }

    private GamaClassLoader() {
    }

    public ClassLoader addBundle(Bundle bundle) {
        BundleClassLoader bundleClassLoader = this.createBundleClassLoaderFor(bundle);
        return this.addLoader(bundleClassLoader);
    }

    public ClassLoader addLoader(ClassLoader classLoader) {
        this.loaders.add(classLoader);
        return classLoader;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        int n = 0;
        int n2 = this.loaders.size();
        while (n < n2) {
            try {
                return this.loaders.get(n).loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n;
            }
        }
        Class clazz = customLoader.findClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string + " not found in GAMA");
        }
        return clazz;
    }

    @Override
    protected URL findResource(String string) {
        int n = 0;
        int n2 = this.loaders.size();
        while (n < n2) {
            URL uRL = this.loaders.get(n).getResource(string);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return null;
    }

    @Override
    public URL getResource(String string) {
        return this.findResource(string);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private BundleClassLoader createBundleClassLoaderFor(Bundle bundle) {
        return (BundleClassLoader)AccessController.doPrivileged(() -> new BundleClassLoader(bundle));
    }

    public static class BundleClassLoader
    extends ClassLoader {
        private final Bundle bundle;

        protected BundleClassLoader(Bundle bundle) {
            super(null);
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            try {
                return this.bundle.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException(string + " not found in [" + this.bundle.getSymbolicName() + "]", classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new ClassNotFoundException(string + " not defined in [" + this.bundle.getSymbolicName() + "]", noClassDefFoundError);
            }
        }

        @Override
        protected URL findResource(String string) {
            return this.bundle.getResource(string);
        }

        protected Enumeration findResources(String string) throws IOException {
            return this.bundle.getResources(string);
        }

        @Override
        public URL getResource(String string) {
            return this.findResource(string);
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class clazz = this.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    public static class ListBasedLoader
    extends ClassLoader {
        Set<Class> classes = new LinkedHashSet<Class>();

        ListBasedLoader() {
        }

        public boolean addNewClass(Class clazz) {
            return this.classes.add(clazz);
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class clazz = this.findClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            for (Class clazz : this.classes) {
                if (!clazz.getCanonicalName().equals(string)) continue;
                return clazz;
            }
            return null;
        }
    }
}

